; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=reassociate,dce < %s | FileCheck %s

; The two va_arg instructions depend on the memory/context, are therfore not
; identical and the sub should not be optimized to 0 by reassociate.
;
; ...
; ...
define i32 @func(i32 %dummy, ...) {
;
; CHECK-LABEL: @func(
; CHECK-NEXT:    [[VARARGS:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    call void @llvm.va_start.p0(ptr [[VARARGS]])
; CHECK-NEXT:    [[V0:%.*]] = va_arg ptr [[VARARGS]], i32
; CHECK-NEXT:    [[V1:%.*]] = va_arg ptr [[VARARGS]], i32
; CHECK-NEXT:    [[V0_NEG:%.*]] = sub i32 0, [[V0]]
; CHECK-NEXT:    [[SUB:%.*]] = add i32 [[V0_NEG]], 1
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[SUB]], [[V1]]
; CHECK-NEXT:    call void @llvm.va_end.p0(ptr [[VARARGS]])
; CHECK-NEXT:    ret i32 [[ADD]]
;
  %varargs = alloca ptr, align 8
  call void @llvm.va_start(ptr %varargs)
  %v0 = va_arg ptr %varargs, i32
  %v1 = va_arg ptr %varargs, i32
  %sub = sub nsw i32 %v1, %v0
  %add = add nsw i32 %sub, 1
  call void @llvm.va_end(ptr %varargs)
  ret i32 %add
}

declare void @llvm.va_start(ptr)
declare void @llvm.va_end(ptr)
