; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt < %s -passes='require<globals-aa>,gvn' -S | FileCheck %s

; Ensure we do not hoist the load over the call.

@G1 = internal global i32 1
@G2 = internal global i32 1

define i32 @direct_intrinsic(i1 %c) {
; CHECK-LABEL: define {{[^@]+}}@direct_intrinsic
; CHECK-SAME: (i1 [[C:%.*]]) {
; CHECK-NEXT:    br i1 [[C]], label [[INIT:%.*]], label [[CHECK:%.*]]
; CHECK:       init:
; CHECK-NEXT:    store i32 0, ptr @G1, align 4
; CHECK-NEXT:    br label [[CHECK]]
; CHECK:       check:
; CHECK-NEXT:    call void @llvm.unknown()
; CHECK-NEXT:    [[V:%.*]] = load i32, ptr @G1, align 4
; CHECK-NEXT:    ret i32 [[V]]
;
  br i1 %c, label %init, label %check
init:
  store i32 0, ptr @G1
  br label %check
check:
  call void @llvm.unknown()
  %v = load i32, ptr @G1
  ret i32 %v
}

define i32 @indirect_intrinsic(i1 %c) {
; CHECK-LABEL: define {{[^@]+}}@indirect_intrinsic
; CHECK-SAME: (i1 [[C:%.*]]) {
; CHECK-NEXT:    br i1 [[C]], label [[INIT:%.*]], label [[CHECK:%.*]]
; CHECK:       init:
; CHECK-NEXT:    store i32 0, ptr @G2, align 4
; CHECK-NEXT:    br label [[CHECK]]
; CHECK:       check:
; CHECK-NEXT:    call void @intrinsic_caller()
; CHECK-NEXT:    [[V:%.*]] = load i32, ptr @G2, align 4
; CHECK-NEXT:    ret i32 [[V]]
;
  br i1 %c, label %init, label %check
init:
  store i32 0, ptr @G2
  br label %check
check:
  call void @intrinsic_caller()
  %v = load i32, ptr @G2
  ret i32 %v
}

define fastcc void @intrinsic_caller() {
; CHECK-LABEL: define {{[^@]+}}@intrinsic_caller() {
; CHECK-NEXT:    call void @llvm.unknown()
; CHECK-NEXT:    ret void
;
  call void @llvm.unknown()
  ret void
}

declare void @llvm.unknown()

