; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=div-rem-pairs -S -mtriple=x86_64-unknown-unknown    | FileCheck %s

declare void @foo(i32, i32)

define void @decompose_illegal_srem_same_block(i32 %a, i32 %b) {
; CHECK-LABEL: @decompose_illegal_srem_same_block(
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A]], [[B]]
; CHECK-NEXT:    call void @foo(i32 [[REM]], i32 [[DIV]])
; CHECK-NEXT:    ret void
;
  %rem = srem i32 %a, %b
  %div = sdiv i32 %a, %b
  call void @foo(i32 %rem, i32 %div)
  ret void
}

define void @decompose_illegal_urem_same_block(i32 %a, i32 %b) {
; CHECK-LABEL: @decompose_illegal_urem_same_block(
; CHECK-NEXT:    [[DIV:%.*]] = udiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[REM:%.*]] = urem i32 [[A]], [[B]]
; CHECK-NEXT:    call void @foo(i32 [[REM]], i32 [[DIV]])
; CHECK-NEXT:    ret void
;
  %div = udiv i32 %a, %b
  %rem = urem i32 %a, %b
  call void @foo(i32 %rem, i32 %div)
  ret void
}

; Hoist and optionally decompose the sdiv because it's safe and free.
; PR31028 - https://bugs.llvm.org/show_bug.cgi?id=31028

define i32 @hoist_sdiv(i32 %a, i32 %b) {
; CHECK-LABEL: @hoist_sdiv(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A]], [[B]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[REM]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i32 [ [[DIV]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RET]]
;
entry:
  %rem = srem i32 %a, %b
  %cmp = icmp eq i32 %rem, 42
  br i1 %cmp, label %if, label %end

if:
  %div = sdiv i32 %a, %b
  br label %end

end:
  %ret = phi i32 [ %div, %if ], [ 3, %entry ]
  ret i32 %ret
}

; Hoist and optionally decompose the udiv because it's safe and free.

define i64 @hoist_udiv(i64 %a, i64 %b) {
; CHECK-LABEL: @hoist_udiv(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[REM:%.*]] = urem i64 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[DIV:%.*]] = udiv i64 [[A]], [[B]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[REM]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i64 [ [[DIV]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i64 [[RET]]
;
entry:
  %rem = urem i64 %a, %b
  %cmp = icmp eq i64 %rem, 42
  br i1 %cmp, label %if, label %end

if:
  %div = udiv i64 %a, %b
  br label %end

end:
  %ret = phi i64 [ %div, %if ], [ 3, %entry ]
  ret i64 %ret
}

; Hoist the srem if it's safe and free, otherwise decompose it.

define i16 @hoist_srem(i16 %a, i16 %b) {
; CHECK-LABEL: @hoist_srem(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i16 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[REM:%.*]] = srem i16 [[A]], [[B]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i16 [[DIV]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i16 [ [[REM]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i16 [[RET]]
;
entry:
  %div = sdiv i16 %a, %b
  %cmp = icmp eq i16 %div, 42
  br i1 %cmp, label %if, label %end

if:
  %rem = srem i16 %a, %b
  br label %end

end:
  %ret = phi i16 [ %rem, %if ], [ 3, %entry ]
  ret i16 %ret
}

; Hoist the urem if it's safe and free, otherwise decompose it.

define i8 @hoist_urem(i8 %a, i8 %b) {
; CHECK-LABEL: @hoist_urem(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = udiv i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[REM:%.*]] = urem i8 [[A]], [[B]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[DIV]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i8 [ [[REM]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i8 [[RET]]
;
entry:
  %div = udiv i8 %a, %b
  %cmp = icmp eq i8 %div, 42
  br i1 %cmp, label %if, label %end

if:
  %rem = urem i8 %a, %b
  br label %end

end:
  %ret = phi i8 [ %rem, %if ], [ 3, %entry ]
  ret i8 %ret
}

; Be careful with RAUW/invalidation if this is a srem-of-srem.

define i32 @srem_of_srem_unexpanded(i32 %X, i32 %Y, i32 %Z) {
; CHECK-LABEL: @srem_of_srem_unexpanded(
; CHECK-NEXT:    [[T0:%.*]] = mul nsw i32 [[Z:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[T1:%.*]] = sdiv i32 [[X:%.*]], [[T0]]
; CHECK-NEXT:    [[T2:%.*]] = mul nsw i32 [[T0]], [[T1]]
; CHECK-NEXT:    [[T3:%.*]] = srem i32 [[X]], [[T0]]
; CHECK-NEXT:    [[T4:%.*]] = sdiv i32 [[T3]], [[Y]]
; CHECK-NEXT:    [[T5:%.*]] = mul nsw i32 [[T4]], [[Y]]
; CHECK-NEXT:    [[T6:%.*]] = srem i32 [[T3]], [[Y]]
; CHECK-NEXT:    ret i32 [[T6]]
;
  %t0 = mul nsw i32 %Z, %Y
  %t1 = sdiv i32 %X, %t0
  %t2 = mul nsw i32 %t0, %t1
  %t3 = srem i32 %X, %t0
  %t4 = sdiv i32 %t3, %Y
  %t5 = mul nsw i32 %t4, %Y
  %t6 = srem i32 %t3, %Y
  ret i32 %t6
}
define i32 @srem_of_srem_expanded(i32 %X, i32 %Y, i32 %Z) {
; CHECK-LABEL: @srem_of_srem_expanded(
; CHECK-NEXT:    [[T0:%.*]] = mul nsw i32 [[Z:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[T1:%.*]] = sdiv i32 [[X:%.*]], [[T0]]
; CHECK-NEXT:    [[T2:%.*]] = mul nsw i32 [[T0]], [[T1]]
; CHECK-NEXT:    [[T3_RECOMPOSED:%.*]] = srem i32 [[X]], [[T0]]
; CHECK-NEXT:    [[T4:%.*]] = sdiv i32 [[T3_RECOMPOSED]], [[Y]]
; CHECK-NEXT:    [[T5:%.*]] = mul nsw i32 [[T4]], [[Y]]
; CHECK-NEXT:    [[T6_RECOMPOSED:%.*]] = srem i32 [[T3_RECOMPOSED]], [[Y]]
; CHECK-NEXT:    ret i32 [[T6_RECOMPOSED]]
;
  %t0 = mul nsw i32 %Z, %Y
  %t1 = sdiv i32 %X, %t0
  %t2 = mul nsw i32 %t0, %t1
  %t3 = sub nsw i32 %X, %t2
  %t4 = sdiv i32 %t3, %Y
  %t5 = mul nsw i32 %t4, %Y
  %t6 = sub nsw i32 %t3, %t5
  ret i32 %t6
}

; If the ops don't match, don't do anything: signedness.

define i32 @dont_hoist_udiv(i32 %a, i32 %b) {
; CHECK-LABEL: @dont_hoist_udiv(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[REM]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[DIV:%.*]] = udiv i32 [[A]], [[B]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i32 [ [[DIV]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RET]]
;
entry:
  %rem = srem i32 %a, %b
  %cmp = icmp eq i32 %rem, 42
  br i1 %cmp, label %if, label %end

if:
  %div = udiv i32 %a, %b
  br label %end

end:
  %ret = phi i32 [ %div, %if ], [ 3, %entry ]
  ret i32 %ret
}

; If the ops don't match, don't do anything: operation.

define i32 @dont_hoist_srem(i32 %a, i32 %b) {
; CHECK-LABEL: @dont_hoist_srem(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[REM:%.*]] = urem i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[REM]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[REM2:%.*]] = srem i32 [[A]], [[B]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i32 [ [[REM2]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RET]]
;
entry:
  %rem = urem i32 %a, %b
  %cmp = icmp eq i32 %rem, 42
  br i1 %cmp, label %if, label %end

if:
  %rem2 = srem i32 %a, %b
  br label %end

end:
  %ret = phi i32 [ %rem2, %if ], [ 3, %entry ]
  ret i32 %ret
}

; If the ops don't match, don't do anything: operands.

define i32 @dont_hoist_sdiv(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: @dont_hoist_sdiv(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[REM]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A]], [[C:%.*]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i32 [ [[DIV]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RET]]
;
entry:
  %rem = srem i32 %a, %b
  %cmp = icmp eq i32 %rem, 42
  br i1 %cmp, label %if, label %end

if:
  %div = sdiv i32 %a, %c
  br label %end

end:
  %ret = phi i32 [ %div, %if ], [ 3, %entry ]
  ret i32 %ret
}

; If the target doesn't have a unified div/rem op for the type, decompose rem in-place to mul+sub.

define i128 @dont_hoist_urem(i128 %a, i128 %b) {
; CHECK-LABEL: @dont_hoist_urem(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_FROZEN:%.*]] = freeze i128 [[A:%.*]]
; CHECK-NEXT:    [[B_FROZEN:%.*]] = freeze i128 [[B:%.*]]
; CHECK-NEXT:    [[DIV:%.*]] = udiv i128 [[A_FROZEN]], [[B_FROZEN]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i128 [[DIV]], 42
; CHECK-NEXT:    br i1 [[CMP]], label [[IF:%.*]], label [[END:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[TMP0:%.*]] = mul i128 [[DIV]], [[B_FROZEN]]
; CHECK-NEXT:    [[REM_DECOMPOSED:%.*]] = sub i128 [[A_FROZEN]], [[TMP0]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i128 [ [[REM_DECOMPOSED]], [[IF]] ], [ 3, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i128 [[RET]]
;
entry:
  %div = udiv i128 %a, %b
  %cmp = icmp eq i128 %div, 42
  br i1 %cmp, label %if, label %end

if:
  %rem = urem i128 %a, %b
  br label %end

end:
  %ret = phi i128 [ %rem, %if ], [ 3, %entry ]
  ret i128 %ret
}

; Hoist both ops to the common predecessor block.

define i32 @no_domination(i1 %cmp, i32 %a, i32 %b) {
; CHECK-LABEL: @no_domination(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A]], [[B]]
; CHECK-NEXT:    br i1 [[CMP:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br label [[END:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RET:%.*]] = phi i32 [ [[DIV]], [[IF]] ], [ [[REM]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RET]]
;
entry:
  br i1 %cmp, label %if, label %else

if:
  %div = sdiv i32 %a, %b
  br label %end

else:
  %rem = srem i32 %a, %b
  br label %end

end:
  %ret = phi i32 [ %div, %if ], [ %rem, %else ]
  ret i32 %ret
}

define i64 @diamond_pred_has_other_sucessors(i64 %a, i64 %b, i64 %c) {
; CHECK-LABEL: @diamond_pred_has_other_sucessors(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    switch i64 [[A:%.*]], label [[RETURN:%.*]] [
; CHECK-NEXT:    i64 0, label [[SW_BB:%.*]]
; CHECK-NEXT:    i64 1, label [[SW_BB1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw.bb:
; CHECK-NEXT:    [[DIV:%.*]] = udiv i64 [[B:%.*]], [[C:%.*]]
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       sw.bb1:
; CHECK-NEXT:    [[REM:%.*]] = urem i64 [[B]], [[C]]
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi i64 [ [[REM]], [[SW_BB1]] ], [ [[DIV]], [[SW_BB]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i64 [[RETVAL_0]]
;
entry:
  switch i64 %a, label %return [
  i64 0, label %sw.bb
  i64 1, label %sw.bb1
  ]

sw.bb:                                            ; preds = %entry
  %div = udiv i64 %b, %c
  br label %return

sw.bb1:                                           ; preds = %entry
  %rem = urem i64 %b, %c
  br label %return

return:                                           ; preds = %entry, %sw.bb1, %sw.bb
  %retval.0 = phi i64 [ %rem, %sw.bb1 ], [ %div, %sw.bb ], [ 0, %entry ]
  ret i64 %retval.0
}

define i64 @diamond_div_no_unique_predecessor(i64 %a, i64 %b, i64 %c) {
; CHECK-LABEL: @diamond_div_no_unique_predecessor(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[A:%.*]], -1
; CHECK-NEXT:    br i1 [[CMP]], label [[FOO:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sgt i64 [[A]], 1
; CHECK-NEXT:    br i1 [[CMP1]], label [[BAR:%.*]], label [[BAZ:%.*]]
; CHECK:       baz:
; CHECK-NEXT:    [[DIV:%.*]] = udiv i64 [[B:%.*]], [[C:%.*]]
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       foo:
; CHECK-NEXT:    br label [[BAZ]]
; CHECK:       bar:
; CHECK-NEXT:    [[REM:%.*]] = urem i64 [[B]], [[C]]
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi i64 [ [[DIV]], [[BAZ]] ], [ [[REM]], [[BAR]] ]
; CHECK-NEXT:    ret i64 [[RETVAL_0]]
;
entry:
  %cmp = icmp slt i64 %a, -1
  br i1 %cmp, label %foo, label %if.end

if.end:
  %cmp1 = icmp sgt i64 %a, 1
  br i1 %cmp1, label %bar, label %baz

baz:
  %div = udiv i64 %b, %c
  br label %return

foo:
  br label %baz

bar:
  %rem = urem i64 %b, %c
  br label %return

return:
  %retval.0 = phi i64 [ %div, %baz ], [ %rem, %bar ]
  ret i64 %retval.0
}

define i64 @diamond_rem_no_unique_predecessor(i64 %a, i64 %b, i64 %c) {
; CHECK-LABEL: @diamond_rem_no_unique_predecessor(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[A:%.*]], -1
; CHECK-NEXT:    br i1 [[CMP]], label [[FOO:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sgt i64 [[A]], 1
; CHECK-NEXT:    br i1 [[CMP1]], label [[BAR:%.*]], label [[BAZ:%.*]]
; CHECK:       baz:
; CHECK-NEXT:    [[REM:%.*]] = urem i64 [[B:%.*]], [[C:%.*]]
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       foo:
; CHECK-NEXT:    br label [[BAZ]]
; CHECK:       bar:
; CHECK-NEXT:    [[DIV:%.*]] = udiv i64 [[B]], [[C]]
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi i64 [ [[REM]], [[BAZ]] ], [ [[DIV]], [[BAR]] ]
; CHECK-NEXT:    ret i64 [[RETVAL_0]]
;
entry:
  %cmp = icmp slt i64 %a, -1
  br i1 %cmp, label %foo, label %if.end

if.end:
  %cmp1 = icmp sgt i64 %a, 1
  br i1 %cmp1, label %bar, label %baz

baz:
  %rem = urem i64 %b, %c
  br label %return

foo:
  br label %baz

bar:
  %div = udiv i64 %b, %c
  br label %return

return:
  %retval.0 = phi i64 [ %rem, %baz ], [ %div, %bar ]
  ret i64 %retval.0
}

declare void @dummy()

define i32 @invoke_not_willreturn(i32 %a, i32 %b) personality ptr null {
; CHECK-LABEL: @invoke_not_willreturn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    invoke void @dummy()
; CHECK-NEXT:    to label [[CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i32 [[DIV]]
; CHECK:       lpad:
; CHECK-NEXT:    [[TMP0:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A]], [[B]]
; CHECK-NEXT:    ret i32 [[REM]]
;
entry:
  invoke void @dummy()
  to label %cont unwind label %lpad

cont:
  %div = sdiv i32 %a, %b
  ret i32 %div

lpad:
  landingpad { ptr, i32 }
  cleanup
  %rem = srem i32 %a, %b
  ret i32 %rem
}

define i32 @invoke_willreturn(i32 %a, i32 %b) personality ptr null {
; CHECK-LABEL: @invoke_willreturn(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A]], [[B]]
; CHECK-NEXT:    invoke void @dummy() #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    to label [[CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    ret i32 [[DIV]]
; CHECK:       lpad:
; CHECK-NEXT:    [[TMP0:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    ret i32 [[REM]]
;
entry:
  invoke void @dummy() willreturn
  to label %cont unwind label %lpad

cont:
  %div = sdiv i32 %a, %b
  ret i32 %div

lpad:
  landingpad { ptr, i32 }
  cleanup
  %rem = srem i32 %a, %b
  ret i32 %rem
}

; Use this personality function so that catchpad is guaranteed to transfer.
declare void @ProcessCLRException()

define i32 @catchswitch(i32 %a, i32 %b) personality ptr @ProcessCLRException {
; CHECK-LABEL: @catchswitch(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    invoke void @dummy() #[[ATTR0]]
; CHECK-NEXT:    to label [[CONT:%.*]] unwind label [[LPAD:%.*]]
; CHECK:       cont:
; CHECK-NEXT:    ret i32 0
; CHECK:       lpad:
; CHECK-NEXT:    [[CS:%.*]] = catchswitch within none [label %cp] unwind label [[LPAD_END:%.*]]
; CHECK:       cp:
; CHECK-NEXT:    [[TMP0:%.*]] = catchpad within [[CS]] []
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i32 [[DIV]]
; CHECK:       lpad.end:
; CHECK-NEXT:    [[TMP1:%.*]] = cleanuppad within none []
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[A]], [[B]]
; CHECK-NEXT:    ret i32 [[REM]]
;
entry:
  invoke void @dummy() willreturn
  to label %cont unwind label %lpad

cont:
  ret i32 0

lpad:
  %cs = catchswitch within none [label %cp] unwind label %lpad.end

cp:
  catchpad within %cs []
  %div = sdiv i32 %a, %b
  ret i32 %div

lpad.end:
  cleanuppad within none []
  %rem = srem i32 %a, %b
  ret i32 %rem
}
