; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S -passes=jump-threading,correlated-propagation < %s | FileCheck %s

; This runs both jump threading and CVP to query values in the right order.
; The comparison should not fold.

define void @test(i32 %n, i1 %c, i1 %c2) {
; CHECK-LABEL: define void @test(
; CHECK-SAME: i32 [[N:%.*]], i1 [[C:%.*]], i1 [[C2:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[IV]], 0
; CHECK-NEXT:    call void @use(i1 [[CMP]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i32 [[IV]], 1
; CHECK-NEXT:    br label [[LOOP2:%.*]]
; CHECK:       loop2:
; CHECK-NEXT:    br i1 [[C]], label [[LOOP2_LATCH:%.*]], label [[LOOP2_LATCH]]
; CHECK:       loop2.latch:
; CHECK-NEXT:    br i1 [[C2]], label [[LOOP_LATCH]], label [[LOOP2]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[EXIT_COND:%.*]] = icmp eq i32 [[IV_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[EXIT_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %iv.next, %loop.latch ], [ 0, %entry ]
  %cmp = icmp eq i32 %iv, 0
  call void @use(i1 %cmp)
  %iv.next = add nuw nsw i32 %iv, 1
  br label %loop2

loop2:
  br i1 %c, label %loop2.latch, label %loop2.split

loop2.split:
  br label %loop2.latch

loop2.latch:
  br i1 %c2, label %loop.latch, label %loop2

loop.latch:
  %exit.cond = icmp eq i32 %iv.next, %n
  br i1 %exit.cond, label %exit, label %loop

exit:
  ret void
}

declare void @use(i1)
