; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

define i32 @test_loop_varying_bound_add_rec() {
; CHECK-LABEL: define i32 @test_loop_varying_bound_add_rec() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_HEADER:%.*]]
; CHECK:       for.header:
; CHECK-NEXT:    [[IND1:%.*]] = phi i64 [ [[IND1_I:%.*]], [[FOR_LATCH:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IND2:%.*]] = phi i64 [ [[IND2_I:%.*]], [[FOR_LATCH]] ], [ 5, [[ENTRY]] ]
; CHECK-NEXT:    [[REM:%.*]] = srem i64 [[IND2]], 4
; CHECK-NEXT:    [[CMP6:%.*]] = icmp eq i64 [[IND1]], [[REM]]
; CHECK-NEXT:    br i1 [[CMP6]], label [[EXIT1:%.*]], label [[FOR_LATCH]]
; CHECK:       for.latch:
; CHECK-NEXT:    [[IND2_I]] = add i64 [[IND2]], 1
; CHECK-NEXT:    [[IND1_I]] = add i64 [[IND1]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[IND1_I]], 8
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT2:%.*]], label [[FOR_HEADER]]
; CHECK:       exit2:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[REM]], 0
; CHECK-NEXT:    [[RET:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[RET]]
; CHECK:       exit1:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %for.header

for.header:
  %ind1 = phi i64 [ %ind1.i, %for.latch ], [ 0, %entry ]
  %ind2 = phi i64 [ %ind2.i, %for.latch ], [ 5, %entry ]
  %rem = srem i64 %ind2, 4
  %cmp6 = icmp eq i64 %ind1, %rem
  br i1 %cmp6, label %exit1, label %for.latch

for.latch:
  %ind2.i = add i64 %ind2, 1
  %ind1.i = add i64 %ind1, 1
  %cond = icmp eq i64 %ind1.i, 8
  br i1 %cond, label %exit2, label %for.header

exit2:
  %cmp = icmp eq i64 %rem, 0
  %ret = zext i1 %cmp to i32
  ret i32 %ret

exit1:
  ret i32 0
}

declare i64 @callee()

define i32 @test_loop_varying_bound_call() {
; CHECK-LABEL: define i32 @test_loop_varying_bound_call() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_HEADER:%.*]]
; CHECK:       for.header:
; CHECK-NEXT:    [[IND1:%.*]] = phi i64 [ [[IND1_I:%.*]], [[FOR_LATCH:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[VAL:%.*]] = call i64 @callee()
; CHECK-NEXT:    [[CMP6:%.*]] = icmp eq i64 [[IND1]], [[VAL]]
; CHECK-NEXT:    br i1 [[CMP6]], label [[EXIT1:%.*]], label [[FOR_LATCH]]
; CHECK:       for.latch:
; CHECK-NEXT:    [[IND1_I]] = add i64 [[IND1]], 1
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[IND1_I]], 8
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT2:%.*]], label [[FOR_HEADER]]
; CHECK:       exit2:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[VAL]], 0
; CHECK-NEXT:    [[RET:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    ret i32 [[RET]]
; CHECK:       exit1:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %for.header

for.header:
  %ind1 = phi i64 [ %ind1.i, %for.latch ], [ 0, %entry ]
  %val = call i64 @callee()
  %cmp6 = icmp eq i64 %ind1, %val
  br i1 %cmp6, label %exit1, label %for.latch

for.latch:
  %ind1.i = add i64 %ind1, 1
  %cond = icmp eq i64 %ind1.i, 8
  br i1 %cond, label %exit2, label %for.header

exit2:
  %cmp = icmp eq i64 %val, 0
  %ret = zext i1 %cmp to i32
  ret i32 %ret

exit1:
  ret i32 0
}
