; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=ve-unknown-unknown -mattr=+vpu | FileCheck %s

define fastcc <512 x i32> @brd_v512i32(i32 %s) {
; CHECK-LABEL: brd_v512i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    sll %s1, %s0, 32
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    or %s0, %s0, %s1
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v0, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %val = insertelement <512 x i32> undef, i32 %s, i32 0
  %ret = shufflevector <512 x i32> %val, <512 x i32> undef, <512 x i32> zeroinitializer
  ret <512 x i32> %ret
}

define fastcc <512 x i32> @brdi_v512i32() {
; CHECK-LABEL: brdi_v512i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    or %s0, 17, (0)1
; CHECK-NEXT:    sll %s1, %s0, 32
; CHECK-NEXT:    and %s0, %s0, (32)0
; CHECK-NEXT:    or %s0, %s0, %s1
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v0, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %val = insertelement <512 x i32> undef, i32 17, i32 0
  %ret = shufflevector <512 x i32> %val, <512 x i32> undef, <512 x i32> zeroinitializer
  ret <512 x i32> %ret
}

define fastcc <512 x float> @brd_v512f32(float %s) {
; CHECK-LABEL: brd_v512f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    and %s1, %s0, (32)1
; CHECK-NEXT:    srl %s0, %s0, 32
; CHECK-NEXT:    or %s0, %s0, %s1
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v0, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %val = insertelement <512 x float> undef, float %s, i32 0
  %ret = shufflevector <512 x float> %val, <512 x float> undef, <512 x i32> zeroinitializer
  ret <512 x float> %ret
}

define fastcc <512 x float> @brdi_v512f32() {
; CHECK-LABEL: brdi_v512f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lea.sl %s0, 0
; CHECK-NEXT:    and %s1, %s0, (32)1
; CHECK-NEXT:    srl %s0, %s0, 32
; CHECK-NEXT:    or %s0, %s0, %s1
; CHECK-NEXT:    lea %s1, 256
; CHECK-NEXT:    lvl %s1
; CHECK-NEXT:    vbrd %v0, %s0
; CHECK-NEXT:    b.l.t (, %s10)
  %val = insertelement <512 x float> undef, float 0.e+00, i32 0
  %ret = shufflevector <512 x float> %val, <512 x float> undef, <512 x i32> zeroinitializer
  ret <512 x float> %ret
}
