; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+f,-d < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 --mattr=+f,-d < %s | FileCheck %s --check-prefix=LA64

declare void @abort()

define void @br_fcmp_oeq_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_oeq_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB0_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB0_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_oeq_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB0_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB0_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp oeq float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_oeq_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_oeq_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cune.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB1_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB1_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_oeq_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cune.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB1_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB1_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp oeq float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ogt_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ogt_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bcnez $fcc0, .LBB2_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB2_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ogt_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bcnez $fcc0, .LBB2_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB2_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ogt float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ogt_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ogt_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cule.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB3_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB3_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ogt_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cule.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB3_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB3_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ogt float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_oge_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_oge_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bcnez $fcc0, .LBB4_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB4_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_oge_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bcnez $fcc0, .LBB4_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB4_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp oge float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_oge_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_oge_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cult.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB5_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB5_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_oge_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cult.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB5_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB5_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp oge float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_olt_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_olt_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB6_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB6_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_olt_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB6_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB6_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp olt float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_olt_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_olt_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cule.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bceqz $fcc0, .LBB7_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB7_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_olt_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cule.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bceqz $fcc0, .LBB7_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB7_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp olt float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ole_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ole_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB8_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB8_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ole_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB8_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB8_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ole float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ole_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ole_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cult.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bceqz $fcc0, .LBB9_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB9_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ole_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cult.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bceqz $fcc0, .LBB9_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB9_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ole float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_one_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_one_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cne.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB10_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB10_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_one_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cne.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB10_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB10_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp one float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_one_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_one_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cueq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB11_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB11_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_one_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cueq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB11_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB11_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp one float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ord_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ord_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cor.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB12_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB12_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ord_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cor.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB12_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB12_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ord float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ord_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ord_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cun.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB13_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB13_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ord_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cun.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB13_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB13_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ord float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ueq_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ueq_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cueq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB14_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB14_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ueq_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cueq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB14_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB14_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ueq float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ueq_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ueq_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cne.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB15_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB15_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ueq_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cne.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB15_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB15_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ueq float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ugt_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ugt_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cult.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bcnez $fcc0, .LBB16_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB16_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ugt_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cult.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bcnez $fcc0, .LBB16_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB16_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ugt float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ugt_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ugt_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB17_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB17_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ugt_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB17_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB17_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ugt float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_uge_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_uge_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cule.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bcnez $fcc0, .LBB18_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB18_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_uge_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cule.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bcnez $fcc0, .LBB18_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB18_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp uge float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_uge_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_uge_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB19_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB19_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_uge_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB19_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB19_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp uge float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ult_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ult_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cult.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB20_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB20_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ult_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cult.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB20_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB20_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ult float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ult_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ult_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bceqz $fcc0, .LBB21_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB21_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ult_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bceqz $fcc0, .LBB21_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB21_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ult float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_ule_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ule_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cule.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB22_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB22_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ule_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cule.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB22_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB22_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ule float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_ule_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_ule_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bceqz $fcc0, .LBB23_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB23_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_ule_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bceqz $fcc0, .LBB23_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB23_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp ule float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_une_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_une_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cune.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB24_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB24_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_une_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cune.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB24_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB24_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp une float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_une_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_une_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB25_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB25_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_une_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB25_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB25_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp une float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}

define void @br_fcmp_uno_bcnez_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_uno_bcnez_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cun.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bcnez $fcc0, .LBB26_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB26_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_uno_bcnez_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cun.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bcnez $fcc0, .LBB26_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB26_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp uno float %a, %b
  br i1 %1, label %if.then, label %if.else
if.else:
  ret void
if.then:
  tail call void @abort()
  unreachable
}

define void @br_fcmp_uno_bceqz_float(float %a, float %b) nounwind {
; LA32-LABEL: br_fcmp_uno_bceqz_float:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cor.s $fcc0, $fa0, $fa1
; LA32-NEXT:    bceqz $fcc0, .LBB27_2
; LA32-NEXT:  # %bb.1: # %if.else
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB27_2: # %if.then
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    bl abort
;
; LA64-LABEL: br_fcmp_uno_bceqz_float:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cor.s $fcc0, $fa0, $fa1
; LA64-NEXT:    bceqz $fcc0, .LBB27_2
; LA64-NEXT:  # %bb.1: # %if.else
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB27_2: # %if.then
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    st.d $ra, $sp, 8 # 8-byte Folded Spill
; LA64-NEXT:    pcaddu18i $ra, %call36(abort)
; LA64-NEXT:    jirl $ra, $ra, 0
  %1 = fcmp uno float %a, %b
  br i1 %1, label %if.then, label %if.else
if.then:
  tail call void @abort()
  unreachable
if.else:
  ret void
}
