; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=kaveri < %s | FileCheck -enable-var-scope -check-prefixes=CI %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=tonga < %s | FileCheck -enable-var-scope -check-prefixes=VI %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx900 < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX11-FAKE16 %s

; DAGCombiner will transform:
; (fabs (bf16 bitcast (i16 a))) => (bf16 bitcast (and (i16 a), 0x7FFFFFFF))
; unless isFabsFree returns true

define amdgpu_kernel void @s_fabs_free_bf16(ptr addrspace(1) %out, i16 %in) {
; CI-LABEL: s_fabs_free_bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s2, s2, 0x7fff
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_mov_b32_e32 v2, s2
; CI-NEXT:    flat_store_short v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: s_fabs_free_bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[8:9], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s2, s2, 0x7fff
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fabs_free_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: s_fabs_free_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-TRUE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, s2
; GFX11-TRUE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: s_fabs_free_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %bc= bitcast i16 %in to bfloat
  %fabs = call bfloat @llvm.fabs.bf16(bfloat %bc)
  store bfloat %fabs, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fabs_bf16(ptr addrspace(1) %out, bfloat %in) {
; CI-LABEL: s_fabs_bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s2, s2, 0x7fff
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_mov_b32_e32 v2, s2
; CI-NEXT:    flat_store_short v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: s_fabs_bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[8:9], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s2, s2, 0x7fff
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fabs_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: s_fabs_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-TRUE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, s2
; GFX11-TRUE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: s_fabs_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %fabs = call bfloat @llvm.fabs.bf16(bfloat %in)
  store bfloat %fabs, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fabs_v2bf16(ptr addrspace(1) %out, <2 x bfloat> %in) {
; CI-LABEL: s_fabs_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_mov_b32_e32 v2, s2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: s_fabs_v2bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[8:9], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fabs_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fabs_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %fabs = call <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat> %in)
  store <2 x bfloat> %fabs, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fabs_v4bf16(ptr addrspace(1) %out, <4 x bfloat> %in) {
; CI-LABEL: s_fabs_v4bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s4, s3, 0xffff0000
; CI-NEXT:    s_lshl_b32 s3, s3, 16
; CI-NEXT:    s_and_b32 s5, s2, 0xffff0000
; CI-NEXT:    v_mul_f32_e64 v0, 1.0, |s4|
; CI-NEXT:    v_mul_f32_e64 v1, 1.0, |s3|
; CI-NEXT:    v_mul_f32_e64 v2, 1.0, |s5|
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; CI-NEXT:    s_lshl_b32 s2, s2, 16
; CI-NEXT:    v_alignbit_b32 v1, v0, v1, 16
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; CI-NEXT:    v_mul_f32_e64 v2, 1.0, |s2|
; CI-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; VI-LABEL: s_fabs_v4bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s4, s3, 0x7fff
; VI-NEXT:    s_lshr_b32 s3, s3, 16
; VI-NEXT:    s_and_b32 s5, s2, 0x7fff
; VI-NEXT:    s_lshr_b32 s2, s2, 16
; VI-NEXT:    s_and_b32 s3, s3, 0x7fff
; VI-NEXT:    s_and_b32 s2, s2, 0x7fff
; VI-NEXT:    s_and_b32 s4, 0xffff, s4
; VI-NEXT:    s_and_b32 s5, 0xffff, s5
; VI-NEXT:    s_lshl_b32 s3, s3, 16
; VI-NEXT:    s_lshl_b32 s2, s2, 16
; VI-NEXT:    s_or_b32 s3, s4, s3
; VI-NEXT:    s_or_b32 s2, s5, s2
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fabs_v4bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s4, s3, 0x7fff
; GFX9-NEXT:    s_lshr_b32 s3, s3, 16
; GFX9-NEXT:    s_and_b32 s5, s2, 0x7fff
; GFX9-NEXT:    s_lshr_b32 s2, s2, 16
; GFX9-NEXT:    s_and_b32 s3, s3, 0x7fff
; GFX9-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX9-NEXT:    s_pack_ll_b32_b16 s3, s4, s3
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s5, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fabs_v4bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s4, s3, 0x7fff
; GFX11-NEXT:    s_lshr_b32 s3, s3, 16
; GFX11-NEXT:    s_lshr_b32 s5, s2, 16
; GFX11-NEXT:    s_and_b32 s2, s2, 0x7fff
; GFX11-NEXT:    s_and_b32 s5, s5, 0x7fff
; GFX11-NEXT:    s_and_b32 s3, s3, 0x7fff
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, s5
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s4, s3
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_mov_b32 v1, s3
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
  %fabs = call <4 x bfloat> @llvm.fabs.v4bf16(<4 x bfloat> %in)
  store <4 x bfloat> %fabs, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fabs_fold_bf16(ptr addrspace(1) %out, bfloat %in0, bfloat %in1) {
; CI-LABEL: fabs_fold_bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s3, s2, 0x7fff
; CI-NEXT:    s_and_b32 s2, s2, 0xffff0000
; CI-NEXT:    s_lshl_b32 s3, s3, 16
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mul_f32_e32 v0, s3, v0
; CI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_store_short v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: fabs_fold_bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[8:9], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s3, s2, 0x7fff
; VI-NEXT:    s_and_b32 s2, s2, 0xffff0000
; VI-NEXT:    s_lshl_b32 s3, s3, 16
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mul_f32_e32 v0, s3, v0
; VI-NEXT:    v_bfe_u32 v1, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v1, vcc, v1, v0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_short v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fabs_fold_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s3, s2, 0x7fff
; GFX9-NEXT:    s_and_b32 s2, s2, 0xffff0000
; GFX9-NEXT:    s_lshl_b32 s3, s3, 16
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mul_f32_e32 v1, s3, v1
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    global_store_short_d16_hi v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: fabs_fold_bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x8
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 0x7fff
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e64 v0, s1, s0
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_bfe_u32 v1, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v2, 0x400000, v0
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v1, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_cndmask_b32 v0, v1, v2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_d16_hi_b16 v3, v0, s[0:1]
; GFX11-NEXT:    s_endpgm
  %fabs = call bfloat @llvm.fabs.bf16(bfloat %in0)
  %fmul = fmul bfloat %fabs, %in1
  store bfloat %fmul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fabs_v2bf16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; CI-LABEL: v_fabs_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x2
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v2, v[0:1]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: v_fabs_v2bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x8
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v2, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff7fff, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fabs_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x8
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_fabs_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %gep.out = getelementptr inbounds <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %val = load <2 x bfloat>, ptr addrspace(1) %gep.in, align 2
  %fabs = call <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat> %val)
  store <2 x bfloat> %fabs, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fabs_free_v2bf16(ptr addrspace(1) %out, i32 %in) #0 {
; CI-LABEL: fabs_free_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_mov_b32_e32 v2, s2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: fabs_free_v2bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[8:9], 0x8
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: fabs_free_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: fabs_free_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s2, s2, 0x7fff7fff
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %bc = bitcast i32 %in to <2 x bfloat>
  %fabs = call <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat> %bc)
  store <2 x bfloat> %fabs, ptr addrspace(1) %out
  ret void
}

; FIXME: Should do fabs after conversion to avoid converting multiple
; times in this particular case.
define amdgpu_kernel void @v_fabs_fold_self_v2bf16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; CI-LABEL: v_fabs_fold_self_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v0
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v2, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_mul_f32_e64 v4, 1.0, |v3|
; CI-NEXT:    v_mul_f32_e64 v5, 1.0, |v2|
; CI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; CI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; CI-NEXT:    v_mul_f32_e32 v3, v4, v3
; CI-NEXT:    v_mul_f32_e32 v2, v5, v2
; CI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: v_fabs_fold_self_v2bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v2, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, 0x7fff
; VI-NEXT:    s_movk_i32 s2, 0x7fff
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; VI-NEXT:    v_and_b32_sdwa v5, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; VI-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f32_e32 v3, v5, v4
; VI-NEXT:    v_mul_f32_e32 v2, v2, v6
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_bfe_u32 v6, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_add_u32_e32 v4, vcc, s2, v4
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v3, 16
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fabs_fold_self_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX9-NEXT:    s_movk_i32 s2, 0x7fff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_and_b32_sdwa v3, s2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX9-NEXT:    v_and_b32_sdwa v0, s2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v0
; GFX9-NEXT:    v_add3_u32 v5, v5, v0, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v6, vcc
; GFX9-NEXT:    s_mov_b32 s2, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v2, s2
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: v_fabs_fold_self_v2bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    global_load_b32 v2, v0, s[2:3]
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0x7fff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0x7fff, v2.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-TRUE16-NEXT:    v_dual_mul_f32 v0, v0, v3 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_mul_f32_e32 v1, v1, v2
; GFX11-TRUE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v1
; GFX11-TRUE16-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: v_fabs_fold_self_v2bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0x7fff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-FAKE16-NEXT:    v_dual_mul_f32 v2, v2, v3 :: v_dual_and_b32 v1, 0x7fff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX11-FAKE16-NEXT:    v_bfe_u32 v1, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add3_u32 v1, v1, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-FAKE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v3, v5, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v1, 0x7060302
; GFX11-FAKE16-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %val = load <2 x bfloat>, ptr addrspace(1) %gep
  %fabs = call <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat> %val)
  %fmul = fmul <2 x bfloat> %fabs, %val
  store <2 x bfloat> %fmul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fabs_fold_v2bf16(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %other.val) #0 {
; CI-LABEL: v_fabs_fold_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; CI-NEXT:    s_load_dword s4, s[8:9], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v0
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v2, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_and_b32 s1, s4, 0xffff0000
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_lshl_b32 s0, s4, 16
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v3, 0x7fff0000, v2
; CI-NEXT:    v_and_b32_e32 v2, 0x7fff, v2
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_mul_f32_e32 v3, s1, v3
; CI-NEXT:    v_mul_f32_e32 v2, s0, v2
; CI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; VI-LABEL: v_fabs_fold_v2bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; VI-NEXT:    s_load_dword s4, s[8:9], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v2, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, 0x7fff
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_lshl_b32 s0, s4, 16
; VI-NEXT:    s_and_b32 s1, s4, 0xffff0000
; VI-NEXT:    s_movk_i32 s2, 0x7fff
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_sdwa v4, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_and_b32_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f32_e32 v3, s0, v4
; VI-NEXT:    v_mul_f32_e32 v2, s1, v2
; VI-NEXT:    v_bfe_u32 v4, v3, 16, 1
; VI-NEXT:    v_bfe_u32 v6, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; VI-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; VI-NEXT:    v_add_u32_e32 v4, vcc, s2, v4
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; VI-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v3, 16
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fabs_fold_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[2:3]
; GFX9-NEXT:    s_movk_i32 s2, 0x7fff
; GFX9-NEXT:    s_lshl_b32 s3, s4, 16
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff0000
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_sdwa v2, s2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v0, s2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f32_e32 v2, s3, v2
; GFX9-NEXT:    v_mul_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v0
; GFX9-NEXT:    v_add3_u32 v5, v5, v0, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v6, vcc
; GFX9-NEXT:    s_mov_b32 s2, 0x7060302
; GFX9-NEXT:    v_perm_b32 v0, v0, v2, s2
; GFX9-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: v_fabs_fold_v2bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-TRUE16-NEXT:    s_lshl_b32 s2, s4, 16
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0x7fff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0x7fff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-TRUE16-NEXT:    v_dual_mul_f32 v0, s2, v0 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_and_b32 s2, s4, 0xffff0000
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    v_mul_f32_e32 v1, s2, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v1
; GFX11-TRUE16-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: v_fabs_fold_v2bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FAKE16-NEXT:    s_load_b32 s4, s[4:5], 0x10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-FAKE16-NEXT:    s_lshl_b32 s2, s4, 16
; GFX11-FAKE16-NEXT:    s_and_b32 s3, s4, 0xffff0000
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_mul_f32 v0, s2, v0 :: v_dual_and_b32 v1, 0x7fff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v2, v4 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_dual_mul_f32 v1, s3, v1 :: v_dual_mov_b32 v2, 0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x7060302
; GFX11-FAKE16-NEXT:    global_store_b32 v2, v0, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %val = load <2 x bfloat>, ptr addrspace(1) %gep
  %fabs = call <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat> %val)
  %other.val.cvt = bitcast i32 %other.val to <2 x bfloat>
  %fmul = fmul <2 x bfloat> %fabs, %other.val.cvt
  store <2 x bfloat> %fmul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_extract_fabs_fold_v2bf16(ptr addrspace(1) %in) #0 {
; CI-LABEL: v_extract_fabs_fold_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; CI-NEXT:    v_mul_f32_e64 v1, 1.0, |v1|
; CI-NEXT:    v_mul_f32_e64 v0, 1.0, |v0|
; CI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; CI-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; CI-NEXT:    v_add_f32_e32 v0, 2.0, v0
; CI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; CI-NEXT:    flat_store_short v[0:1], v1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    flat_store_short v[0:1], v0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
;
; VI-LABEL: v_extract_fabs_fold_v2bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, 0x7fff
; VI-NEXT:    s_movk_i32 s0, 0x7fff
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_sdwa v2, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_and_b32_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_mul_f32_e32 v1, 4.0, v2
; VI-NEXT:    v_add_f32_e32 v0, 2.0, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_bfe_u32 v4, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    flat_store_short v[0:1], v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_extract_fabs_fold_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_movk_i32 s0, 0x7fff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_sdwa v1, s0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_sdwa v0, s0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 2.0, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v2, v2, v1, s0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_add3_u32 v4, v4, v0, s0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    global_store_short_d16_hi v[0:1], v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_short_d16_hi v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: v_extract_fabs_fold_v2bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0x7fff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0x7fff, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-TRUE16-NEXT:    v_dual_mul_f32 v0, 4.0, v0 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v1, 2.0, v1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc_lo
; GFX11-TRUE16-NEXT:    global_store_d16_hi_b16 v[0:1], v0, off dlc
; GFX11-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-TRUE16-NEXT:    global_store_d16_hi_b16 v[0:1], v1, off dlc
; GFX11-TRUE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: v_extract_fabs_fold_v2bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0x7fff, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_dual_mul_f32 v0, 4.0, v0 :: v_dual_and_b32 v1, 0x7fff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v2, v4 :: v_dual_lshlrev_b32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 2.0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v3, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_add3_u32 v3, v3, v1, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc_lo
; GFX11-FAKE16-NEXT:    global_store_d16_hi_b16 v[0:1], v0, off dlc
; GFX11-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FAKE16-NEXT:    global_store_d16_hi_b16 v[0:1], v1, off dlc
; GFX11-FAKE16-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-FAKE16-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %val = load <2 x bfloat>, ptr addrspace(1) %gep.in
  %fabs = call <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat> %val)
  %elt0 = extractelement <2 x bfloat> %fabs, i32 0
  %elt1 = extractelement <2 x bfloat> %fabs, i32 1

  %fmul0 = fmul bfloat %elt0, 4.0
  %fadd1 = fadd bfloat %elt1, 2.0
  store volatile bfloat %fmul0, ptr addrspace(1) poison
  store volatile bfloat %fadd1, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @v_extract_fabs_no_fold_v2bf16(ptr addrspace(1) %in) #0 {
; CI-LABEL: v_extract_fabs_no_fold_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfe_u32 v1, v0, 16, 15
; CI-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; CI-NEXT:    flat_store_short v[0:1], v0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    flat_store_short v[0:1], v1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
;
; VI-LABEL: v_extract_fabs_no_fold_v2bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; VI-NEXT:    s_add_i32 s12, s12, s17
; VI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; VI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v0, v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_short v[0:1], v1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_extract_fabs_no_fold_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX9-NEXT:    global_store_short v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_short_d16_hi v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_extract_fabs_no_fold_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX11-NEXT:    global_store_b16 v[0:1], v0, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_store_d16_hi_b16 v[0:1], v0, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %val = load <2 x bfloat>, ptr addrspace(1) %gep.in
  %fabs = call <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat> %val)
  %elt0 = extractelement <2 x bfloat> %fabs, i32 0
  %elt1 = extractelement <2 x bfloat> %fabs, i32 1
  store volatile bfloat %elt0, ptr addrspace(1) poison
  store volatile bfloat %elt1, ptr addrspace(1) poison
  ret void
}

declare bfloat @llvm.fabs.bf16(bfloat) #1
declare <2 x bfloat> @llvm.fabs.v2bf16(<2 x bfloat>) #1
declare <4 x bfloat> @llvm.fabs.v4bf16(<4 x bfloat>) #1
declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }

