; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

define <2 x half> @select_v2f16(<2 x half> %op1, <2 x half> %op2, <2 x i1> %mask) {
; CHECK-LABEL: select_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    mov z3.s, z2.s[1]
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    zip1 z2.h, z2.h, z3.h
; CHECK-NEXT:    lsl z2.h, z2.h, #15
; CHECK-NEXT:    asr z2.h, z2.h, #15
; CHECK-NEXT:    and z2.h, z2.h, #0x1
; CHECK-NEXT:    cmpne p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v2f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #10]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    str w10, [sp, #28]
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <2 x i1> %mask, <2 x half> %op1, <2 x half> %op2
  ret <2 x half> %sel
}

define <4 x half> @select_v4f16(<4 x half> %op1, <4 x half> %op2, <4 x i1> %mask) {
; CHECK-LABEL: select_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z2.h, z2.h, #15
; CHECK-NEXT:    asr z2.h, z2.h, #15
; CHECK-NEXT:    and z2.h, z2.h, #0x1
; CHECK-NEXT:    cmpne p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #14]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #18]
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w9, w11, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w9, w10, #0, #1
; NONEON-NOSVE-NEXT:    str h0, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #12]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #10]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    str h0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <4 x i1> %mask, <4 x half> %op1, <4 x half> %op2
  ret <4 x half> %sel
}

define <8 x half> @select_v8f16(<8 x half> %op1, <8 x half> %op2, <8 x i1> %mask) {
; CHECK-LABEL: select_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    uunpklo z2.h, z2.b
; CHECK-NEXT:    lsl z2.h, z2.h, #15
; CHECK-NEXT:    asr z2.h, z2.h, #15
; CHECK-NEXT:    and z2.h, z2.h, #0x1
; CHECK-NEXT:    cmpne p0.h, p0/z, z2.h, #0
; CHECK-NEXT:    sel z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    str d2, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #47]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #45]
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    tst w13, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w13, w15, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w12, w12, #0, #1
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    tst w13, #0xffff
; NONEON-NOSVE-NEXT:    sbfx w13, w14, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    str h0, [sp, #62]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #28]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    tst w13, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #26]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    tst w12, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #58]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #24]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    tst w11, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #22]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    tst w10, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #54]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #20]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    tst w9, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #52]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #18]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldr h1, [sp]
; NONEON-NOSVE-NEXT:    tst w8, #0xffff
; NONEON-NOSVE-NEXT:    str h0, [sp, #50]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #16]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    str h0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %sel = select <8 x i1> %mask, <8 x half> %op1, <8 x half> %op2
  ret <8 x half> %sel
}

define void @select_v16f16(ptr %a, ptr %b) {
; CHECK-LABEL: select_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fcmeq p1.h, p0/z, z1.h, z0.h
; CHECK-NEXT:    fcmeq p0.h, p0/z, z2.h, z3.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    sel z1.h, p0, z2.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q3, [x1]
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-96]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #18]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr h4, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h5, [sp, #4]
; NONEON-NOSVE-NEXT:    ldr h16, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt s2, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h1
; NONEON-NOSVE-NEXT:    ldr h17, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s6, h4
; NONEON-NOSVE-NEXT:    fcvt s7, h5
; NONEON-NOSVE-NEXT:    ldr h19, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s18, h17
; NONEON-NOSVE-NEXT:    ldr h21, [sp, #10]
; NONEON-NOSVE-NEXT:    ldr h22, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s20, h19
; NONEON-NOSVE-NEXT:    ldr h24, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr h25, [sp, #34]
; NONEON-NOSVE-NEXT:    fcmp s3, s2
; NONEON-NOSVE-NEXT:    fcvt s2, h16
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr h26, [sp, #36]
; NONEON-NOSVE-NEXT:    ldr h27, [sp, #38]
; NONEON-NOSVE-NEXT:    ldr h28, [sp, #42]
; NONEON-NOSVE-NEXT:    ldr h29, [sp, #44]
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, eq
; NONEON-NOSVE-NEXT:    fcmp s7, s6
; NONEON-NOSVE-NEXT:    fcvt s7, h3
; NONEON-NOSVE-NEXT:    ldr h6, [sp, #26]
; NONEON-NOSVE-NEXT:    fcsel s1, s5, s4, eq
; NONEON-NOSVE-NEXT:    fcmp s18, s2
; NONEON-NOSVE-NEXT:    fcvt s4, h6
; NONEON-NOSVE-NEXT:    fcvt s18, h21
; NONEON-NOSVE-NEXT:    ldr h5, [sp, #28]
; NONEON-NOSVE-NEXT:    str h0, [sp, #66]
; NONEON-NOSVE-NEXT:    fcsel s2, s17, s16, eq
; NONEON-NOSVE-NEXT:    fcmp s20, s7
; NONEON-NOSVE-NEXT:    fcvt s16, h5
; NONEON-NOSVE-NEXT:    fcvt s17, h22
; NONEON-NOSVE-NEXT:    ldr h7, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h20, [sp, #14]
; NONEON-NOSVE-NEXT:    str h1, [sp, #68]
; NONEON-NOSVE-NEXT:    fcsel s3, s19, s3, eq
; NONEON-NOSVE-NEXT:    fcmp s18, s4
; NONEON-NOSVE-NEXT:    fcvt s19, h7
; NONEON-NOSVE-NEXT:    fcvt s23, h20
; NONEON-NOSVE-NEXT:    ldr h18, [sp, #48]
; NONEON-NOSVE-NEXT:    str h2, [sp, #70]
; NONEON-NOSVE-NEXT:    fcsel s4, s21, s6, eq
; NONEON-NOSVE-NEXT:    fcmp s17, s16
; NONEON-NOSVE-NEXT:    fcvt s17, h18
; NONEON-NOSVE-NEXT:    fcvt s21, h24
; NONEON-NOSVE-NEXT:    ldr h16, [sp, #50]
; NONEON-NOSVE-NEXT:    str h3, [sp, #72]
; NONEON-NOSVE-NEXT:    fcsel s5, s22, s5, eq
; NONEON-NOSVE-NEXT:    fcmp s23, s19
; NONEON-NOSVE-NEXT:    fcvt s22, h16
; NONEON-NOSVE-NEXT:    fcvt s23, h25
; NONEON-NOSVE-NEXT:    ldr h19, [sp, #52]
; NONEON-NOSVE-NEXT:    str h4, [sp, #74]
; NONEON-NOSVE-NEXT:    fcsel s6, s20, s7, eq
; NONEON-NOSVE-NEXT:    fcmp s21, s17
; NONEON-NOSVE-NEXT:    fcvt s20, h19
; NONEON-NOSVE-NEXT:    fcvt s21, h26
; NONEON-NOSVE-NEXT:    ldr h17, [sp, #54]
; NONEON-NOSVE-NEXT:    str h5, [sp, #76]
; NONEON-NOSVE-NEXT:    fcsel s7, s24, s18, eq
; NONEON-NOSVE-NEXT:    fcmp s23, s22
; NONEON-NOSVE-NEXT:    fcvt s22, h17
; NONEON-NOSVE-NEXT:    fcvt s23, h27
; NONEON-NOSVE-NEXT:    ldr h18, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr h24, [sp, #40]
; NONEON-NOSVE-NEXT:    str h6, [sp, #78]
; NONEON-NOSVE-NEXT:    fcsel s16, s25, s16, eq
; NONEON-NOSVE-NEXT:    fcmp s21, s20
; NONEON-NOSVE-NEXT:    fcvt s21, h18
; NONEON-NOSVE-NEXT:    fcvt s25, h24
; NONEON-NOSVE-NEXT:    ldr h20, [sp, #58]
; NONEON-NOSVE-NEXT:    str h7, [sp, #80]
; NONEON-NOSVE-NEXT:    fcsel s19, s26, s19, eq
; NONEON-NOSVE-NEXT:    fcmp s23, s22
; NONEON-NOSVE-NEXT:    fcvt s23, h20
; NONEON-NOSVE-NEXT:    fcvt s26, h28
; NONEON-NOSVE-NEXT:    ldr h22, [sp, #60]
; NONEON-NOSVE-NEXT:    str h16, [sp, #82]
; NONEON-NOSVE-NEXT:    fcsel s17, s27, s17, eq
; NONEON-NOSVE-NEXT:    fcmp s25, s21
; NONEON-NOSVE-NEXT:    fcvt s25, h22
; NONEON-NOSVE-NEXT:    fcvt s27, h29
; NONEON-NOSVE-NEXT:    ldr h21, [sp, #62]
; NONEON-NOSVE-NEXT:    str h19, [sp, #84]
; NONEON-NOSVE-NEXT:    fcsel s18, s24, s18, eq
; NONEON-NOSVE-NEXT:    ldr h24, [sp, #46]
; NONEON-NOSVE-NEXT:    fcmp s26, s23
; NONEON-NOSVE-NEXT:    fcvt s23, h21
; NONEON-NOSVE-NEXT:    str h17, [sp, #86]
; NONEON-NOSVE-NEXT:    fcvt s26, h24
; NONEON-NOSVE-NEXT:    fcsel s20, s28, s20, eq
; NONEON-NOSVE-NEXT:    fcmp s27, s25
; NONEON-NOSVE-NEXT:    ldr h25, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h27, [sp]
; NONEON-NOSVE-NEXT:    str h18, [sp, #88]
; NONEON-NOSVE-NEXT:    fcvt s17, h25
; NONEON-NOSVE-NEXT:    fcvt s18, h27
; NONEON-NOSVE-NEXT:    fcsel s7, s29, s22, eq
; NONEON-NOSVE-NEXT:    fcmp s26, s23
; NONEON-NOSVE-NEXT:    str h20, [sp, #90]
; NONEON-NOSVE-NEXT:    fcsel s16, s24, s21, eq
; NONEON-NOSVE-NEXT:    str h7, [sp, #92]
; NONEON-NOSVE-NEXT:    fcmp s18, s17
; NONEON-NOSVE-NEXT:    str h16, [sp, #94]
; NONEON-NOSVE-NEXT:    fcsel s2, s27, s25, eq
; NONEON-NOSVE-NEXT:    str h2, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x half>, ptr %a
  %op2 = load <16 x half>, ptr %b
  %mask = fcmp oeq <16 x half> %op1, %op2
  %sel = select <16 x i1> %mask, <16 x half> %op1, <16 x half> %op2
  store <16 x half> %sel, ptr %a
  ret void
}

define <2 x float> @select_v2f32(<2 x float> %op1, <2 x float> %op2, <2 x i1> %mask) {
; CHECK-LABEL: select_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    lsl z2.s, z2.s, #31
; CHECK-NEXT:    asr z2.s, z2.s, #31
; CHECK-NEXT:    and z2.s, z2.s, #0x1
; CHECK-NEXT:    cmpne p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp d2, d0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    str d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp s1, s2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #20]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    cmp w8, #0
; NONEON-NOSVE-NEXT:    sbfx w8, w9, #0, #1
; NONEON-NOSVE-NEXT:    fcsel s3, s2, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w8, #0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    stp s0, s3, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %sel = select <2 x i1> %mask, <2 x float> %op1, <2 x float> %op2
  ret <2 x float> %sel
}

define <4 x float> @select_v4f32(<4 x float> %op1, <4 x float> %op2, <4 x i1> %mask) {
; CHECK-LABEL: select_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    lsl z2.s, z2.s, #31
; CHECK-NEXT:    asr z2.s, z2.s, #31
; CHECK-NEXT:    and z2.s, z2.s, #0x1
; CHECK-NEXT:    cmpne p0.s, p0/z, z2.s, #0
; CHECK-NEXT:    sel z0.s, p0, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    str d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #12]
; NONEON-NOSVE-NEXT:    ldp s1, s2, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #44]
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    cmp w9, #0
; NONEON-NOSVE-NEXT:    sbfx w9, w11, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    fcsel s3, s2, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #40]
; NONEON-NOSVE-NEXT:    cmp w9, #0
; NONEON-NOSVE-NEXT:    sbfx w9, w10, #0, #1
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    ldp s1, s2, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, #0
; NONEON-NOSVE-NEXT:    stp s0, s3, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #36]
; NONEON-NOSVE-NEXT:    fcsel s3, s2, s0, ne
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #32]
; NONEON-NOSVE-NEXT:    cmp w8, #0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, ne
; NONEON-NOSVE-NEXT:    stp s0, s3, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %sel = select <4 x i1> %mask, <4 x float> %op1, <4 x float> %op2
  ret <4 x float> %sel
}

define void @select_v8f32(ptr %a, ptr %b) {
; CHECK-LABEL: select_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fcmeq p1.s, p0/z, z1.s, z0.s
; CHECK-NEXT:    fcmeq p0.s, p0/z, z2.s, z3.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    sel z1.s, p0, z2.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q3, [x1]
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-96]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp s0, s2, [sp, #20]
; NONEON-NOSVE-NEXT:    ldp s1, s3, [sp, #4]
; NONEON-NOSVE-NEXT:    ldr s4, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr s17, [sp]
; NONEON-NOSVE-NEXT:    ldp s6, s7, [sp, #36]
; NONEON-NOSVE-NEXT:    fcmp s1, s0
; NONEON-NOSVE-NEXT:    fcsel s0, s1, s0, eq
; NONEON-NOSVE-NEXT:    fcmp s3, s2
; NONEON-NOSVE-NEXT:    ldp s1, s5, [sp, #28]
; NONEON-NOSVE-NEXT:    fcsel s2, s3, s2, eq
; NONEON-NOSVE-NEXT:    ldp s16, s3, [sp, #44]
; NONEON-NOSVE-NEXT:    fcmp s4, s1
; NONEON-NOSVE-NEXT:    fcsel s1, s4, s1, eq
; NONEON-NOSVE-NEXT:    fcmp s5, s3
; NONEON-NOSVE-NEXT:    ldr s4, [sp, #52]
; NONEON-NOSVE-NEXT:    fcsel s3, s5, s3, eq
; NONEON-NOSVE-NEXT:    fcmp s6, s4
; NONEON-NOSVE-NEXT:    ldr s5, [sp, #56]
; NONEON-NOSVE-NEXT:    stp s2, s1, [sp, #72]
; NONEON-NOSVE-NEXT:    fcsel s4, s6, s4, eq
; NONEON-NOSVE-NEXT:    fcmp s7, s5
; NONEON-NOSVE-NEXT:    ldr s6, [sp, #60]
; NONEON-NOSVE-NEXT:    fcsel s5, s7, s5, eq
; NONEON-NOSVE-NEXT:    fcmp s16, s6
; NONEON-NOSVE-NEXT:    ldr s7, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s3, s4, [sp, #80]
; NONEON-NOSVE-NEXT:    fcsel s6, s16, s6, eq
; NONEON-NOSVE-NEXT:    fcmp s17, s7
; NONEON-NOSVE-NEXT:    fcsel s3, s17, s7, eq
; NONEON-NOSVE-NEXT:    stp s5, s6, [sp, #88]
; NONEON-NOSVE-NEXT:    stp s3, s0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x float>, ptr %a
  %op2 = load <8 x float>, ptr %b
  %mask = fcmp oeq <8 x float> %op1, %op2
  %sel = select <8 x i1> %mask, <8 x float> %op1, <8 x float> %op2
  store <8 x float> %sel, ptr %a
  ret void
}

define <1 x double> @select_v1f64(<1 x double> %op1, <1 x double> %op2, <1 x i1> %mask) {
; CHECK-LABEL: select_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tst w0, #0x1
; CHECK-NEXT:    fcsel d0, d0, d1, ne
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    tst w0, #0x1
; NONEON-NOSVE-NEXT:    fcsel d0, d0, d1, ne
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %sel = select <1 x i1> %mask, <1 x double> %op1, <1 x double> %op2
  ret <1 x double> %sel
}

define <2 x double> @select_v2f64(<2 x double> %op1, <2 x double> %op2, <2 x i1> %mask) {
; CHECK-LABEL: select_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $z2
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    lsl z2.d, z2.d, #63
; CHECK-NEXT:    asr z2.d, z2.d, #63
; CHECK-NEXT:    and z2.d, z2.d, #0x1
; CHECK-NEXT:    cmpne p0.d, p0/z, z2.d, #0
; CHECK-NEXT:    sel z0.d, p0, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    str d2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d1, d2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    sbfx x8, x8, #0, #1
; NONEON-NOSVE-NEXT:    cmp x8, #0
; NONEON-NOSVE-NEXT:    sbfx x8, x9, #0, #1
; NONEON-NOSVE-NEXT:    fcsel d3, d2, d0, ne
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    cmp x8, #0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, ne
; NONEON-NOSVE-NEXT:    stp d0, d3, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %sel = select <2 x i1> %mask, <2 x double> %op1, <2 x double> %op2
  ret <2 x double> %sel
}

define void @select_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: select_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    fcmeq p1.d, p0/z, z1.d, z0.d
; CHECK-NEXT:    fcmeq p0.d, p0/z, z2.d, z3.d
; CHECK-NEXT:    mov z0.d, p1/m, z1.d
; CHECK-NEXT:    sel z1.d, p0, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: select_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q0, q3, [x1]
; NONEON-NOSVE-NEXT:    ldp q1, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-96]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp d5, d1, [sp]
; NONEON-NOSVE-NEXT:    ldp d0, d3, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp d4, d2, [sp, #40]
; NONEON-NOSVE-NEXT:    fcmp d1, d0
; NONEON-NOSVE-NEXT:    fcsel d0, d1, d0, eq
; NONEON-NOSVE-NEXT:    fcmp d3, d2
; NONEON-NOSVE-NEXT:    ldr d1, [sp, #56]
; NONEON-NOSVE-NEXT:    fcsel d2, d3, d2, eq
; NONEON-NOSVE-NEXT:    fcmp d4, d1
; NONEON-NOSVE-NEXT:    ldr d3, [sp, #16]
; NONEON-NOSVE-NEXT:    fcsel d1, d4, d1, eq
; NONEON-NOSVE-NEXT:    fcmp d5, d3
; NONEON-NOSVE-NEXT:    fcsel d3, d5, d3, eq
; NONEON-NOSVE-NEXT:    stp d2, d1, [sp, #80]
; NONEON-NOSVE-NEXT:    stp d3, d0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x double>, ptr %a
  %op2 = load <4 x double>, ptr %b
  %mask = fcmp oeq <4 x double> %op1, %op2
  %sel = select <4 x i1> %mask, <4 x double> %op1, <4 x double> %op2
  store <4 x double> %sel, ptr %a
  ret void
}
