; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-pc-windows-elf < %s | FileCheck %s

; Make sure windows elf does not assert with exceptions. This is a
; hack for MCJIT that could be treated as an error when it is removed.

@_ZTIi = external global ptr

declare i32 @foo(i32)
declare i32 @__gxx_personality_v0(...)

define void @bar() personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: bar:
; CHECK:       // %bb.0: // %continue
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    adrp x8, :got:foo
; CHECK-NEXT:    mov w0, #42 // =0x2a
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:foo]
; CHECK-NEXT:    blr x8
; CHECK-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    ret
  %exn.slot = alloca ptr
  %ehselector.slot = alloca i32
  %1 = invoke i32 @foo(i32 42) to label %continue unwind label %cleanup

cleanup:
  %lp = landingpad { ptr, i32 } cleanup
  %lp.0 = extractvalue { ptr, i32 } %lp, 0
  store ptr %lp.0, ptr %exn.slot, align 8
  %lp.1 = extractvalue { ptr, i32 } %lp, 1
  store i32 %lp.1, ptr %ehselector.slot, align 4
  br label %eh.resume

continue:
  ret void

eh.resume:
  %exn = load ptr, ptr %exn.slot, align 8
  unreachable
}
