; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 \
; RUN:   | FileCheck %s --check-prefixes=COMMON,CHECK
; RUN: opt -passes='print<access-info>' -disable-output \
; RUN:   -mtriple=arm64-apple-macosx %s 2>&1 \
; RUN:   | FileCheck %s --check-prefixes=COMMON,VW128
; RUN: opt -passes='print<access-info>' -disable-output \
; RUN:   -mtriple=arm64-apple-macosx -mattr=+sve %s 2>&1 \
; RUN:   | FileCheck %s --check-prefixes=COMMON,MAXLEN

; REQUIRES: aarch64-registered-target

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

; If the dependence distance is not a constant, whether it gets identified as backwards or unknown depends on the minimum distance and the target's vector length.

define void @backward_min_distance_8(ptr %A, i64 %N) {
; COMMON-LABEL: 'backward_min_distance_8'
; COMMON-NEXT:    loop:
; COMMON-NEXT:      Memory dependences are safe with run-time checks
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Check 0:
; COMMON-NEXT:        Comparing group GRP0:
; COMMON-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; COMMON-NEXT:        Against group GRP1:
; COMMON-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; COMMON-NEXT:      Grouped accesses:
; COMMON-NEXT:        Group GRP0:
; COMMON-NEXT:          (Low: {(1 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(257 + %A),+,1}<nw><%outer.header>)
; COMMON-NEXT:            Member: {{\{\{}}(1 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; COMMON-NEXT:        Group GRP1:
; COMMON-NEXT:          (Low: %A High: (256 + %A))
; COMMON-NEXT:            Member: {%A,+,1}<nuw><%loop>
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
; COMMON-NEXT:    outer.header:
; COMMON-NEXT:      Report: loop is not the innermost loop
; COMMON-NEXT:      Dependences:
; COMMON-NEXT:      Run-time memory checks:
; COMMON-NEXT:      Grouped accesses:
; COMMON-EMPTY:
; COMMON-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; COMMON-NEXT:      SCEV assumptions:
; COMMON-EMPTY:
; COMMON-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 1, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}

define void @backward_min_distance_120(ptr %A, i64 %N) {
; CHECK-LABEL: 'backward_min_distance_120'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with a maximum safe vector width of 120 bits
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:        BackwardVectorizable:
; CHECK-NEXT:            %l = load i8, ptr %gep, align 4 ->
; CHECK-NEXT:            store i8 %add, ptr %gep.off.iv, align 4
; CHECK-EMPTY:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
; CHECK-NEXT:    outer.header:
; CHECK-NEXT:      Report: loop is not the innermost loop
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; VW128-LABEL: 'backward_min_distance_120'
; VW128-NEXT:    loop:
; VW128-NEXT:      Memory dependences are safe with run-time checks
; VW128-NEXT:      Dependences:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Check 0:
; VW128-NEXT:        Comparing group GRP0:
; VW128-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; VW128-NEXT:        Against group GRP1:
; VW128-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; VW128-NEXT:      Grouped accesses:
; VW128-NEXT:        Group GRP0:
; VW128-NEXT:          (Low: {(15 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(271 + %A),+,1}<nw><%outer.header>)
; VW128-NEXT:            Member: {{\{\{}}(15 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; VW128-NEXT:        Group GRP1:
; VW128-NEXT:          (Low: %A High: (256 + %A))
; VW128-NEXT:            Member: {%A,+,1}<nuw><%loop>
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
; VW128-NEXT:    outer.header:
; VW128-NEXT:      Report: loop is not the innermost loop
; VW128-NEXT:      Dependences:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Grouped accesses:
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
;
; MAXLEN-LABEL: 'backward_min_distance_120'
; MAXLEN-NEXT:    loop:
; MAXLEN-NEXT:      Memory dependences are safe with run-time checks
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Check 0:
; MAXLEN-NEXT:        Comparing group GRP0:
; MAXLEN-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; MAXLEN-NEXT:        Against group GRP1:
; MAXLEN-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-NEXT:        Group GRP0:
; MAXLEN-NEXT:          (Low: {(15 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(271 + %A),+,1}<nw><%outer.header>)
; MAXLEN-NEXT:            Member: {{\{\{}}(15 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; MAXLEN-NEXT:        Group GRP1:
; MAXLEN-NEXT:          (Low: %A High: (256 + %A))
; MAXLEN-NEXT:            Member: {%A,+,1}<nuw><%loop>
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
; MAXLEN-NEXT:    outer.header:
; MAXLEN-NEXT:      Report: loop is not the innermost loop
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 15, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}

define void @backward_min_distance_128(ptr %A, i64 %N) {
; CHECK-LABEL: 'backward_min_distance_128'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with a maximum safe vector width of 128 bits
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:        BackwardVectorizable:
; CHECK-NEXT:            %l = load i8, ptr %gep, align 4 ->
; CHECK-NEXT:            store i8 %add, ptr %gep.off.iv, align 4
; CHECK-EMPTY:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
; CHECK-NEXT:    outer.header:
; CHECK-NEXT:      Report: loop is not the innermost loop
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; VW128-LABEL: 'backward_min_distance_128'
; VW128-NEXT:    loop:
; VW128-NEXT:      Memory dependences are safe with run-time checks
; VW128-NEXT:      Dependences:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Check 0:
; VW128-NEXT:        Comparing group GRP0:
; VW128-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; VW128-NEXT:        Against group GRP1:
; VW128-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; VW128-NEXT:      Grouped accesses:
; VW128-NEXT:        Group GRP0:
; VW128-NEXT:          (Low: {(16 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(272 + %A),+,1}<nw><%outer.header>)
; VW128-NEXT:            Member: {{\{\{}}(16 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; VW128-NEXT:        Group GRP1:
; VW128-NEXT:          (Low: %A High: (256 + %A))
; VW128-NEXT:            Member: {%A,+,1}<nuw><%loop>
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
; VW128-NEXT:    outer.header:
; VW128-NEXT:      Report: loop is not the innermost loop
; VW128-NEXT:      Dependences:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Grouped accesses:
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
;
; MAXLEN-LABEL: 'backward_min_distance_128'
; MAXLEN-NEXT:    loop:
; MAXLEN-NEXT:      Memory dependences are safe with run-time checks
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Check 0:
; MAXLEN-NEXT:        Comparing group GRP0:
; MAXLEN-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; MAXLEN-NEXT:        Against group GRP1:
; MAXLEN-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-NEXT:        Group GRP0:
; MAXLEN-NEXT:          (Low: {(16 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(272 + %A),+,1}<nw><%outer.header>)
; MAXLEN-NEXT:            Member: {{\{\{}}(16 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; MAXLEN-NEXT:        Group GRP1:
; MAXLEN-NEXT:          (Low: %A High: (256 + %A))
; MAXLEN-NEXT:            Member: {%A,+,1}<nuw><%loop>
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
; MAXLEN-NEXT:    outer.header:
; MAXLEN-NEXT:      Report: loop is not the innermost loop
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 16, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}

define void @backward_min_distance_256(ptr %A, i64 %N) {
; CHECK-LABEL: 'backward_min_distance_256'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with a maximum safe vector width of 256 bits
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:        BackwardVectorizable:
; CHECK-NEXT:            %l = load i8, ptr %gep, align 4 ->
; CHECK-NEXT:            store i8 %add, ptr %gep.off.iv, align 4
; CHECK-EMPTY:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
; CHECK-NEXT:    outer.header:
; CHECK-NEXT:      Report: loop is not the innermost loop
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
; VW128-LABEL: 'backward_min_distance_256'
; VW128-NEXT:    loop:
; VW128-NEXT:      Memory dependences are safe with a maximum safe vector width of 256 bits
; VW128-NEXT:      Dependences:
; VW128-NEXT:        BackwardVectorizable:
; VW128-NEXT:            %l = load i8, ptr %gep, align 4 ->
; VW128-NEXT:            store i8 %add, ptr %gep.off.iv, align 4
; VW128-EMPTY:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Grouped accesses:
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
; VW128-NEXT:    outer.header:
; VW128-NEXT:      Report: loop is not the innermost loop
; VW128-NEXT:      Dependences:
; VW128-NEXT:      Run-time memory checks:
; VW128-NEXT:      Grouped accesses:
; VW128-EMPTY:
; VW128-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; VW128-NEXT:      SCEV assumptions:
; VW128-EMPTY:
; VW128-NEXT:      Expressions re-written:
;
; MAXLEN-LABEL: 'backward_min_distance_256'
; MAXLEN-NEXT:    loop:
; MAXLEN-NEXT:      Memory dependences are safe with run-time checks
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Check 0:
; MAXLEN-NEXT:        Comparing group GRP0:
; MAXLEN-NEXT:          %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
; MAXLEN-NEXT:        Against group GRP1:
; MAXLEN-NEXT:          %gep = getelementptr inbounds i8, ptr %A, i64 %iv
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-NEXT:        Group GRP0:
; MAXLEN-NEXT:          (Low: {(32 + %A)<nuw>,+,1}<nuw><%outer.header> High: {(288 + %A),+,1}<nw><%outer.header>)
; MAXLEN-NEXT:            Member: {{\{\{}}(32 + %A)<nuw>,+,1}<nuw><%outer.header>,+,1}<nuw><%loop>
; MAXLEN-NEXT:        Group GRP1:
; MAXLEN-NEXT:          (Low: %A High: (256 + %A))
; MAXLEN-NEXT:            Member: {%A,+,1}<nuw><%loop>
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
; MAXLEN-NEXT:    outer.header:
; MAXLEN-NEXT:      Report: loop is not the innermost loop
; MAXLEN-NEXT:      Dependences:
; MAXLEN-NEXT:      Run-time memory checks:
; MAXLEN-NEXT:      Grouped accesses:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; MAXLEN-NEXT:      SCEV assumptions:
; MAXLEN-EMPTY:
; MAXLEN-NEXT:      Expressions re-written:
;
entry:
  br label %outer.header

outer.header:
  %outer.iv = phi i64 [ 32, %entry ], [ %outer.iv.next, %outer.latch ]
  %gep.off = getelementptr inbounds i8, ptr %A, i64 %outer.iv
  br label %loop

loop:
  %iv = phi i64 [ 0, %outer.header ], [ %iv.next, %loop ]
  %gep = getelementptr inbounds i8, ptr %A, i64 %iv
  %l = load i8 , ptr %gep, align 4
  %add = add nsw i8 %l, 5
  %gep.off.iv = getelementptr inbounds i8, ptr %gep.off, i64 %iv
  store i8 %add, ptr %gep.off.iv, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %exitcond.not = icmp eq i64 %iv.next, 256
  br i1 %exitcond.not, label %outer.latch, label %loop

outer.latch:
  %outer.iv.next = add nuw nsw i64 %outer.iv, 1
  %ec.2 = icmp eq i64 %outer.iv.next, %N
  br i1 %ec.2, label %exit, label %outer.header

exit:
  ret void
}
