/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.path.PathInputPanel;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathInputBase {
    private static InstallData installData;
    private static final Logger logger;
    public static final String SHOWCREATEDIRECTORYMESSAGE = "ShowCreateDirectoryMessage";
    public static final String SHOWEXISTINGDIRECTORYWARNING = "ShowExistingDirectoryWarning";

    public static void setInstallData(InstallData installData) {
        PathInputBase.installData = installData;
    }

    public static boolean isWritable(String path) {
        return PathInputBase.isWritable(new File(path));
    }

    public static boolean isWritable(File path) {
        boolean result = false;
        File existParent = IoHelper.existingParent(path);
        if (existParent != null) {
            if (installData.getPlatform().isA(Platforms.WINDOWS)) {
                try {
                    File tmpDir = new File(existParent.getAbsoluteFile() + File.separator + "iZwrite" + System.nanoTime());
                    tmpDir.mkdir();
                    File tmpFile = new File(tmpDir.getAbsoluteFile() + File.separator + "izWrite.tmp");
                    tmpFile.createNewFile();
                    result = true;
                    if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                    if (!tmpDir.delete()) {
                        tmpDir.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.toString(), e);
                }
            } else {
                result = existParent.canWrite();
            }
        }
        return result;
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return "";
        }
        if (path.startsWith("~") && installData.getPlatform().isA(Platform.Name.UNIX)) {
            String home = System.getProperty("user.home");
            path = home + path.substring(1);
        }
        return new File(path).getAbsolutePath();
    }

    static {
        logger = Logger.getLogger(PathInputPanel.class.getName());
    }
}

