/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.ConditionReference;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.rules.process.RefCondition;

public class NotCondition
extends ConditionReference {
    private static final long serialVersionUID = 2886367480913278231L;
    private transient RulesEngine rules;
    private String referencedConditionId;

    public NotCondition(RulesEngine rules) {
        this.rules = rules;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() <= 0) {
            throw new Exception("Missing nested element in condition \"" + this.getId() + "\"");
        }
        String type = xmlcondition.getAttribute("type");
        if (xmlcondition.getChildrenCount() != 1 || type == null || type.equals("ref") && !RefCondition.isValidRefCondition(xmlcondition.getChildAtIndex(0))) {
            throw new Exception("Condition \"" + this.getId() + "\" needs exactly one condition of type \"ref\" as operand");
        }
        RefCondition refCondition = new RefCondition(this.rules);
        refCondition.readFromXML(xmlcondition.getChildAtIndex(0));
        this.referencedConditionId = refCondition.getReferencedConditionId();
    }

    @Override
    public void resolveReference() {
        Condition condition = null;
        if (this.referencedConditionId != null) {
            condition = this.rules.getCondition(this.referencedConditionId);
        }
        if (condition == null) {
            throw new IzPackException("Referenced condition \"" + this.referencedConditionId + "\" not found");
        }
        this.setReferencedCondition(condition);
    }

    @Override
    public boolean isTrue() {
        Condition condition = this.getReferencedCondition();
        if (condition != null) {
            if (condition.getInstallData() == null) {
                condition.setInstallData(this.getInstallData());
            }
            return !condition.isTrue();
        }
        return false;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuilder details = new StringBuilder();
        details.append(this.getId());
        details.append(" depends on:<ul><li>NOT ");
        details.append(this.getReferencedCondition().getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        IXMLElement conditionElement = this.rules.createConditionElement(this.getReferencedCondition(), conditionRoot);
        this.getReferencedCondition().makeXMLData(conditionElement);
        conditionRoot.addChild(conditionElement);
    }

    public static Condition createFromCondition(Condition referencedCondition, RulesEngine rules) {
        NotCondition notCondition = null;
        if (referencedCondition != null) {
            notCondition = new NotCondition(rules);
            notCondition.setReferencedCondition(referencedCondition);
            notCondition.setInstallData(referencedCondition.getInstallData());
        }
        return notCondition;
    }
}

