'\" t
.\" tbl X |troffort -man -IOF -A4 -r21 -w8.25
.\" SCCS Information: %Z%%Y% %M% %I% %G%
.\" =========================================================
.\" EDIT HISTORY:
.\" 
.\" 05/05/91	HAIM ROMAN, COMPUTER SCIENCE DEPARTMENT, TECHNION
.\" (1) Added references to hvt100 (the Hebrew-English emulator for X)
.\"
.\" 04/03/90	HAIM ROMAN, COMPUTER SCIENCE DEPARTMENT, TECHNION
.\" (1) Added .exrciv, EXINITV, & TERMIV
.\" (2) Added using vi.iv on a Sun screen
.\" (3) Updated BUGS section
.\" (4) added TERMCAP section
.\" (5) Added ^X, v, & V commands to OPTIONS & COMMAND SUMMARY section
.\" (6) Redefined string registers & .PR/.PL macros so they also work
.\" under nroff.
.\" 
.\" 01/01/89	HAIM ROMAN, COMPUTER SCIENCE DEPARTMENT, TECHNION
.\" (1) Changed listing of bugs to match latest version of vi.iv.
.\" (2) Changed Hebrew font from J (Jerusalem) to OF (OldJaffa-Fixed),
.\" because OF is a fixed-width font.
.\" (3) Changed font position 21 to 15 & 14 to 30, to match the ditroff's
.\" new defaults for RL fonts & dtroff's new default assignments of fonts
.\" to positions.
.\" 
.\" 11/1989		HAIM ROMAN, COMPUTER SCIENCE DEPARTMENT, TECHNION
.\" (1) changed 21 to 14 & 14 to 21, because with ditroff, font
.\" positions 19-23 are by default RL fonts
.\" 
.\" 1988		URI HABUSHA &/or DAN BERRY, COMPUTER SCIENCE
.\" 			DEPARTMENT, TECHNION
.\" created this manual
.\" =========================================================
.\" INITIAL DEFINITIONS & SETUP:
.\" -| -- string register denoting the beginning of a file
.ds -| \-\h'-.24m'|
.\" 
.\" es -- string register for the ESCAPE symbol
.if n .ds es <ESC>
.if t .ds es \(te
.\" 
.\" nl -- string register denoting carriage-return or new-line
.if n .ds nl <NEWL>
.if t .ds nl \(cr
.\" 
.\" .PR/.PL -- commands for FFORTID postprocessor
.\" 	Do not define these if processing via nroff, as they will just
.\" 	produce garbage in the output.
.if t \
\{\
.dePR
.br
.fl
\\!x PR
.br
..
.dePL
.br
.fl
\\!x PL
.br
..
.\}
.nh
.\" .su -- subsection
.de su
.sp
.ne 3
\\fB\\$1\\fR
.br
..
.\" .ES/.EE -- example start & example end ??????
.de ES
.ft C
.sp
.nf
..
.de EE
.fi
.ft R
.sp
..
.de SB
.in 1.5i
.ll 3i
.ft C
..
.de SE
.in
.ll
.ft R
..
.\" 
.\" 	IN ORDER TO USE WITH DITROFF, THE RL FONTS MUST BE 13-17
.\" 	OR 23.
.\" 		(HAIM ROMAN 22/11/1989)
.\" 
.\" .\".fp 13 hF \" as RL alphabet
.fp 15 OF \" as RL alphabet
.\" .\".fp 18 hT \" as RL alphabet
.\" .\".fp 20 hF \" as LR alphabet
.fp 30 OF \" as LR alphabet
.\" .\".fp 22 hT \" as LR alphabet
.\" ==============================================================
.\" T E X T   O F   T H E   M A N U A L :
.\" 
.\" .TH VI.IV 1 "December, 1988"
.TH VI.IV L "February, 1990"
.UC
.SH NAME
vi.iv \-bi-directional full-screen text editor based on vi
.SH SYNOPSIS
\&\fCvi.iv\fP
[
.\" \fIvi.iv options\fP		.\" LISTED THE VI.IV OPTIONS
\&\fC\-S\fP
] [
\&\fC\-MS\fP
] [
\&\fC\-LR|RL
] [
.\" \&\fC\-t\fP		.\" NOT LISTING THE NORMAL VI COMMANDS IN DETAIL
.\" \fItag\fP
.\" ] [
.\" \&\fC\-r\fP
.\" ] [
.\" \&\fC+\fIcommand\fR
.\" ] [
.\" \&\fC\-l\fP
.\" ] [
.\" \&\fC\-w\fIn\fR
\&\fIvi options\fP
]
\fIname ...\fP
.\".I "vi options"
.\"] [
.\"\fB+\fR\fIcommand\fR
.\"] [
.\"\fB\-w\fIn\fR
.\"]
.\"name ...
.\" ===========================================================
.SH NOTE:
This manual is fairly long, since it describes some of the concepts of
bi-directional editing that 
.I vi.iv
is based on.
If this is your first time editing time-ordered bi-directional text,
it is probably worthwhile to read the DESCRIPTION section.  But if you
want to skip that and get more concise information about how ro run 
.I vi.iv
and the commands it has that
.I vi (1)
does not have, you'll want to read the following sections:
OPTIONS & COMMANDS, and THE TECHNION COMPUTER SCIENCE FACULTY
INSTALLATION.  If you are responsible for maintaining 
.I vi.iv ,
then you may also want to read TERMCAP FIELDS.
.\" ===========================================================
.SH DESCRIPTION
\fIvi.iv\fP is a bi-directional full screen text editor based on
\fIvi\fP(1). \fIvi.iv\fP works just like \fIvi\fP
except for being able to handle bi-directional text,
for example containing English and Hebrew.
\fIvi.iv\fP is not limited to terminals supporting Hebrew,
and can likewise work with
all alphabets found on the terminal. Therefore, in order to not be
restricted to these particular languages, we will speak in the abstract
about a language LR, written from left to right, and about a language RL,
written from right to left.
The language LR \fIis\fP, however, written with the Latin
alphabet, the alphabet of the ASCII codes. The lanuage RL can be Arabic,
Hebrew, etc., although the examples in this manual page are in Hebrew.
.PP
The reader is assumed to be familiar with \fIvi\fP. \fIvi.iv\fP has been
designed to appear as \fIvi\fP when only LR text is used and is shown from
left-to-right. Accordingly, the explanation given here is focused on the
difference between \fIvi.iv\fP and \fIvi\fP and explains most things in
terms of the already well-known behavior of \fIvi\fP.
.PP
.\" 	CHANGE THIS BACK WHEN INSTALL A CONSTANT-WIDTH FONT
.\" All examples of file contents, screen appearances, and entered commands or
.\" text are shown in constant width fonts. File contents 
In the examples, file contents
are always shown from
left to right and have a file-beginning symbol, \(lq\fC\*(-|\fP\(rq, at the left
end. Screen appearances are marked by vertical bars on the left and right
sides serving as boundaries of an imaginary screen whose width is 30
characters. Entered text or commands are always shown from left to right
with no special markings at either end; each character shown is part of the
input. In a file contents or an input, \(lq\*(nl\(rq represents a
new-line character or a carriage return respectively, \(lq^\(rq
represents pressing CONTROL simultaneously with the following character,
\(lq\*(es\(rq represents the ESCAPE character, and \(lq\(sq\(rq
represents a blank when emphasis is needed.
.su "Principles"
.PP
There are a few simple principles which form the bases for both the design and
effective use of \fIvi.iv\fP. They guided the design and implementation.
A clear understanding of them by the user allows him or her to deduce the
expected behavior of the system.
.su "Coding of Characters"
.PP
Normally, seven bits suffices for the encoding of the Latin letters in what is
called the ASCII code. Likewise, seven bits suffices for the encoding each
of the
Hebrew and Arabic alphabets. There exists standard encodings for each
in which the letters get codes allocated to letters in ASCII. Thus the
standard encodings for Hebrew and Arabic have the digits,
punctuation and control characters in the same positions they have in ASCII.
\fIvi.iv\fP assumes an encoding for the characters of the alphabets such
that the characters of the Latin alphabet, according to the ASCII code have
the eighth bit off. It assumes that the characters of the other RL alphabet
have the eighth bit on with the lower order seven bits as in the standard
code. Thus if RL is Hebrew, \fIvi.iv\fP is using the
ESCII code. (See \fIescii\fP(7).) By storing all characters with the proper
setting of the eighth bit, the file remembers the language for all
characters, even the digits, punctuation, and control characters, such as
tabs. In addition, most recently developed
terminals, with the ability to change alphabet on a character-by-character
basis, use the eighth bit to indicate in which language a particular seven bit
code is to be shown on the screen.
.su "Current View"
.PP
The first of these is the concept of a \fIview\fP of a document. At any time,
\fIvi.iv\fP has a window open on a portion of a document. That portion is
called the \fIcurrent view\fP and is what the user sees on the screen.
.ne 3
.su "View Direction"
.PP
At any time, the view that \fIvi.iv\fP is presenting has a direction, which
is either left-to-right (LR) or right-to-left (RL).
In the following, \(lqX\(rq and \(lqY\(rq are each
\(lqleft\(rq or \(lqright\(rq but not the same.
The impact of this direction is that if it is from X
to Y, then the beginning of a line is on the X side of the screen, paragraph
indentation takes place on the X side of the screen, the end of a line is
either at the Y end of the screen or some place to the Y of the beginning,
etc.  The view direction is
superimposed on what ever text is being shown at the moment.
As far as \fIvi.iv\fP is concerned, the view direction
\fInothing\fP whatsoever to do with the language of the document; although
to the human user, using an LR view for a Hebrew document or an RL view for an
English document will not feel too comfortable.
Some English text in an LR view is:
.ES
.SB
|If I am not for myself,       |
|  then who is for me?         |
|If I am only for myself,      |
|  then what am I?             |
|If not now, then when?        |
|  -Pirke Avot                 |
.SE
.EE
The same text in an RL view does not look quite as nice:
.PR
.ES
.SB
.ft 15
|\fCIf I am not for myself,\f(15       |
|\fC  then who is for me?\f(15         |
|\fCIf I am only for myself,\f(15      |
|\fC  then what am I?\f(15             |
|\fCIf not now, then when?\f(15        |
|\fC  -Pirke Avot\f(15                 |
.SE
.EE
.PL
Actually, because English is an LR language, in an RL view, it is being
written backwards in order that it appear written from left to right.
Some Hebrew text in an RL view is:
.PR
.ES
.SB
.ft 15
|`m `io `pi li, ni li?         |
|`m `pi lrvni, nd `pi?         |
|`m l` rkyie, `inzi?           |
|  -txwi `aez                  |
.SE
.EE
.PL
The same Hebrew text in an LR view does not look so nice:
.ES
.SB
|\f(15`m `io `pi li, ni li?\fC         |
|\f(15`m `pi lrvni, nd `pi?\fC         |
|\f(15`m l` rkyie, `inzi?\fC           |
|\f(15  -txwi `aez\fC                  |
.SE
.EE
Similarly, because Hebrew is an RL language, in an LR view, it is being
written backwards in order that it appear written from right to left.
.PP
The current view direction can be changed at any time by use of a set command;
.ES
	:set rightleft
	:set rl
	:set nolr
	:set noleftright
.EE
all set the view direction as RL, and
.ES
	:set leftright
	:set lr
	:set norl
	:set norightleft
.EE
all set the view direction as LR. Note then that any given window of the
file being edited can be viewed from either direction, although not at the
same time in a given \fIvi.iv\fP invocation.
When started up, \fIvi.iv\fP assumes an LR view direction unless there is
a contraindicating command in the \&\fC.exrc\fP (or \&\fC.exriv\fP) 
file or in the \&\fCEXINIT\fP (or \&\fCEXINITIV\fP) variable.
.su "Time Order vs. Visual Order"
.PP
A given file can be kept in one of two orders:
.TP
\fBtime order\fP
.br
The characters are stored in the order in which they would be input if
the text were typed from beginning to end with no backspacing. It is the
order in which the characters are pronounced if the text is read aloud.
Thus if one considers the file as ordered from left to right, then the
letters of LR text appear to be in the right order, but the letters of RL
text appears to be backwards.
.TP
\fBvisual order\fP
.br
The characters are stored in the order in which they appear on the screen.
.PP
In order to clarify the difference between these two orders, suppose
that the view direction is from right to left, and suppose one typed
the letters
.ES
	\f(30yni\(sq\fCuri
.EE
with the intention of seeing
.PR
.ES
.SB
.ft 15
|yni \fCuri\f(15                       |
.SE
.EE
.PL
on the screen.  That intention implies that the view must
be RL, for the first word is on the right.
With time order the characters are stored in the file in the following
order:
.ES
	\*(-|\f(30yni\(sq\fCuri
.EE
With visual order the characters are stored in the file in the following
order:
.ES
	\*(-|\fC                       uri\(sq\f(30iny
.EE
.PP
If, on the other hand, the view direction were LR, then the same
input would appear as
.ES
.SB
|\f(15yni\fC uri                       |
.SE
.EE
on the screen.
With time order, the characters are stored in the file in the same order as
for the RL view example:
.ES
	\*(-|\f(30yni\(sq\fCuri
.EE
However, with visual order the characters are stored in the file
in the following order:
.ES
	\*(-|\f(30iny\(sq\fCuri
.EE
Note that in all of the above examples,
in order for the space to end up between the
two words, the space has to be entered in the language whose
direction is the same as that of the view.
.PP
Thus, time order is dependent only on the order of input and is
independent of the viewing order. Visual order is dependent on the
order of input and on the viewing order.
.su "Screen Appearance"
.PP
While the contents of files are kept in time order, the screen appearance
of those contents are in the order in which a human being wants to see the
characters. In this order, all the text on one line is read before moving
on to the next, each language is read in its own natural direction, and the
major flow of each line is according to the natural direction of the
document's main language. Because the main language of a document is
somewhat arbitrary and depends on a human choice which can be indpendent of
the contents, \fIvi.iv\fP simply considers the current view direction as
defining for that moment a main language whose direction is equal to the
view direction.
.PP
The screen appearance of any view is a function of the current view
direction and the language of the individual characters, i.e., the state of
their eighth bits. While the actual editor cannot use exactly the following
algorithm (because it is trying to avoid to have to redraw whole lines),
the ultimate expected appearance of a view can be understood in terms of
the following line-by-line algorithm:
.ES
.ft H
\f(HBfor\fP each line in the view \f(HBdo\fP
	\f(HBif\fP the current view direction is LR \f(HBthen\fP
		rotate each contiguous string of RL text about its own center axis
	\f(HBelse\fP (the current view direction is RL)
		rotate the whole line about its center axis;
		rotate each contiguous string of LR text about its own center axis
	\f(HBfi\fP
\f(HBod\fP
.EE
.PP
As an example, consider the following three-line file contents:
.ES
	\*(-|\f(30de` `nx "\fCHello there Uri
	\*(-|and Dan. How are you
	\*(-|today?\f(30" l`exi ecpi`l
.EE
If the current view direction is LR, then the appearance of the view is:
.ES
.SB
|\f(15de` `nx "\fCHello there Uri      |
|and Dan. How are you          |
|today?\f(15" l`exi ecpi`l\fC          |
.SE
.EE
However, if the current view direction is RL, then the appearance of
the view is:
.PR
.ES
.SB
.ft 15
|de` `nx "\fCHello there Uri\f(15      |
|\fCand Dan. How are you\f(15          |
|\fCtoday?\f(15" l`exi ecpi`l          |
.SE
.EE
.PL
.PP
It is interesting that the formatting system used to format this manual,
\fIditroff/ffortid\fP, a bi-directional version of \fIditroff\fP
expects its input in time order and uses the same line-by-line algorithm to
reorganize the mixed langauge text on each line so that the text in each
language is printed in its own natural direction. Hence, in order to
arrange that the various screen displays were printed correctly it sufficed
to give to the formatter only the file contents. In order that file
contents not get reversed by the formatter, the same Hebrew font was
mounted in two different positions, only one of these positions was
specified to be RL, and the file examples were prepared with its Hebrew in
the LR position of the font.
.su "Shef Format"
.PP
The combination of ESCII code and time order is called \fIshef format\fP.
\fIvi.iv\fP's default assumption is that the file is in shef format.
The editor
.IR vih (l),
however, uses the following format:
.RS
.IP (1)
Visual order (going from right to left)
.IP (2)
The coding follows ASCII except:
.RS
.IP (a)
The codes normally assigned to the lower case letters (& the grave
accent, "\(ga") represent the Hebrew characters
.IP (b)
The lower case letters (& "\(ga") are represented by by their normal
ASCII codes with the eighth bit set
.RE
.RE
.PP
\fIVi.iv\fP can be invoked
with the \fC\-S\fP option to operate under ESCII with visual order.
Additionally, if after invoking \fIvi.iv\fP, it is discovered that the file
looks strange, one can cause \fIvi.iv\fP to operate in visual order by
uttering:
.ES
	:set nosheformat
.EE
Note that
the order of storage of the file is a permanent property of the file
and \fIvi.iv\fP will not convert the file from one order to another.
There are other programs, such as \fIsheff\fP(l), for that purpose.
.\" 
.su "Current Language of Input"
.PP
The next important concept is that of the current language of input. The
current language of input is either LR or RL. It governs how the
keystrokes are interpreted, what character appears on the screen and what
goes into the file. Once in the file, the language of a character does
\fInot\fP change even if the current language changes.
If the current language is LR, then the standard qwerty
keyboard is assumed and the generated ASCII seven-bit codes are stored with
the eighth bit off. If the current language is RL, then the standard
keyboard arrangement for RL is assumed, and the generated seven-bit codes
are stored with the eighth bit on; in some cases, the keyboard provides the
full eight-bit codes, and in some cases only seven bits comes from the
keyboard and the on eighth bit must provided by the software.
The termcap for each terminal describes which kind it is and describes what
operations the terminal is capable of doing; there is more on termcaps
later.
.PP
The command for switching the current language of input is \&\fC^x\fP.
As the user indicates a desire to switch by issuing the
switching command, \fIvi.iv\fP tells the terminal to switch mode if the
current termcap says that the terminal has a software-issueable command to
do so. If the terminal does not have such a command,
then the user is told by means of a highlighted bottom-line message
to manually flip the terminal's mode; of course, if the user fails to do so,
the results are weird!
.PP
There is a slight problem with the character chosen to indicate a change of
input language. Many users use \&\fC^x\fP as the line killing command by
having told the shell
.ES
	stty kill ^x
.EE
As a result giving \&\fC^x\fP during input causes erasing of the input line
rather than a change to the input language; \fIvi.iv\fP never gets to see
the \&\fC^x\fP since the \fItty\fP driver has swallowed it together with the
whole line of input.
As \fIvi\fP has given a meaning to almost every possible character
generable from the keyboard, there were not too many choices of characters
to use as the language change indication. The character had to be something
that is not likely to be put into a file; if it were, then the user would
have to escape it each time it would be put into the file rather than be
obeyed. Thus it had to be some \&\fCCONTROL\fP character that did not have
another meaning. Generally, a users uses either of \&\fC^x\fP or \&\fC^u\fP
as a signal to the \fItty\fP driver but not both. The latter is used more often
and is used as the line killer. Therefore, it was decided to use the former
as the language change indication and to make which character that is used
as the indication settable with:
.ES
	:set changelang=\fInew-character
.EE
The second author uses \&\fC^x\fP as the line killer and does
.ES
	:set changelang=^v^u
.EE
to set the language change indicator to \&\fC^u\fP.
In the subsequent discussion, \&\fC^x\fP is used to denote the language
change indicator whatever it may be.
.PP
The following begins a discussion of the effect of the commands. For each
command, its effect depends on the current constellation of view direction
and current language and takes into account the exigencies and implications
of preservation of time order.
.su "Modes"
.PP
There are three modes for which it is important to know the current
language and view direction direction, namely insert mode, command mode,
and pattern/substitute mode. Actually, \fIvi\fP considers there to be only
two modes, insert mode and command mode, with patterns and substitutions being
given in command mode. \fIvi.iv\fP treats patterns and substitutions
slightly different from other commands; hence, it is convenient to
them as being in a separate mode.
.su "Cursor"
.PP
Before considering the details of each mode, it is necessary to explain the
rules concerning the cursor's position. In command and pattern/substitute
modes, the cursor is positioned over the currently considered character,
namely the one to which the next command will apply. The cursor movement
commands work relative to the screen rather than relative to the file
contents. For example, hitting the left arrow key causes the cursor to
move to the left on the screen even across a language change boundary;
the cursor does not just move backwards in the file with
attendant jumps when crossing language change boundaries.
It was decided that equating cursor movement with movement within the file
would be too confusing to the user. It is far easier for \fIvi.iv\fP to map
from the current cursor position to the right position in the file than
for the user to map from the right position in the file to the
corresponding position on the screen.
.PP
For occasions in which movemement withing the file is desired, there are
commands for moving forward and backwards in the file.
Specifically, the \&\fCv\fP command is to move the cursor to the position
of the next character in the file. The command \&\fCV\fP moves the cursor
to the position of the previous character in the file.
These commands are useful for dispelling confusion
about the order of contents of the file. One
simply moves the cursor to the beginning of the line, according to the
current view direction, types \&\fCv\fP, and watches where the cursor goes.
.PP
In insert mode, the cursor is always at the screen position that will
receive the next character. Where this is relative to the previously
entered character depends on the current language and the current view
direction. After ESCAPEing from the insert mode, the cursor will move to be
at the character after the last inserted character relative to the current
view direction.
.su "Insert Mode"
.PP
The current language affects what is going into the file during insert
mode. As mentioned, if the current language is LR, then the input
is interpreted as coming from the standard Latin qwerty keyboard and the
characters go into the file with the eighth bit off. If the current
language is RL, then the input is interpreted as coming from the standard
RL keyboard and the characters go into the file with the eighth bit on.
.PP
The current language setting
is global over the insert mode sessions.
That is, if one exits and then re-enters
insert mode without having issued one of the language changing commands,
then the current language after re-entry is the same as before exit.
.PP
In insert mode, the current direction determines where the cursor starts
after each new line and in which direction it moves. If the direction is
LR, then the cursor starts at the left end and moves to the right. If the
current direction is RL, then the cursor starts at the right end and moves
to the left.
.PP
In an LR view direction, the \&\fCa\fP command moves the cursor to the
right of the current position to designate the position to receive
the first inserted character. The \&\fCi\fP command moves the cursor to the
left of the current position to designate the position to receive the
first inserted character. Thereafter, as mentioned, the cursor moves or
stays to be at the position to receive the next inserted character. Thus,
if the current language is LR, the cursor moves to the right, and if the current
language is RL, the cursor stays in the same position; in either case
the text to the right of the cursor slides to the right.
The rules for an RL view may be obtained by opposing each of \(lqleft\(rq
and \(lqright\(rq and \(lqR\(rq and \(lqL\(rq in the above.
.PP
Below are some examples of insertions. In each case, three versions of the
the state of the line being edited are shown after typing each character of
the insertion. The three versions are the file contents, the LR view, and
the RL view. In each screen view, the position of the cursor is marked with an
underscore. For each step, the three versions occupies three consecutive
lines, with the file contents to the far left, the LR view in the center,
and the RL view to the far right. Between the three lines for each step is
the next input character centered all by itself in the line.
This scheme of showing the successive
states during the input of an operation is followed for all the examples
shown in the remainder of this manual.
.PP
The initial state of the first example is:
.ES
\*(-|He said "" to Dan.
\h'1.5i'|He said \o'"\(ul'" to Dan.            |
.PR
\f(15|\fCHe said "\o'"\(ul' to Dan.\f(15            |
.PL
.EE
Now, suppose that the current language for input is RL, and the input is:
.ES
	a\f(30ylem\fP\*(es
.EE
that is, to append \&\f(15ylem\fP after the opening LR quote. The states are:
.ES
.ce
a
\*(-|He said "" to Dan.
\h'1.5i'|He said "\o'"\(ul' to Dan.            |
.PR
\f(15|\fCHe said \o'"\(ul'" to Dan.\f(15            |
.PL

.ce
\f(30y\fC
\*(-|He said "\f(30y\fC" to Dan.
\h'1.5i'|He said "\f(15\o'y\(ul'\fC" to Dan.           |
.PR
\f(15|\fCHe said \o'"\(ul'\f(15y\fC" to Dan.\f(15           |
.PL

.ce
\f(30l\fC
\*(-|He said "\f(30yl\fC" to Dan.
\h'1.5i'|He said "\f(15y\o'l\(ul'\fC" to Dan.          |
.PR
\f(15|\fCHe said \o'"\(ul'\f(15yl\fC" to Dan.\f(15          |
.PL

.ce
\f(30e\fC
\*(-|He said "\f(30yle\fC" to Dan.
\h'1.5i'|He said "\f(15yl\o'e\(ul'\fC" to Dan.         |
.PR
\f(15|\fCHe said \o'"\(ul'\f(15yle\fC" to Dan.\f(15         |
.PL

.ce
\f(30m\fC
\*(-|He said "\f(30ylem\fC" to Dan.
\h'1.5i'|He said "\f(15yle\o'm\(ul'\fC" to Dan.        |
.PR
\f(15|\fCHe said \o'"\(ul'\f(15ylem\fC" to Dan.\f(15        |
.PL

.ce
\*(es\fC
\*(-|He said "\f(30ylem\fC" to Dan.
\h'1.5i'|He said "\f(15\o'y\(ul'lem\fC" to Dan.        |
.PR
\f(15|\fCHe said "\f(15yle\o'm\(ul'\fC" to Dan.\f(15        |
.PL
.EE
Note that when the view direction runs counter to the normal direction of
most of the text, the results are somewhat surprising. The RL views of the
English sentence above were strange, especially after the Hebrew letters
were introduced.
.PP
The initial state of the second example is:
.ES
\*(-|\f(30de` `nx "" l`exi
\h'1.5i'\fC|\f(15de` `nx "\o'"\(ul' l`exi\fC              |
.PR
\f(15|de` `nx \o'"\(ul'" l`exi              |
.PL
.EE
The typed input is
.ES
	aHello\*(es
.EE
The subsequent states are:
.ES
.ce
a
\*(-|\f(30de` `nx "" l`exi
\h'1.5i'\fC|\f(15de` `nx \o'"\(ul'" l`exi\fC              |
.PR
\f(15|de` `nx "\o'"\(ul' l`exi              |
.PL

.ce
\fCH
\*(-|\f(30de` `nx "\fCH\f(30" l`exi
\h'1.5i'\fC|\f(15de` `nx \o'"\(ul'\fCH\f(15" l`exi\fC              |
.PR
\f(15|de` `nx "\fC\o'H\(ul'\f(15" l`exi              |
.PL

.ce
\fCe
\*(-|\f(30de` `nx "\fCHe\f(30" l`exi
\h'1.5i'\fC|\f(15de` `nx \o'"\(ul'\fCHe\f(15" l`exi\fC              |
.PR
\f(15|de` `nx "\fCH\o'e\(ul'\f(15" l`exi              |
.PL

.ce
\fCl
\*(-|\f(30de` `nx "\fCHel\f(30" l`exi
\h'1.5i'\fC|\f(15de` `nx \o'"\(ul'\fCHel\f(15" l`exi\fC              |
.PR
\f(15|de` `nx "\fCHe\o'l\(ul'\f(15" l`exi              |
.PL

.ce
\fCl
\*(-|\f(30de` `nx "\fCHell\f(30" l`exi
\h'1.5i'\fC|\f(15de` `nx \o'"\(ul'\fCHell\f(15" l`exi\fC              |
.PR
\f(15|de` `nx "\fCHel\o'l\(ul'\f(15" l`exi              \(|x
.PL

.ce
\fCo
\*(-|\f(30de` `nx "\fCHello\f(30" l`exi
\h'1.5i'\fC|\f(15de` `nx \o'"\(ul'\fCHello\f(15" l`exi\fC              |
.PR
\f(15|de` `nx "\fCHell\o'o\(ul'\f(15" l`exi              |
.PL

.ce
\*(es
\*(-|\f(30de` `nx "\fCHello\f(30" l`exi
\h'1.5i'\fC|\f(15de` `nx "\fCHell\o'o\(ul'\f(15" l`exi\fC              |
.PR
\f(15|de` `nx "\fC\o'H\(ul'ello\f(15" l`exi              |
.PL
.EE
.PP
In the case of an overwriting session of insert mode, from the issuance of
an \&\fCR\fP command, the cursor moves in the current language's direction
and stays over the next character to be changed.
.PP
Giving a \&\fC^x\fP during insert mode is equivalent to ESCAPEing to end
the current insertion or overwriting,
issuing \&\fC^x\fP during command mode, and
entering an append insertion in the other language at the point at which
the cursor came to rest upon the ESCAPE. Note that if you were in an
overwriting insert mode before the language change, you are no longer in
an overwriting insert mode after the change. The reason for this is that
with the direction change that happens with a language change, you would be
overwriting what you had just entered as an overwrite.
.su "Bi-lingual Characters"
.PP
There are a number of characters that are in both languages.
These are the digits, the punctuation symbols, and the space and tab
characters. These characters exist in both the lower and upper halves of
the full eight-bit character set. The two codes for any such character have
exactly the same lower order seven bits, and thus differ by exactly 128.
When they are typed, they will go into the file with the eighth bit setting
consistent with the current language direction.
.PP
While the two codes for one of these characters are printed the same way on
the screen, they cause different behavior under the rendering algorithm.
As a result, the user that cannot remember under which language one of
these characters is entered (It may not even have been entered by the same
user!) may be surprised by the screen appearance after modifications and
may not be able to predict the effects of modifications.
For example, exchanging the order of inputting a space and changing
langauge direction causes different screen appearances. Suppose the view
direction is R-L. Suppose one has entered in time order an LR \fItroff\fP
command with an RL argument. The time-ordered file contents are:
.ES
\*(-|\&.su\o' \(ul'\f(30zwvix
.EE
If the space between the \(``\fCu\fP\('' and the \(``\f(30z\fP\('' is in
LR, then the screen appearance of the line is:
.ES
.PR
\f(15|\fC\&.su\o' \(ul'\f(15zwvix                     |
.PL
.EE
If, however, the space is in RL, then the screen appearance is:
.ES
.PR
\f(15|\fC\&.su\f(15\o' \(ul'zwvix                     |
.PL
.EE
As another example, again in an R-L view, the time-ordered file contents
.ES
\*(-|\f(30dgaxd \fCJones & Sons
.EE
appears as
.ES
.PR
\f(15|dgaxd \fCJones & Sons\f(15            |
.PL
.EE
if the \(``\fC&\fP\('' and the spaces surrounding it are in LR, but appears
as
.ES
.PR
\f(15|dgaxd \fCJones\f(15 & \fCSons\f(15            |
.PL
.EE
if the \(``\fC&\fP\('' and the spaces are in RL.
.PP
In order to help the user not to get lost in these circumstances,
it was decided to have an option under which \fIvi.iv\fP would
highlight the characters of the language
whose direction opposes that of the current view.
This highlighting can be requested either from the invoking command line by
adding the \&\fC\-MS\fP option or from within \fIvi.iv\fP by 
uttering one of:
.ES
:set marksecondlang
:set marksl
.EE
This highlighting is done
by what ever method of highlighting is offered by the current terminal
as indicated by the current termcap.
With an underlining highlighting the four R-L view examples above would
appear, respectively, as:
.ES
.PR
\f(15|\fC\&\o'.\(ul'\o's\(ul'\o'u\(ul'\o' \(ul'\f(15zwvix                     |
.sp
\f(15|\fC\&\o'.\(ul'\o's\(ul'\o'u\(ul'\f(15 zwvix                     |
.sp
\f(15|dgaxd \fC\o'J\(ul'\o'o\(ul'\o'n\(ul'\o'e\(ul'\o's\(ul'\o' \(ul'\o'&\(ul'\o' \(ul'\o'S\(ul'\o'o\(ul'\o'n\(ul'\o's\(ul'\f(15            |
.sp
\f(15|dgaxd \fC\o'J\(ul'\o'o\(ul'\o'n\(ul'\o'e\(ul'\o's\(ul'\f(15 & \fC\o'S\(ul'\o'o\(ul'\o'n\(ul'\o's\(ul'\f(15            |
.PL
.EE
.PP
This feature should help the user keep track of numerals.
If one wants a numeral to appear in the normal order, it must be entered
either in L-R order as LR characters or in R-L order as RL
characters. The presence or lack of underlining should remind the user
which way the numerals were entered.
.PP
These bi-lingual characters cause a problem to users when constructing
search patterns. It is impossible, merely by looking at a printed copy of
text or by listening to someone or one's mind pronounce some text, to
know for sure under which language one of these characters was entered into
the edited file. Therefore, it was decided to let any of these characters
match itself in either language. Because the codes of the two languages'
versions of one of these characters differ only in the eighth bit, it was
easy to implement this modification to the search algorithm. Apart from the
eighth bit cleaning, this change
was the only one made to the editing command processor not directly for
the purpose of implementing a new feature.
.su "Numerals"
.PP
In some right-to-left languages, e.g., Hebrew, numerals are written
with the most significant digit on the left, i.e., from left to right.
For these RL languages, entering numerals is problematic. If in RL language
insertion mode, if the digits are entered in the order pronounced, i.e.,
most significant first, they will appear backwards on the screen. One way
to insure that the numerals appear in the normal order on the screen is to
always switch language direction, with \&\fC^x\fP, just before and just
after entering the numeral, so that the numeral goes in as LR text. This
way, the time ordering of the digits is from most to least
significant. Another way, which is actually what Hebrew typists do with
Hebrew, right-to-left typewriters, is to stay in the RL insertion mode and
just enter the digits backwards. This way, however, the time ordering of
the digits in the file is from least to most significant. Since many Hebrew
typewriters provide upper case Latin letters with the shifted keys, the
method of backwards entry is also used by many Hebrew typist for entering
short sequences of upper case Latin letters (as opposed to changing typing
element and typing direction).
.PP
Entering numerals and upper case Latin letters occurs often enoough in
entering Hebrew text, that it was decided to provided a special treatment
for them as an option obtained by saying one of
.ES
:set rlnumberuppercase
:set rlnu
.EE
Under this option, whenever in RL insertion mode, each time that a digit or
an upper case character \fIC\fP is entered, is is as though \&\fC^x\fP
were entered just before the \fIC\fP to bring \fIvi.iv\fP into RL insertion
mode. \fIvi.iv\fP stays in the RL insertion mode until the first subsequent
space, tab, or \&\fC^x\fP is entered. At that point, \fIvi.iv\fP returns to
RL entry mode and accepts the space or tab as having been entered as an RL
language character.
.PP
Note that all characters entered under this automatically entered LR
insertio mode go into the file in time order, as do \fIall\fP characters,
go into the file with the eighth bit off, and are displayed on the screen
from left to right. Note also that one is not restricted to entering just
digits or upper case Latin letters; once the LR insertion mode is entered,
all characters in what would be considered one word are going in as LR
characters. Thus, one can enter, for example,
full arithmetic expressions, words of upper
and lower case Latin letters beginning with an upper case letter, etc.
It was simpler to implement the mode in this manner than to restrict it to
model the usage of a Hebrew typewriter!
.su "Command Mode"
.PP
Commands are always given with an LR view and start
off in the LR language, regardless of what is the current situation for the
insert mode. This is because commands always begin with Latin letters.
The language switching commands can be issued during a command.
The effect of such a change is strictly local to the
command or pattern/substitute.
.PP
The implication of always being in the LR language when starting a command
is that if one exits a session of insert mode that was under the RL
language and then desires to issue a command,
one does not have to issue a language
change to get \fIvi.iv\fP to believe that the input is in the LR language;
In command mode, in which one must be after an escape from input mode,
\fIvi.iv\fP
automatically puts the terminal in LR mode if it can. If the terminal must
be manually flipped to change language, \fIvi.iv\fP does not ask for the
manual flip; it simply translates the incoming character codes so that
pressing the correct key for a latin letter is interpreted as that letter
regardless of the actual code emitted by the key. (This is the only place
where the fact that the terminal is a Hebrew as opposed to an Arabic
terminal is critical; the translation is language dependent.) In either
case, the user has nothing to do to get the command accepted in the LR
language, and in the latter case he or she does not have the bother of
manually flipping the terminal for only one character.
After the command is done, the current direction and language
reverts to what it was before entering the command,
so that the behavior with respect to the surrounding sessions of insert
mode is as if one had not even given a command.
The above is slightly different if the first character of the command is in
fact \(lq\&\fC/\fP\(rq or \(lq\&\fC?\fP\(rq. Then, in
\fIvi.iv\fP, one enters what is called pattern/substitute mode.
.su "Pattern/Substitute Mode"
.PP
Pattern and substitutes are always given with an LR view, since they are really
special cases of commands, which are always given with an LR view. However,
the current language of a pattern is the
language corresponding the view direction of the last session of input mode.
That is, if the view direction of the last session of input mode was RL,
then the pattern starts off in the RL language. This choice is consistent
with the observation that if the view direction of the last input is say,
RL, then most characters that are input are going to be in the RL language
and the most likely pattern that one is going to search for is also going
to be in the RL language. In any case, the language of a pattern can be
changed at any time during input of the pattern by issuing a \&\fC^x\fP.
After the pattern matching and substitution is done,
the current direction and language
reverts to what it was before entering the pattern/substitute,
so that, again, the behavior with respect to the surrounding sessions of insert
mode is as if one had not even given a command.
.su "Metacharacters and Escapes"
.PP
In the pattern matching and substition subsystem, there are a number of
characters that have special meaning either within patterns or within
replacing text. For example, \(``.\('' in a search pattern matches any
single character, and \(``&\('' in a replacement string causes
interpolation of the string being replaced. In order to obtain the
non-special meanings of these special characters, one may precede them
.\" with the \fIvi\fP escape character, the backslash, \(``\e\(''. Thus, \(``\e.\(''
with the \fIvi\fP escape character, the backslash, \(``\e\(''. Thus, \(``\e\^.\(''
in a search pattern matches only \(``.\('', and \(``\e&\('' in a
replacement string causes interpolation of \(``&\(''. To get the
backslash character itself in a non-escaping use one simple doubles the
character, \o'a\(ga' la \(``\e\e\(''). The problem with this simple
escaping scheme is that for some inexplicable reason, most Hebrew
terminals simply do not have the backslash key! Moreover, in many of
the switchable Latin-Hebrew terminals, when it is Hebrew mode, the
backslash key does not work. Thus, in Hebrew mode, another character
must be used. \fIvi\fP has assigned a meaning to every non-alphanumeric
character. Therefore, there is no really convenient single character
suited for this function, which might not be used heavily for other
reasons, it was decided to make the so-called RL escape character
settable with any of the following commands:
.ES
:set backslashRL=\fIc\fP
:set bslRL=\fIc\fP
.EE
For example, to get \(``^\('' to be the RL escape character, one can say
.ES
:set backslashRL=^
.EE
The default RL backslash character is \(``\fC!\fP\(''.
.su "Details of Some Commands"
.su "Pattern Matching"
.PP
A pattern, entered in time order, is matched
against the contents of the file, stored in time order. This behavior, while
simple to explain, easy to implement, and easy to apply, can produce
surprising results.
Suppose a line of the file (shown left to right) is:
.ES
	\*(-|\f(30`ab\fCabcdefghi\f(30cde\*(nl
.EE
Were it on the screen, its LR and RL view appearances would be:
.ES
\h'1.5i'|\f(15`ab\fCabcdefghi\f(15cde\fC               |
.PR
\f(15|`ab\fCabcdefghi\f(15cde               |
.PL
.EE
The pattern
.ES
	/\f(30`ab\fCabc/
.EE
matches the first six characters of the line. However, those six
consecutive characters are not adjacent on the screen. In any case the
cursor ends up position at the first character \&\f(30`\fP. For the aid of
the reader of this manual, the matched
characters are marked with a hyphens underneath, but these hyphens do not
appear on the screen.
.ES
\h'1.5i'|\f(15\o'`\(ul'ab\fCabcdefghi\f(15cde\fC               |
\h'1.5i'\&\ \u\fC------         \d
.PR
\f(15|\o'`\(ul'ab\fCabcdefghi\f(15cde               |
\&\ \u\fC   ---      ---\d
.PL
.EE
.su "Substitution"
.PP
The real impact of this behavior shows up when one does a substitution. The
substitution follows the \fIvi\fP rules working on the pattern, the
substititution, and the file contents \fIall in time order\fP.
Under the same view direction and file contents as above,
.ES
	:s/\f(30`ab\fCabc/\f(30fgh\fCjkl/
.EE
causes the following changes:
.ES
\*(-|\f(30fgh\fCjkldefghi\f(30cde\*(nl
\h'1.5i'\fC|\f(15fgh\fCjkldefghi\f(15cde\fC               |
.PR
\f(15|fgh\fCjkldefghi\f(15cde               |
.PL
.EE
The underlined characters got changed. On the other hand,
.ES
	:s/\f(30`ab\fCabc/jkl\f(30fgh\fC/
.EE
causes the changes:
.ES
\*(-|jkl\f(30fgh\fCdefghi\f(30cde\*(nl
\h'1.5i'\fC|jkl\f(15fgh\fCdefghi\f(15cde\fC               |
.PR
\f(15|\fCjkl\f(15fgh\fCdefghi\f(15cde               |
.PL
.EE
.PP
While the pattern matching and substitution according to the time-ordered
characters in the file may be easy to describe and, in fact, easy to
implement, it may seem counter-intuitive especially when the matched and
changed portions are not adjacent to each other on the screen.
However, to pattern match and thus substitute according to what appears on
the screen is fraught with a number of problems.
.IP 1.
Most of the time that one searches for a pattern it is to find something
that is \fInot\fP currently visible on the screen. In that case, searching
according to appearance is inappropriate and searching according to
time-ordered characters is really the only way that works. Suppose that in
a previous editing session the line,
.ES
\f(30de` `nx "\fCHello there Uri and Dan. How are you today?\f(30" l`exi ecpi`l
.EE
were entered into the file.
Under a RL view direction, assuming a screen width sufficiently large,
it happens appear as
.ES
.PR
.ti -.5i
\f(15|de` `nx "\fCHello there Uri and Dan. How are you today?\f(15" l`exi ecpi`l   |
.PL
.EE
on the screen, with \&\fCtoday?\fP adjacent to \&\f(15`nx "\fP. Now suppose
that in this current session, it is desired to bring this sentence into the
window. Is not the user more likely to remember that
he or she typed something beginning with
.ES
\f(30de` `nx "\fCHello
.EE
and thus the pattern should be typed
.ES
/\f(30de` `nx "\fCHello/
.EE
than that after it was typed it looked like
.ES
.PR
.ti -.5i
\f(15|de` `nx "\fCHello there Uri and Dan. How are you today?\f(15" l`exi ecpi`l   |
.PL
.EE
and thus the pattern should be something like
.ES
/\f(30de` `nx "\fCtoday?/  \fR?
.EE
.IP 2.
Searching by appearance contradicts the time-order orientation of the
entire rest of \fIvi.iv\fP. Adopting searching by appearance would just
make the command language of \fIvi.iv\fP not self-consistent and thus more
complicated.
.IP 3.
The search algorithm would have to construct the screen appearance of each line
in the file before it could search in the line. This, of course, slows the
search down considerably and moreover requires significant changes to the
basic functional part of \fIvi\fP. Every change to the functional part of
\fIvi\fP increases the danger that downward compatibility from \fIvi.iv\fP
to \fIvi\fP will be lost.
.PP
Thus searching according to time order is adopted. Indeed, in all of the
commands, some of the effects of adherence to time order seem a bit
surprising. However, in each case, a similar argument for adopting pure
time-order semantics can be given.
.su "Deletion and Change Commands"
.PP
The apparent behavior of deletion is affected also.
Suppose the three versions of line of the file are
.ES
\*(-|\f(30`ab cde \fCabc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab \o'c\(ul'de \fCabc def ghi \f(15fgh\fC       |
.PR
\f(15|`ab \o'c\(ul'de \fCabc def ghi \f(15fgh       |
.PL
.EE
and the cursor is positioned under the \&\f(30c\fP.
Now, suppose that the command \&\fCd2w\fP is given with the intention of
deleting two words.
Then the result is:
.ES
\*(-|\f(30`ab \fCdef ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab \fCdef ghi \f(15fgh\fC               |
.PR
\f(15|`ab \fCdef ghi \f(15fgh               |
.PL
.EE
Back up now to the situation before the deletion. Suppose that the command
.ES
	c2w\f(30ijkl \fCjklm\*(es
.EE
is given. Then the portion that was deleted above is actually
changed. What is interesting is that this change is happening in real time
and progresses through the file in time order. Below in four-line groups,
are shown
the file state and screen appearance after each successive character is typed
replacing the two words by \&\f(30ijkl \fCjklm\fR.
.ES
.ce
c2w
\*(-|\f(30`ab cde \fCabc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab \o'c\(ul'de \fCab$ def ghi \f(15fgh\fC       |
.PR
\f(15|`ab \o'c\(ul'de \fCab$ def ghi \f(15fgh       |
.PL

.ce
\f(30i\fC
\*(-|\f(30`ab ide \fCabc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab i\o'd\(ul'e \fCab$ def ghi \f(15fgh\fC       |
.PR
\f(15|`ab i\o'd\(ul'e \fCab$ def ghi \f(15fgh       |
.PL

.ce
\f(30j\fC
\*(-|\f(30`ab ije \fCabc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ij\o'e\(ul' \fCab$ def ghi \f(15fgh\fC       |
.PR
\f(15|`ab ij\o'e\(ul' \fCab$ def ghi \f(15fgh       |
.PL

.ce
\f(30k\fC
\*(-|\f(30`ab ijk \fCabc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijk\o' \(ul'\fCab$ def ghi \f(15fgh\fC       |
.PR
\f(15|`ab ijk\o' \(ul'\fCab$ def ghi \f(15fgh       |
.PL

.ce
\f(30l\fC
\*(-|\f(30`ab ijkl\fCabc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijkl\fC\o'a\(ul'b$ def ghi \f(15fgh\fC       |
.PR
\f(15|`ab ijkl\fC\o'a\(ul'b$ def ghi \f(15fgh       |
.PL

.ce
\(sq\fC
\*(-|\f(30`ab ijkl \fCbc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijkl \fC\o'b\(ul'$ def ghi \f(15fgh\fC       |
.PR
\f(15|`ab ijkl \fC\o'b\(ul'$ def ghi \f(15fgh       |
.PL

.ce
\fCj
\*(-|\f(30`ab ijkl \fCjc def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijkl \fCj\o'$\(ul' def ghi \f(15fgh\fC       |
.PR
\f(15|`ab ijkl \fCj\o'$\(ul' def ghi \f(15fgh       |
.PL

.ce
\fCk
\*(-|\f(30`ab ijkl \fCjk def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijkl \fCjk\o' \(ul'def ghi \f(15fgh\fC       |
.PR
\f(15|`ab ijkl \fCjk\o' \(ul'def ghi \f(15fgh       |
.PL

.ce
\fCl
\*(-|\f(30`ab ijkl \fCjkl def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijkl \fCjkl\o' \(ul'def ghi \f(15fgh\fC      |
.PR
\f(15|`ab ijkl \fCjkl\o' \(ul'def ghi \f(15fgh      |
.PL

.ce
\fCm
\*(-|\f(30`ab ijkl \fCjklm def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijkl \fCjklm\o' \(ul'def ghi \f(15fgh\fC     |
.PR
\f(15|`ab ijkl \fCjklm\o' \(ul'def ghi \f(15fgh     |
.PL

.ce
\*(es
\*(-|\f(30`ab ijkl \fCjklm def ghi \f(30fgh\*(nl
\h'1.5i'\fC|\f(15`ab ijkl \fCjkl\o'm\(ul' def ghi \f(15fgh\fC     |
.PR
\f(15|`ab ijkl \fCjkl\o'm\(ul' def ghi \f(15fgh     |
.PL
.EE
.PP
Space limitations prevent a more complete set of examples. However, armed
with the concepts of view direction, current language, and time order, and the
rules about cursor position and the various modes, the reader should be
able to deduce the expected behavior of any \fIvi.iv\fP command.
.\" ========================================================
.ne 4
.SH "OPTIONS & COMMANDS"
.\" 
.su "Set Commands"
.PP
The following is a complete list of the \&\fC:set\fP commands available
in \fIvi.iv\fP that are not available in \fIvi\fP. Note that for every
command
.ES
\&\fC:set \fIX\fR
.EE
of type \fItoggle\fP, \fIX\fP being either the
full spelling or an abbreviation not beginning with \(lq\&\fCno\fP\(rq,
there is a command
.ES
\&\fC:set no\fIX\fR
.EE
to set the toggle the other way.
.sp
.ne 4
.na
.ta 1.6i +.6i +.5i +.8i
.in +3.5i
.ti -3.5i
Option	Abbrev.	Type	Default	Meaning
.br
.ti -3.5i
\l'6.5i'
.sp .5v
.ti -3.5i
\fCrightleft\fP	\fCrl\fP	toggle	\fCnorl\fP	changes the view of the editing
session to RL; besides right justifying
all lines and changing the direction of cursor movement, it is arranged
that the next insert mode will be RL; if the terminal as described by the
\fItermcap\fP does not have hardware support for RL views, processing is
slowed down as right-to-left operation is simulated by brute force screen
redrawing
.sp
.ti -3.5i
\fCleftright\fP	\fClr\fP	toggle	\fClr\fP	\&\fCrl\fP means \&\fCnolr\fP,
and \&\fClr\fP means \&\fCnorl\fP
.sp
.ti -3.5i
.\" \fCsheformat\fP	\fCsf\fP	toggle	\fClr\fP	used to indicate the format
\fCsheformat\fP	\fCsf\fP	toggle	\fCsf\fP	used to indicate the format
of the file being edited; the characters of an
\&\fCsf\fP file are stored in time order; the characters of a
\&\fCnosf\fP file are stored in visual order; \&\fCnosf\fP files are
generally those that were created originally with \fIvih\fP(1)
.sp
.ti -3.5i
.\" \fCchangelang\fP	\fCchlk\fP	string	\fC^x\fP	used to set the character that
\fCchangelang\fP	\fC    \fP	string	\fC^x\fP	used to set the character that
indicates a change in the language and direction of insert modes
.sp
.ti -3.5i
\fCbackslashRL\fP	\fCbsRL\fP	string	\fC!\fP	used to set the character that
serves as the escape metacharacter in patterns and substitutions
.sp
.ti -3.5i
\fCrlnumberuppercase\fP	\fCrlnu\fP	toggle	\fCnorlnu\fP	indicates that during RL
insert mode, entry of a digit or upper case Latin
letter and all characters up to but not including the next blank or tab is
done in LR insert mode; this automatic LR insert mode is also exited by
entry of whetever is the language change character, e.g., \&\fC^x\fP
.sp
.ti -3.5i
\fCmarksecondlang\fP	\fCmarksl\fP	toggle	\fCnomarksl\fP	indicates that all text
in the current secondary language should be marked
by whatever highlighting is available according to the \fItermcap\fP; the
secondary language is that whose direction is opposite that of the current
view
.sp
.in -3.5i
.RT
.ad
These \&\fC:set\fP commands can be given also in the \&\fC.exrc\fP 
(or \&\fC.exrciv\fP) file
or in the value of the \&\fCEXINIT\fP 
(or \&\fCEXINITIV\fP) shell variable, but without the
preceding colon, to cause their being executed as \fIvi.iv\fP is starting
up.
.\" 
.su "Other Commands"
.PP
\fC^x\fP toggles the insertion mode between LR & RL.  You can specify
another character to do this via the
.ft C
:set changelang
.ft
command.
.PP
\fCv\fP goes to the next character based on the order stored in the
file (as opposed to the order it is displayed on the screen).
\fCV\fP goes to the previous character.
.\" 
.su "Command Line Options"
.PP
The \fIvi.iv\fP command line options alluded to in the synopsis are as
follows.
.na
.sp
.ne 4
.ta .5i
.in +.5i
.ti -.5i
Option	Meaning
.br
.ti -.5i
\l'6.5i'
.sp .5v
.ti -.5i
\fC\-S\fP	tells \fIvi.iv\fP to treat the edited file as being stored in visual order
instead of time order, e.g., as having been created by \fIvih\fP(1); note
that once a file is in any particular order, \fIvi.iv\fP \fIcannot\fP be
used to put it in the other order
.sp
.ti -.5i
\fC\-MS\fP	tells \fIvi.iv\fP to do \&\fC:set marksl\fP as it starts up
.sp
.ti -.5i
\fC\-LR\fP	tells \fIvi.iv\fP to do \&\fC:set lr\fP as it starts up
.sp
.ti -.5i
\fC\-RL\fP	tells \fIvi.iv\fP to do \&\fC:set rl\fP as it starts up
.in -.5i
.RT
.ad
.sp
Clearly, \&\fC\-LR\fP and \&\fC\-RL\fP are mutually exclusive, and the
last of these that appears in the command line is the one whose effect is
finally felt as the editing session begins.
.\" .PP
.\" In general, in the event of conflicting settings in the \&\fC.exrc\fP
.\" file, the \&\fCEXINIT\fP shell variable, and the command line options,
.\" \fIvi\fP's rules concerning order of their interpretation apply.
.\" ================================================================
.SH THE TECHNION COMPUTER SCIENCE FACULTY INSTALLATION
.PP
This section deals with information specific to the installation of
.I vi.iv
at the Computer Science Faculty of the Technion.
.su "Environment"
.PP
Currently, this installation of
.I vi.iv
uses its own private 
.IR termcap (5)
file
(see the
.B FILES
section below).  Thus, it does not matter what the TERMCAP environment
variable is set to, or even if it is set at all.  
This might change in future versions.
.PP
.I Vi.iv
uses the TERMIV environment variable to determine which entry to
use; current possible values (as of 24/04/90) are:
.TS
center ;
li l .
.sp
vt100iv	DEC vt100-compatible terminal
vi100iv	Visual terminal
suniv	Sun terminal (via \fIvthtool\fP(l) or \fIhvt100\fP(l))
.sp
.TE
You should check the 
.IR termcap (5) 
file that
.I vi.iv 
uses for the most up-to-date list of terminal types (see the
.B FILES
section for which 
.IR termcap (5)
file is used).
.PP
If TERMIV is not set,
.I vi.iv
will attempt to set it based on the current value of TERM.
However, this will not work on a Sun screen, as explained below.
This automatic setting of TERMIV might change or be deleted in future
versions.
.\" -----------
.su "Running vi.iv on a Sun Terminal"
.PP
First, you start up a windowing system (e.g.,
.IR SunView " or " X ).
Then, you must run a terminal emulator that can display both Hebrew (or 
whichever right-to-light language that you want) & English.  Under
.IR SunView ,
you can run
.IR vthtool (l) ;
under
.IR X ,
you can run
.IR hvt100 (l).
See the manuals for these commands for more information.
.PP
When you run
.I vi.iv
via
.IR vthtool (l),
the mouse-driven arrow keys will work, but the keyboard arrow keys will not.
You can, however, make the keyboard arrow keys work with the following
\fCmap\fP commands:
.TS
center ;
l .
.ft C
.sp
map \*(es[A k
map \*(es[B j
map \*(es[D h
map \*(es[C l
.sp
.ft
.TE
You enter the escape character (\*(es) by typing \fC^V\fP, then \*(es.
It will be echoed as \(lq\fC^[\fP\(rq.
.\" -----
.su "Startup Commands"
.PP
.I Vi.iv
uses the file
.I .exrc
and the environment variable EXINIT in the same way & the same
precedence as
.IR vi (1),
except:
.RS
.IP (1)
If there is a file named
.IR .exrciv ,
it will take precedence over
.IR .exrc .
.IP (2)
If there is an environment variable named EXINITIV, it will take
precedence over EXINIT.
.RE
This scheme allows one to have separate startup commands for 
.IR shef (5)
files if desired, or to use the same startup commands for both pure
.IR ascii "(5) and " shef (5)
files.
.\" -----
.su "Printing This Manual"
.PP
To print this manual, first copy the file 
.I /usr/man/manl/vi.iv.l
to your directory, then type the command
.sp
.RS
\fCditroff -FOF -P\fP\fIprinter\fP\fC vi.iv.l\fP
.RE
.sp
However, please do so sparingly.  This is a long manual (more than 17
pages!).
Also, please remember to delete your local copy of the manual when
done in order to save disk space.
.\" ================================================================
.SH TERMCAP FIELDS
.PP
In addition to the standard
.IR termcap (5)
fields used by 
.IR vi "(1), " vi.iv
uses new termcap fields for its Hebrew capabilities.  These are listed
below.  They all represent strings that are sent to the terminal to
control actions.
.TS
center ;
lb lb
li l .
Field	Description
\_	\_
eg	Change to left-to-right cursor motion
he	Change to right-to-left cursor motion
hn	Hebrew character set on
hf	Hebrew character set off (i.e., English characters)
.TE
.PP
Note that some of these field names are used by 
.IR vih (l) 
for different functions,
so that you cannot use the same termcap entry for both editors.
.\" ================================================================
.ne 3
.SH FILES
.\" /etc/termcap	terminal capabilities database
.TS
lb l .
/usr/local/lib/vi.iv/termcap	private terminal capabilities database
.TE
.\" ==========================================================
.ne 3
.SH SEE ALSO
.PP
.IR ex "(1), " vi "(1), " edit (1), 
\(lqVi Quick Reference\(rq card,
\(lqAn Introduction to Display Editing with Vi\(rq by William Joy.
.PP
\(lq\fIvi.iv\fP, a Bi-directional Version of the \fIvi\fP Full-Screen
Editor\(rq, by Uri Habusha and Daniel M. Berry.
.PP
.IR escii "(7), " shef "(5), " sheff "(l), " 
.IR vthtool "(l), " hvt100 "(l), " termcap (5).
.\" =============================================================
.SH AUTHOR
William Joy wrote
.I vi
.br
Mark Horton added macros to
.IR vi 's
\fIvisual\fR mode.
.br
Uri Habusha made
.I vi
bi-directional to become
.IR vi.iv \&.
.br
Yael Dubinsky & Haim Roman installed
.I vi.iv
on the Computer Science Department's Sun-4.
.\" .br
.\" If there are any questions/problems, please talk to Haim Roman
.\" .RI ( haim@csmail ).
.\" ============================================================
.\" B U G S :
.\" 
.SH BUGS
.\" --------------------------------------------------
.B The following are bugs of
.IB vi.iv :
.PP
The 'c' & 's' commands reverse the order of secondary language strings
(e.g., if you are viewing in RL mode, it reverses the LR strings).
Worse, you might not see this effect until you type ^L.  It is
suggested that first you  delete, then insert (or append).
.PP
When you replace a line by the \fCcc\fP command,
.I vi.iv
inserts another line from somewhere else in the file after the cursor.
This extra text remains even after you type \&\fC^L\fP.
The way around this is to go to the first character in the line and
do \fCc$\fP.
.PP
When you enter an RL string to search for, 
.I vi.iv
acts as if
.I rlnu
is set, whether or not it really is.
.PP
When you type \fC:quit\fP when you haven't saved your edits,
.I vi.iv
re-displays the screen contents.  When in LR view, this is OK.  But
when in RL view, it displays the contents in LR view, without erasing
the current display, resulting in a mess.  However, \&\fC^L\fP takes care of
this.
.PP
When doing the \fCI\fP visual-mode command, make sure that the insert
mode is the same as the view.  If not, the insert may start at the 
.I second
column of the line.
.PP
Tabs at the beginning of the line are not always properly handled
during insert, especially if you delete them or type \&\fC^D\fP.
However, typing \*(es or \&\fC^L\fP will restore the correct display.
.PP
You cannot use the same termcap entry for both
.IR vih (l)
and 
.IR vi.iv .
.PP
When you switch to line-mode (\&\fCQ\fP command), the
\(lq\&\fC:\fP\(rq prompt does not appear.
.PP
The text in the command line at the bottom of the screen sometimes
rolls up into the main text area of the screen.  \fC^L\fP removes it.
.PP
The \(lqdelete to beginning of line\(rq command in insert mode
(\fC^U\fP) only deletes as far as where the text changes language (if
it does in the current line).
.\" ----------------------------------------------------
.sp
.PP
.B
The following bugs are all inherited from
.I vi
.B
and are kept because they have become features already:
.PP
Software tabs using \&\fC^T\fR work only immediately after the
.I autoindent.
.PP
Left and right shifts on intelligent terminals don't make use of
insert and delete character operations in the terminal.
.PP
The
.I wrapmargin
option can be fooled since it looks at output columns when blanks are typed.
If a long word passes through the margin and onto the next line without a 
break, then the line won't be broken.
.PP
Insert/delete within a line can be slow if tabs are present on intelligent
terminals, since the terminals need help in doing this correctly.
.PP
Saving text on deletes in the named buffers is somewhat inefficient.
.PP
The
.I source
command does not work when executed as \&\fC:source\fR;
there is no way to use the \&\fC:append\fR, \&\fC:change\fR,
and \&\fC:insert\fR commands, since it is not possible to give
more than one line of input to a \&\fC:\fR escape.  To use these
on a \&\fC:global\fR you must \&\fCQ\fR to \fIex\fR command mode,
execute them, and then reenter the screen editor with
.I vi
or
.I open.
