/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ceph;

import com.ceph.fs.CephMount;
import com.ceph.fs.CephNotDirectoryException;
import com.ceph.fs.CephPoolException;
import com.ceph.fs.CephStat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ceph.CephConfigKeys;
import org.apache.hadoop.fs.ceph.CephFS;

class CephTalker
extends CephFS {
    private CephMount mount = null;
    private short defaultReplication;

    public CephTalker(Configuration conf, Log log) {
    }

    private String pathString(Path path) {
        return path.toUri().getPath();
    }

    @Override
    void initialize(URI uri, Configuration conf) throws IOException {
        String configopts;
        this.mount = new CephMount("admin");
        String configfile = conf.get("ceph.conf.file", CephConfigKeys.CEPH_CONF_FILE_DEFAULT);
        if (configfile != null) {
            this.mount.conf_read_file(configfile);
        }
        if ((configopts = conf.get("ceph.conf.options", CephConfigKeys.CEPH_CONF_OPTS_DEFAULT)) != null) {
            String[] options;
            for (String option : options = configopts.split(",")) {
                String[] keyval = option.split("=");
                if (keyval.length != 2) {
                    throw new IllegalArgumentException("Invalid Ceph option: " + option);
                }
                String key = keyval[0];
                String val = keyval[1];
                try {
                    this.mount.conf_set(key, val);
                }
                catch (Exception e) {
                    throw new IOException("Error setting Ceph option " + key + " = " + val);
                }
            }
        }
        this.defaultReplication = (short)conf.getInt("ceph.replication", 3);
        String root = conf.get("ceph.root.dir", "/");
        this.mount.mount(root);
        boolean localizeReads = conf.getBoolean("ceph.localize.reads", true);
        this.mount.localize_reads(localizeReads);
        this.mount.chdir("/");
    }

    @Override
    int __open(Path path, int flags, int mode) throws IOException {
        return this.mount.open(this.pathString(path), flags, mode);
    }

    @Override
    int open(Path path, int flags, int mode) throws IOException {
        int fd = this.__open(path, flags, mode);
        CephStat stat = new CephStat();
        this.fstat(fd, stat);
        if (stat.isDir()) {
            this.mount.close(fd);
            throw new FileNotFoundException();
        }
        return fd;
    }

    @Override
    int open(Path path, int flags, int mode, int stripe_unit, int stripe_count, int object_size, String data_pool) throws IOException {
        int fd = this.mount.open(this.pathString(path), flags, mode, stripe_unit, stripe_count, object_size, data_pool);
        CephStat stat = new CephStat();
        this.fstat(fd, stat);
        if (stat.isDir()) {
            this.mount.close(fd);
            throw new FileNotFoundException();
        }
        return fd;
    }

    @Override
    void fstat(int fd, CephStat stat) throws IOException {
        this.mount.fstat(fd, stat);
    }

    @Override
    void lstat(Path path, CephStat stat) throws IOException {
        try {
            this.mount.lstat(this.pathString(path), stat);
        }
        catch (CephNotDirectoryException e) {
            throw new FileNotFoundException();
        }
    }

    @Override
    void rmdir(Path path) throws IOException {
        this.mount.rmdir(this.pathString(path));
    }

    @Override
    void unlink(Path path) throws IOException {
        this.mount.unlink(this.pathString(path));
    }

    @Override
    void rename(Path src, Path dst) throws IOException {
        this.mount.rename(this.pathString(src), this.pathString(dst));
    }

    @Override
    String[] listdir(Path path) throws IOException {
        CephStat stat = new CephStat();
        try {
            this.mount.lstat(this.pathString(path), stat);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (!stat.isDir()) {
            return null;
        }
        return this.mount.listdir(this.pathString(path));
    }

    @Override
    void mkdirs(Path path, int mode) throws IOException {
        this.mount.mkdirs(this.pathString(path), mode);
    }

    @Override
    void close(int fd) throws IOException {
        this.mount.close(fd);
    }

    @Override
    void chmod(Path path, int mode) throws IOException {
        this.mount.chmod(this.pathString(path), mode);
    }

    @Override
    void shutdown() throws IOException {
        this.mount.unmount();
        this.mount = null;
    }

    @Override
    short getDefaultReplication() {
        return this.defaultReplication;
    }

    @Override
    short get_file_replication(Path path) throws IOException {
        CephStat stat = new CephStat();
        this.mount.lstat(this.pathString(path), stat);
        int replication = 1;
        if (stat.isFile()) {
            int fd = this.mount.open(this.pathString(path), 1, 0);
            replication = this.mount.get_file_replication(fd);
            this.mount.close(fd);
        }
        return (short)replication;
    }

    @Override
    int get_stripe_unit_granularity() {
        return this.mount.get_stripe_unit_granularity();
    }

    @Override
    void setattr(Path path, CephStat stat, int mask) throws IOException {
        this.mount.setattr(this.pathString(path), stat, mask);
    }

    @Override
    long lseek(int fd, long offset, int whence) throws IOException {
        return this.mount.lseek(fd, offset, whence);
    }

    @Override
    int write(int fd, byte[] buf, long size, long offset) throws IOException {
        return (int)this.mount.write(fd, buf, size, offset);
    }

    @Override
    int read(int fd, byte[] buf, long size, long offset) throws IOException {
        return (int)this.mount.read(fd, buf, size, offset);
    }

    @Override
    String get_file_pool_name(int fd) {
        return this.mount.get_file_pool_name(fd);
    }

    @Override
    int get_pool_id(String pool_name) throws IOException {
        try {
            return this.mount.get_pool_id(pool_name);
        }
        catch (CephPoolException e) {
            throw new IOException();
        }
    }

    @Override
    int get_pool_replication(int poolid) throws IOException {
        try {
            return this.mount.get_pool_replication(poolid);
        }
        catch (CephPoolException e) {
            throw new IOException();
        }
    }
}

