///////////////////////////////////////////////////////////////
//  Copyright 2012 John Maddock. Distributed under the Boost
//  Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_

//
// Compare arithmetic results using fixed_int to GMP results.
//

#ifdef _MSC_VER
#  define _SCL_SECURE_NO_WARNINGS
#endif

#include <boost/multiprecision/cpp_int.hpp>
#include "test.hpp"

#include <iostream>
#include <iomanip>
#include <fstream>
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/binary_iarchive.hpp>
#include <boost/archive/binary_oarchive.hpp>
#include <boost/exception/all.hpp>
#include <boost/filesystem.hpp>
#include <boost/filesystem/fstream.hpp>

boost::filesystem::path root;

template <class T>
void test64()
{
   using namespace boost::multiprecision;

   const char* text_array[] = {
      "4991075498124186",
      "-4991075498124186",
      "750",
      "-750",
      "415210192158791091",
      "-415210192158791091",
      "2172493004228646",
      "-2172493004228646",
      "993",
      "-993",
      "801484291299519218",
      "-801484291299519218",
      "294605502329193119",
      "-294605502329193119",
      "52506",
      "-52506",
      "1509449075377",
      "-1509449075377",
      "2042599",
      "-2042599",
      "228",
      "-228",
      "38666759073",
      "-38666759073",
      "611489",
      "-611489",
      "5393",
      "-5393",
      "12930071684",
      "-12930071684",
      "3606852234541437552",
      "-3606852234541437552",
      "3764404188985662264",
      "-3764404188985662264",
      "13300301596736993408",
      "-13300301596736993408",
      "3519758520509816019",
      "-3519758520509816019",
      "811951798554103911",
      "-811951798554103911",
      "2440",
      "-2440",
      "175149377023342",
      "-175149377023342",
      "5347169560611466452",
      "-5347169560611466452",
      "187134495165780485",
      "-187134495165780485",
      "761263991097466327",
      "-761263991097466327",
      "205",
      "-205",
      "7437277938",
      "-7437277938",
      "2530448830165700",
      "-2530448830165700",
      "3771546153060183",
      "-3771546153060183",
      "1238034",
      "-1238034",
      "1470",
      "-1470",
      "7",
      "-7",
      "203065689",
      "-203065689",
      "130",
      "-130",
      "74717518653749632",
      "-74717518653749632",
      "3028698162338",
      "-3028698162338",
      "3471587482356581",
      "-3471587482356581",
      "34698219712863216",
      "-34698219712863216",
      "941191493582057728",
      "-941191493582057728",
      "14803251323",
      "-14803251323",
      "552076672455",
      "-552076672455",
      "410481316632532",
      "-410481316632532",
      "6",
      "-6",
      "3851011",
      "-3851011",
      "12895806074024545",
      "-12895806074024545",
      "59538",
      "-59538",
      "944776298737546117",
      "-944776298737546117",
      "25010240662345",
      "-25010240662345",
      "29657097213970",
      "-29657097213970",
      "88000252",
      "-88000252",
      "545263458410825",
      "-545263458410825",
      "216600129907865",
      "-216600129907865",
      "262741237793873",
      "-262741237793873",
      "226964744",
      "-226964744",
      "111776857",
      "-111776857",
      "346922769",
      "-346922769",
      "7324307011273",
      "-7324307011273",
      "182",
      "-182",
      "4204",
      "-4204",
      "60455",
      "-60455",
      "35250836865461",
      "-35250836865461",
      "4100298085120029",
      "-4100298085120029",
      "6",
      "-6",
      "3262369",
      "-3262369",
      "103928",
      "-103928",
      "82055266594432948",
      "-82055266594432948",
      "8",
      "-8",
      "1731",
      "-1731",
      "338",
      "-338",
      "13202690186510006305",
      "-13202690186510006305",
      "3916209444926814",
      "-3916209444926814",
      "1801701990484582",
      "-1801701990484582",
      "54042343363098",
      "-54042343363098",
      "86",
      "-86",
      "1346703",
      "-1346703",
      "34499847353417",
      "-34499847353417",
      "870972860051498248",
      "-870972860051498248",
      "2676223213",
      "-2676223213",
      "10",
      "-10",
      "2207730666882",
      "-2207730666882",
      "256557933",
      "-256557933",
      "742",
      "-742",
      "17809514",
      "-17809514",
      "41738",
      "-41738",
      "937490350973899",
      "-937490350973899",
      "10",
      "-10",
      "2153955175933399",
      "-2153955175933399",
      "21",
      "-21",
      "9767",
      "-9767",
      "160991545",
      "-160991545",
      "5537202949",
      "-5537202949",
      "1729222816",
      "-1729222816",
      "880543773",
      "-880543773",
      "4994415770",
      "-4994415770",
      "5667270210124",
      "-5667270210124",
      "1789552738407096",
      "-1789552738407096",
      "52084908492459",
      "-52084908492459",
      "419923376385918098",
      "-419923376385918098",
      "193184120308428",
      "-193184120308428",
      "3716593161704457",
      "-3716593161704457",
      "835313",
      "-835313",
      "47794728416344",
      "-47794728416344",
      "32162267350660",
      "-32162267350660",
      "1",
      "-1",
      "6746653265049",
      "-6746653265049",
      "72924075986572",
      "-72924075986572",
      "4061",
      "-4061",
      "1776612112178",
      "-1776612112178",
      "798",
      "-798",
      "266401037",
      "-266401037",
      "6773927626",
      "-6773927626",
      "935572859041371",
      "-935572859041371",
      "2667878767142547263",
      "-2667878767142547263",
      "107694081993",
      "-107694081993",
      "2478862",
      "-2478862",
      "75439252494463178",
      "-75439252494463178",
      "502732137506",
      "-502732137506",
      "1345285828338743",
      "-1345285828338743",
      "15181",
      "-15181",
      "6",
      "-6",
      "503497089658971",
      "-503497089658971",
      "3925896855680859",
      "-3925896855680859",
      "259231",
      "-259231",
      "7499637741115431",
      "-7499637741115431",
      "16282283214",
      "-16282283214",
      "1664259700668569315",
      "-1664259700668569315",
      "63205423227654",
      "-63205423227654",
      "122839112",
      "-122839112",
      "254133246000861645",
      "-254133246000861645",
      "324448699",
      "-324448699",
      "2634830651678498499",
      "-2634830651678498499",
      "65612160397",
      "-65612160397",
      "7064926544",
      "-7064926544",
      "3816",
      "-3816",
      "1964",
      "-1964",
      "208639360759781",
      "-208639360759781",
      "3910",
      "-3910",
      "95080",
      "-95080",
      "175945",
      "-175945",
      "5880392757177227",
      "-5880392757177227",
      "17254376508100660",
      "-17254376508100660",
      "16568677462108662019",
      "-16568677462108662019",
      "193490",
      "-193490",
      "6055816",
      "-6055816",
      "4421583059373970",
      "-4421583059373970",
      "34879",
      "-34879",
      "52778",
      "-52778",
      "0",
      "0",
      "935000170463558922",
      "-935000170463558922",
      "173",
      "-173",
      "10327678",
      "-10327678",
      "45810516546119519",
      "-45810516546119519",
      "8712",
      "-8712",
      "1932876094515139",
      "-1932876094515139",
      "84388",
      "-84388",
      "2050813773845403160",
      "-2050813773845403160",
      "1542848238524",
      "-1542848238524",
      "1555584758215827",
      "-1555584758215827",
      "3571489748",
      "-3571489748",
      "18291705113053112226",
      "-18291705113053112226",
      "5713248",
      "-5713248",
      "43",
      "-43",
      "7537188724850197",
      "-7537188724850197",
      "3450872745386207",
      "-3450872745386207",
      "335595262120",
      "-335595262120",
      "481778267224",
      "-481778267224",
      "86277827129",
      "-86277827129",
      "132147177032651",
      "-132147177032651",
      "222305704702019735",
      "-222305704702019735",
      "15454425372201",
      "-15454425372201",
      "37444",
      "-37444",
      "14915074751748",
      "-14915074751748",
      "322332143987563",
      "-322332143987563",
      "126997604",
      "-126997604",
      "484901511158709",
      "-484901511158709",
      "7452547923",
      "-7452547923",
      "43400437",
      "-43400437",
      "950",
      "-950",
      "133435748899",
      "-133435748899",
      "13225323986",
      "-13225323986",
      "113",
      "-113",
      "31298263",
      "-31298263",
      "33",
      "-33",
      "11093233",
      "-11093233",
      "13921728621",
      "-13921728621",
      "256811828405",
      "-256811828405",
      "568533463853249",
      "-568533463853249",
      "384553",
      "-384553",
      "1046793359495877872",
      "-1046793359495877872",
      "3513488911471240501",
      "-3513488911471240501",
      "999",
      "-999",
      "3257",
      "-3257",
      "141868737283",
      "-141868737283",
      "97723548",
      "-97723548",
      "380232796",
      "-380232796",
      "11615871",
      "-11615871",
      "2",
      "-2",
      "516935083428",
      "-516935083428",
      "2767393",
      "-2767393",
      "74918721",
      "-74918721",
      "7083",
      "-7083",
      "497484184665289623",
      "-497484184665289623",
      "3309660146889781",
      "-3309660146889781",
      "795624163",
      "-795624163",
      "1739075",
      "-1739075",
      "38737391516580422",
      "-38737391516580422",
      "33363484068",
      "-33363484068",
      "453947517553",
      "-453947517553",
      "7206",
      "-7206",
      "912",
      "-912",
      "1070565937975",
      "-1070565937975",
      "3607679046",
      "-3607679046",
      "503313",
      "-503313",
      "5384337",
      "-5384337",
      "7913554120377",
      "-7913554120377",
      "4112847188",
      "-4112847188",
      "8191226371802",
      "-8191226371802",
      "41268527630506",
      "-41268527630506",
      "446828884957609",
      "-446828884957609",
      "17378379828995102574",
      "-17378379828995102574",
      "802194395",
      "-802194395",
      "6459076776036",
      "-6459076776036",
      "189",
      "-189",
      "456272745323742742",
      "-456272745323742742",
      "35245",
      "-35245",
      "4142317167",
      "-4142317167",
      "240455833189507891",
      "-240455833189507891",
      "32426861928",
      "-32426861928",
      "3464",
      "-3464",
      "15152220677",
      "-15152220677",
      "8550134950160679",
      "-8550134950160679",
      "226598734",
      "-226598734",
      "35686909663",
      "-35686909663",
      "59277903563",
      "-59277903563",
      "6946537179316043375",
      "-6946537179316043375",
      "516198226",
      "-516198226",
      "54",
      "-54",
      "27406574726722597",
      "-27406574726722597",
      "717765982",
      "-717765982",
      "540734180837",
      "-540734180837",
      "381",
      "-381",
      "2883798342",
      "-2883798342",
      "2454889904722697593",
      "-2454889904722697593",
      "5324758776781459411",
      "-5324758776781459411",
      "0",
      "0",
      "3",
      "-3",
      "758016775051877",
      "-758016775051877",
      "6368641396491647651",
      "-6368641396491647651",
      "2409862725919775",
      "-2409862725919775",
      "19831125",
      "-19831125",
      "19839578195623645",
      "-19839578195623645",
      "19556929453271",
      "-19556929453271",
      "245",
      "-245",
      "83382",
      "-83382",
      "30044944",
      "-30044944",
      "10307835790108389",
      "-10307835790108389",
      "266904",
      "-266904",
      "29",
      "-29",
      "1691697088175268",
      "-1691697088175268",
      "6361142035143",
      "-6361142035143",
      "440939789",
      "-440939789",
      "19836890767598",
      "-19836890767598",
      "78676472953102968",
      "-78676472953102968",
      "1663",
      "-1663",
      "7103",
      "-7103",
      "2602952185917450011",
      "-2602952185917450011",
      "8018",
      "-8018",
      "244",
      "-244",
      "1908",
      "-1908",
      "394626",
      "-394626",
      "559",
      "-559",
      "2692219006891972",
      "-2692219006891972",
      "13265871632018922",
      "-13265871632018922",
      "124",
      "-124",
      "222927115625",
      "-222927115625",
      "1283014176523",
      "-1283014176523",
      "63800278885",
      "-63800278885",
      "0",
      "0",
      "1829",
      "-1829",
      "13920824467759",
      "-13920824467759",
      "5133342577177325",
      "-5133342577177325",
      "11207577826",
      "-11207577826",
      "1482655119893",
      "-1482655119893",
      "200471339",
      "-200471339",
      "14758141",
      "-14758141",
      "29794",
      "-29794",
      "17080244",
      "-17080244",
      "699",
      "-699",
      "33751076",
      "-33751076",
      "16396192",
      "-16396192",
      "98",
      "-98",
      "81983490866862",
      "-81983490866862",
      "102679",
      "-102679",
      "13",
      "-13",
      "300",
      "-300",
      "195317",
      "-195317",
      "8257",
      "-8257",
      "9944069581",
      "-9944069581",
      "63162",
      "-63162",
      "2814124367772394",
      "-2814124367772394",
      "136699870",
      "-136699870",
      "2298044154057333478",
      "-2298044154057333478",
      "14",
      "-14",
      "15514009231077760",
      "-15514009231077760",
      "183794877561119741",
      "-183794877561119741",
      "1799598",
      "-1799598",
      "1873291206216770568",
      "-1873291206216770568",
      "31",
      "-31",
      "5025013349",
      "-5025013349",
      "26376",
      "-26376",
      "905247925",
      "-905247925",
      "36545804839",
      "-36545804839",
      "960743",
      "-960743",
      "90208569247342191",
      "-90208569247342191",
      "148711261716954186",
      "-148711261716954186",
      "15491943",
      "-15491943",
      "15539960",
      "-15539960",
      "15",
      "-15",
      "39",
      "-39",
      "7901",
      "-7901",
      "2124324987051603",
      "-2124324987051603",
      "45033487059826453",
      "-45033487059826453",
      "87387056",
      "-87387056",
      "13621",
      "-13621",
      "36002",
      "-36002",
      "130430",
      "-130430",
      "65703401",
      "-65703401",
      "7703922866",
      "-7703922866",
      "171",
      "-171",
      "61731",
      "-61731",
      "1387",
      "-1387",
      "8049274895",
      "-8049274895",
      "1951008680589745867",
      "-1951008680589745867",
      "2763480591525312699",
      "-2763480591525312699",
      "446243894833471417",
      "-446243894833471417",
      "5396319104693",
      "-5396319104693",
      "162371331057",
      "-162371331057",
      "370769520766475",
      "-370769520766475",
      "1",
      "-1",
      "361477542",
      "-361477542",
      "999",
      "-999",
      "5869928506",
      "-5869928506",
      "10725949",
      "-10725949",
      "16",
      "-16",
      "4934609875259411",
      "-4934609875259411",
      "3909261",
      "-3909261",
      "1",
      "-1",
      "96362",
      "-96362",
      "24",
      "-24",
      "206089594430410490",
      "-206089594430410490",
      "104",
      "-104",
      "5836462606744621",
      "-5836462606744621",
      "4267837773445",
      "-4267837773445",
      "485898",
      "-485898",
      "115640927033286",
      "-115640927033286",
      "1554",
      "-1554",
      "8719162940811",
      "-8719162940811",
      "2870768607",
      "-2870768607",
      "1052349661",
      "-1052349661",
      "23867197",
      "-23867197",
      "45326966103",
      "-45326966103",
      "90260998217302",
      "-90260998217302",
      "1523891",
      "-1523891",
      "666993",
      "-666993",
      "107936212247500",
      "-107936212247500",
      "1559140486984",
      "-1559140486984",
      "5874",
      "-5874",
      "5388740994398251",
      "-5388740994398251",
      "9448163810439",
      "-9448163810439",
      "1654654",
      "-1654654",
      "10590",
      "-10590",
      "54734468",
      "-54734468",
      "30749964",
      "-30749964",
      "9811424",
      "-9811424",
      "526166608342",
      "-526166608342",
      "4115859427270797",
      "-4115859427270797",
      "596517644188027",
      "-596517644188027",
      "14364215824260",
      "-14364215824260",
      "187",
      "-187",
      "24260378",
      "-24260378",
      "55791469491162660",
      "-55791469491162660",
      "2106900391",
      "-2106900391",
      "217782523580138",
      "-217782523580138",
      "1216259",
      "-1216259",
      "3275398462",
      "-3275398462",
      "343016100304169644",
      "-343016100304169644",
      "957668440",
      "-957668440",
      "6471546279",
      "-6471546279",
      "614957732",
      "-614957732",
      "130810411909693",
      "-130810411909693",
      "792104",
      "-792104",
      "465",
      "-465",
      "7782172074",
      "-7782172074",
      "55034847",
      "-55034847",
      "6775527365",
      "-6775527365",
      "12803753747546578",
      "-12803753747546578",
      "6126135608700535",
      "-6126135608700535",
      "12740679",
      "-12740679",
      "1266634072040501",
      "-1266634072040501",
      "348269777058432218",
      "-348269777058432218",
      "2184392953733",
      "-2184392953733",
      "9522770891",
      "-9522770891",
      "37077445",
      "-37077445",
      "1364",
      "-1364",
      "375540696398769",
      "-375540696398769",
      "24230",
      "-24230",
      "43119671230",
      "-43119671230",
      "1029673322569841213",
      "-1029673322569841213",
      "14194736",
      "-14194736",
      "4439459006245050525",
      "-4439459006245050525",
      "2016679919307343642",
      "-2016679919307343642",
      "68490",
      "-68490",
      "138373187496830016",
      "-138373187496830016",
      "12",
      "-12",
      "72731399395",
      "-72731399395",
      "103249241",
      "-103249241",
      "686434193208",
      "-686434193208",
      "2220097226366547",
      "-2220097226366547",
      "389615851678",
      "-389615851678",
      "1188756152",
      "-1188756152",
      "3527",
      "-3527",
      "64606107042",
      "-64606107042",
      "1628835",
      "-1628835",
      "14",
      "-14",
      "3398525351",
      "-3398525351",
      "192736533293843919",
      "-192736533293843919",
      "62739",
      "-62739",
      "29797",
      "-29797",
      "27022533997970320",
      "-27022533997970320",
      "85203884819644813",
      "-85203884819644813",
      "16723",
      "-16723",
      "720455425",
      "-720455425",
      "21193",
      "-21193",
      "911",
      "-911",
      "7564",
      "-7564",
      "9937",
      "-9937",
      "17698",
      "-17698",
      "3154835669492701",
      "-3154835669492701",
      "714419922",
      "-714419922",
      "3441710384",
      "-3441710384",
      "2302757",
      "-2302757",
      "13",
      "-13",
      "191092534665719086",
      "-191092534665719086",
      "2671438117955",
      "-2671438117955",
      "269195401",
      "-269195401",
      "1257367614616",
      "-1257367614616",
      "15233",
      "-15233",
      "242652372681",
      "-242652372681",
      "379035516581309513",
      "-379035516581309513",
      "234696334636228",
      "-234696334636228",
      "2190428804113181503",
      "-2190428804113181503",
      "5182131",
      "-5182131",
      "35710270",
      "-35710270",
      "30830418043327",
      "-30830418043327",
      "157",
      "-157",
      "56976290639537",
      "-56976290639537",
      "429094",
      "-429094",
      "8166",
      "-8166",
      "259284720",
      "-259284720",
      "1974",
      "-1974",
      "414549061889",
      "-414549061889",
      "12126192",
      "-12126192",
      "477683",
      "-477683",
      "26",
      "-26",
      "200991115623",
      "-200991115623",
      "105657935189602",
      "-105657935189602",
      "137401581416017",
      "-137401581416017",
      "3133",
      "-3133",
      "41301",
      "-41301",
      "9120545960887397",
      "-9120545960887397",
      "615",
      "-615",
      "1677628",
      "-1677628",
      "487311",
      "-487311",
      "6467819698256",
      "-6467819698256",
      "2721454",
      "-2721454",
      "356423793",
      "-356423793",
      "525408497",
      "-525408497",
      "1791793366931794",
      "-1791793366931794",
      "16267730984",
      "-16267730984",
      "787",
      "-787",
      "82",
      "-82",
      "8594582631777749056",
      "-8594582631777749056",
      "494351",
      "-494351",
      "5138",
      "-5138",
      "404787056092544",
      "-404787056092544",
      "235074602368269",
      "-235074602368269",
      "14",
      "-14",
      "364870",
      "-364870",
      "592299531695979194",
      "-592299531695979194",
      "243533",
      "-243533",
      "228268671797977",
      "-228268671797977",
      "150",
      "-150",
      "2109092292",
      "-2109092292",
      "10814341",
      "-10814341",
      "229344736512",
      "-229344736512",
      "506659",
      "-506659",
      "15065",
      "-15065",
      "73012461469893725",
      "-73012461469893725",
      "183623698",
      "-183623698",
      "30820",
      "-30820"
      };

   boost::filesystem::ifstream is(root / "cpp_int64_serial64.txt");
   std::cout << "Testing cpp_int64_serial64.txt with T=" << typeid(T).name() << std::endl;
   //is.peek();
   BOOST_CHECK(is.good());
   //char c = is.peek();
   //std::size_t s;
   //is >> s;
   boost::archive::text_iarchive ia(is);
   for(unsigned i = 0; i < sizeof(text_array) / sizeof(text_array[0]); ++i)
   {
      T val;
      ia >> val;
      BOOST_CHECK_EQUAL(val, T(text_array[i]));
   }

   boost::filesystem::ifstream is2(root / "cpp_int64_serial32.txt");
   std::cout << "Testing cpp_int64_serial32.txt with T=" << typeid(T).name() << std::endl;
   //is2.peek();
   BOOST_CHECK(is2.good());
   boost::archive::text_iarchive ia2(is2);
   for(unsigned i = 0; i < sizeof(text_array) / sizeof(text_array[0]); ++i)
   {
      T val;
      ia2 >> val;
      BOOST_CHECK_EQUAL(val, T(text_array[i]));
   }
}

template <class T>
void test128()
{
   using namespace boost::multiprecision;

   const char* text_array[] = {
      "27388486965920179246162874599461",
      "-27388486965920179246162874599461",
      "144684",
      "-144684",
      "40075268927703813213972787292005375",
      "-40075268927703813213972787292005375",
      "185882978840350932616815972016599",
      "-185882978840350932616815972016599",
      "118042",
      "-118042",
      "18836407318976510834104635573348923563",
      "-18836407318976510834104635573348923563",
      "305594372610563985628870243265194313",
      "-305594372610563985628870243265194313",
      "992608567",
      "-992608567",
      "1079802217950896854831728",
      "-1079802217950896854831728",
      "382261429251",
      "-382261429251",
      "7995",
      "-7995",
      "1691954012304306190464",
      "-1691954012304306190464",
      "252558125876",
      "-252558125876",
      "63408135",
      "-63408135",
      "1923885021482774859879",
      "-1923885021482774859879",
      "218151618018868077912122028563473880039",
      "-218151618018868077912122028563473880039",
      "1830482607233486577967554117978261568",
      "-1830482607233486577967554117978261568",
      "232684363792492642717810801641182199046",
      "-232684363792492642717810801641182199046",
      "18951107105103656564987041230801322761",
      "-18951107105103656564987041230801322761",
      "18602001100058210837668227206289280804",
      "-18602001100058210837668227206289280804",
      "619312",
      "-619312",
      "3300635207581175104869860370",
      "-3300635207581175104869860370",
      "35913874076527213864347472731883210240",
      "-35913874076527213864347472731883210240",
      "22584003535744275158325315387889625225",
      "-22584003535744275158325315387889625225",
      "1087569784912004503372385117646999025",
      "-1087569784912004503372385117646999025",
      "53419",
      "-53419",
      "6365946347248672643",
      "-6365946347248672643",
      "923074766928095495451885549346",
      "-923074766928095495451885549346",
      "791386027675064089452885112122",
      "-791386027675064089452885112122",
      "1095850863769",
      "-1095850863769",
      "585462",
      "-585462",
      "7",
      "-7",
      "14396352646034696",
      "-14396352646034696",
      "103513",
      "-103513",
      "236879494739813627852695329647307484",
      "-236879494739813627852695329647307484",
      "833105528657041028703317",
      "-833105528657041028703317",
      "403987552870100762517310706932",
      "-403987552870100762517310706932",
      "9241069445104304081394313010837003",
      "-9241069445104304081394313010837003",
      "7747462702643357490732429745555870341",
      "-7747462702643357490732429745555870341",
      "24325940392988231200",
      "-24325940392988231200",
      "3169332595628505508931977",
      "-3169332595628505508931977",
      "2956433455556566120076606972499",
      "-2956433455556566120076606972499",
      "97",
      "-97",
      "162358208806282",
      "-162358208806282",
      "450940116154946927404473774882465",
      "-450940116154946927404473774882465",
      "451641858",
      "-451641858",
      "1225696755823790187144596188382442861",
      "-1225696755823790187144596188382442861",
      "29784146626131423063590613",
      "-29784146626131423063590613",
      "234254347872215512272431905",
      "-234254347872215512272431905",
      "1188109449997714",
      "-1188109449997714",
      "67931289973154010244863599404",
      "-67931289973154010244863599404",
      "15985550526478899202524298413",
      "-15985550526478899202524298413",
      "44969358144856504665069077764",
      "-44969358144856504665069077764",
      "2433869372731414379",
      "-2433869372731414379",
      "389948478409995",
      "-389948478409995",
      "42980455782580666",
      "-42980455782580666",
      "32377741714896213765436617",
      "-32377741714896213765436617",
      "14147536",
      "-14147536",
      "7281984",
      "-7281984",
      "1940499846845",
      "-1940499846845",
      "431464371512114469628917178",
      "-431464371512114469628917178",
      "7407337220313553496076208494128",
      "-7407337220313553496076208494128",
      "30",
      "-30",
      "1327411295501",
      "-1327411295501",
      "66903469770",
      "-66903469770",
      "1681234517540805320612830262883456",
      "-1681234517540805320612830262883456",
      "100",
      "-100",
      "1619033",
      "-1619033",
      "31778",
      "-31778",
      "157454929543174151967897543014505981946",
      "-157454929543174151967897543014505981946",
      "71577966086399886868276034834304",
      "-71577966086399886868276034834304",
      "39053861540146327519720396203958",
      "-39053861540146327519720396203958",
      "744644565611021440442223814",
      "-744644565611021440442223814",
      "141620",
      "-141620",
      "2207944969567",
      "-2207944969567",
      "203426602629118177589459157758",
      "-203426602629118177589459157758",
      "4687930831049614526662210561259545215",
      "-4687930831049614526662210561259545215",
      "13741620425001328569",
      "-13741620425001328569",
      "28",
      "-28",
      "19919840763987597711639960",
      "-19919840763987597711639960",
      "58845502926990870",
      "-58845502926990870",
      "46503",
      "-46503",
      "227899590091810",
      "-227899590091810",
      "520269641",
      "-520269641",
      "533635134464326491653819104191",
      "-533635134464326491653819104191",
      "32",
      "-32",
      "2311765742988497575052179436185",
      "-2311765742988497575052179436185",
      "104",
      "-104",
      "13174010",
      "-13174010",
      "9157004287034859",
      "-9157004287034859",
      "13439929054075798978",
      "-13439929054075798978",
      "1005710832260650449",
      "-1005710832260650449",
      "45810516546119519",
      "-45810516546119519",
      "10111031832823515595",
      "-10111031832823515595",
      "1556666498630726306813245",
      "-1556666498630726306813245",
      "3776079563026301615061583892830",
      "-3776079563026301615061583892830",
      "3554220000452135447940601650",
      "-3554220000452135447940601650",
      "342914370059615129601458555955512766",
      "-342914370059615129601458555955512766",
      "37211915143242116097464702285",
      "-37211915143242116097464702285",
      "8426589576380612848355737491164",
      "-8426589576380612848355737491164",
      "32989222860",
      "-32989222860",
      "2242563523293104833112476952",
      "-2242563523293104833112476952",
      "26340698264302762867393911",
      "-26340698264302762867393911",
      "7",
      "-7",
      "690707180838394286313288",
      "-690707180838394286313288",
      "4152835666147840816597477625",
      "-4152835666147840816597477625",
      "4307204",
      "-4307204",
      "5538028691958331075031052",
      "-5538028691958331075031052",
      "15605",
      "-15605",
      "779689768131768618",
      "-779689768131768618",
      "31804890425581409493",
      "-31804890425581409493",
      "82342246867680606750756320822",
      "-82342246867680606750756320822",
      "9901401020017005286056280532528545058",
      "-9901401020017005286056280532528545058",
      "23964619045267142735208",
      "-23964619045267142735208",
      "23105481037040",
      "-23105481037040",
      "9261441758156913859636303647639218",
      "-9261441758156913859636303647639218",
      "60070546007507763924924",
      "-60070546007507763924924",
      "12326765403330476150347768542599",
      "-12326765403330476150347768542599",
      "1754723286",
      "-1754723286",
      "28",
      "-28",
      "89432086134972543173032616112",
      "-89432086134972543173032616112",
      "57126030796671809943615335657436",
      "-57126030796671809943615335657436",
      "14251136561",
      "-14251136561",
      "34939118696445841694152507070732",
      "-34939118696445841694152507070732",
      "62242533492272937541",
      "-62242533492272937541",
      "743045397928995080970748460370011005",
      "-743045397928995080970748460370011005",
      "657268729381871210499613874",
      "-657268729381871210499613874",
      "5257773746486582",
      "-5257773746486582",
      "40168363520567402312420813782551098",
      "-40168363520567402312420813782551098",
      "61834553929623600",
      "-61834553929623600",
      "8827879038299859860036523950621910882",
      "-8827879038299859860036523950621910882",
      "18187363614017047925823",
      "-18187363614017047925823",
      "1117818522952984212179",
      "-1117818522952984212179",
      "2656685",
      "-2656685",
      "409037",
      "-409037",
      "184490923222475885977498171480",
      "-184490923222475885977498171480",
      "802095",
      "-802095",
      "1362431392",
      "-1362431392",
      "22261578528",
      "-22261578528",
      "29290981558101942713268861928118",
      "-29290981558101942713268861928118",
      "47302301317848473766508256110200",
      "-47302301317848473766508256110200",
      "148503360374909444835237781907560612329",
      "-148503360374909444835237781907560612329",
      "30589987607",
      "-30589987607",
      "9336827203045",
      "-9336827203045",
      "30107043678267266207220294684045",
      "-30107043678267266207220294684045",
      "1084118892329",
      "-1084118892329",
      "7041095740",
      "-7041095740",
      "15",
      "-15",
      "610704633153562426576938052064937496",
      "-610704633153562426576938052064937496",
      "595347631",
      "-595347631",
      "7667191853556",
      "-7667191853556",
      "44454027936868155101947565993903816",
      "-44454027936868155101947565993903816",
      "85883611",
      "-85883611",
      "360758748839243518516454792370840",
      "-360758748839243518516454792370840",
      "2790927324",
      "-2790927324",
      "3742465736365768915898498156617091585",
      "-3742465736365768915898498156617091585",
      "147479413949146319856130",
      "-147479413949146319856130",
      "1039208893123161146877445631451",
      "-1039208893123161146877445631451",
      "4014354216767740814",
      "-4014354216767740814",
      "119781181099519678732165162824065718973",
      "-119781181099519678732165162824065718973",
      "78562776301070",
      "-78562776301070",
      "559",
      "-559",
      "11280106118161133960100664534446",
      "-11280106118161133960100664534446",
      "4606016388942561437580270830022",
      "-4606016388942561437580270830022",
      "57670561868327441370011",
      "-57670561868327441370011",
      "71416894909097014471844",
      "-71416894909097014471844",
      "3968198792173455589573",
      "-3968198792173455589573",
      "13149823145733642608775252727",
      "-13149823145733642608775252727",
      "264546856712400799367073649733688068",
      "-264546856712400799367073649733688068",
      "181571595840115131057831601",
      "-181571595840115131057831601",
      "137320082754",
      "-137320082754",
      "106737570210691788059038313",
      "-106737570210691788059038313",
      "266197717365288449213562655531",
      "-266197717365288449213562655531",
      "2641672529147341",
      "-2641672529147341",
      "151305657535708132064629059130",
      "-151305657535708132064629059130",
      "8838288455460932557542",
      "-8838288455460932557542",
      "229580992302363",
      "-229580992302363",
      "381276009",
      "-381276009",
      "2189254995814346543537",
      "-2189254995814346543537",
      "241062663892019429783",
      "-241062663892019429783",
      "1289",
      "-1289",
      "3768499169854362",
      "-3768499169854362",
      "46",
      "-46",
      "113123194090149",
      "-113123194090149",
      "257162014338572986111",
      "-257162014338572986111",
      "125826984535179834218224",
      "-125826984535179834218224",
      "380714866068747567944322727593",
      "-380714866068747567944322727593",
      "104303598841139",
      "-104303598841139",
      "1065280345148327648773363223393307192",
      "-1065280345148327648773363223393307192",
      "20248493338789246233167313227932895840",
      "-20248493338789246233167313227932895840",
      "162538",
      "-162538",
      "173739",
      "-173739",
      "5359750034437798426950",
      "-5359750034437798426950",
      "665876738146930",
      "-665876738146930",
      "709289441745698432",
      "-709289441745698432",
      "202728866936448",
      "-202728866936448",
      "6",
      "-6",
      "15800583732744199482624014690",
      "-15800583732744199482624014690",
      "29779074291232",
      "-29779074291232",
      "984339779461760",
      "-984339779461760",
      "767398",
      "-767398",
      "415462781851563431292700828131108380",
      "-415462781851563431292700828131108380",
      "1147933945700269690596156182506",
      "-1147933945700269690596156182506",
      "42450738679031729",
      "-42450738679031729",
      "2577950950157",
      "-2577950950157",
      "2522521710801514347400568661434422",
      "-2522521710801514347400568661434422",
      "13819658998892401541",
      "-13819658998892401541",
      "496658145774859954943564",
      "-496658145774859954943564",
      "518126",
      "-518126",
      "1401",
      "-1401",
      "65673247548918355271934",
      "-65673247548918355271934",
      "1902619525684055188",
      "-1902619525684055188",
      "32325262934",
      "-32325262934",
      "768343207102",
      "-768343207102",
      "7717131697976593508998559",
      "-7717131697976593508998559",
      "318668224221205716681",
      "-318668224221205716681",
      "373695949349041942234118586",
      "-373695949349041942234118586",
      "2374230638947377832537387112",
      "-2374230638947377832537387112",
      "38727149332417950712342749093",
      "-38727149332417950712342749093",
      "50641097967663747879422486643603294439",
      "-50641097967663747879422486643603294439",
      "155679557293775199",
      "-155679557293775199",
      "9584524694361179551000251851",
      "-9584524694361179551000251851",
      "1555",
      "-1555",
      "153598430081275298827470966254180164",
      "-153598430081275298827470966254180164",
      "1792977580",
      "-1792977580",
      "40513995299101921791",
      "-40513995299101921791",
      "205149194684558953622782831493255495",
      "-205149194684558953622782831493255495",
      "8569592230593344920443",
      "-8569592230593344920443",
      "508895",
      "-508895",
      "19768102480409470254",
      "-19768102480409470254",
      "137276814223629775094893592279819",
      "-137276814223629775094893592279819",
      "294000609851122741",
      "-294000609851122741",
      "65049209437230122275",
      "-65049209437230122275",
      "23362940999728532813",
      "-23362940999728532813",
      "88836918597358775734007849873044275046",
      "-88836918597358775734007849873044275046",
      "434035006963316670",
      "-434035006963316670",
      "622",
      "-622",
      "581347029549389573249184843256799",
      "-581347029549389573249184843256799",
      "180338559687589565",
      "-180338559687589565",
      "561053757585637776917747",
      "-561053757585637776917747",
      "32239",
      "-32239",
      "33901075413575967103",
      "-33901075413575967103",
      "8932885164594123487128517542485517028",
      "-8932885164594123487128517542485517028",
      "83521148713289418108751633969571232369",
      "-83521148713289418108751633969571232369",
      "7",
      "-7",
      "97",
      "-97",
      "148574175322938930280707441746",
      "-148574175322938930280707441746",
      "34819851973902418549646788688822516665",
      "-34819851973902418549646788688822516665",
      "8315372482034321202893445528412",
      "-8315372482034321202893445528412",
      "78070260632520",
      "-78070260632520",
      "1694579890551276986736768820881486",
      "-1694579890551276986736768820881486",
      "148949594888574520284515061",
      "-148949594888574520284515061",
      "7155",
      "-7155",
      "54025120576002",
      "-54025120576002",
      "6486075462638233",
      "-6486075462638233",
      "381736014892858568664127676041586",
      "-381736014892858568664127676041586",
      "20417033368",
      "-20417033368",
      "129",
      "-129",
      "4369312912082114047863415327506",
      "-4369312912082114047863415327506",
      "3425863567263779336359928",
      "-3425863567263779336359928",
      "126664685306324611",
      "-126664685306324611",
      "79290635423234192686030222410",
      "-79290635423234192686030222410",
      "89904040753844842469288403271470296",
      "-89904040753844842469288403271470296",
      "303078",
      "-303078",
      "24403696",
      "-24403696",
      "71519894287768242731407528483177175738",
      "-71519894287768242731407528483177175738",
      "43562121429",
      "-43562121429",
      "27030",
      "-27030",
      "24600",
      "-24600",
      "248387716733",
      "-248387716733",
      "371528",
      "-371528",
      "4787877250361840261744279869821",
      "-4787877250361840261744279869821",
      "4997511746500297909058528782721320",
      "-4997511746500297909058528782721320",
      "1586",
      "-1586",
      "31554014671157226899246",
      "-31554014671157226899246",
      "2859985988700258455304314",
      "-2859985988700258455304314",
      "4509508709806307404851",
      "-4509508709806307404851",
      "9",
      "-9",
      "1637744",
      "-1637744",
      "12479552255352789077760938",
      "-12479552255352789077760938",
      "976489633596851129859012248183437",
      "-976489633596851129859012248183437",
      "851806998881827048562",
      "-851806998881827048562",
      "906771089783845862955091",
      "-906771089783845862955091",
      "80038352079069729",
      "-80038352079069729",
      "17388136706500",
      "-17388136706500",
      "61145989",
      "-61145989",
      "94774844620540266019",
      "-94774844620540266019",
      "408281",
      "-408281",
      "952903032817435",
      "-952903032817435",
      "1631092620569808",
      "-1631092620569808",
      "2138",
      "-2138",
      "212824926871186875960728065608",
      "-212824926871186875960728065608",
      "4268162925",
      "-4268162925",
      "36",
      "-36",
      "223723",
      "-223723",
      "16415665053",
      "-16415665053",
      "25788643",
      "-25788643",
      "70220421074486178069",
      "-70220421074486178069",
      "4575797377",
      "-4575797377",
      "76884751129407965501107148587666",
      "-76884751129407965501107148587666",
      "29088346935783207",
      "-29088346935783207",
      "45914004714587007155631909758206960989",
      "-45914004714587007155631909758206960989",
      "248",
      "-248",
      "5579572272102752655174722938686",
      "-5579572272102752655174722938686",
      "30175831892260274369581289965353458",
      "-30175831892260274369581289965353458",
      "1237805257371",
      "-1237805257371",
      "4843618316827222290521953980935538236",
      "-4843618316827222290521953980935538236",
      "240",
      "-240",
      "15807477184070179658",
      "-15807477184070179658",
      "4142567393",
      "-4142567393",
      "12811809209743734075",
      "-12811809209743734075",
      "1485630615919152225304",
      "-1485630615919152225304",
      "7910273036167",
      "-7910273036167",
      "8463758727276424785250829495444564",
      "-8463758727276424785250829495444564",
      "64731869997654405671780238192304416",
      "-64731869997654405671780238192304416",
      "23615438174870",
      "-23615438174870",
      "352157140910141",
      "-352157140910141",
      "5",
      "-5",
      "59221",
      "-59221",
      "2569479",
      "-2569479",
      "542857439184063766884246909368",
      "-542857439184063766884246909368",
      "1823313067549638501383110895210828",
      "-1823313067549638501383110895210828",
      "3270724720703321",
      "-3270724720703321",
      "301251143",
      "-301251143",
      "2479800639",
      "-2479800639",
      "91698905921",
      "-91698905921",
      "2871719453817880",
      "-2871719453817880",
      "15334399950643828095",
      "-15334399950643828095",
      "5526",
      "-5526",
      "233477156",
      "-233477156",
      "133654",
      "-133654",
      "16379095557010108528",
      "-16379095557010108528",
      "781428672272181160786182179076882317",
      "-781428672272181160786182179076882317",
      "8296349327720787412560043280221269761",
      "-8296349327720787412560043280221269761",
      "10281035380942381640132947771350381026",
      "-10281035380942381640132947771350381026",
      "21040070113550157615461288",
      "-21040070113550157615461288",
      "25742884982404545443527",
      "-25742884982404545443527",
      "32454973901024441799985592013",
      "-32454973901024441799985592013",
      "743",
      "-743",
      "48093509516189552",
      "-48093509516189552",
      "3310081024",
      "-3310081024",
      "555885664598428773514",
      "-555885664598428773514",
      "12816465810736",
      "-12816465810736",
      "318",
      "-318",
      "11177674634623001920713776522758",
      "-11177674634623001920713776522758",
      "4478260629000",
      "-4478260629000",
      "7",
      "-7",
      "16047003680147439",
      "-16047003680147439",
      "183",
      "-183",
      "59147119480091828181670682607031985",
      "-59147119480091828181670682607031985",
      "14760016",
      "-14760016",
      "6274417502047620562218369346380",
      "-6274417502047620562218369346380",
      "14026544807038936634796795",
      "-14026544807038936634796795",
      "17158839999",
      "-17158839999",
      "15548352769483287520249305142",
      "-15548352769483287520249305142",
      "362163",
      "-362163",
      "3476850886273368477018353",
      "-3476850886273368477018353",
      "12190143908040407488",
      "-12190143908040407488",
      "521525508150081044",
      "-521525508150081044",
      "433309060522200",
      "-433309060522200",
      "2165455650813681324517",
      "-2165455650813681324517",
      "6819348098387524497126647285",
      "-6819348098387524497126647285",
      "464251630203",
      "-464251630203",
      "145993167313",
      "-145993167313",
      "23955493117052698447116654044",
      "-23955493117052698447116654044",
      "1249962737542647752328381",
      "-1249962737542647752328381",
      "25985762",
      "-25985762",
      "8825811397396758414408048174991",
      "-8825811397396758414408048174991",
      "456322584656453621447742298",
      "-456322584656453621447742298",
      "3635296824314",
      "-3635296824314",
      "48071792",
      "-48071792",
      "573327609505513",
      "-573327609505513",
      "32947066161183",
      "-32947066161183",
      "3572119014464",
      "-3572119014464",
      "339951878200713991932774",
      "-339951878200713991932774",
      "9829263561931267281756747918204",
      "-9829263561931267281756747918204",
      "99133551353390277845579505558",
      "-99133551353390277845579505558",
      "87647698384969946179713959",
      "-87647698384969946179713959",
      "812",
      "-812",
      "874259982778101",
      "-874259982778101",
      "427106308211321596930989851275848063",
      "-427106308211321596930989851275848063",
      "182604408166381257",
      "-182604408166381257",
      "1027122202590661838104329309513",
      "-1027122202590661838104329309513",
      "1354315694936",
      "-1354315694936",
      "6079470672663034486",
      "-6079470672663034486",
      "141187763548195492188625309258190962",
      "-141187763548195492188625309258190962",
      "5948423816691427",
      "-5948423816691427",
      "3790826071191932816",
      "-3790826071191932816",
      "475187449013755049",
      "-475187449013755049",
      "134916830618137216019136180544",
      "-134916830618137216019136180544",
      "289548281081",
      "-289548281081",
      "56088",
      "-56088",
      "71309468310269123716",
      "-71309468310269123716",
      "4319226187100950",
      "-4319226187100950",
      "64155929243330777086",
      "-64155929243330777086",
      "1346606607492942300949980881912922",
      "-1346606607492942300949980881912922",
      "56691962171349121239043134503543",
      "-56691962171349121239043134503543",
      "179884054884043",
      "-179884054884043",
      "1457175629136147646463304750253",
      "-1457175629136147646463304750253",
      "298847019807831033427383443102915235",
      "-298847019807831033427383443102915235",
      "3724333984635632125440253",
      "-3724333984635632125440253",
      "75997801235764509433",
      "-75997801235764509433",
      "624924035973776",
      "-624924035973776",
      "663853",
      "-663853",
      "39794266307878236329712249281466",
      "-39794266307878236329712249281466",
      "68236356",
      "-68236356",
      "874551267305634766833",
      "-874551267305634766833",
      "3069873585346853407835416677633253152",
      "-3069873585346853407835416677633253152",
      "128022182325463",
      "-128022182325463",
      "102685407245351562527197662841526650696",
      "-102685407245351562527197662841526650696",
      "1268696403523315749290280644252872285",
      "-1268696403523315749290280644252872285",
      "962551179",
      "-962551179",
      "5397346809016967977013332103668812",
      "-5397346809016967977013332103668812",
      "19",
      "-19",
      "1383556287038543763721",
      "-1383556287038543763721",
      "596132342851497",
      "-596132342851497",
      "386032274487026935724854",
      "-386032274487026935724854",
      "913487342891468949707909122983",
      "-913487342891468949707909122983",
      "60948098701787507435146",
      "-60948098701787507435146",
      "2022832067596000203",
      "-2022832067596000203",
      "25656479",
      "-25656479",
      "2346119770800025007571",
      "-2346119770800025007571",
      "376371975341",
      "-376371975341",
      "9",
      "-9",
      "2942356530044344965",
      "-2942356530044344965",
      "3932381905103911287794534670998227",
      "-3932381905103911287794534670998227",
      "3218056320",
      "-3218056320",
      "102738821",
      "-102738821",
      "234572888397008437041293767052858",
      "-234572888397008437041293767052858",
      "5858001549782605027037905592031557",
      "-5858001549782605027037905592031557",
      "90718950",
      "-90718950",
      "39428225166028193",
      "-39428225166028193",
      "1383746282",
      "-1383746282",
      "915121",
      "-915121",
      "8970289",
      "-8970289",
      "4322641789",
      "-4322641789",
      "260209037",
      "-260209037",
      "6609227084602664174553003642710",
      "-6609227084602664174553003642710",
      "37231518369001507",
      "-37231518369001507",
      "4301528568595403190",
      "-4301528568595403190",
      "2333077100212",
      "-2333077100212",
      "11565",
      "-11565",
      "255726621336514413017008354182674709",
      "-255726621336514413017008354182674709",
      "17395422733913073065750181",
      "-17395422733913073065750181",
      "125019234224449492",
      "-125019234224449492",
      "4740360722276299853297125",
      "-4740360722276299853297125",
      "7568347",
      "-7568347",
      "17122026961016863428287",
      "-17122026961016863428287",
      "112577394987931131505768113032531171",
      "-112577394987931131505768113032531171",
      "7046212555452856822490707564",
      "-7046212555452856822490707564",
      "33256103762317100748101545285090311772",
      "-33256103762317100748101545285090311772",
      "104639691131091",
      "-104639691131091",
      "74043463548796243",
      "-74043463548796243",
      "49942702457067622169669481",
      "-49942702457067622169669481",
      "12806",
      "-12806",
      "4194227136755752775246633399",
      "-4194227136755752775246633399",
      "22363149786",
      "-22363149786",
      "53844",
      "-53844",
      "6204108132585699",
      "-6204108132585699",
      "133987",
      "-133987",
      "47357030709179941308475",
      "-47357030709179941308475",
      "167735124254221045",
      "-167735124254221045",
      "58394613871",
      "-58394613871",
      "214",
      "-214",
      "97085709128533841718123",
      "-97085709128533841718123",
      "9049249133086876221572990732831",
      "-9049249133086876221572990732831",
      "1860834869623152381150863486",
      "-1860834869623152381150863486",
      "3868776",
      "-3868776",
      "714752211",
      "-714752211",
      "117044601375672047600456567336894",
      "-117044601375672047600456567336894",
      "38202",
      "-38202",
      "1706135867048",
      "-1706135867048",
      "568201454130",
      "-568201454130",
      "10071543790040355676774628",
      "-10071543790040355676774628",
      "3955606956905",
      "-3955606956905",
      "1710822834542941",
      "-1710822834542941",
      "28185453895207483",
      "-28185453895207483",
      "2241403707806732425937134125743",
      "-2241403707806732425937134125743",
      "24424908461669836348",
      "-24424908461669836348",
      "39965",
      "-39965",
      "5776",
      "-5776",
      "161984235115107451958835599550261843326",
      "-161984235115107451958835599550261843326",
      "29821471341",
      "-29821471341",
      "3087720",
      "-3087720",
      "234408055908870511236228564329",
      "-234408055908870511236228564329",
      "367687929171771055426419375659",
      "-367687929171771055426419375659",
      "31",
      "-31",
      "14038375921",
      "-14038375921",
      "1272562766857183500104765994611086188",
      "-1272562766857183500104765994611086188",
      "5395131009",
      "-5395131009",
      "34630426722601695384252351222",
      "-34630426722601695384252351222",
      "16553",
      "-16553",
      "11084856402443484655",
      "-11084856402443484655",
      "4497048086787",
      "-4497048086787",
      "32568631422747274845485",
      "-32568631422747274845485",
      "262201867566",
      "-262201867566",
      "3603196342",
      "-3603196342",
      "32228667062769096924274427075075163477",
      "-32228667062769096924274427075075163477",
      "693196875773858622",
      "-693196875773858622",
      "375838207",
      "-375838207",
   };

   boost::filesystem::ifstream is(root / "cpp_int128_serial64.txt");
   std::cout << "Testing cpp_int128_serial64.txt with T=" << typeid(T).name() << std::endl;
   //is.peek();
   BOOST_CHECK(is.good());
   boost::archive::text_iarchive ia(is);
   for(unsigned i = 0; i < sizeof(text_array) / sizeof(text_array[0]); ++i)
   {
#ifndef BOOST_NO_EXCEPTIONS
      try
      {
#endif
         T val;
         ia >> val;
         BOOST_CHECK_EQUAL(val, T(text_array[i]));
#ifndef BOOST_NO_EXCEPTIONS
      }
      catch(const boost::exception& e)
      {
         std::cout << "Caught boost::exception with:\n";
         std::cout << diagnostic_information(e);
      }
      catch(const std::exception& e)
      {
         std::cout << "Caught std::exception with:\n";
         std::cout << e.what() << std::endl;
      }
#endif
   }

   boost::filesystem::ifstream is2(root / "cpp_int128_serial32.txt");
   std::cout << "Testing cpp_int128_serial32.txt with T=" << typeid(T).name() << std::endl;
   //is2.peek();
   BOOST_CHECK(is2.good());
   boost::archive::text_iarchive ia2(is2);
   for(unsigned i = 0; i < sizeof(text_array) / sizeof(text_array[0]); ++i)
   {
#ifndef BOOST_NO_EXCEPTIONS
      try
      {
#endif
         T val;
         ia2 >> val;
         BOOST_CHECK_EQUAL(val, T(text_array[i]));
#ifndef BOOST_NO_EXCEPTIONS
      }
      catch(const boost::exception& e)
      {
         std::cout << "Caught boost::exception with:\n";
         std::cout << diagnostic_information(e);
      }
      catch(const std::exception& e)
      {
         std::cout << "Caught std::exception with:\n";
         std::cout << e.what() << std::endl;
      }
#endif
   }
}

template <class T>
void test1024()
{
   using namespace boost::multiprecision;

   const char* text_array[] = {
      "199116592524695642085302184291534972104821103496846288349049702743455488423756865233534697793799569802866670981662356904270988544309072648691983459024063468708849163858558300444260495432655880504371186304007206097685833870163932928823469130199562442992",
      "-199116592524695642085302184291534972104821103496846288349049702743455488423756865233534697793799569802866670981662356904270988544309072648691983459024063468708849163858558300444260495432655880504371186304007206097685833870163932928823469130199562442992",
      "900593985907599133309438051698408853499625",
      "-900593985907599133309438051698408853499625",
      "1999874529133918706984995533406759076286565612920872635155416162504047196283513226624804224664215451103787410646351770677862238993331622942206185777454355265435238628326337253875004975201674224657309748975788962678417182798452737039836018579998386385843839364431684621083773420995",
      "-1999874529133918706984995533406759076286565612920872635155416162504047196283513226624804224664215451103787410646351770677862238993331622942206185777454355265435238628326337253875004975201674224657309748975788962678417182798452737039836018579998386385843839364431684621083773420995",
      "3984622917724894533997006216154563211907361459910318973090457115167740283771041468834030135879776466911564784436671674308756100400008317797390250537451443539509892669634431827675333761787371583170220547281395030543315815109821053621124047969069733480692532",
      "-3984622917724894533997006216154563211907361459910318973090457115167740283771041468834030135879776466911564784436671674308756100400008317797390250537451443539509892669634431827675333761787371583170220547281395030543315815109821053621124047969069733480692532",
      "3232318919913083002600961037970380935109",
      "-3232318919913083002600961037970380935109",
      "31063287987662242043295268121189412701158946907681323476663158129071217086758046387444487305432940821201595312001091888440038537739012180871591529361766112029121819690067004102150186222757899576567650712850787690098182019345491656562683693940513570929164008316791512277994247388861874767036310283032",
      "-31063287987662242043295268121189412701158946907681323476663158129071217086758046387444487305432940821201595312001091888440038537739012180871591529361766112029121819690067004102150186222757899576567650712850787690098182019345491656562683693940513570929164008316791512277994247388861874767036310283032",
      "551891699448873731005410917251662274314405815829594429768196331539904618164780043996715480720882109933893638976491102937306842056459564612366897777250359518885611699552940726261111066137661097166708199216229508773692203174236076409923801944639195246263554709054412966237162836449108",
      "-551891699448873731005410917251662274314405815829594429768196331539904618164780043996715480720882109933893638976491102937306842056459564612366897777250359518885611699552940726261111066137661097166708199216229508773692203174236076409923801944639195246263554709054412966237162836449108",
      "335366696367917734077308183957523963605452915968160245855756922088011",
      "-335366696367917734077308183957523963605452915968160245855756922088011",
      "516747586835313993425742202038941743391184401954870801073750702371672555461045948927255871449025485037535181895965683819085832663856528858925035833888106053116851498798112586463619731478072279623",
      "-516747586835313993425742202038941743391184401954870801073750702371672555461045948927255871449025485037535181895965683819085832663856528858925035833888106053116851498798112586463619731478072279623",
      "266698476906140000185555171296233707414383217616977634049828438937252114299738535337312010987594",
      "-266698476906140000185555171296233707414383217616977634049828438937252114299738535337312010987594",
      "1742740128166122778815789893503",
      "-1742740128166122778815789893503",
      "9724178186350731882862121812371154796147496227432585250532513144071077406366937493221094046638206862261142165156227060439590867019554905722401562859987295808994814401942",
      "-9724178186350731882862121812371154796147496227432585250532513144071077406366937493221094046638206862261142165156227060439590867019554905722401562859987295808994814401942",
      "78669120642064259414462176059292690866387576703089703385165678245138348243792107699164",
      "-78669120642064259414462176059292690866387576703089703385165678245138348243792107699164",
      "20818242466417733255855534640058104588616172091806661117670",
      "-20818242466417733255855534640058104588616172091806661117670",
      "4285795302257142023279557595265352619153550443850366091691013701573116876759469534501053640452948548428208657312557380072256478428969426137868124810140942586250078976271",
      "-4285795302257142023279557595265352619153550443850366091691013701573116876759469534501053640452948548428208657312557380072256478428969426137868124810140942586250078976271",
      "582604000062572804923757892130426287093735944713405746172610139142407500801888662008036220641936720421041737454101798928020195070207248743108048751731809924563484418793905813766932871306262995484219521766924610729803972858084042961494083239630079092513694133586118612073236719306830956983397633251414977754",
      "-582604000062572804923757892130426287093735944713405746172610139142407500801888662008036220641936720421041737454101798928020195070207248743108048751731809924563484418793905813766932871306262995484219521766924610729803972858084042961494083239630079092513694133586118612073236719306830956983397633251414977754",
      "15244715246682897475794438496539784661328456725495852276384174914973848673559621029178770197754207946620279120766931180917955631763555863913554513123775304647102553401018292948818112379521732233018874991323186887132286586138108436833252904592044083624364585617172057137372527454560587256796482346",
      "-15244715246682897475794438496539784661328456725495852276384174914973848673559621029178770197754207946620279120766931180917955631763555863913554513123775304647102553401018292948818112379521732233018874991323186887132286586138108436833252904592044083624364585617172057137372527454560587256796482346",
      "2162895251469736394155373749298870491019042810468937007114239114834965434324532372477043450771464135064045267665496385710799863273304844467062688237563757141742551576106360777697871874341148850361709074093167368004234386954371485929893986000482110508651966963502456247924228172005161782355542551339301544053",
      "-2162895251469736394155373749298870491019042810468937007114239114834965434324532372477043450771464135064045267665496385710799863273304844467062688237563757141742551576106360777697871874341148850361709074093167368004234386954371485929893986000482110508651966963502456247924228172005161782355542551339301544053",
      "1598979420051373213779067102428825857258960753077031910510837547866117340690938015398588975672437163347616966444506118889316096334851198017036793976867532695462600493286904022181865571035930456030653116939922200581824528814030699118802949188745959300411809512397337408237271478944565611123755566305",
      "-1598979420051373213779067102428825857258960753077031910510837547866117340690938015398588975672437163347616966444506118889316096334851198017036793976867532695462600493286904022181865571035930456030653116939922200581824528814030699118802949188745959300411809512397337408237271478944565611123755566305",
      "16972265575362228409871949532650408574482631199000565615577589612763707133618421955651468786564593364791708076161039592041831568321621510957105628787468779948579969928175938436896904310402554255504042135507367561049409553354413837219069382497010795375231533129182910408442845936728120354915635936898",
      "-16972265575362228409871949532650408574482631199000565615577589612763707133618421955651468786564593364791708076161039592041831568321621510957105628787468779948579969928175938436896904310402554255504042135507367561049409553354413837219069382497010795375231533129182910408442845936728120354915635936898",
      "6578842255326490592104075020940649831283616551660",
      "-6578842255326490592104075020940649831283616551660",
      "21683239365736925204171059844091235529220850759783534345105279221261364632686763920546656745741380892718845596049305277834093327836699551790128153290026473154694088594033146472697265593756340629571314831536187835497879992488",
      "-21683239365736925204171059844091235529220850759783534345105279221261364632686763920546656745741380892718845596049305277834093327836699551790128153290026473154694088594033146472697265593756340629571314831536187835497879992488",
      "82705023096235991529043144815694768432078642064433253929157769869969882959684824083733064475507849892985247689495254462302557886989778499312762640233348268023648079139590178633699092745191633841431797230103981800388019961016410936969661694491101422518397720383375579079432440889617406834440612316345",
      "-82705023096235991529043144815694768432078642064433253929157769869969882959684824083733064475507849892985247689495254462302557886989778499312762640233348268023648079139590178633699092745191633841431797230103981800388019961016410936969661694491101422518397720383375579079432440889617406834440612316345",
      "182226847821689839702269917063301483274601928154240894497051272590070015871573462612330908644446070144310876769617182637134479859518870301265103824148955731473219622377635930380500965073993471768564617573332989796817488809960475386339256946590978228792909775228312826022751099327081513175259103822462404",
      "-182226847821689839702269917063301483274601928154240894497051272590070015871573462612330908644446070144310876769617182637134479859518870301265103824148955731473219622377635930380500965073993471768564617573332989796817488809960475386339256946590978228792909775228312826022751099327081513175259103822462404",
      "5047815496286192631875136121482961684854345143375644371655857541129061222585290469283326779682311519927896776754142231238721306654582346292285270137340078762804088754913299932236143865279819208519978638432654788640663782736369734346995034407838300134017424349501474133378173964391719130592921725",
      "-5047815496286192631875136121482961684854345143375644371655857541129061222585290469283326779682311519927896776754142231238721306654582346292285270137340078762804088754913299932236143865279819208519978638432654788640663782736369734346995034407838300134017424349501474133378173964391719130592921725",
      "22536736652558441743601984420319740",
      "-22536736652558441743601984420319740",
      "327447539579270438292704828441807528233522606163188888154105354488483374541037700785580710347093169240568594799687437260325328617564586900214241043337",
      "-327447539579270438292704828441807528233522606163188888154105354488483374541037700785580710347093169240568594799687437260325328617564586900214241043337",
      "576979741896869527546425470124797714231020028752356356333225775983321871157857129520067018389689110139112275805449955044770978296650876883361429976430221447982628049254445385786013507310850518003697984237866336100952912645415854388908568224414707",
      "-576979741896869527546425470124797714231020028752356356333225775983321871157857129520067018389689110139112275805449955044770978296650876883361429976430221447982628049254445385786013507310850518003697984237866336100952912645415854388908568224414707",
      "755708508440402225863498155833596268190934339616501653733913066972752009318647339364141109604780235018474569114884922495929398288656171192074004071372424004589137926220537255429717898046520571796147507616408370836807000016827363741604261172604190",
      "-755708508440402225863498155833596268190934339616501653733913066972752009318647339364141109604780235018474569114884922495929398288656171192074004071372424004589137926220537255429717898046520571796147507616408370836807000016827363741604261172604190",
      "28048724901616569597172899970128263950954786552499389660847160202213362969018987235256727605",
      "-28048724901616569597172899970128263950954786552499389660847160202213362969018987235256727605",
      "173167043910755577166191737374818499849624950",
      "-173167043910755577166191737374818499849624950",
      "48",
      "-48",
      "18463009925253820920449684292621801312807473363997541122773157125946854399091765241363833326106601909427978296931833223183788301543",
      "-18463009925253820920449684292621801312807473363997541122773157125946854399091765241363833326106601909427978296931833223183788301543",
      "31164619961775222493397145731379707",
      "-31164619961775222493397145731379707",
      "1816096570786800455898299961483294949815377533170208282553387279497784999672154364831631933541855425071102266426105906939977630773287626616160771806315066360322795263086589842632991562964241768039371149116395673886243340566387264938743398973079853460222114803451321466708714785006727",
      "-1816096570786800455898299961483294949815377533170208282553387279497784999672154364831631933541855425071102266426105906939977630773287626616160771806315066360322795263086589842632991562964241768039371149116395673886243340566387264938743398973079853460222114803451321466708714785006727",
      "286006007227658140199584887789816189451349886507993355022297173895214040208905643298365570365441499922605759964419143497079708873231260957597650186760056343574600947950687835678669676590667783184666",
      "-286006007227658140199584887789816189451349886507993355022297173895214040208905643298365570365441499922605759964419143497079708873231260957597650186760056343574600947950687835678669676590667783184666",
      "18358404935882372210070601728050732884947257854425817110955248936260198050228809460271322586740505320746909919918679627100695097433534409202108416481259416338560209999440019558569552164395624923489329323411399738280552853025588689733098861097523",
      "-18358404935882372210070601728050732884947257854425817110955248936260198050228809460271322586740505320746909919918679627100695097433534409202108416481259416338560209999440019558569552164395624923489329323411399738280552853025588689733098861097523",
      "4134722455319345214940599980631794346657332870755359010455452155626594269008814501180484509879573967565890465226873255542092192607602138135728673418643645201766135430371744351074472506612976620427027592918016747144700651239945277040717933887512645490432181939225775342965",
      "-4134722455319345214940599980631794346657332870755359010455452155626594269008814501180484509879573967565890465226873255542092192607602138135728673418643645201766135430371744351074472506612976620427027592918016747144700651239945277040717933887512645490432181939225775342965",
      "54920807074733793884577529077249631831162657302693894027178095216669108940322624411834499900757281913727092273510264248215928273287884179463378853565331877701638585020489866284361829333257710807106023052404897652297092714031250456279772808462426750654556160069174238558295987347555132735561420095",
      "-54920807074733793884577529077249631831162657302693894027178095216669108940322624411834499900757281913727092273510264248215928273287884179463378853565331877701638585020489866284361829333257710807106023052404897652297092714031250456279772808462426750654556160069174238558295987347555132735561420095",
      "399265560197794252401617167580850085282220794173216714093253564006986475971645145366672323528680289510504223856530994241334812625576574784650620927403732184",
      "-399265560197794252401617167580850085282220794173216714093253564006986475971645145366672323528680289510504223856530994241334812625576574784650620927403732184",
      "31621966437344909804014117858935966136505781977117316516659445266533686603282356943749115958158394083237531612132476116831423261618528802877894233115470068483988764082981116838784931515017818535550110918",
      "-31621966437344909804014117858935966136505781977117316516659445266533686603282356943749115958158394083237531612132476116831423261618528802877894233115470068483988764082981116838784931515017818535550110918",
      "1606985215548409716503362538444761880543201213399618535731027289265156579177336621807120077949866098802813413615868269176538634784089984273973440941833767736805385007543715097934592673987261460898859324638806817938705575451364443949120235151257544",
      "-1606985215548409716503362538444761880543201213399618535731027289265156579177336621807120077949866098802813413615868269176538634784089984273973440941833767736805385007543715097934592673987261460898859324638806817938705575451364443949120235151257544",
      "285683190193",
      "-285683190193",
      "8061697887583266465310973659826347597097558972448901485453524610917952084739066859639084715521710210973596165921",
      "-8061697887583266465310973659826347597097558972448901485453524610917952084739066859639084715521710210973596165921",
      "6219223289787909965098172528033914428025426344931365048240610134846930087708486382224526942350364117413020461482722657384885935391455080562169318712277658961972965925941924792948343565934378704158420349097774074011993945850670748056251470218258676908828627471885",
      "-6219223289787909965098172528033914428025426344931365048240610134846930087708486382224526942350364117413020461482722657384885935391455080562169318712277658961972965925941924792948343565934378704158420349097774074011993945850670748056251470218258676908828627471885",
      "697258758163542187076749918900636966609908531786609361940000240519",
      "-697258758163542187076749918900636966609908531786609361940000240519",
      "1046098084657831111818175325887422175023162118504873435909952452494852374571808810176243062515313047215471029884493246457829292480590847793716267629027995295229796393654811459791589585169546388254745922345946744655803804613032804268083425871981695717315478983498539611218241664930157839795",
      "-1046098084657831111818175325887422175023162118504873435909952452494852374571808810176243062515313047215471029884493246457829292480590847793716267629027995295229796393654811459791589585169546388254745922345946744655803804613032804268083425871981695717315478983498539611218241664930157839795",
      "2484434366380099043156299869169661345741558449531766681226478781813341982338634464499146134940119727735818398667362505498484418919464161091166892386016324225384189876252889149071097656823108497551033588357003722",
      "-2484434366380099043156299869169661345741558449531766681226478781813341982338634464499146134940119727735818398667362505498484418919464161091166892386016324225384189876252889149071097656823108497551033588357003722",
      "308286676308193197031410043742676292328591745213481644733897249474373496522533072738438449939815750248898922885290011346375849968712988888608255565930075126704466104946675008196710396726585487442780152614905677",
      "-308286676308193197031410043742676292328591745213481644733897249474373496522533072738438449939815750248898922885290011346375849968712988888608255565930075126704466104946675008196710396726585487442780152614905677",
      "1578729146192540123786163537348004400750916878495381648015362308555564957146975794392752284685500828245809393902172165166570",
      "-1578729146192540123786163537348004400750916878495381648015362308555564957146975794392752284685500828245809393902172165166570",
      "753635193017654981561112585877756433926946338453536513833144933556077262395793429496030381482043731560006145122148417766008778064151654898372617208349138764363280371778703526306929669285807019015087056633479893959366709941765720251266",
      "-753635193017654981561112585877756433926946338453536513833144933556077262395793429496030381482043731560006145122148417766008778064151654898372617208349138764363280371778703526306929669285807019015087056633479893959366709941765720251266",
      "1023056796494340203037740397557237363844811192683830278749294166121707658052654599305485368530300819052987687826810994785603794931372101763295285975973124930171986523205085256147491724466952116413750593896486505408297359237231028",
      "-1023056796494340203037740397557237363844811192683830278749294166121707658052654599305485368530300819052987687826810994785603794931372101763295285975973124930171986523205085256147491724466952116413750593896486505408297359237231028",
      "7279368955234841237989689629914561920962002431310686381873314222568640123479287155739276546923764190325442924090937031964044572030997024902955450149096922769606827151526955803170246823486172000556133026264782831784752812128580068",
      "-7279368955234841237989689629914561920962002431310686381873314222568640123479287155739276546923764190325442924090937031964044572030997024902955450149096922769606827151526955803170246823486172000556133026264782831784752812128580068",
      "424617380576309116241807458648692744450386557212868763669113075114477578778872841574527732081207492431831870311301491048670446826911900920994644694",
      "-424617380576309116241807458648692744450386557212868763669113075114477578778872841574527732081207492431831870311301491048670446826911900920994644694",
      "7046686003127119093099476961562427444038611347486414217752094860417190797774076723407713585872307944642824878964077822345",
      "-7046686003127119093099476961562427444038611347486414217752094860417190797774076723407713585872307944642824878964077822345",
      "19949119701600514825288852843654302777880460105733015351003691242645123465142555331932685718332487926262997425529449487067278953683",
      "-19949119701600514825288852843654302777880460105733015351003691242645123465142555331932685718332487926262997425529449487067278953683",
      "16469140092633375339743693580164888653727421730589027379476942842394844761208703483677054585417793177811566576822391363212778421263249183342676114446881502895872964885316569671443951931393367071689754985",
      "-16469140092633375339743693580164888653727421730589027379476942842394844761208703483677054585417793177811566576822391363212778421263249183342676114446881502895872964885316569671443951931393367071689754985",
      "1061702816480363701187846694728343109042150409401045998",
      "-1061702816480363701187846694728343109042150409401045998",
      "7391047600385760425390763210856013417540808412389899",
      "-7391047600385760425390763210856013417540808412389899",
      "3720217478561502591416009227591582869882982470098168796813426264578076670286029029195560760567",
      "-3720217478561502591416009227591582869882982470098168796813426264578076670286029029195560760567",
      "66106892589637039037744676327200772291368517688108041167197715930935273497569759111332854815299471155925869011997907566713674005971100914739364454164984587128896600583993354569858550495377843782520710717979164977585093",
      "-66106892589637039037744676327200772291368517688108041167197715930935273497569759111332854815299471155925869011997907566713674005971100914739364454164984587128896600583993354569858550495377843782520710717979164977585093",
      "655105381318829622535325161492573443039473032159228692157069475333288969363672255837498503071757247193471076794288004751047135238604867298249068617214132553959376152373616588040808707670098140225261882200984527500899566180951300745344526414599508",
      "-655105381318829622535325161492573443039473032159228692157069475333288969363672255837498503071757247193471076794288004751047135238604867298249068617214132553959376152373616588040808707670098140225261882200984527500899566180951300745344526414599508",
      "32279098297",
      "-32279098297",
      "91236285260894969491370094562444170610185292123928049180398654028165920269699400153752501142438076",
      "-91236285260894969491370094562444170610185292123928049180398654028165920269699400153752501142438076",
      "76148543022827828542260034575767140554118312303651220784462009876431985956698652362044",
      "-76148543022827828542260034575767140554118312303651220784462009876431985956698652362044",
      "83588868584829923837376678742649596503169974719002042708417338297148455364317505115231903770625036463360146776147319869172298475847924715607135999201658410499586149882123548133278995113231076277183588359228055211291455848766205373827838498451914146847385535315038611426",
      "-83588868584829923837376678742649596503169974719002042708417338297148455364317505115231903770625036463360146776147319869172298475847924715607135999201658410499586149882123548133278995113231076277183588359228055211291455848766205373827838498451914146847385535315038611426",
      "963957921647213",
      "-963957921647213",
      "13301565202923219609572812103802050473736468733",
      "-13301565202923219609572812103802050473736468733",
      "4746350713999103687568954691814",
      "-4746350713999103687568954691814",
      "2001142907044963200442678450863815898813903676660733058871895239756077633074421909013654237542517301596550011117510574893770558703407744684777702961205416292826384730912647565673208707968211244040320246494312087239093502776249390829799552970184550131203169359608726456455152480928583576591394902496106626144",
      "-2001142907044963200442678450863815898813903676660733058871895239756077633074421909013654237542517301596550011117510574893770558703407744684777702961205416292826384730912647565673208707968211244040320246494312087239093502776249390829799552970184550131203169359608726456455152480928583576591394902496106626144",
      "107594281614292318387817778890700162347725421105656330924973717308436245329157596183845769858366750239404646287651057292302740816759738471158092800874582432179112119211566698620828469639621669897519755264598100204713172616980523260714264267451063089420215",
      "-107594281614292318387817778890700162347725421105656330924973717308436245329157596183845769858366750239404646287651057292302740816759738471158092800874582432179112119211566698620828469639621669897519755264598100204713172616980523260714264267451063089420215",
      "1748285028280968559027056769483145164710362048627307365465656148480028444958644903475995728328069875726460568057080202853997524099097288749318318801615657840242878599655077486108729249226195564937733374638566648902211364103190286203200478747078106163053",
      "-1748285028280968559027056769483145164710362048627307365465656148480028444958644903475995728328069875726460568057080202853997524099097288749318318801615657840242878599655077486108729249226195564937733374638566648902211364103190286203200478747078106163053",
      "11460180193889065606722132385926501525431980106546682247601052575855000134486061731618687473242633808411918689848577390823351808790715520481001965421879800810352399655561482898353748786253207752078326991084961012083",
      "-11460180193889065606722132385926501525431980106546682247601052575855000134486061731618687473242633808411918689848577390823351808790715520481001965421879800810352399655561482898353748786253207752078326991084961012083",
      "574927035874041759213679385423821561867",
      "-574927035874041759213679385423821561867",
      "120643345454198941508563017089006360092589256126170227342940319190269214269775023269721267117406618",
      "-120643345454198941508563017089006360092589256126170227342940319190269214269775023269721267117406618",
      "43211052397169822368769320044098366176065820670381470825125490923898893035078574715878390619044493658716106759475917845349930472007385257270090791727486873231922936861573077702054193955871675235660795444516942345577520753954381850029768",
      "-43211052397169822368769320044098366176065820670381470825125490923898893035078574715878390619044493658716106759475917845349930472007385257270090791727486873231922936861573077702054193955871675235660795444516942345577520753954381850029768",
      "9844479373748707013063227964029459596247847016794211846228318515960354387966950301750833297921955723417061013994092483915173465284502461089399372968661262420490350455873655690633576331503541999665999411319072898423762904939498903689838493823091884957816736065194017711554932378966207638596446",
      "-9844479373748707013063227964029459596247847016794211846228318515960354387966950301750833297921955723417061013994092483915173465284502461089399372968661262420490350455873655690633576331503541999665999411319072898423762904939498903689838493823091884957816736065194017711554932378966207638596446",
      "1549569662025720311251404569332722105893198679127923795355656951920288528581705427103792360667449800130523485559533763978458224547356178202688985769505",
      "-1549569662025720311251404569332722105893198679127923795355656951920288528581705427103792360667449800130523485559533763978458224547356178202688985769505",
      "36315742657",
      "-36315742657",
      "8921164792041877158829344493852966827789686565858639796763485931102357440731861058782552324538917399828752311227018705861210803742330995498617328892413590387831390338234562492080836551321361310716484078814",
      "-8921164792041877158829344493852966827789686565858639796763485931102357440731861058782552324538917399828752311227018705861210803742330995498617328892413590387831390338234562492080836551321361310716484078814",
      "3564428449813842615037566955460603551635405941961408429533479906924825068973042239756262262787799344453371579266807953907224412476869508",
      "-3564428449813842615037566955460603551635405941961408429533479906924825068973042239756262262787799344453371579266807953907224412476869508",
      "803208608149818042371281509635155439483",
      "-803208608149818042371281509635155439483",
      "4866189324296232234061833332746205890326919472641667725283106186358795590420827732306960443344464312769726502055107509",
      "-4866189324296232234061833332746205890326919472641667725283106186358795590420827732306960443344464312769726502055107509",
      "207298564235033398879052037508717471071493511497187540585110196743",
      "-207298564235033398879052037508717471071493511497187540585110196743",
      "193717918520883498325012985935003601959305178471191450716579245791510632312265720137365047580022087853055977679260908512014775411818562756581294466392949427067700253919565514470785071872659525583000795812531290669561365815697655594188906",
      "-193717918520883498325012985935003601959305178471191450716579245791510632312265720137365047580022087853055977679260908512014775411818562756581294466392949427067700253919565514470785071872659525583000795812531290669561365815697655594188906",
      "2437877491739207",
      "-2437877491739207",
      "37013774102202564305419053038604891745828779816673570038156288209445014156533018002446399548329104265253840467051874818175306349349752734572291264362672503100264435752942371629071789078883405034467875813374259058124047248097835249024123072756933",
      "-37013774102202564305419053038604891745828779816673570038156288209445014156533018002446399548329104265253840467051874818175306349349752734572291264362672503100264435752942371629071789078883405034467875813374259058124047248097835249024123072756933",
      "354494755327",
      "-354494755327",
      "11780642893082070770985419994433169541426957824422257433844",
      "-11780642893082070770985419994433169541426957824422257433844",
      "485430660154648600595640793061533874664308049695155979729256186778257302321647241550949220266916178753497849914452979205318162",
      "-485430660154648600595640793061533874664308049695155979729256186778257302321647241550949220266916178753497849914452979205318162",
      "23858852603627264837843140314865296322097028936336850188878465502728409524610276592851077626292364546252755103916928846389671162429425418906991891502973",
      "-23858852603627264837843140314865296322097028936336850188878465502728409524610276592851077626292364546252755103916928846389671162429425418906991891502973",
      "2073475025890625790912875485180905813499103080617022204722722710095631077512485124044881139986135538169181486312704584071614904004373594716419",
      "-2073475025890625790912875485180905813499103080617022204722722710095631077512485124044881139986135538169181486312704584071614904004373594716419",
      "15280710757061816529388583850582811170979066299366854920512818520549969116440063183787310498271091672343434592650388724950511822972092076",
      "-15280710757061816529388583850582811170979066299366854920512818520549969116440063183787310498271091672343434592650388724950511822972092076",
      "6382485371693619169022055595031229091762638736860010414889365673981891166426242136610234221929171470107008843300114050380584829581671837693187024514818",
      "-6382485371693619169022055595031229091762638736860010414889365673981891166426242136610234221929171470107008843300114050380584829581671837693187024514818",
      "12185224224701673175361331319115762816895575796767843658049699617134858039026831564288739190981827007791493862865956911735574421879562096311558676154252796632277351699205162505700258194809563580445507",
      "-12185224224701673175361331319115762816895575796767843658049699617134858039026831564288739190981827007791493862865956911735574421879562096311558676154252796632277351699205162505700258194809563580445507",
      "34003980273948488873087243030302546934071096333462110121575903766367670827215796429777573314114296018716373089777559546454127470648315079633590832262220530391541976999162677539194732289306375110039265026554808460597438607169664283497662076280786",
      "-34003980273948488873087243030302546934071096333462110121575903766367670827215796429777573314114296018716373089777559546454127470648315079633590832262220530391541976999162677539194732289306375110039265026554808460597438607169664283497662076280786",
      "122848198938353223588037911092014612429998780961520627899382186456109045142826399845219049519395028055840868305519753136489752495357572137972700299899629238691174342998161949671331013802430679284465951931850871392212632",
      "-122848198938353223588037911092014612429998780961520627899382186456109045142826399845219049519395028055840868305519753136489752495357572137972700299899629238691174342998161949671331013802430679284465951931850871392212632",
      "43537967438743700082839955990027575248714598937547106788531846714509188167960975769453819977500278194590313507781727399526395127656584060420218121352097776308452702567298202679209230473699619650828718821287113120498048345913575657082695406163703126042367182026511481872506111256791596",
      "-43537967438743700082839955990027575248714598937547106788531846714509188167960975769453819977500278194590313507781727399526395127656584060420218121352097776308452702567298202679209230473699619650828718821287113120498048345913575657082695406163703126042367182026511481872506111256791596",
      "58406767675650075287505789516356411545831826432139397101494864325157903449602707567656548116973052773130530151058837990354645940288559829449340220508188691146281802100553666536211206823508084744153463134410959296949868335640749454837",
      "-58406767675650075287505789516356411545831826432139397101494864325157903449602707567656548116973052773130530151058837990354645940288559829449340220508188691146281802100553666536211206823508084744153463134410959296949868335640749454837",
      "845873210129906374353022076245969947869460127750482252356111232286849327159845231580563758295137285209548293776383830614553566014483472912208993044958366148170162204310293796785477227702675371216304957228188615867576567406231041038281756292397397561",
      "-845873210129906374353022076245969947869460127750482252356111232286849327159845231580563758295137285209548293776383830614553566014483472912208993044958366148170162204310293796785477227702675371216304957228188615867576567406231041038281756292397397561",
      "53588224463377221082233930622411910641801456988689291134720826079004949443094787414435",
      "-53588224463377221082233930622411910641801456988689291134720826079004949443094787414435",
      "72112722851930798700228005210608826370783262851441860040831117968729809788108346159403319971018904246301591088717098607465649205797470097967252119620134427778008686902310907006410363397508152328805949858597088819284277",
      "-72112722851930798700228005210608826370783262851441860040831117968729809788108346159403319971018904246301591088717098607465649205797470097967252119620134427778008686902310907006410363397508152328805949858597088819284277",
      "641918660703774309882129738043218549030513645540611429936046631082566036061356980177384685321883957675631751681520848096394297317163463488891570190724496654177980091225725954578443264041706056677969812886935701",
      "-641918660703774309882129738043218549030513645540611429936046631082566036061356980177384685321883957675631751681520848096394297317163463488891570190724496654177980091225725954578443264041706056677969812886935701",
      "30",
      "-30",
      "6394573041749544637932142063252660876011988517352129759808021807615786602503160259195561963658103141713195046053277921040817887800559226509891982140334607813922841396821838502087774297750475588617168795",
      "-6394573041749544637932142063252660876011988517352129759808021807615786602503160259195561963658103141713195046053277921040817887800559226509891982140334607813922841396821838502087774297750475588617168795",
      "1786466222561817425577249373742981037566301146961591730677121116610853649457567467081637483584212899635954801237845898555279493690732411882920175456222801107258417531725553455448259056866349458253419178431317512242742160",
      "-1786466222561817425577249373742981037566301146961591730677121116610853649457567467081637483584212899635954801237845898555279493690732411882920175456222801107258417531725553455448259056866349458253419178431317512242742160",
      "137832029750529182794342751962197941412491800492104",
      "-137832029750529182794342751962197941412491800492104",
      "8108038128324706368474080686463548136481517039342729533539080912561382244733668445971779623479147878923993970600643926905142316004585446689923640217524203592135814813370649929971097550423245537858260",
      "-8108038128324706368474080686463548136481517039342729533539080912561382244733668445971779623479147878923993970600643926905142316004585446689923640217524203592135814813370649929971097550423245537858260",
      "5002261098184392173934780113066967242",
      "-5002261098184392173934780113066967242",
      "690951335667913995812417540653386648776452918801140879728454196755039750563977820072442505506359908874725801630758561609054355988759175228289",
      "-690951335667913995812417540653386648776452918801140879728454196755039750563977820072442505506359908874725801630758561609054355988759175228289",
      "10674213497798883899476403327832261239905267095517429500221095458852845305968864392299051608409658803957443554649236067724400487971044164121242198029786220",
      "-10674213497798883899476403327832261239905267095517429500221095458852845305968864392299051608409658803957443554649236067724400487971044164121242198029786220",
      "17992446102498398809906415490084711513529803098403245836231064924343042871622653363618957583240979467823413823373231710836844132776133330230504849252207785917957852664671150869449421757327447929003162434828411052366071580989788644644058346",
      "-17992446102498398809906415490084711513529803098403245836231064924343042871622653363618957583240979467823413823373231710836844132776133330230504849252207785917957852664671150869449421757327447929003162434828411052366071580989788644644058346",
      "33842687090178160518628086932775600899160163731425276680317104716407292755478424345380082755988441733647290183079908808136196734777398636133355822624652625917768049717031860506349867723992592655421369270624555109106177714680336653018611913032875963068852500326353648887921416851020395037162987766",
      "-33842687090178160518628086932775600899160163731425276680317104716407292755478424345380082755988441733647290183079908808136196734777398636133355822624652625917768049717031860506349867723992592655421369270624555109106177714680336653018611913032875963068852500326353648887921416851020395037162987766",
      "1054083826397869852970042065169251590328234555837539271102624160027471295945233271106117930450857346874100524858325086710499923040919634021718345296558298025504382070214470223730",
      "-1054083826397869852970042065169251590328234555837539271102624160027471295945233271106117930450857346874100524858325086710499923040919634021718345296558298025504382070214470223730",
      "136407237437852413879681494779911076041207111591826209650287776324941155126675066585977968663006698647245",
      "-136407237437852413879681494779911076041207111591826209650287776324941155126675066585977968663006698647245",
      "2224879942826211211569920900726660211869323323310097306306571308813333981073744504097938050565302837264530253763057896699924896596092066791400879438413472679293844669326318441711505238433328261842523388469632517312478257062414756535170295711651910005290949014898120581894",
      "-2224879942826211211569920900726660211869323323310097306306571308813333981073744504097938050565302837264530253763057896699924896596092066791400879438413472679293844669326318441711505238433328261842523388469632517312478257062414756535170295711651910005290949014898120581894",
      "4047288308565310307500509489225346109923522467464514519968591592559230455772855713422415453581291554663695129034041054508221015627588797163542760075301595269083019308332323602089140",
      "-4047288308565310307500509489225346109923522467464514519968591592559230455772855713422415453581291554663695129034041054508221015627588797163542760075301595269083019308332323602089140",
      "1035816948031741587849086409216542916935656696246164119153928232713320856714123588940050533131790722677035036233284471386922732645880058503610308346951059222695446014860710224009856786160873437306753478940623814638264314179274958950671363159961289293",
      "-1035816948031741587849086409216542916935656696246164119153928232713320856714123588940050533131790722677035036233284471386922732645880058503610308346951059222695446014860710224009856786160873437306753478940623814638264314179274958950671363159961289293",
      "1718216153801609870534260896130470102834028900689159827595233108230047",
      "-1718216153801609870534260896130470102834028900689159827595233108230047",
      "157320",
      "-157320",
      "4922208547816973044459635133646703969879372571533096054296883386644122380530951726299847426987732042397595779976830474678726947018304354845591378517358359470056483109237714380888286233563680472388849805778688479350769638569123934902",
      "-4922208547816973044459635133646703969879372571533096054296883386644122380530951726299847426987732042397595779976830474678726947018304354845591378517358359470056483109237714380888286233563680472388849805778688479350769638569123934902",
      "3067476257285335874566823333688543442128450810079871657467124491543338509419265027748695014643813306181544035536165512867635982606378678645467114585754422748255288790715628747169903578478381870157776988838327310364853622786578500012302428307039672498275",
      "-3067476257285335874566823333688543442128450810079871657467124491543338509419265027748695014643813306181544035536165512867635982606378678645467114585754422748255288790715628747169903578478381870157776988838327310364853622786578500012302428307039672498275",
      "883397505237211649947418585007890070022882946801242047716792933816916920312758",
      "-883397505237211649947418585007890070022882946801242047716792933816916920312758",
      "1100016596294277930396702074837291475694950629762363744759571589030108139933298189695770187024515803626715526690351811923084433342467648792302262756272887683638924910835436501074742486120762849764143752164258427412169550392618539176353678199434066032915",
      "-1100016596294277930396702074837291475694950629762363744759571589030108139933298189695770187024515803626715526690351811923084433342467648792302262756272887683638924910835436501074742486120762849764143752164258427412169550392618539176353678199434066032915",
      "3318653243827753930075076609367167950215271547197165956541578677095035789105230285577300537970253024380004869448887191421072498566168883197146749684037295491",
      "-3318653243827753930075076609367167950215271547197165956541578677095035789105230285577300537970253024380004869448887191421072498566168883197146749684037295491",
      "18917325422442253597680054225840324956976833511185836470606776355469702018395215498115502098244359450586779118546945991879765584863693947599352077215049091215099400154668038964846442469328921458041398569034401548536622210828439622386945359553017072968575829651399459030775837160233158886103",
      "-18917325422442253597680054225840324956976833511185836470606776355469702018395215498115502098244359450586779118546945991879765584863693947599352077215049091215099400154668038964846442469328921458041398569034401548536622210828439622386945359553017072968575829651399459030775837160233158886103",
      "254366786216910043665990950804997231945088908428747001184159373059058493118875749329803453882635522927040165937386417763335659992218458086511885522609981363333096153519757022667758401739961262948319999739472528794701",
      "-254366786216910043665990950804997231945088908428747001184159373059058493118875749329803453882635522927040165937386417763335659992218458086511885522609981363333096153519757022667758401739961262948319999739472528794701",
      "37544442396527426899195446849672655465276344502770712178079384432684510232491164260359865664795991038222782506894463672347582854",
      "-37544442396527426899195446849672655465276344502770712178079384432684510232491164260359865664795991038222782506894463672347582854",
      "15673578372504731899692149900135775418224632075238646337867467957107034530818946478167665455128984412394389268797819166734444989508179006505772666514111230952795610254140089645092544526629237404643329919824803563866840859270664303879742294839213766102351871211663636813556965",
      "-15673578372504731899692149900135775418224632075238646337867467957107034530818946478167665455128984412394389268797819166734444989508179006505772666514111230952795610254140089645092544526629237404643329919824803563866840859270664303879742294839213766102351871211663636813556965",
      "27481560151479303283253590172063634693210359375791056643367262359056676411581745877899312410880682306069203702180378974272137310962",
      "-27481560151479303283253590172063634693210359375791056643367262359056676411581745877899312410880682306069203702180378974272137310962",
      "59764850084546321076270115679381459961266663920938595034931337715038895288728780241940147905268936247355365797839452044959717373177405268037975305459371499345817108953258614141073965011536848191412758145014880201415800076045236677519189441266640929126443802253464497061850704733496580039504966534",
      "-59764850084546321076270115679381459961266663920938595034931337715038895288728780241940147905268936247355365797839452044959717373177405268037975305459371499345817108953258614141073965011536848191412758145014880201415800076045236677519189441266640929126443802253464497061850704733496580039504966534",
      "236346389410506959600114343181511587020869234266420558654132661642154355113727359542557485608210379840787154866691122790684707204957449484562815548156526563035046035495563526969340",
      "-236346389410506959600114343181511587020869234266420558654132661642154355113727359542557485608210379840787154866691122790684707204957449484562815548156526563035046035495563526969340",
      "8815935276532889936007554615797399527468399687615548740700254897861864429815615560728972825692565852981716178182277189313249729477257089767951370396136769451014576455113",
      "-8815935276532889936007554615797399527468399687615548740700254897861864429815615560728972825692565852981716178182277189313249729477257089767951370396136769451014576455113",
      "15766842373922966734945972936934487778733908393732",
      "-15766842373922966734945972936934487778733908393732",
      "6595752830737826074851600247398704243439581",
      "-6595752830737826074851600247398704243439581",
      "883607119507167020680444599092885224088612050268051636998275726360170767104266391951078564780752590643878108107048593830807317310688757872408858062530074042278525133611486569437859217448040432508288719355266779546627635013182590336527",
      "-883607119507167020680444599092885224088612050268051636998275726360170767104266391951078564780752590643878108107048593830807317310688757872408858062530074042278525133611486569437859217448040432508288719355266779546627635013182590336527",
      "33694907409791755762655404952802940988899691249",
      "-33694907409791755762655404952802940988899691249",
      "323333915936767999634844119809319135460509879311229599308354939953168279",
      "-323333915936767999634844119809319135460509879311229599308354939953168279",
      "109533461242727456317187321637480456637352670377446387229311720642342270936669079",
      "-109533461242727456317187321637480456637352670377446387229311720642342270936669079",
      "1385911310557366456440256909064094890695543397784942861180089270740259394708721160036253862597269877264942393141524860354011688095362554758164667579347793400229024555480224078270156224230580104617746710199310164986752840215359839845498564497854670854",
      "-1385911310557366456440256909064094890695543397784942861180089270740259394708721160036253862597269877264942393141524860354011688095362554758164667579347793400229024555480224078270156224230580104617746710199310164986752840215359839845498564497854670854",
      "29774115054799535833930768716897017350284486426186383584162324318962025027678962428276603554895692141466695531519088683268104074739324371129542465293986416152097350166384444454811692728264434003142202934260616565733198831279676615440572524973775003086833767426",
      "-29774115054799535833930768716897017350284486426186383584162324318962025027678962428276603554895692141466695531519088683268104074739324371129542465293986416152097350166384444454811692728264434003142202934260616565733198831279676615440572524973775003086833767426",
      "74696367101640724890251441072354635571976155536130046140237438589798381789554793148406818355661257862104683281722318017709028012486180422540427675980472782459468162926394976288225872264456693023891477557259759177462765826175659413065496505969367440547828089465241517425279607801825661125137502490209352550",
      "-74696367101640724890251441072354635571976155536130046140237438589798381789554793148406818355661257862104683281722318017709028012486180422540427675980472782459468162926394976288225872264456693023891477557259759177462765826175659413065496505969367440547828089465241517425279607801825661125137502490209352550",
      "1204196594639385922414846449687106633371016123988162000948048507502126642148118",
      "-1204196594639385922414846449687106633371016123988162000948048507502126642148118",
      "846833858170919771038203149272750341572762713657689308208261686002409383861625765452744323828942233333",
      "-846833858170919771038203149272750341572762713657689308208261686002409383861625765452744323828942233333",
      "182161452241374047273456867899515861555380897442569148219001470598361338903885535593714631480225974535244035939079461012689178031931288032512442603044979036705163872936026346865633839654342088060028594652808131903888369770826412770233292335398149959646",
      "-182161452241374047273456867899515861555380897442569148219001470598361338903885535593714631480225974535244035939079461012689178031931288032512442603044979036705163872936026346865633839654342088060028594652808131903888369770826412770233292335398149959646",
      "982677520230623904675071524585093908331832014895485448777250229533226440326748097093798644810",
      "-982677520230623904675071524585093908331832014895485448777250229533226440326748097093798644810",
      "2470642728099219780778259687407342337194729387462688122808418202258274933287",
      "-2470642728099219780778259687407342337194729387462688122808418202258274933287",
      "21642",
      "-21642",
      "28109476527429648692470007325789564480573483619310804793750563939329019602047743826734114282192488430735600284398989680911911960943283501628534649887574302741936678165842670818369902783900366003306472118461382044113045381589251197206074842928328220219584087542112389580462137108895790086",
      "-28109476527429648692470007325789564480573483619310804793750563939329019602047743826734114282192488430735600284398989680911911960943283501628534649887574302741936678165842670818369902783900366003306472118461382044113045381589251197206074842928328220219584087542112389580462137108895790086",
      "24473934394139795039432356490797923225705279667816043556538102097065",
      "-24473934394139795039432356490797923225705279667816043556538102097065",
      "967666937415492520370655115944840613051857445576119169258498049770608556022671644163127742796054969198094856",
      "-967666937415492520370655115944840613051857445576119169258498049770608556022671644163127742796054969198094856",
      "8777670436928270404636672844045971126192291209566648012730356503650458463860437163044293866063131499188106079322582985846405009457295181485284286775546965040263973340573887093705724765371051485505998527923498980801571623582212444207027545811844533625560957194790459778850062900748",
      "-8777670436928270404636672844045971126192291209566648012730356503650458463860437163044293866063131499188106079322582985846405009457295181485284286775546965040263973340573887093705724765371051485505998527923498980801571623582212444207027545811844533625560957194790459778850062900748",
      "10519677007822794739900735125229787943972331835720269482799977",
      "-10519677007822794739900735125229787943972331835720269482799977",
      "1590072871278743537180333082100146324295480429097445157011611168462260468069742799519303496051313133424632939883615906533434106640128123864165917007171699524724790769928823375793283671051479570198286895253998686473352852617282646423776591164499455695311138248299",
      "-1590072871278743537180333082100146324295480429097445157011611168462260468069742799519303496051313133424632939883615906533434106640128123864165917007171699524724790769928823375793283671051479570198286895253998686473352852617282646423776591164499455695311138248299",
      "383577258388475022706431955525247573599499248581278423720457780337892379126935",
      "-383577258388475022706431955525247573599499248581278423720457780337892379126935",
      "4092674502161259843824589343985242161447501042778080381002610852870457757982768392530808942900298511043488661625193784801456963642409098266685508736530379429664593489447947572985105744943017018734265426997872693998175650632205202701888817395372790067319643794599452089403576233527127077671169622",
      "-4092674502161259843824589343985242161447501042778080381002610852870457757982768392530808942900298511043488661625193784801456963642409098266685508736530379429664593489447947572985105744943017018734265426997872693998175650632205202701888817395372790067319643794599452089403576233527127077671169622",
      "13404427613900927247182634952369430867149749267930075884187025351198408344520192279603454195813154024830997527858376982434391797362547445527455503408360391999256823815839930266546427915841779",
      "-13404427613900927247182634952369430867149749267930075884187025351198408344520192279603454195813154024830997527858376982434391797362547445527455503408360391999256823815839930266546427915841779",
      "1782731694176936358469465341561020425473553201468123279175729849215977910638614519237563454448377541145186523281923996935231617014737050458102419525422740666362815640052502503060273650753054955785368306923652680382227789211754118567371586934",
      "-1782731694176936358469465341561020425473553201468123279175729849215977910638614519237563454448377541145186523281923996935231617014737050458102419525422740666362815640052502503060273650753054955785368306923652680382227789211754118567371586934",
      "71445070949104597011738157784103420085714634511010244724089831548057084941763190363056184849082451693612273802898122477866754965092090652561708550",
      "-71445070949104597011738157784103420085714634511010244724089831548057084941763190363056184849082451693612273802898122477866754965092090652561708550",
      "29824403422520048745171796949849941396331286906646046322404644703962912292598789686250791183932008392905170486032131129329348882564734443795544653928497362304776093305233881623231624358963434097033411434801644527775046832916455013625115699965097251269229855092992005057236242615322851235046388965677957662",
      "-29824403422520048745171796949849941396331286906646046322404644703962912292598789686250791183932008392905170486032131129329348882564734443795544653928497362304776093305233881623231624358963434097033411434801644527775046832916455013625115699965097251269229855092992005057236242615322851235046388965677957662",
      "3305915750647269729664177438631754300633043385617699516297426765949911376314744190602062381040796872234391958",
      "-3305915750647269729664177438631754300633043385617699516297426765949911376314744190602062381040796872234391958",
      "3478784122562389625603",
      "-3478784122562389625603",
      "92086546733522598295324541515522297712847163647680019382995445215746554554174953976307228051786981849535290733112403050554954140651771516865900059530798935625857134201153825877196274813040051834092674214044263432436343855130586740109759258782054166065929",
      "-92086546733522598295324541515522297712847163647680019382995445215746554554174953976307228051786981849535290733112403050554954140651771516865900059530798935625857134201153825877196274813040051834092674214044263432436343855130586740109759258782054166065929",
      "65957872354116509297400621319564903702253130516097675674670945971981309842410416012915540911950348439255536201700835793048055599890677253563036692899622137331645054971331690373584438379720134181489517623643988341292887235850459604282122921452528",
      "-65957872354116509297400621319564903702253130516097675674670945971981309842410416012915540911950348439255536201700835793048055599890677253563036692899622137331645054971331690373584438379720134181489517623643988341292887235850459604282122921452528",
      "4165190074711498372705686642027748628010631591673700346085849569414502903758312031393196903476997644869669022781414821544378466903717692187198478658086148256293129853045819435002914",
      "-4165190074711498372705686642027748628010631591673700346085849569414502903758312031393196903476997644869669022781414821544378466903717692187198478658086148256293129853045819435002914",
      "502172553703744753908380772164642649304217792528090440716191580724484473328235664927817984771636372875409898830005825976063650593238541433729038373056225370315599153406133185392320847",
      "-502172553703744753908380772164642649304217792528090440716191580724484473328235664927817984771636372875409898830005825976063650593238541433729038373056225370315599153406133185392320847",
      "25810339190726741831136349797818105994358611764887668315197822821632935574011575463532742868091838388104842551381619490991039627647851601302773448573544037953054558472548",
      "-25810339190726741831136349797818105994358611764887668315197822821632935574011575463532742868091838388104842551381619490991039627647851601302773448573544037953054558472548",
      "4665422938667922731390545239525991067478667357298476881860826251089436662146540827982134227087684685030991914103761128873483160892760746361799786480055617662181625815248230938316973880302906675299954379007760370823224832674779",
      "-4665422938667922731390545239525991067478667357298476881860826251089436662146540827982134227087684685030991914103761128873483160892760746361799786480055617662181625815248230938316973880302906675299954379007760370823224832674779",
      "2223735597830224864049890057834039493638098960775167604145066375240100821674008194961337124741661084219067145508494176034464042665143434078149689607318313818865277681569064932224810481504434495675653041063465302100041302802648038458370477008560806359234416742985635022084248641500377",
      "-2223735597830224864049890057834039493638098960775167604145066375240100821674008194961337124741661084219067145508494176034464042665143434078149689607318313818865277681569064932224810481504434495675653041063465302100041302802648038458370477008560806359234416742985635022084248641500377",
      "42345447563490737654515925924136916105150662665879987625806652403110474948139404742355256883201223238547442445427767854602327889485658289780295383306283583160293766253974742903668207523228749309062814526339073599070",
      "-42345447563490737654515925924136916105150662665879987625806652403110474948139404742355256883201223238547442445427767854602327889485658289780295383306283583160293766253974742903668207523228749309062814526339073599070",
      "40757494492054593189505181124883370961902335356122875708839948469462201920152164929215445",
      "-40757494492054593189505181124883370961902335356122875708839948469462201920152164929215445",
      "489422217562968312762274110453276604934633603473056760608254327080440181671628006090249666021287247215269380617364913734802444913151007354363389984204873709403053283740243705411640696405073698784366581571968399",
      "-489422217562968312762274110453276604934633603473056760608254327080440181671628006090249666021287247215269380617364913734802444913151007354363389984204873709403053283740243705411640696405073698784366581571968399",
      "203828256280853345400063519072625079280180030947163985710628295241982787474897521472368518281000277120011930353824152022905149681658066777399408021281560972784695745183483128330447721487075906552349941557379095078354083487747855104922",
      "-203828256280853345400063519072625079280180030947163985710628295241982787474897521472368518281000277120011930353824152022905149681658066777399408021281560972784695745183483128330447721487075906552349941557379095078354083487747855104922",
      "12579256107866823853770946314828592500732374403508913980712874463292391864755987195690537357503818366347747743186695890433",
      "-12579256107866823853770946314828592500732374403508913980712874463292391864755987195690537357503818366347747743186695890433",
      "26755461309842501536357032592700549777692476999989333013567704060006230872678556198949194222172481328325450314710024939575841488411640806870121381285742075565712411648904027990740378131995279017965737335010708563099143288460848557783",
      "-26755461309842501536357032592700549777692476999989333013567704060006230872678556198949194222172481328325450314710024939575841488411640806870121381285742075565712411648904027990740378131995279017965737335010708563099143288460848557783",
      "179718434482969588987690660522936295504619795328517541448501507443327040584026830018965223706205351139318424383916072860628585971720095475736018979361135523338248920218527202",
      "-179718434482969588987690660522936295504619795328517541448501507443327040584026830018965223706205351139318424383916072860628585971720095475736018979361135523338248920218527202",
      "4559476727415984415667742638506394832394804942241662737080235712002719322907465863068712531182175979070036317680566622",
      "-4559476727415984415667742638506394832394804942241662737080235712002719322907465863068712531182175979070036317680566622",
      "18056873734891410248496182290389914805111823879862689239017282732",
      "-18056873734891410248496182290389914805111823879862689239017282732",
      "28355632329442976457768532159881703427555635510700435885472670967222653884076177077876502624372493819303621756857250806505170393973261606631093857830885883244831587318220509004",
      "-28355632329442976457768532159881703427555635510700435885472670967222653884076177077876502624372493819303621756857250806505170393973261606631093857830885883244831587318220509004",
      "1459732654931833317515433139762665712773308964783227471709926780387231673576225461320924899820938949422193790260955695331912805657904286897274122419209888368548603",
      "-1459732654931833317515433139762665712773308964783227471709926780387231673576225461320924899820938949422193790260955695331912805657904286897274122419209888368548603",
      "841297417411594292128977",
      "-841297417411594292128977",
      "4242195673983737600970155103235752981938372024288592013363272064075708471058134960551862070710453189027317281773782487650970",
      "-4242195673983737600970155103235752981938372024288592013363272064075708471058134960551862070710453189027317281773782487650970",
      "197127905405798244",
      "-197127905405798244",
      "6563407470658357675196420807382675727943443587151170499642011999875762151944659352887984041897388778521562733",
      "-6563407470658357675196420807382675727943443587151170499642011999875762151944659352887984041897388778521562733",
      "171120862433529862507872013528755671195868254123500416552655719933624587064946914905766882327146949422149531556848478731913777486790475986722345662117903207153341",
      "-171120862433529862507872013528755671195868254123500416552655719933624587064946914905766882327146949422149531556848478731913777486790475986722345662117903207153341",
      "187214460763227398586269742130045771591887383985328887736156741862960369193610822715922978601952519088940029424980096549841026833488303831185375087247455968007157419452960145311595471",
      "-187214460763227398586269742130045771591887383985328887736156741862960369193610822715922978601952519088940029424980096549841026833488303831185375087247455968007157419452960145311595471",
      "2673090487374081993731207525489391145288488762290600450482603424170240599600446740180718555900667741328318482506598059839151491967628487386391045037818794920023261735737921639708995039726148095626857322210114264941784225627483927045402749218",
      "-2673090487374081993731207525489391145288488762290600450482603424170240599600446740180718555900667741328318482506598059839151491967628487386391045037818794920023261735737921639708995039726148095626857322210114264941784225627483927045402749218",
      "299586874531112789052013025908546379682766040499696938471256503832571345345612339844529913907580250563145642647",
      "-299586874531112789052013025908546379682766040499696938471256503832571345345612339844529913907580250563145642647",
      "405538475580851874887939920459327617092961192248480802208813876830531489658564864824178266672271683879464330412787024584249226414349424728066961849584546083679996737251131765131648932944495100981642907933045304884221229278087094810231012513599884296417415741723145516546902774087770992604",
      "-405538475580851874887939920459327617092961192248480802208813876830531489658564864824178266672271683879464330412787024584249226414349424728066961849584546083679996737251131765131648932944495100981642907933045304884221229278087094810231012513599884296417415741723145516546902774087770992604",
      "4289997525579508886804910999084475469759259557183118236485054735737485047460566798688052482933027075995626140181076328124548622067825535609834113884951451721787266314523910215228638324453588589604475728750868849529649579405314779527171490876426202137784122981787297800640695809335850632264276817218",
      "-4289997525579508886804910999084475469759259557183118236485054735737485047460566798688052482933027075995626140181076328124548622067825535609834113884951451721787266314523910215228638324453588589604475728750868849529649579405314779527171490876426202137784122981787297800640695809335850632264276817218",
      "8307592530302620538620421474950064873013",
      "-8307592530302620538620421474950064873013",
      "668153113826415803744690433659063449914674108460",
      "-668153113826415803744690433659063449914674108460",
      "46917857009025361535384034419352878543368877134948287044907072634745489626203425426919312434872888667388137952819558853009128820322712955326948275185023832843664510785316937903",
      "-46917857009025361535384034419352878543368877134948287044907072634745489626203425426919312434872888667388137952819558853009128820322712955326948275185023832843664510785316937903",
      "72692276728923532198738657661593229541714898424777445103294553106601965453652630548922019551752677856073619742879036073418",
      "-72692276728923532198738657661593229541714898424777445103294553106601965453652630548922019551752677856073619742879036073418",
      "1365147498021014007274145395277247416653740352472059016216427940658523565320578614021663036729154339063385098348763260722534882240886880631939819",
      "-1365147498021014007274145395277247416653740352472059016216427940658523565320578614021663036729154339063385098348763260722534882240886880631939819",
      "114300720014386070718720229683003272046146186775381997423967458204765959963431901037954797839956346151530366909939183214",
      "-114300720014386070718720229683003272046146186775381997423967458204765959963431901037954797839956346151530366909939183214",
      "6762",
      "-6762",
      "52958329794842511544564431607079502085929565913139912125121000214082684350382689340216127453430020886928460043472604757294523852724883994706799227072659732722150629405334684502120793494615254736603105282342926917766772004919",
      "-52958329794842511544564431607079502085929565913139912125121000214082684350382689340216127453430020886928460043472604757294523852724883994706799227072659732722150629405334684502120793494615254736603105282342926917766772004919",
      "176688206756700071063559027466389453920766491733115376426152125336429137613213551729990793300311032785623",
      "-176688206756700071063559027466389453920766491733115376426152125336429137613213551729990793300311032785623",
      "1922483080110348257033411950111656752298655371856953617086529843662865561409994291993287457671153478029077149725149857725",
      "-1922483080110348257033411950111656752298655371856953617086529843662865561409994291993287457671153478029077149725149857725",
      "116652054071220139544336382432735630060274666911983",
      "-116652054071220139544336382432735630060274666911983",
      "5174104538080339543938990263794928249064915674657896129852899608936285960971761863486556625630466310050160624211680012958157394810117796321101931191821302341708281726643201876685372393200977149042032383466554582623637450297592330981838876150680862436764327264788138788126029954523641986",
      "-5174104538080339543938990263794928249064915674657896129852899608936285960971761863486556625630466310050160624211680012958157394810117796321101931191821302341708281726643201876685372393200977149042032383466554582623637450297592330981838876150680862436764327264788138788126029954523641986",
      "56602051214329308908684928399837460067357624824927409574521689818931407829513021195830603280968596169697964984976489620035360483629559652883726214824557656337088813049173231800245733072858891481768028465352155733037356970930661713472640527903665",
      "-56602051214329308908684928399837460067357624824927409574521689818931407829513021195830603280968596169697964984976489620035360483629559652883726214824557656337088813049173231800245733072858891481768028465352155733037356970930661713472640527903665",
      "50465855132621952642877529162542254312895872248149199085828932352785530557943935823716975491349313488156548806716473058702726383127266",
      "-50465855132621952642877529162542254312895872248149199085828932352785530557943935823716975491349313488156548806716473058702726383127266",
      "2103822150383069790413887708626272542825699206757181614299988243654634518589287733034323781018255",
      "-2103822150383069790413887708626272542825699206757181614299988243654634518589287733034323781018255",
      "2884145868221566190464654384898336516944031094549949335240745089189320393412625205715458573411537464678090067152741985416827426839574623518965109414118185662809105887512018969132683541056905460490486376635525002751775036410408309529607280059108670794204594780445621",
      "-2884145868221566190464654384898336516944031094549949335240745089189320393412625205715458573411537464678090067152741985416827426839574623518965109414118185662809105887512018969132683541056905460490486376635525002751775036410408309529607280059108670794204594780445621",
      "17151949587338385537174755341574689039375819189521363664160085642631581896638291949680521029535105884955679278095750173056302788876858996886433270550139444896998901",
      "-17151949587338385537174755341574689039375819189521363664160085642631581896638291949680521029535105884955679278095750173056302788876858996886433270550139444896998901",
      "480533356849702776352763749832742587425919427139102525668442168835109831060078665166920712330431373189225474215620302495581803094913110624590177406888394624128938633526464614177040468306987399",
      "-480533356849702776352763749832742587425919427139102525668442168835109831060078665166920712330431373189225474215620302495581803094913110624590177406888394624128938633526464614177040468306987399",
      "4048293905596052205036948911452380394795846231788449",
      "-4048293905596052205036948911452380394795846231788449",
      "26995137345178218227830930364666340738",
      "-26995137345178218227830930364666340738",
      "774397441571262230984201650112220858044164538606555323635490088358801192583611522683260312754942754317572391764052135170163899209038840031703432786259696586141227827701639190998818229513",
      "-774397441571262230984201650112220858044164538606555323635490088358801192583611522683260312754942754317572391764052135170163899209038840031703432786259696586141227827701639190998818229513",
      "18762561208181880394479657197069746737270753294648933008217092757003616838536799737540224936022419848244051559923181261528435902887894811151076237",
      "-18762561208181880394479657197069746737270753294648933008217092757003616838536799737540224936022419848244051559923181261528435902887894811151076237",
      "907239775827042770755661550314761787115062100342977397902609610238855670466824379",
      "-907239775827042770755661550314761787115062100342977397902609610238855670466824379",
      "752510106807455900379909618532778973994453687695730898309343615105390212836204453042377052183212876905061",
      "-752510106807455900379909618532778973994453687695730898309343615105390212836204453042377052183212876905061",
      "1594387591422875707361322970839625151131381378174641793551465510142159417127028702651513859466122585110982922292801583543059620610053622982905425511766811223211156471041084636387606630303692709955363035",
      "-1594387591422875707361322970839625151131381378174641793551465510142159417127028702651513859466122585110982922292801583543059620610053622982905425511766811223211156471041084636387606630303692709955363035",
      "23316150037708287470080374296114607254763375473373018965703611900047553929551418522455587001961482391010828529091929849671267100179126145618520750402550331537136654",
      "-23316150037708287470080374296114607254763375473373018965703611900047553929551418522455587001961482391010828529091929849671267100179126145618520750402550331537136654",
      "206570606519236414660405117101821960086150934143523942248291980694989781221204732295572458288359135192620910534498754440751275665591490740002481374496819362873621178489882031204314197626575326338703982006151642904",
      "-206570606519236414660405117101821960086150934143523942248291980694989781221204732295572458288359135192620910534498754440751275665591490740002481374496819362873621178489882031204314197626575326338703982006151642904",
      "64632739363686102310668199833121081452653123828159756435580680576799270035485260582762183515021072594277553694799435773660728228989363057503956061322371391729597055325808343868799201699918264379213943162952380242502610323",
      "-64632739363686102310668199833121081452653123828159756435580680576799270035485260582762183515021072594277553694799435773660728228989363057503956061322371391729597055325808343868799201699918264379213943162952380242502610323",
      "589421411734420159501267976455896411309276255208891167201590523330271039604417032437154142085688410405533459836702131617092573518938815446609802434772431958960872071215171855513041280388698254907927340515117391166070141683457342784",
      "-589421411734420159501267976455896411309276255208891167201590523330271039604417032437154142085688410405533459836702131617092573518938815446609802434772431958960872071215171855513041280388698254907927340515117391166070141683457342784",
      "78879805619934569024599381571707822806614963415349200270284875054237164864359624372158647647863797008340316828012300755667110314855460503179181117097385701319739187114139718329827695009617428401620773545555394848573360317456047893463046622890050301003010952433178967879125505419476694805185008787411114258",
      "-78879805619934569024599381571707822806614963415349200270284875054237164864359624372158647647863797008340316828012300755667110314855460503179181117097385701319739187114139718329827695009617428401620773545555394848573360317456047893463046622890050301003010952433178967879125505419476694805185008787411114258",
      "23502781763641178064404023959903165549857567200280242514656186491195674181432757323176594593508102253721487854615955222259753262265267416938",
      "-23502781763641178064404023959903165549857567200280242514656186491195674181432757323176594593508102253721487854615955222259753262265267416938",
      "409297139610776763506123895143481451963282099839420969098705456374184360544846067009871040867462673178544358986308342020083146065020599826820240081787171394155098100110040672410422987400472449240126519719022700797622570738",
      "-409297139610776763506123895143481451963282099839420969098705456374184360544846067009871040867462673178544358986308342020083146065020599826820240081787171394155098100110040672410422987400472449240126519719022700797622570738",
      "23333202714794325323697505",
      "-23333202714794325323697505",
      "88926553698672071141130629238070206100425021951043909308812007686747474756572535280975280230894876905612920792259781652532353624660383165526934048092970256374163978700915230573599950689593884285235239417830600259906139092309559397593337924686035082341037174504874298230037865321327",
      "-88926553698672071141130629238070206100425021951043909308812007686747474756572535280975280230894876905612920792259781652532353624660383165526934048092970256374163978700915230573599950689593884285235239417830600259906139092309559397593337924686035082341037174504874298230037865321327",
      "193216483164388919875865726156220378900478525465101761599275916110098513",
      "-193216483164388919875865726156220378900478525465101761599275916110098513",
      "445147927105811334112201187535182947887817402193430490222008844342623483790016955826328140200646698573333197769902932812101243075968229955686369555029175781",
      "-445147927105811334112201187535182947887817402193430490222008844342623483790016955826328140200646698573333197769902932812101243075968229955686369555029175781",
      "404724915427015100236245877077487335897861954733139220931559056131326351438847042320598819539736832267015136080413912317007525653866157576085879981310860858916082141809558153661155248226776118160741627797764071433035028151035984348656570943456141740411122305727778772350559929918941",
      "-404724915427015100236245877077487335897861954733139220931559056131326351438847042320598819539736832267015136080413912317007525653866157576085879981310860858916082141809558153661155248226776118160741627797764071433035028151035984348656570943456141740411122305727778772350559929918941",
      "15881033668267446564985922502808887168130126414945171534501886241573767046656582600501857191275522198094812554481448361027945717673462595782212036129626347287630493102505400",
      "-15881033668267446564985922502808887168130126414945171534501886241573767046656582600501857191275522198094812554481448361027945717673462595782212036129626347287630493102505400",
      "2137415689988797072560582676089346590053122445",
      "-2137415689988797072560582676089346590053122445",
      "323798850186148580554863589187091135845440166774430133093440314556959379021941132307127400322225854705093073925068652013957143959242670668925116774275979824",
      "-323798850186148580554863589187091135845440166774430133093440314556959379021941132307127400322225854705093073925068652013957143959242670668925116774275979824",
      "173508106063459544226297157276274728721118210069318517925122848577242175434996938459695476331454013223646557993405407002578179119005445994337106614223750746479653994536225606203430489837348181146905602085037927766933972128185498665420530967676198121700174",
      "-173508106063459544226297157276274728721118210069318517925122848577242175434996938459695476331454013223646557993405407002578179119005445994337106614223750746479653994536225606203430489837348181146905602085037927766933972128185498665420530967676198121700174",
      "78355099355274385235041105626642472390321765441120677546321753788293394435411913702107288104186287888107050196021354011143759436476044341380451",
      "-78355099355274385235041105626642472390321765441120677546321753788293394435411913702107288104186287888107050196021354011143759436476044341380451",
      "14082584100725485095810331470851521352703939751219746773401724408039845947212432002741091564650266209598267452042246073901010147451656273871799778680203026839107331149",
      "-14082584100725485095810331470851521352703939751219746773401724408039845947212432002741091564650266209598267452042246073901010147451656273871799778680203026839107331149",
      "2451726111242013614644472867015070800954350593117210091845723358334627905121894871023262409519589588967063261046514660829821816464168656627289239433694932574140916666824",
      "-2451726111242013614644472867015070800954350593117210091845723358334627905121894871023262409519589588967063261046514660829821816464168656627289239433694932574140916666824",
      "20065158625055757494521923831526555875918181556943569250588125153526936260221797604217490757723244157360646025073105062346371489195519447915244240862375631489025063124997553195851549786517441567063889510370756857238499576234680378947724748027600877684623953611544337343413268969959530489689129071097842283967",
      "-20065158625055757494521923831526555875918181556943569250588125153526936260221797604217490757723244157360646025073105062346371489195519447915244240862375631489025063124997553195851549786517441567063889510370756857238499576234680378947724748027600877684623953611544337343413268969959530489689129071097842283967",
      "2877720628966736569525036642910772915862211025917410379176852591593786965122381483084242795700755306144132542301154682139822037092615315519",
      "-2877720628966736569525036642910772915862211025917410379176852591593786965122381483084242795700755306144132542301154682139822037092615315519",
      "3795119948781692972575431",
      "-3795119948781692972575431",
      "117633423107664842386614454295318823031546808284886498133093442797780366695865088951102734835036375188027702346663647830425172733187275067584200082224814835976110754843437513016147344252016745713239843138800215136235719850541984478206795380204540097476184957279443",
      "-117633423107664842386614454295318823031546808284886498133093442797780366695865088951102734835036375188027702346663647830425172733187275067584200082224814835976110754843437513016147344252016745713239843138800215136235719850541984478206795380204540097476184957279443",
      "6028200577464886742220964264433220606667469744201474633845587044124944417457573648621749660231277732832613157240821087790368844691241612",
      "-6028200577464886742220964264433220606667469744201474633845587044124944417457573648621749660231277732832613157240821087790368844691241612",
      "1117820580139700758941594748763781946255037110167582749384133756752449839190401944216912957650664993553129645500059553210763046702311000117537213965255288711420760932554622971299296197897",
      "-1117820580139700758941594748763781946255037110167582749384133756752449839190401944216912957650664993553129645500059553210763046702311000117537213965255288711420760932554622971299296197897",
      "894440058986616656162159749909897",
      "-894440058986616656162159749909897",
      "11758059164722075820822351813564721682251718268398125058702252593271794825804844012676212580269973081943948588059900469592179919885984813401833621636489306",
      "-11758059164722075820822351813564721682251718268398125058702252593271794825804844012676212580269973081943948588059900469592179919885984813401833621636489306",
      "48260623373995703142149825869126942692445720237750683695954821352777035904885960923027672480964040682023869233942201916828693522743832886088998972188767776078279426029402097202986260065462533610836932273188567823090315418748142243190815560532101505961513910649086153182477090526300312187507612192",
      "-48260623373995703142149825869126942692445720237750683695954821352777035904885960923027672480964040682023869233942201916828693522743832886088998972188767776078279426029402097202986260065462533610836932273188567823090315418748142243190815560532101505961513910649086153182477090526300312187507612192",
      "155032044456958560653742313851007803134963800248495609164183285804227615140653638264588439258316691251377924988538500569549816017742093617863981847156274851353234781166567436349214058632603830394495548221403249818520855020397602702298881144444526972675887598504476681959777521420493375210129749627151599",
      "-155032044456958560653742313851007803134963800248495609164183285804227615140653638264588439258316691251377924988538500569549816017742093617863981847156274851353234781166567436349214058632603830394495548221403249818520855020397602702298881144444526972675887598504476681959777521420493375210129749627151599",
      "117",
      "-117",
      "31151175335",
      "-31151175335",
      "35374964788462894211615124919986334396217303170433399786403229831899783789349053619411986131305536842776505623498475004759495592581325624956208728845327562674600497034793430703900584828213353358028973193115581365893453195729236094397513635",
      "-35374964788462894211615124919986334396217303170433399786403229831899783789349053619411986131305536842776505623498475004759495592581325624956208728845327562674600497034793430703900584828213353358028973193115581365893453195729236094397513635",
      "11796859242834559349330645424007719279425086069437451547961817738176345052586077262730615110965711332407717403184353050831388270460861280643450803074302303211224953369570563468013937668078037503909168201005260137906679740236981824660385730820591421051254923150011711560287985553001992949325890751138512",
      "-11796859242834559349330645424007719279425086069437451547961817738176345052586077262730615110965711332407717403184353050831388270460861280643450803074302303211224953369570563468013937668078037503909168201005260137906679740236981824660385730820591421051254923150011711560287985553001992949325890751138512",
      "170647522893580509002975714845089353418304318223993041052613489603839464032767136346831417604396147862171608710351258359424720597066331032122844389758062085194297618983116731697591466836398130208912823480520907032976237477074428855652406620425725105496",
      "-170647522893580509002975714845089353418304318223993041052613489603839464032767136346831417604396147862171608710351258359424720597066331032122844389758062085194297618983116731697591466836398130208912823480520907032976237477074428855652406620425725105496",
      "5281478654865951520041163170269381080147277352244478257096792252048711710697114547916527006005288159091362187924",
      "-5281478654865951520041163170269381080147277352244478257096792252048711710697114547916527006005288159091362187924",
      "4612981530909908953399866319425198830164041651329116814589068706471983209837216442140437916749761739590696654721694691453248631167747384468652625616153898389404331335686814768720227658621123619760490072200457566243849427676890450504279708348832752925128591526859889728",
      "-4612981530909908953399866319425198830164041651329116814589068706471983209837216442140437916749761739590696654721694691453248631167747384468652625616153898389404331335686814768720227658621123619760490072200457566243849427676890450504279708348832752925128591526859889728",
      "230942413272730226530444519509994205060147713549648054777582719550812782352234600742222169014506643621109087605680440174002739494059492224354791764876753787909937534165450961813280650662325436679754051868455414",
      "-230942413272730226530444519509994205060147713549648054777582719550812782352234600742222169014506643621109087605680440174002739494059492224354791764876753787909937534165450961813280650662325436679754051868455414",
      "528690042093345595850504247",
      "-528690042093345595850504247",
      "31537765402865704303346035013066893813209666897703115111579537190812318360668479310525622135277986713283804",
      "-31537765402865704303346035013066893813209666897703115111579537190812318360668479310525622135277986713283804",
      "1599362772260782365940237955777469665833441883265981514825058091831969039328944925726126036206151420504388513842915084045761",
      "-1599362772260782365940237955777469665833441883265981514825058091831969039328944925726126036206151420504388513842915084045761",
      "22018294718309903690696646065850459504307668740106965970119563766751726997751841635147532383629353261767951801681466624415627829013290232821085001690020179707527003163210966668639431417007076432036482650137410011799888860384641536214437778644612376970907784011215",
      "-22018294718309903690696646065850459504307668740106965970119563766751726997751841635147532383629353261767951801681466624415627829013290232821085001690020179707527003163210966668639431417007076432036482650137410011799888860384641536214437778644612376970907784011215",
      "139228864110515195216553853606798559408959520596931103855825362443397424774758172",
      "-139228864110515195216553853606798559408959520596931103855825362443397424774758172",
      "438362563301076",
      "-438362563301076",
      "536477710240446158400855952047098861739032777002422842180036166459742934651199360607978321612514452622744911025658574877961214107174719449789017540265828279486524590338437269953368890994755662873267173870955360800125978287820421262971848425170065",
      "-536477710240446158400855952047098861739032777002422842180036166459742934651199360607978321612514452622744911025658574877961214107174719449789017540265828279486524590338437269953368890994755662873267173870955360800125978287820421262971848425170065",
      "498862087303189047484286815556440094292974761004818123941676688570935488959257235857771896260779999415327140115975996793571922312686472323161351487622438079274047587863856806852283080757914159158900221821",
      "-498862087303189047484286815556440094292974761004818123941676688570935488959257235857771896260779999415327140115975996793571922312686472323161351487622438079274047587863856806852283080757914159158900221821",
      "397485490350112467732556257997195088092587231213238688938663359508903507782996482344687130558398493814503644541315765003280501133111",
      "-397485490350112467732556257997195088092587231213238688938663359508903507782996482344687130558398493814503644541315765003280501133111",
      "849712043650971777004742171643106324862754090831744200814795006972518085972931752076874433562783731671435108431684162545599206785950669723461026526402295759448129538027792947274880743875232398841880484354651333627643180878756213653",
      "-849712043650971777004742171643106324862754090831744200814795006972518085972931752076874433562783731671435108431684162545599206785950669723461026526402295759448129538027792947274880743875232398841880484354651333627643180878756213653",
      "31939357424827970804026114453315327769012263471221072258182242042519626638563054352273477096407109171097657867287701617587164195568409977479696410846577473709461543239341493963739506308939662837999529461859333741861608567355869490150265338213466190360633042086859245316851129010609",
      "-31939357424827970804026114453315327769012263471221072258182242042519626638563054352273477096407109171097657867287701617587164195568409977479696410846577473709461543239341493963739506308939662837999529461859333741861608567355869490150265338213466190360633042086859245316851129010609",
      "59075219415446517463799317419672630289040",
      "-59075219415446517463799317419672630289040",
      "61544636348619846793635535253831658039274289566061329628",
      "-61544636348619846793635535253831658039274289566061329628",
      "470399936237982365631161793432085070263103572484796818885564848815758149943921811891860946060341559711899471195599373649384438242044515090831782134530922053677106020022279456123296157017910183495235140194390296804039743799564279602012304465862001339612585603213921336997140271860031180936085302533520084",
      "-470399936237982365631161793432085070263103572484796818885564848815758149943921811891860946060341559711899471195599373649384438242044515090831782134530922053677106020022279456123296157017910183495235140194390296804039743799564279602012304465862001339612585603213921336997140271860031180936085302533520084",
      "4263018257494613144043214865050835432323223259669979976818528797978364036590648420",
      "-4263018257494613144043214865050835432323223259669979976818528797978364036590648420",
      "1030364360168890027890816549580",
      "-1030364360168890027890816549580",
      "792685786141580556314148491833336274593743818",
      "-792685786141580556314148491833336274593743818",
      "641446086312126555467875106303989084781624843543297958597183735580271101775752996685163",
      "-641446086312126555467875106303989084781624843543297958597183735580271101775752996685163",
      "5495154319842093167496249323058689957423462",
      "-5495154319842093167496249323058689957423462",
      "11789599234651983989010071854908355935861398361186377696491616773407893531669446332781833177934487486443699554324479061335467496521890118734937498733191672611144989167953103344991959519028482263752023000602387955366518706202210024461852086754020196",
      "-11789599234651983989010071854908355935861398361186377696491616773407893531669446332781833177934487486443699554324479061335467496521890118734937498733191672611144989167953103344991959519028482263752023000602387955366518706202210024461852086754020196",
      "11868320247536683221143642841170454891656934116545619261841381472878070159790790558172360288429121201484338870667354265884102674537478716958516286215910855456088033052883980008436942265685062267471783017549551768359416886934474316919451518061351858590202914987178911670",
      "-11868320247536683221143642841170454891656934116545619261841381472878070159790790558172360288429121201484338870667354265884102674537478716958516286215910855456088033052883980008436942265685062267471783017549551768359416886934474316919451518061351858590202914987178911670",
      "1284156757531040914593221",
      "-1284156757531040914593221",
      "9523156885736314276851029956129745152608513178870686801769759111308470996123088771851122858908132203444859152976097503444227519069060806081448518797562327844612222984531692130770",
      "-9523156885736314276851029956129745152608513178870686801769759111308470996123088771851122858908132203444859152976097503444227519069060806081448518797562327844612222984531692130770",
      "31415032545650652773467205308921957370624743383488073117109921420678201637023554362493982589097031342230335705038785983149366806922747914694551472092848890719761600241693293020110370962350805350",
      "-31415032545650652773467205308921957370624743383488073117109921420678201637023554362493982589097031342230335705038785983149366806922747914694551472092848890719761600241693293020110370962350805350",
      "38540294830367981299370153716758943624066595675817723365819908936210186285351422767835324962411068698716556932780434832522209505361628036446058246936860795564022909013649",
      "-38540294830367981299370153716758943624066595675817723365819908936210186285351422767835324962411068698716556932780434832522209505361628036446058246936860795564022909013649",
      "1489",
      "-1489",
      "2270684970894467473228397152522666196967234885",
      "-2270684970894467473228397152522666196967234885",
      "623594270429426955031234189496487600662597646571928622449980935215346797035198838197888222869632091525558748378610334926140669245375114542239425712378426359715133474059991644743953906535538195465100677512751053",
      "-623594270429426955031234189496487600662597646571928622449980935215346797035198838197888222869632091525558748378610334926140669245375114542239425712378426359715133474059991644743953906535538195465100677512751053",
      "60223901057086672916139687208371207252559034742838976658538850201068490068101652675647609676435807962967919811849514616239086913537412970210091632651259826174103338368751134965303230126211398438698151879240977404460468186851886617548182773561840252412981638510923",
      "-60223901057086672916139687208371207252559034742838976658538850201068490068101652675647609676435807962967919811849514616239086913537412970210091632651259826174103338368751134965303230126211398438698151879240977404460468186851886617548182773561840252412981638510923",
      "352083164097278474078005845682075986531119761078051415723391468152762696096016941577257179144242535089572306180818322625093102190964224730315213843217203692079968682",
      "-352083164097278474078005845682075986531119761078051415723391468152762696096016941577257179144242535089572306180818322625093102190964224730315213843217203692079968682",
      "256914715526573594304760664453685512541013676570328830117752884150636769825195172277797835580253224279327546275273345112399482552434310216245805227544453571042746897560531287112979681556135355",
      "-256914715526573594304760664453685512541013676570328830117752884150636769825195172277797835580253224279327546275273345112399482552434310216245805227544453571042746897560531287112979681556135355",
      "3929812712463085187666519605941080752665430680003082969619532219612559124276337233356486033607557565841182562299051203553436156356748939",
      "-3929812712463085187666519605941080752665430680003082969619532219612559124276337233356486033607557565841182562299051203553436156356748939",
      "1342865274232326934240128816495975896816628726930390134403022164244814040962732527145178443776536620876592577",
      "-1342865274232326934240128816495975896816628726930390134403022164244814040962732527145178443776536620876592577",
      "75482499101235806844482700363651520608393572186840116071510831",
      "-75482499101235806844482700363651520608393572186840116071510831",
      "157079333706470320589362721287335446436100673921262275021919536009571391130921654202277262407403872423297032197476611916298599850639905615780935087993369908937",
      "-157079333706470320589362721287335446436100673921262275021919536009571391130921654202277262407403872423297032197476611916298599850639905615780935087993369908937",
      "21096758435207806377330934948465784354053655",
      "-21096758435207806377330934948465784354053655",
      "7296202760566732448484088809683111106213594240238214600327977304983210800704941723091693567279115428088283219305211898160182",
      "-7296202760566732448484088809683111106213594240238214600327977304983210800704941723091693567279115428088283219305211898160182",
      "9473711847689244707278408760608984165904137893454069938633516224794155238069623008814110071678551847797982066773376077",
      "-9473711847689244707278408760608984165904137893454069938633516224794155238069623008814110071678551847797982066773376077",
      "424157689387860814675639",
      "-424157689387860814675639",
      "2311915845008175998603844058297620909349923283750536586587937434312377733844702049651807722475434283757267961177665307169760829875889028168476878787006491399930630338344642910500797043234542368361571429181649829252175786093011520179318",
      "-2311915845008175998603844058297620909349923283750536586587937434312377733844702049651807722475434283757267961177665307169760829875889028168476878787006491399930630338344642910500797043234542368361571429181649829252175786093011520179318",
      "74548539487073557220326968093479867500276859338046876248826540472060313997",
      "-74548539487073557220326968093479867500276859338046876248826540472060313997",
      "11654322736763",
      "-11654322736763",
      "53007278098826078101002711940372616336",
      "-53007278098826078101002711940372616336",
      "79488890173950413261690334491844393856301694056413503617980571504653230048955",
      "-79488890173950413261690334491844393856301694056413503617980571504653230048955",
      "408713674815985937940894525901270256192656939969702057871",
      "-408713674815985937940894525901270256192656939969702057871",
      "793896474068238367668141234719022911425186020423846578406386752245064555357695445408188930726837363615519065571656957027286833070564842125230923415365473419",
      "-793896474068238367668141234719022911425186020423846578406386752245064555357695445408188930726837363615519065571656957027286833070564842125230923415365473419",
      "174808944301193943551146900431326706416195767876909997906726651518289372951",
      "-174808944301193943551146900431326706416195767876909997906726651518289372951",
      "15518425275704712437859509478557555507942868590674242179846381629609574039655947926978374551659365245896461352380663149726832850553382303285336261869176813113104452944002526144559297701143263522625331250816271032050756743914895178056748128568613436826595",
      "-15518425275704712437859509478557555507942868590674242179846381629609574039655947926978374551659365245896461352380663149726832850553382303285336261869176813113104452944002526144559297701143263522625331250816271032050756743914895178056748128568613436826595",
      "704584697906407199708590092378103021972791431202757824957775774072784740246334320005088181512002963310761780580704786814454975765",
      "-704584697906407199708590092378103021972791431202757824957775774072784740246334320005088181512002963310761780580704786814454975765",
      "657607704878895067543343694899228430336912631528241927302696775319590907402199923852512833112461947631065129028125536463067298383212071017877117414800369576545371975736320978897530313093703317591926126573581594016017999087405971954224745504107290022634832416486976440197266126685274050284770811156390509",
      "-657607704878895067543343694899228430336912631528241927302696775319590907402199923852512833112461947631065129028125536463067298383212071017877117414800369576545371975736320978897530313093703317591926126573581594016017999087405971954224745504107290022634832416486976440197266126685274050284770811156390509",
      "7494538701531220",
      "-7494538701531220",
      "7300727560805294687539012803042995909238449713032452769229667883869087209620881400305875438962218813943386360970483979638425963787311826059269116699436735359914333529525984293006337531416122388956292154685035813667508959604499191395591577891525195678171",
      "-7300727560805294687539012803042995909238449713032452769229667883869087209620881400305875438962218813943386360970483979638425963787311826059269116699436735359914333529525984293006337531416122388956292154685035813667508959604499191395591577891525195678171",
      "255504587698518445312717922712930691081197792561411090916056798257637114731417865482714584651043811829851492818242972929470506766333616107450122580899272969326648134119416080989201012163771767787520485155594757300555185954280304839051723173371630921394024027714555984796981691309",
      "-255504587698518445312717922712930691081197792561411090916056798257637114731417865482714584651043811829851492818242972929470506766333616107450122580899272969326648134119416080989201012163771767787520485155594757300555185954280304839051723173371630921394024027714555984796981691309",
      "1957270404535432491577732407654814296272924990076105665080976425316855184394075979033347631859",
      "-1957270404535432491577732407654814296272924990076105665080976425316855184394075979033347631859",
      "403660520770889026052145363858883993968408567876919963129339377184354008618147803968877043087318952555532301757740363864562971760902711427500126603597011858241477379568684342423222828785569617251693287873736233651273385183220731182322820758659074766543835657767799241434709242669340338048971",
      "-403660520770889026052145363858883993968408567876919963129339377184354008618147803968877043087318952555532301757740363864562971760902711427500126603597011858241477379568684342423222828785569617251693287873736233651273385183220731182322820758659074766543835657767799241434709242669340338048971",
      "1360462270574406",
      "-1360462270574406",
      "41324796834060083364741632465744604155931640433410301186397363904266930128665463361513275697352082859944863112972305377171961651196393476069297383272360",
      "-41324796834060083364741632465744604155931640433410301186397363904266930128665463361513275697352082859944863112972305377171961651196393476069297383272360",
      "3704475702528052685702177087226789799951985298635254026584051739803799717979",
      "-3704475702528052685702177087226789799951985298635254026584051739803799717979",
      "15324664249401045013727127578266722880923015582445744082290396086739217665923549238159714472241913755511109729288179218537980252473553017573593867710189",
      "-15324664249401045013727127578266722880923015582445744082290396086739217665923549238159714472241913755511109729288179218537980252473553017573593867710189",
      "991713895885660445361195566630120268552033337199519129194545503121325658310309321599773356998546067469176345858459212673467904704287664190684736527585420239571896710231",
      "-991713895885660445361195566630120268552033337199519129194545503121325658310309321599773356998546067469176345858459212673467904704287664190684736527585420239571896710231",
      "496917928889709928816019707237559067993121139550552680620307451932907944813916325593269613319259002416192",
      "-496917928889709928816019707237559067993121139550552680620307451932907944813916325593269613319259002416192",
      "5420780319939699155212032775979062279900280911343420051629512809105059842240345509925762577052334971725879572674586223682520124367213762780782010484201065072155930114824432335178466411605479995327050114745584339793378334895820002004268553531081904844570983717097867410603089",
      "-5420780319939699155212032775979062279900280911343420051629512809105059842240345509925762577052334971725879572674586223682520124367213762780782010484201065072155930114824432335178466411605479995327050114745584339793378334895820002004268553531081904844570983717097867410603089",
      "34178515956045799076849256172156569827315750483663840127186371829050429609564171778221768139311136758783705861242122641003313096493057103420927909105632095530710317446888521007163646123762242884609239534269531565599291518871943322912836596141732912619557997670259415580841015283",
      "-34178515956045799076849256172156569827315750483663840127186371829050429609564171778221768139311136758783705861242122641003313096493057103420927909105632095530710317446888521007163646123762242884609239534269531565599291518871943322912836596141732912619557997670259415580841015283",
      "24753103731553244306801885710094553322976800783421479907592940309642834383335499833992007826858595009726122",
      "-24753103731553244306801885710094553322976800783421479907592940309642834383335499833992007826858595009726122",
      "1303658351822779358400767265190404914258468501671414115714852481575404440331055726991532424857235529818287464081864",
      "-1303658351822779358400767265190404914258468501671414115714852481575404440331055726991532424857235529818287464081864",
      "82442525420",
      "-82442525420",
      "40181847350075911374014072545070982",
      "-40181847350075911374014072545070982",
      "6331081104259962585725418329411543440752124680199",
      "-6331081104259962585725418329411543440752124680199",
      "669444625991257897062056995037426293652388602030282843269573026219936289974215349592874907406715089995765108583608936617284270069188005340481379259012388729065198804182112491651898040335690016003489264765600281922569438256615076042625367641",
      "-669444625991257897062056995037426293652388602030282843269573026219936289974215349592874907406715089995765108583608936617284270069188005340481379259012388729065198804182112491651898040335690016003489264765600281922569438256615076042625367641",
      "1168675103592556804163240443883135991575851814861660107303310966160744170850036726911375287483597293098658196142018318809369957616827451967868069658172182991177709289250815148540710360498467949152008438530805196222119517692659923705203865993818359838900924606163081858543",
      "-1168675103592556804163240443883135991575851814861660107303310966160744170850036726911375287483597293098658196142018318809369957616827451967868069658172182991177709289250815148540710360498467949152008438530805196222119517692659923705203865993818359838900924606163081858543",
      "2496566005249030514809106685776267657051598627391700353125416989638685021308242404184826752692976528990582207413089494945",
      "-2496566005249030514809106685776267657051598627391700353125416989638685021308242404184826752692976528990582207413089494945",
      "75831002519613645538052701409851076434071446092420445852577692671",
      "-75831002519613645538052701409851076434071446092420445852577692671",
      "1595257514333333836407007696922732712451830781457969960247677871324618039799",
      "-1595257514333333836407007696922732712451830781457969960247677871324618039799",
      "2352103706291595728734823852677068972089963637096939637892631185119057636184628093243",
      "-2352103706291595728734823852677068972089963637096939637892631185119057636184628093243",
      "55150603036064305927003551612930888862894407146543079948823875920053285006001048840253371944560550042245523051895932284432859",
      "-55150603036064305927003551612930888862894407146543079948823875920053285006001048840253371944560550042245523051895932284432859",
      "183652285344198865127020235735671716726282119574663849914811753120306798386549535194663979983946501785937569600701888628541389188176220321121981286091051",
      "-183652285344198865127020235735671716726282119574663849914811753120306798386549535194663979983946501785937569600701888628541389188176220321121981286091051",
      "1670967627370678916184944999086",
      "-1670967627370678916184944999086",
      "1779553803107116970428487453385844908445190212603430402358107740295247",
      "-1779553803107116970428487453385844908445190212603430402358107740295247",
      "163081585689520939847508610298505981110843",
      "-163081585689520939847508610298505981110843",
      "24608823059620600828775541561806855624217762717902459681958610060078155650689789569089307408156194776319918700684027035605476736967141308737778808097438",
      "-24608823059620600828775541561806855624217762717902459681958610060078155650689789569089307408156194776319918700684027035605476736967141308737778808097438",
      "176229540909991348680999108287461921475890812511086227972678364382149132437628380310728470828832129727355735848528049467023561657293359463509078809812981500824290722272220174525789664137788219060477887820838690954729061422727025173596051655147380497411055372159528861310774057097642760262454",
      "-176229540909991348680999108287461921475890812511086227972678364382149132437628380310728470828832129727355735848528049467023561657293359463509078809812981500824290722272220174525789664137788219060477887820838690954729061422727025173596051655147380497411055372159528861310774057097642760262454",
      "1521679829312851456536026361859335013780557838686738466687399128709926436847394871570976840503705308125705873792672378389916115357657382793749503126640771533338992032259981620506047817865492352874670892991966609760209061301594191537869902100817987599206558753487441796712670736855202929172147294",
      "-1521679829312851456536026361859335013780557838686738466687399128709926436847394871570976840503705308125705873792672378389916115357657382793749503126640771533338992032259981620506047817865492352874670892991966609760209061301594191537869902100817987599206558753487441796712670736855202929172147294",
      "4157696366999482544605875019162016856282588665242578471972156413342580075270416675018859586511300869507848273592737229363773252760313860357749814761595582127449880857952033970115380383676900743584438652262171904692777471245621134891056589732734422433379524779439127971588536170244050150621694478",
      "-4157696366999482544605875019162016856282588665242578471972156413342580075270416675018859586511300869507848273592737229363773252760313860357749814761595582127449880857952033970115380383676900743584438652262171904692777471245621134891056589732734422433379524779439127971588536170244050150621694478",
      "1080490672913509861800536351320773525291317691569674170377657976498332490333353859955175522548201462648648619481614475899104059632553936657464424434357970937863187647621979084401315431140833788114037982",
      "-1080490672913509861800536351320773525291317691569674170377657976498332490333353859955175522548201462648648619481614475899104059632553936657464424434357970937863187647621979084401315431140833788114037982",
      "3194906436319924706167835645658948826079202290534790460576542221669512825113141647211107781595153842508704176837984748167835595231049849647151228364465638129922085890581512323653",
      "-3194906436319924706167835645658948826079202290534790460576542221669512825113141647211107781595153842508704176837984748167835595231049849647151228364465638129922085890581512323653",
      "66347107100300795802324266184385521196001191250641925506321442631467978776436571080979857829987956896197464196707824641007632965810482791998323932299431716570622215408517414037865201951734572676314196738287234254247520531646927798844",
      "-66347107100300795802324266184385521196001191250641925506321442631467978776436571080979857829987956896197464196707824641007632965810482791998323932299431716570622215408517414037865201951734572676314196738287234254247520531646927798844",
      "11755070349326455201",
      "-11755070349326455201",
      "156651043578414506824194498430628709042640792209942834690006663445469241908219457011408374641207896652700963717365255757469753081082784",
      "-156651043578414506824194498430628709042640792209942834690006663445469241908219457011408374641207896652700963717365255757469753081082784",
      "6564614203586776498688508944538260136293893809517937442849470545503761844",
      "-6564614203586776498688508944538260136293893809517937442849470545503761844",
      "598962115054858410821731842471416988283668169539322479066058751789827287104304434155465947780173527582423899421590786844022599493768874809775192652719882115272582161354987",
      "-598962115054858410821731842471416988283668169539322479066058751789827287104304434155465947780173527582423899421590786844022599493768874809775192652719882115272582161354987",
      "14443508661606107679701498958114275550218690763128482677663411487796540412372251008043398613017374358807500824",
      "-14443508661606107679701498958114275550218690763128482677663411487796540412372251008043398613017374358807500824",
      "39256841936111992",
      "-39256841936111992",
      "22003604980409010500616552575366573651583935479333537954768716122155414073009794841075971673796002258058407019824164705801672155808939681382770846685292342660131406075122591374505200827365481659521834044185780365112968118493953141135082476859603163146563",
      "-22003604980409010500616552575366573651583935479333537954768716122155414073009794841075971673796002258058407019824164705801672155808939681382770846685292342660131406075122591374505200827365481659521834044185780365112968118493953141135082476859603163146563",
      "892612825794032675237656399315067134384177542558409873295423125742291209107349193521326932311978865",
      "-892612825794032675237656399315067134384177542558409873295423125742291209107349193521326932311978865",
      "124621",
      "-124621",
      "39935862547719441432334200243323687785328282085889753818085154826607463592957499184719152632875679930608636031007549318604365",
      "-39935862547719441432334200243323687785328282085889753818085154826607463592957499184719152632875679930608636031007549318604365",
      "53150384435463",
      "-53150384435463",
      "5038617365140462881167623487900113792134127235018266576334866703847563260548724132738580936393867769669999269123356358833922994762144381270134211004782972194957315491988474542647182488355728455727224128393875804308265676177706683756178477181259888932449640561270717525443984031839",
      "-5038617365140462881167623487900113792134127235018266576334866703847563260548724132738580936393867769669999269123356358833922994762144381270134211004782972194957315491988474542647182488355728455727224128393875804308265676177706683756178477181259888932449640561270717525443984031839",
      "18681375094308610932506726878974665535026964461038388",
      "-18681375094308610932506726878974665535026964461038388",
      "1694490961016050821118863403337160606621945374045986683635096733891067660467665114977365173029439236924493435715113229950328428294138767438612886428848619529462540214870987656585503501640006260787493433146977269874730836153316545758154447988098965049",
      "-1694490961016050821118863403337160606621945374045986683635096733891067660467665114977365173029439236924493435715113229950328428294138767438612886428848619529462540214870987656585503501640006260787493433146977269874730836153316545758154447988098965049",
      "34981000632270288897102343437813403379909519445061202916917950066646896121823399718762441640573618996405513221104482936830650441434933771175014497076492252938974657476531072878259814088155492254761929",
      "-34981000632270288897102343437813403379909519445061202916917950066646896121823399718762441640573618996405513221104482936830650441434933771175014497076492252938974657476531072878259814088155492254761929",
      "68186095594637277569008966718516358384203015123161693897355580993692840848969688",
      "-68186095594637277569008966718516358384203015123161693897355580993692840848969688",
      "1134126702908819566229008255313053760389444389322516415435539141233919754193425951992416106929842896080872524876962976885893778825250951315557865558643443244064361902243653517585491772912650759627537475187929799073482588432081",
      "-1134126702908819566229008255313053760389444389322516415435539141233919754193425951992416106929842896080872524876962976885893778825250951315557865558643443244064361902243653517585491772912650759627537475187929799073482588432081",
      "1219660173804105678519644769228717229961",
      "-1219660173804105678519644769228717229961",
      "9337788234986472797155798668633720432652335098955723216110827539222560791046580758896359512684081023719629520191135356937552064341414985563338865755044029781700472823138498290646709782655770432472849",
      "-9337788234986472797155798668633720432652335098955723216110827539222560791046580758896359512684081023719629520191135356937552064341414985563338865755044029781700472823138498290646709782655770432472849",
      "150424008592708034173259810113475930440810989335879628469427925370034758050373228994166602606657381400670968588175849346743433462784970176019171026242734",
      "-150424008592708034173259810113475930440810989335879628469427925370034758050373228994166602606657381400670968588175849346743433462784970176019171026242734",
      "10709102135708711290774115917568703434210917471089837954174155027939142290457621570052339242896415391737492196297186964273273691467020576606",
      "-10709102135708711290774115917568703434210917471089837954174155027939142290457621570052339242896415391737492196297186964273273691467020576606",
      "590791035282122817187786741012881114662078084344037620155645055415644697693432897703240908766855757699902350106663298",
      "-590791035282122817187786741012881114662078084344037620155645055415644697693432897703240908766855757699902350106663298",
      "6644806769073273664533505828539666955754832084759883392732355768142191452695685189350231701935219212931529500767858294148963537439795792593286239876735316935797953104882",
      "-6644806769073273664533505828539666955754832084759883392732355768142191452695685189350231701935219212931529500767858294148963537439795792593286239876735316935797953104882",
      "176511387805688073718855394072841750443509085589889404547084544683339270522709736525152936011885659232618530216217042113370236595468110548243408426032715706575057369503893468170961068580632412998988853143083945510800966719",
      "-176511387805688073718855394072841750443509085589889404547084544683339270522709736525152936011885659232618530216217042113370236595468110548243408426032715706575057369503893468170961068580632412998988853143083945510800966719",
      "18197814169943971748763655537459580789924675680558018542859068281859940671016292870607058355",
      "-18197814169943971748763655537459580789924675680558018542859068281859940671016292870607058355",
      "53665744969332986906645019910160121106654070883148709396576439910412784742262054480460348",
      "-53665744969332986906645019910160121106654070883148709396576439910412784742262054480460348",
      "15114701057818447666738431676226302502804615316350076959331191793491140183426763779197478527183420304400143976231566802442732838190730866504640269901006105030291550705062305121857555495397899088813125248050183715824996357342602508",
      "-15114701057818447666738431676226302502804615316350076959331191793491140183426763779197478527183420304400143976231566802442732838190730866504640269901006105030291550705062305121857555495397899088813125248050183715824996357342602508",
      "4538684087847049584760102928758931951663047136365690317969652570682351595540576228149035948547456528545997589204036236408244581413584178489307193893093917026883317801237483886776457347545442242",
      "-4538684087847049584760102928758931951663047136365690317969652570682351595540576228149035948547456528545997589204036236408244581413584178489307193893093917026883317801237483886776457347545442242",
      "68104327977018907402564677909296985240865850899633815987571",
      "-68104327977018907402564677909296985240865850899633815987571",
      "21126389218307474702937983111939394337442364463717300558898463056361786715220551813192286109604739592089468027639535160949266165405455186969313451687709111127347596851523580180558147019220445717949314588542773729044755127625855190216933115799293871340",
      "-21126389218307474702937983111939394337442364463717300558898463056361786715220551813192286109604739592089468027639535160949266165405455186969313451687709111127347596851523580180558147019220445717949314588542773729044755127625855190216933115799293871340",
      "78222020599461507025837080263377239508386033815939450849751163859949403589369059725826445373571398499131861482443466775202688633343807807754044978711136865112845737811903231211872791854642958065042325855161499335",
      "-78222020599461507025837080263377239508386033815939450849751163859949403589369059725826445373571398499131861482443466775202688633343807807754044978711136865112845737811903231211872791854642958065042325855161499335",
      "4085759411276713693098232266986821269735231020974977020052575836176404619187789208196423060444205",
      "-4085759411276713693098232266986821269735231020974977020052575836176404619187789208196423060444205",
      "1184210350766462097978915832676647869625660103053116596342",
      "-1184210350766462097978915832676647869625660103053116596342",
      "194539222104802835983292205414714434524058762756885327380706701321718655745439492716048166059927935241719149428879885478",
      "-194539222104802835983292205414714434524058762756885327380706701321718655745439492716048166059927935241719149428879885478",
      "302225946492334746161844140625842416406247812604200025274581247745184222647724964120371508273766497009905662425211",
      "-302225946492334746161844140625842416406247812604200025274581247745184222647724964120371508273766497009905662425211",
      "28866482602752218187265274692665814018194886187165103251546083935605515506785082873738653268219928502362268",
      "-28866482602752218187265274692665814018194886187165103251546083935605515506785082873738653268219928502362268",
      "5544952079050015240077157700940320243659550435014574041421348665396935579816611507888574593385073797911479160663545693602347256422370826097076074812916781822541849687962368590784552937977886205",
      "-5544952079050015240077157700940320243659550435014574041421348665396935579816611507888574593385073797911479160663545693602347256422370826097076074812916781822541849687962368590784552937977886205",
      "323710452268087591982845307319501376132372316351918100708894690678941776259635618528227710164786257540427054071430282571860354523279847215012107332817795823639212909924515178824923234673149086462596636590350327539723310798213754665082582892561015344012",
      "-323710452268087591982845307319501376132372316351918100708894690678941776259635618528227710164786257540427054071430282571860354523279847215012107332817795823639212909924515178824923234673149086462596636590350327539723310798213754665082582892561015344012",
      "6298178214804809482382903740893261997309254126083786539013344521457218202089579665480198608566443109151164759409311083172285986019510870966646266562147239668466233708302275847273212515270194723859620577435475775917236877537636439092304144350",
      "-6298178214804809482382903740893261997309254126083786539013344521457218202089579665480198608566443109151164759409311083172285986019510870966646266562147239668466233708302275847273212515270194723859620577435475775917236877537636439092304144350",
      "577024710470352032965427500450059067959437337861971906117178872729996600387523062943239129117535935908310731558466601208272240830153365070900204066680943610473920336450708951789975218349225167580113063050191",
      "-577024710470352032965427500450059067959437337861971906117178872729996600387523062943239129117535935908310731558466601208272240830153365070900204066680943610473920336450708951789975218349225167580113063050191",
      "37972747755906620986262153",
      "-37972747755906620986262153",
      "183829698115229455555876942979003514516640128880295179243921716692283845612914437405435307612733660894727800824835948",
      "-183829698115229455555876942979003514516640128880295179243921716692283845612914437405435307612733660894727800824835948",
      "2423832959667360118257064702737609023425800632192836723430775336591100757144072935869557583342500327350488117394557246526227000890820814931134670064874494870718496008517213657614840456624436847012780602721278103167235601948187645617975091973272873241569047573971620372584048698612150640",
      "-2423832959667360118257064702737609023425800632192836723430775336591100757144072935869557583342500327350488117394557246526227000890820814931134670064874494870718496008517213657614840456624436847012780602721278103167235601948187645617975091973272873241569047573971620372584048698612150640",
      "3689827013849535585619411952203826247332426367647260820678883970327796902123440577075450728217270007491470250603087878349241859733492652613679",
      "-3689827013849535585619411952203826247332426367647260820678883970327796902123440577075450728217270007491470250603087878349241859733492652613679",
      "38998054937697595881540875647042048333681659113425435564641134367164935592905762620334835531916327661633470289669510511757807865630506235328273222918421117111281556873070254844441312814372799410820410797988722601761642743512387994633124078",
      "-38998054937697595881540875647042048333681659113425435564641134367164935592905762620334835531916327661633470289669510511757807865630506235328273222918421117111281556873070254844441312814372799410820410797988722601761642743512387994633124078",
      "1742133972499057105001733325633478018605566678002165515479191311988758932166961086848659714709",
      "-1742133972499057105001733325633478018605566678002165515479191311988758932166961086848659714709",
      "2553559760939673132290078919768155422943752579897989356503182382672252331377594911957598202962666902881961594758670198463065653145968650999812730247666",
      "-2553559760939673132290078919768155422943752579897989356503182382672252331377594911957598202962666902881961594758670198463065653145968650999812730247666",
      "51684745772714675394936241781816223514919452679364520537119434050698905337439734233644472369565180889405426257288782419010082579894095799847229362421193687113981266355014802762308095739808334529392234853485537967988890313769779739241401223407407962126345943032536670110549434751102",
      "-51684745772714675394936241781816223514919452679364520537119434050698905337439734233644472369565180889405426257288782419010082579894095799847229362421193687113981266355014802762308095739808334529392234853485537967988890313769779739241401223407407962126345943032536670110549434751102",
      "672712112462360351910518120594120040601436948606148058222300198559244738922266341042360305651450642724475561271288385956130680220169715",
      "-672712112462360351910518120594120040601436948606148058222300198559244738922266341042360305651450642724475561271288385956130680220169715",
      "813447070819324251037079581265526580292907576372477729204338404955584410222478934593619630935314222063003252993694281837026881675600656782635846343833",
      "-813447070819324251037079581265526580292907576372477729204338404955584410222478934593619630935314222063003252993694281837026881675600656782635846343833",
      "1117610225194419065337568894513493776564803226432743080986022521406296090276409739149656072953983798754546991402130235309864912523411568994",
      "-1117610225194419065337568894513493776564803226432743080986022521406296090276409739149656072953983798754546991402130235309864912523411568994",
      "54306983641232120685850754812687679873466315381427348676538013927626387380179070467333206768501131364932160162454016646002006230714059820560113529334910854401021111543333022008153795820172235468858146103351502311717114025204496145038",
      "-54306983641232120685850754812687679873466315381427348676538013927626387380179070467333206768501131364932160162454016646002006230714059820560113529334910854401021111543333022008153795820172235468858146103351502311717114025204496145038",
      "113450443712297816016750119935548807386514765087946158026225637996838314569438356054721778395168",
      "-113450443712297816016750119935548807386514765087946158026225637996838314569438356054721778395168",
      "7352437924947754601546368441398130",
      "-7352437924947754601546368441398130",
      "9846278286558101102640461230277730613939270868227307780570935600269093778822376992893008780014141741647103776048800092788896154696011762350215865588521108549",
      "-9846278286558101102640461230277730613939270868227307780570935600269093778822376992893008780014141741647103776048800092788896154696011762350215865588521108549",
      "73473583275712621559167315389071668112406649781987949641633299346855217310106910560443921944813054763213555679810164708505",
      "-73473583275712621559167315389071668112406649781987949641633299346855217310106910560443921944813054763213555679810164708505",
      "44337393529749818041445106472308772039346354808448275796454672077580119659002042203928900642842510640740800196651911559238276834896411685658708100385336014325",
      "-44337393529749818041445106472308772039346354808448275796454672077580119659002042203928900642842510640740800196651911559238276834896411685658708100385336014325",
      "3029057656526271554842230678161240050706458471766453329711413581607557927250588221517218424325311508555983065479955684772259815134067055583713776773155106422220131994155338255582516687249210697344355756374535219768311432253647445765860280496088041768667890441415297183",
      "-3029057656526271554842230678161240050706458471766453329711413581607557927250588221517218424325311508555983065479955684772259815134067055583713776773155106422220131994155338255582516687249210697344355756374535219768311432253647445765860280496088041768667890441415297183",
      "730896103566527607730753327836819245922931354292181064204035921357800084090450560460429017252539616543803713640582458341962589048267291080308369681271304618861351862971290465709198912575367354463123427808437784040240907793877567792057788579265909741136",
      "-730896103566527607730753327836819245922931354292181064204035921357800084090450560460429017252539616543803713640582458341962589048267291080308369681271304618861351862971290465709198912575367354463123427808437784040240907793877567792057788579265909741136",
      "875972480821342956908137350797672986141068914679963791517259506036957992167704898826150763674879737404204136150",
      "-875972480821342956908137350797672986141068914679963791517259506036957992167704898826150763674879737404204136150",
      "80978095866121182143792129768500985270760294511412625411940522384234727394805988434574920055266468176140927390504528795674710202014688877516082928870193399763361133821060656660414289111945500870045554749239179606901392281466574470956468260058934",
      "-80978095866121182143792129768500985270760294511412625411940522384234727394805988434574920055266468176140927390504528795674710202014688877516082928870193399763361133821060656660414289111945500870045554749239179606901392281466574470956468260058934",
      "5108366192611283244622529332098588886037670912044545212175942213533408183226647011059305581499429284848730575416013640342256910485443191764062474694987448384264155646101960915742145430768592056025304400156363995432483639209748602875976799644331086294285921358845745557709942066403846",
      "-5108366192611283244622529332098588886037670912044545212175942213533408183226647011059305581499429284848730575416013640342256910485443191764062474694987448384264155646101960915742145430768592056025304400156363995432483639209748602875976799644331086294285921358845745557709942066403846",
      "6930180124964356147220207591422279016208371685360099598238746492283122379172191493127595009844321810224523734815981086376030176488602168657385920504832784693281301596520980175713179280297526196841775",
      "-6930180124964356147220207591422279016208371685360099598238746492283122379172191493127595009844321810224523734815981086376030176488602168657385920504832784693281301596520980175713179280297526196841775",
      "127195984139760103169058839514903174746000769823723851981181127452175305070890259297605399965306923149188386831728624922603033165495625460062407066507409867399121450024",
      "-127195984139760103169058839514903174746000769823723851981181127452175305070890259297605399965306923149188386831728624922603033165495625460062407066507409867399121450024",
      "766856719860424381068595879781443086540018712198126893034614346925577170838696737465130140374926102571846639744916246",
      "-766856719860424381068595879781443086540018712198126893034614346925577170838696737465130140374926102571846639744916246",
      "24452524790653436824651691432192056396622748",
      "-24452524790653436824651691432192056396622748",
      "21600696784921267417096322615448095147085787610512586576154030214298480866233496998058741115961394009177458631301020467184235259516317585587331608708009650567889604390408691257559911506849475326601795863368339333809604283115447728657967640020590611529",
      "-21600696784921267417096322615448095147085787610512586576154030214298480866233496998058741115961394009177458631301020467184235259516317585587331608708009650567889604390408691257559911506849475326601795863368339333809604283115447728657967640020590611529",
      "3758893374497950117544956548495424355416942972081749559738750",
      "-3758893374497950117544956548495424355416942972081749559738750",
      "139402452879531227967305026093373374931960661729048047992046850704933112027363474989587334281949398194424695097699435389253833391313981068405251271500306551642365788",
      "-139402452879531227967305026093373374931960661729048047992046850704933112027363474989587334281949398194424695097699435389253833391313981068405251271500306551642365788",
      "25612506870374484873779089622294846964717659760278221279975070009760319283018786412097109135597197982352674303356191527475964885419517878154272980015867348900662204209918494643594136945278141027429152743583659050244679551461363259179124592558207169009059175419818764353589040423929215554316106",
      "-25612506870374484873779089622294846964717659760278221279975070009760319283018786412097109135597197982352674303356191527475964885419517878154272980015867348900662204209918494643594136945278141027429152743583659050244679551461363259179124592558207169009059175419818764353589040423929215554316106",
      "2947281537862409310348470927599528845929360328199550369835553099926787046871370053629653311891644595607839493",
      "-2947281537862409310348470927599528845929360328199550369835553099926787046871370053629653311891644595607839493",
      "5238370098473928109261593022401423141534005322972191017431019829640519389374820628584873426299810704519554264840639788753962805520465217577654353515132848032321812308255870691241084866912560646162061587045231920247690379479011365117594385434098375615768143923448693726900625714250700557084631365841487720",
      "-5238370098473928109261593022401423141534005322972191017431019829640519389374820628584873426299810704519554264840639788753962805520465217577654353515132848032321812308255870691241084866912560646162061587045231920247690379479011365117594385434098375615768143923448693726900625714250700557084631365841487720",
      "12442661493742591574470274906943075194519541250480406451734421223577085372382129292566795701869646895013888531785728273885219518563236237522720693500170071741905622101669444727271767185013757679737024246566421692125582577245793910930758790508707497799356723763185459314157218014300646936606",
      "-12442661493742591574470274906943075194519541250480406451734421223577085372382129292566795701869646895013888531785728273885219518563236237522720693500170071741905622101669444727271767185013757679737024246566421692125582577245793910930758790508707497799356723763185459314157218014300646936606",
      "196768397706108832434401218046908395079672619951322343962935515221968814879",
      "-196768397706108832434401218046908395079672619951322343962935515221968814879",
      "105448359738523054755775683879539460376932545724741416465977687344195271654833613392218097960778272870252224864512166575087075095234145517359783987574090392012176562600550144885565709822164722304408771214923078090216303447672907406306494260347265557611811281654313383497",
      "-105448359738523054755775683879539460376932545724741416465977687344195271654833613392218097960778272870252224864512166575087075095234145517359783987574090392012176562600550144885565709822164722304408771214923078090216303447672907406306494260347265557611811281654313383497",
      "427047",
      "-427047",
      "81856543863229949865307411717645038275510945758537814749232160844289351485471852172626662270166132792505150910334705532703104971400349296170150117058939300885252778996956",
      "-81856543863229949865307411717645038275510945758537814749232160844289351485471852172626662270166132792505150910334705532703104971400349296170150117058939300885252778996956",
      "1157793815124456718861516590400363995161915570086903147642852686851669744820819994596924330213342515606147016987948857909",
      "-1157793815124456718861516590400363995161915570086903147642852686851669744820819994596924330213342515606147016987948857909",
      "940896637988538567397975357071445094467989790092928263312671948706628805236843480432542018263224679720038185333011214261501267693681777878339707753984890375587248023646920869739576148750778030",
      "-940896637988538567397975357071445094467989790092928263312671948706628805236843480432542018263224679720038185333011214261501267693681777878339707753984890375587248023646920869739576148750778030",
      "1277092697774915455425325818506548913089778045288703511320462361515661192684081707471069783269077123507880082821996357021946680618631451261991566032521034200533398597806696743013088727321199529921154950435385831032453193119895011784079743410",
      "-1277092697774915455425325818506548913089778045288703511320462361515661192684081707471069783269077123507880082821996357021946680618631451261991566032521034200533398597806696743013088727321199529921154950435385831032453193119895011784079743410",
      "12484594365439504824667126116411560379532608011162188261784732952579595718551939216912931261112627180909253846258363935011877417495984302385508560070358584377699655038250487243650598",
      "-12484594365439504824667126116411560379532608011162188261784732952579595718551939216912931261112627180909253846258363935011877417495984302385508560070358584377699655038250487243650598",
      "1741383885783666349682975645698617932237500743715841391107227784204719855585223522172382200426887024717924383874873388819696857115564677905327552504",
      "-1741383885783666349682975645698617932237500743715841391107227784204719855585223522172382200426887024717924383874873388819696857115564677905327552504",
      "9368096919796958094889245340222417626105947858557433047800723019",
      "-9368096919796958094889245340222417626105947858557433047800723019",
      "76669478098694609561491577319843969528266563067895013521486786451595735010640930020326448743208375914951894083260394091483935932234283855098968632145970697415601093343",
      "-76669478098694609561491577319843969528266563067895013521486786451595735010640930020326448743208375914951894083260394091483935932234283855098968632145970697415601093343",
      "1876639712516985144893922794716264029310990922149953750634405350881578456885688177463809312620",
      "-1876639712516985144893922794716264029310990922149953750634405350881578456885688177463809312620",
      "186077",
      "-186077",
      "24038469015057796648084289920894727399732658423825146209930020877671076098132117966877846149087015358546337692428012385515366055633105998821389203",
      "-24038469015057796648084289920894727399732658423825146209930020877671076098132117966877846149087015358546337692428012385515366055633105998821389203",
      "20641259550745643346234485579665129143463532482322387615585139677830682894079763990366000612134891527828252798370386444670430513385825695220928137556290078834398139256712344468615779923734232143070994661634892049806652900001420233970754048793898042171067992448201191787158435561",
      "-20641259550745643346234485579665129143463532482322387615585139677830682894079763990366000612134891527828252798370386444670430513385825695220928137556290078834398139256712344468615779923734232143070994661634892049806652900001420233970754048793898042171067992448201191787158435561",
      "90558282393161622936261650596857143828421884875124973816361813844395166",
      "-90558282393161622936261650596857143828421884875124973816361813844395166",
      "893374152282726891992085958120127485743572202276100990922171",
      "-893374152282726891992085958120127485743572202276100990922171",
      "104601387324033669002784175389856736439866138446091862232274237956270168921868535320405566731385430625654533746364405250312870593863224985439702639684142355791792905233795969344981850689932028254291726954427057743196839190399880526778270712454970430735459654847",
      "-104601387324033669002784175389856736439866138446091862232274237956270168921868535320405566731385430625654533746364405250312870593863224985439702639684142355791792905233795969344981850689932028254291726954427057743196839190399880526778270712454970430735459654847",
      "1100640547822452822259608780637373041065326977053681954192776181527618577050122442455730624660403304296015412329954372289398853654524721225006003581004995451247487399511260858844108588935136691954558538445962684147337611140312567681054887671734241832035049841922672004195071",
      "-1100640547822452822259608780637373041065326977053681954192776181527618577050122442455730624660403304296015412329954372289398853654524721225006003581004995451247487399511260858844108588935136691954558538445962684147337611140312567681054887671734241832035049841922672004195071",
      "2967167885422023119778255262377939967247041745814218496240360",
      "-2967167885422023119778255262377939967247041745814218496240360",
      "2766027933722171046554231292404911532459570636916540872038932307272865118512724883948205112046666709093487559219830075352753072061667201",
      "-2766027933722171046554231292404911532459570636916540872038932307272865118512724883948205112046666709093487559219830075352753072061667201",
      "1003655344057107767912014692725976261732681876044961311820943946784371",
      "-1003655344057107767912014692725976261732681876044961311820943946784371",
      "21900502732037517315370094764239443613058564433",
      "-21900502732037517315370094764239443613058564433",
      "45583003657081227658306304711498324162428223935090104",
      "-45583003657081227658306304711498324162428223935090104",
      "204245432840569041148483982796093177932369679988233999329901019356075995960",
      "-204245432840569041148483982796093177932369679988233999329901019356075995960",
      "54884247902140437035368361407902527545416356458607442580170745253262030",
      "-54884247902140437035368361407902527545416356458607442580170745253262030",
      "5334518155628744158007803052398794311169463840470474113725097881874982744596886959948255678621385420985539108742608260405936297075345765000664456806209794363451383928857878909914356480954702762980348813177584480927161733854397043441077512115118243",
      "-5334518155628744158007803052398794311169463840470474113725097881874982744596886959948255678621385420985539108742608260405936297075345765000664456806209794363451383928857878909914356480954702762980348813177584480927161733854397043441077512115118243",
      "586483295964769639990961973863221490702912450472376751506581704396550840803536849728609056194074161983174132325139036388003751640146943",
      "-586483295964769639990961973863221490702912450472376751506581704396550840803536849728609056194074161983174132325139036388003751640146943",
      "5160489070412055213478248749143153314027313193274772183541029614946527505345515388990899156035333461408310459047357741425430914259324755065994103",
      "-5160489070412055213478248749143153314027313193274772183541029614946527505345515388990899156035333461408310459047357741425430914259324755065994103",
      "2027629455583867858236950998133711110883394281732352207813586603417947074456218393483520509566027",
      "-2027629455583867858236950998133711110883394281732352207813586603417947074456218393483520509566027",
      "5188557124098846103707325218",
      "-5188557124098846103707325218",
      "400020709349724273938863924454731823809936035083490166372176005731818513778095755824243823423942457408986667759613017098976884623086030827980554523509430858361367786615095252152639811158705182507617454882805400018345969632806081496172562211701111188286396198492796040003060705842273291",
      "-400020709349724273938863924454731823809936035083490166372176005731818513778095755824243823423942457408986667759613017098976884623086030827980554523509430858361367786615095252152639811158705182507617454882805400018345969632806081496172562211701111188286396198492796040003060705842273291",
      "5077741618469045793277646564358992920960476333244601450034145830501181786188670069707891777075377020328052369395749044352605314330803964782636667529924732654192256597972743806214879074858492363595605",
      "-5077741618469045793277646564358992920960476333244601450034145830501181786188670069707891777075377020328052369395749044352605314330803964782636667529924732654192256597972743806214879074858492363595605",
      "7696189909584112429236607890412659528293987626026266720440261172438548134466224807156242301070086176781584925647653568383958946454001",
      "-7696189909584112429236607890412659528293987626026266720440261172438548134466224807156242301070086176781584925647653568383958946454001",
      "417308020029030078568441933098093721107857721939799845259428192907357371830765301672126412079562811182564973992528737210195074535804805307396531464692210817793443042424312992541689337630019211372",
      "-417308020029030078568441933098093721107857721939799845259428192907357371830765301672126412079562811182564973992528737210195074535804805307396531464692210817793443042424312992541689337630019211372",
      "1322555438304138854190608504305314090997872332525802468309",
      "-1322555438304138854190608504305314090997872332525802468309",
      "2243252463390097730206022598597097545362441865345445435367208364900608574068701725911900977005694987837525981666534993121316833074810732688679185645071871012387337549509711648733018",
      "-2243252463390097730206022598597097545362441865345445435367208364900608574068701725911900977005694987837525981666534993121316833074810732688679185645071871012387337549509711648733018",
      "996999631246356886686476319402220462702895536107891846414650166937411337235327374798687258137003461594493394303654723633588050290355700009203863700819430055925538137094125943576776423062708423296431824562515335853105906638174471031706521164070138118239692600817313403027773040755",
      "-996999631246356886686476319402220462702895536107891846414650166937411337235327374798687258137003461594493394303654723633588050290355700009203863700819430055925538137094125943576776423062708423296431824562515335853105906638174471031706521164070138118239692600817313403027773040755",
      "7407232727584141857860413969133193973271286288996885370643743601041844697247425570485073230177615935516189249509933008589795827697527731537095440446937896691012576063103682886965547257404970422133160836803032660735755375228",
      "-7407232727584141857860413969133193973271286288996885370643743601041844697247425570485073230177615935516189249509933008589795827697527731537095440446937896691012576063103682886965547257404970422133160836803032660735755375228",
      "66507856432274251794176455954413617080912111625650403908424515766595169565610373272262880697471290673940957493067336542878127434500093321175322023848113318710961186458831481208336221616883931621941707175292010516439902743884847403671155360181449053131615233540637713255704186616742945621336873834200241",
      "-66507856432274251794176455954413617080912111625650403908424515766595169565610373272262880697471290673940957493067336542878127434500093321175322023848113318710961186458831481208336221616883931621941707175292010516439902743884847403671155360181449053131615233540637713255704186616742945621336873834200241",
      "31961863828553380988033812855214593359459211110640445946699728653449149746905536006308298520671497324063634041",
      "-31961863828553380988033812855214593359459211110640445946699728653449149746905536006308298520671497324063634041",
      "119618377523937755424839832529346904290447125277702998330825686745624714380165535983701718800753406524499580430492483313401840673306022",
      "-119618377523937755424839832529346904290447125277702998330825686745624714380165535983701718800753406524499580430492483313401840673306022",
      "405681915481957710524110670648088015005969944212725894176433228902381563426021784100141533714164168640878972504794623170560976727288628780986689105062652396339731589340681696758070055865849332874664598654305386",
      "-405681915481957710524110670648088015005969944212725894176433228902381563426021784100141533714164168640878972504794623170560976727288628780986689105062652396339731589340681696758070055865849332874664598654305386",
      "80071205989351736846133464673563483",
      "-80071205989351736846133464673563483",
      "9700773864531435625616214899914065324460851600463291968860331922457988802290698665249481817160070262860115617949877440060186269123630022169856579023685715276196199558700467573542360702057439871151548632003937134635666",
      "-9700773864531435625616214899914065324460851600463291968860331922457988802290698665249481817160070262860115617949877440060186269123630022169856579023685715276196199558700467573542360702057439871151548632003937134635666",
      "64944106993602113652248278796057650905995695388886180354923002182559697540323513",
      "-64944106993602113652248278796057650905995695388886180354923002182559697540323513",
      "37929576313535611121803978435959309812321783154717",
      "-37929576313535611121803978435959309812321783154717",
      "1201000338412478811264460901269015663629403940922465995711563366282532392888117164309460791962587700786925689531323402454933712",
      "-1201000338412478811264460901269015663629403940922465995711563366282532392888117164309460791962587700786925689531323402454933712",
      "470447114867440006531646544662395180489380",
      "-470447114867440006531646544662395180489380",
      "1886414975033222890759454788368278722523410826550821944244006726465034055937087351501071112805393425149681091697659539390880213755450593178650888546158680682861726300055346238147353584",
      "-1886414975033222890759454788368278722523410826550821944244006726465034055937087351501071112805393425149681091697659539390880213755450593178650888546158680682861726300055346238147353584",
      "4664892726074011412424061191534682518434402852534244066439859284421669515547644494221267860310050082413903960265959420616932209365599069348",
      "-4664892726074011412424061191534682518434402852534244066439859284421669515547644494221267860310050082413903960265959420616932209365599069348",
      "28780798756024002725983431800204693077146606485161761312577563898465001036018344",
      "-28780798756024002725983431800204693077146606485161761312577563898465001036018344",
      "32330329650876",
      "-32330329650876",
      "2119979291121167235646126537631495326938621591198105160016067466298282031395514388037592761773940160529230271536093864046314956321286102399202685013097514391108059946817681956440747156573",
      "-2119979291121167235646126537631495326938621591198105160016067466298282031395514388037592761773940160529230271536093864046314956321286102399202685013097514391108059946817681956440747156573",
      "263699852555513851494126759556555000194041870735492675256368970869569739794241286439438865360257448383332427174288750874993061959293095843277366404592822430413842608440069138162513296663098194916628650623285377787520407274835441660863529425698257",
      "-263699852555513851494126759556555000194041870735492675256368970869569739794241286439438865360257448383332427174288750874993061959293095843277366404592822430413842608440069138162513296663098194916628650623285377787520407274835441660863529425698257",
      "1128694221447083514833565943172494061961392351570236661606778701297263608082693757967704225149730415407045688293665284383612835316877341572601586213504558102647155013466806252198360829785603030320627697854353131933390896",
      "-1128694221447083514833565943172494061961392351570236661606778701297263608082693757967704225149730415407045688293665284383612835316877341572601586213504558102647155013466806252198360829785603030320627697854353131933390896",
      "6916983731776108089130775823204431120044571113273264",
      "-6916983731776108089130775823204431120044571113273264",
      "75914457793044064895413508037682032379902701971013411488690441608545",
      "-75914457793044064895413508037682032379902701971013411488690441608545",
      "8879499247714081140479921556021160510154213025912153490299817518668111141293995912780879974244590421191162074944570118497100570991099380592606670090324723096261264086252974733149488230484359814997329229447712203652808121303397231512080257394400660537777330",
      "-8879499247714081140479921556021160510154213025912153490299817518668111141293995912780879974244590421191162074944570118497100570991099380592606670090324723096261264086252974733149488230484359814997329229447712203652808121303397231512080257394400660537777330",
      "1724506383335075569722951957439066815",
      "-1724506383335075569722951957439066815",
      "1194371342067583821224146035467746385145120448082902327311395191487125759843115454058224224089457130",
      "-1194371342067583821224146035467746385145120448082902327311395191487125759843115454058224224089457130",
      "116571209611185337284731713897921002952811284109399364843701582086430272601727355870457693093",
      "-116571209611185337284731713897921002952811284109399364843701582086430272601727355870457693093",
      "26168929789567416417896877953711683735315284288420053745760833960409035809279614614583672230970848586995471196762264833662013726559369765619103011658619869727814614782931489481458661981043479676591818357",
      "-26168929789567416417896877953711683735315284288420053745760833960409035809279614614583672230970848586995471196762264833662013726559369765619103011658619869727814614782931489481458661981043479676591818357",
      "243012047985288247713378637185988647187985010392388570351653505841125573018162558460717652828862937",
      "-243012047985288247713378637185988647187985010392388570351653505841125573018162558460717652828862937",
      "10664054546419657059895154308389295209775305216580625182685797954089483388356503442301133821162999463846286618424679215827037042324",
      "-10664054546419657059895154308389295209775305216580625182685797954089483388356503442301133821162999463846286618424679215827037042324",
      "93382430984727342024648229617198660330774557968214720265565362040755873830899272200516094884487181897372100083086702655979998495443",
      "-93382430984727342024648229617198660330774557968214720265565362040755873830899272200516094884487181897372100083086702655979998495443",
      "13126062810625043063456380164790384012915764511630796458248365510538114092330596186281347044586364215270683612292866613952971844005196715563009674494624957852022027173471052976928718844001264455268592601375542242160924315548654836823549859553",
      "-13126062810625043063456380164790384012915764511630796458248365510538114092330596186281347044586364215270683612292866613952971844005196715563009674494624957852022027173471052976928718844001264455268592601375542242160924315548654836823549859553",
      "9368582362765814557187196024001227849888168077472266659772600971697428366492708926906258905590833059706396684592884687526358204703256054330603971127944678906",
      "-9368582362765814557187196024001227849888168077472266659772600971697428366492708926906258905590833059706396684592884687526358204703256054330603971127944678906",
      "278701771665221100457912961846034172",
      "-278701771665221100457912961846034172",
      "382464310254920012603200760",
      "-382464310254920012603200760",
      "1086701652931645659413181704075891369501487115000150234704055924790606399915277424771761502385407750848874457084738431566772206432850777390818546802908541311070886519070558468667864533850452989704316665227997074954119733405730362633188789872620053510199052652185571293239445061650299573526583634686290646340",
      "-1086701652931645659413181704075891369501487115000150234704055924790606399915277424771761502385407750848874457084738431566772206432850777390818546802908541311070886519070558468667864533850452989704316665227997074954119733405730362633188789872620053510199052652185571293239445061650299573526583634686290646340",
      "1436027919103852779047018224513001412434295916624702899496423156978055321701822379",
      "-1436027919103852779047018224513001412434295916624702899496423156978055321701822379",
      "358956740433261819154697401028765647885314537021358004573",
      "-358956740433261819154697401028765647885314537021358004573",
      "2570919810686260443090976956907911580117431201667893432876299852175711324820817103455438469322058313607578962386364736310503021461418759938196980029731001153192509640082331671491566785848363799371983266719541295357316341488191889371987260280114237",
      "-2570919810686260443090976956907911580117431201667893432876299852175711324820817103455438469322058313607578962386364736310503021461418759938196980029731001153192509640082331671491566785848363799371983266719541295357316341488191889371987260280114237",
      "25162923422743354542149586612896418135445747897968173426132346622460254031452425686287824478617146278670264713886155228992283141903843330748647605337845897726364270262270221388553425764365596646869122752625837519793121116201637138123589",
      "-25162923422743354542149586612896418135445747897968173426132346622460254031452425686287824478617146278670264713886155228992283141903843330748647605337845897726364270262270221388553425764365596646869122752625837519793121116201637138123589",
      "4278027626",
      "-4278027626",
      "13701895078474585475247137503379489809369496012756504256009512583880126487325483060",
      "-13701895078474585475247137503379489809369496012756504256009512583880126487325483060",
      "840786904525379769789300537711189060152537247097220818494507832789559514433741881148404020369408737305833463880040532404710981950433015449671738772090021173041178316879389133142755654332186395733035047829330146580877246938698632854141466195209370012956133251007728880713807067719044277",
      "-840786904525379769789300537711189060152537247097220818494507832789559514433741881148404020369408737305833463880040532404710981950433015449671738772090021173041178316879389133142755654332186395733035047829330146580877246938698632854141466195209370012956133251007728880713807067719044277",
      "3276292788321967735809171244238550320799741743618059640716169790896705284371",
      "-3276292788321967735809171244238550320799741743618059640716169790896705284371",
      "1444750318330952168038880813831551223482419869563017466378766743222046493652050967605113492030925684948366811229446235163057029451862026449099533578455062305802501669339640305034074716552601620379378463996993533643594750826540",
      "-1444750318330952168038880813831551223482419869563017466378766743222046493652050967605113492030925684948366811229446235163057029451862026449099533578455062305802501669339640305034074716552601620379378463996993533643594750826540",
      "24086541858702055427502392901637",
      "-24086541858702055427502392901637",
      "4330081338691920762224608526717824389301173480290111106078901689480766861452007892469366598230052182293662205113692558414456231710116801557663552676919",
      "-4330081338691920762224608526717824389301173480290111106078901689480766861452007892469366598230052182293662205113692558414456231710116801557663552676919",
      "27418448940760548112970686808757044592831257648000991603843244426565505080207854209562533723933529598541150",
      "-27418448940760548112970686808757044592831257648000991603843244426565505080207854209562533723933529598541150",
      "4864349348505372641735591623253935562079434294533303015906939805788562228545435455999490952132421630107381486091394263343039603335970384360527032450993718152333512135859319365168",
      "-4864349348505372641735591623253935562079434294533303015906939805788562228545435455999490952132421630107381486091394263343039603335970384360527032450993718152333512135859319365168",
      "1626611771502100547320818336906281142864525046004643066115702536679123387159152005305066",
      "-1626611771502100547320818336906281142864525046004643066115702536679123387159152005305066",
      "14293419224795219525714860242008460020503397376158988250120766700936504062",
      "-14293419224795219525714860242008460020503397376158988250120766700936504062",
      "8260753138917023233566421292298962764237807151943318525543970544500632597376493524337437826032865212814429643010352970402898369401423576606526232369458199913160215970566401517084565439231237176671986172844275163759328663201716196906130863901168073596480102005930047541965611641872232312988889482629",
      "-8260753138917023233566421292298962764237807151943318525543970544500632597376493524337437826032865212814429643010352970402898369401423576606526232369458199913160215970566401517084565439231237176671986172844275163759328663201716196906130863901168073596480102005930047541965611641872232312988889482629",
      "5277758874516137277732773354886538661032533122667342258245153872341673598212237223809452902009488931372563068631458175710208259076234089320690",
      "-5277758874516137277732773354886538661032533122667342258245153872341673598212237223809452902009488931372563068631458175710208259076234089320690",
      "1604105217156493424796219158328988017738562338480346273566670218046",
      "-1604105217156493424796219158328988017738562338480346273566670218046",
   };

   boost::filesystem::ifstream is(root / "cpp_int1024_serial64.txt");
   std::cout << "Testing cpp_int1024_serial64.txt with T=" << typeid(T).name() << std::endl;
   //is.peek();
   BOOST_CHECK(is.good());
   boost::archive::text_iarchive ia(is);
   for(unsigned i = 0; i < sizeof(text_array) / sizeof(text_array[0]); ++i)
   {
#ifndef BOOST_NO_EXCEPTIONS
      try
      {
#endif
         T val;
         ia >> val;
         BOOST_CHECK_EQUAL(val, T(text_array[i]));
#ifndef BOOST_NO_EXCEPTIONS
      }
      catch(const boost::exception& e)
      {
         std::cout << "Caught boost::exception with:\n";
         std::cout << diagnostic_information(e);
      }
      catch(const std::exception& e)
      {
         std::cout << "Caught std::exception with:\n";
         std::cout << e.what() << std::endl;
      }
#endif
   }

   boost::filesystem::ifstream is2(root / "cpp_int1024_serial32.txt");
   std::cout << "Testing cpp_int1024_serial32.txt with T=" << typeid(T).name() << std::endl;
   //is2.peek();
   BOOST_CHECK(is2.good());
   boost::archive::text_iarchive ia2(is2);
   for(unsigned i = 0; i < sizeof(text_array) / sizeof(text_array[0]); ++i)
   {
#ifndef BOOST_NO_EXCEPTIONS
      try
      {
#endif
         T val;
         ia2 >> val;
         BOOST_CHECK_EQUAL(val, T(text_array[i]));
#ifndef BOOST_NO_EXCEPTIONS
      }
      catch(const boost::exception& e)
      {
         std::cout << "Caught boost::exception with:\n";
         std::cout << diagnostic_information(e);
      }
      catch(const std::exception& e)
      {
         std::cout << "Caught std::exception with:\n";
         std::cout << e.what() << std::endl;
      }
#endif
   }
}

int main(int argc, char const* argv[])
{
   if(argc == 2)
   {
      root = argv[1];
      std::cout << "Setting root directory to " << argv[1] << std::endl;
   }
   using namespace boost::multiprecision;
   test64<cpp_int>();
   test64<number<cpp_int_backend<64, 64> > >();
   test128<cpp_int>();
   test128<number<cpp_int_backend<128, 128> > >();
   test1024<cpp_int>();
   test1024<number<cpp_int_backend<1024, 1024> > >();
   return boost::report_errors();
}

