/*  I2Card liest und manipuliert 2KBit Speicherkarten via Uniprog	
    Copyright (C) 1999  Pherol <pherol@gmx.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <stdio.h>
#include <unistd.h>
#include <asm/io.h>
#include <math.h>
#include "i2card.h"

/*Lowlevel Funktionen*/

/*start und stop Flankenwechsel whrend CLK high*/
void start(void)
{
	outb((DATA_PIN+CLK_PIN),BASE);
	usleep(SLEEP);
	outb(CLK_PIN,BASE);
	usleep(SLEEP);
}

void stop(void)
{
	outb(CLK_PIN,BASE);
	usleep(SLEEP);
	outb((DATA_PIN+CLK_PIN),BASE);
	usleep(SLEEP);
	outb(DATA_PIN,BASE);
}

void high(void)
{
	outb(DATA_PIN,BASE);
	outb((DATA_PIN+CLK_PIN),BASE);
	usleep(SLEEP);
	outb(DATA_PIN,BASE);
}

void low(void)
{
	outb(0,BASE);
	outb(CLK_PIN,BASE);
	usleep(SLEEP);
	outb(0,BASE);
}

/*1 Takt und gibt DATA zurueck*/
int clk(void)
{
	int in;
	outb(DATA_PIN,BASE);
	outb((DATA_PIN+CLK_PIN),BASE);
	usleep(SLEEP);
	in=inb(BASE+1);
	outb(DATA_PIN,BASE);
	if(in==127)return 1;
	if(in==191)return 0;
}

/*Highlevel Funktionen*/
/*Sendet 7 Bit Adresse + Read/Write Bit*/
/*Dezimal ist zwar unschoen,wird aber von jedem verstanden*/
void snd_addr(int byte,int rw)
{
	int i=0;

	printf("Slave address=");
	for (i=6;i>-1;i--){
		if((byte-pow2(i))>=0){
			byte-=pow2(i);
			printf("1");
			high();
		}
		else{
			printf("0");
			low();
		}
	}
	if (rw==0){
		printf(" 0");
		low();
	}
	if (rw==1){
		printf(" 1");
		high();
	}

	printf("\n");
}

/*Sendet 8 Bit*/
void snd_byte(int data)
{
	int i=0;

	for (i=7;i>-1;i--){
		if((data-pow2(i))>=0){
			data-=pow2(i);
			printf("1");
			high();
		}
		else{
			printf("0");
			low();
		}
	}
	printf("\n");
}

/*Liest komplette Karte*/
void read_card(void)
{
	int i,n;

	start();
	snd_addr(SLV_ADDR,READ);
	if(0!=clk()){
		printf("Error: No ACK after sending slave address\n");
		if((ioperm(BASE,8,0))!=0)
			printf("Error: while setting ioperm's");
		exit();
	}

	for(i=0;i<(BYTES-1);i++){
		for(n=0;n<8;n++) printf("%d",clk());
	low();				/* ACK */

	printf("\n");
	}

	/* Letztes Byte ohne ACK */
	
	for(n=0;n<8;n++) printf("%d",clk());
	high();				/* kein ACK */
	stop();
	printf("\n");
}

/*nur 'Byte Write' implementiert*/
/*also jeweils 1 byte 'manipulieren'*/
void write_card(byte_addr,data)
{
	start();
	snd_addr(SLV_ADDR,WRITE);
	if(0!=clk()){
		printf("Error: No ACK after sending slave address\n");
		if((ioperm(BASE,8,0))!=0)
			printf("Error: while setting ioperm's");
		exit();
	}

	printf("Byte address=");
	snd_byte(byte_addr);
	if(0!=clk()){
		printf("Error: No ACK after sending byte address\n");
		if((ioperm(BASE,8,0))!=0)
			printf("Error: while setting ioperm's");
		exit();
	}

	printf("Data=");
	snd_byte(data);
	if(0!=clk()){
		printf("Error: No ACK after sending data\n");
		if((ioperm(BASE,8,0))!=0)
			printf("Error: while setting ioperm's");
		exit();
	}

	stop();
	printf("Writing EEPROM...");	
	/*nach max. 10ms ist der selbst getimte write-cycle beendet*/
	usleep(10000);
	printf("OK!\n");
}

/* Rest ist unwichtig... :-)*/
main(int argc, char *argv[])
{
	char ch;
	int write=0,byte=-1,data=-1;

	printf("I2Card Copyright (C) 1999 Pherol\n");

	if((ioperm(BASE,8,1))!=0){
		printf("Error: You need root privileges\n");
		exit();
	}
	
	while(ch!=-1){
		ch=getopt(argc,argv,"hrwb:d:");
		switch (ch){
			case'r':
				read_card();
				break;

			case'w':
				write=1;
				break;

			case'b':
				sscanf(optarg,"%d",&byte);
				break;

			case'd':
				sscanf(optarg,"%d",&data);
				break;

			case'h':
				printf("Usage:\ni2card -r\t\tRead card to stdout\n");
				printf("i2card -w -b 1 -d 10\tWrite 1st byte to 00001010\n");
				break;

			default:
				 break;
		}
	}
	
	if(write==1 && byte>=1 && byte<=256 && data>=0 && data<=255) 
		write_card((byte-1),data);

	if((ioperm(BASE,8,0))!=0){
		printf("Error: while setting ioperm's");
		exit();
	}
	
}
