/***************************************
  PERSO - Mon Aug 20 2001 - Version 1.0
  Calculation of identity-numbers for german identity cards(BRD).
  ******************/ /******************
  Written by Tilo Ulbrich <TiloUlbrich@web.de>

  This file Copyright 2001 Tilo Ulbrich
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ******************/ /******************

  compile: cc perso.c -o perso

  Return-Codes:
    0 --> number is valid
   -1 --> error calcing number, not valid (checksums)
***************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define SEPARATOR "--------------------------------\n"

struct identitynumber
{
  char block1_data[9];
  int block1_checksum;

  char block2_data[6];
  int block2_checksum;

  char block3_data[6];
  int block3_checksum;

  int checksum;  // is block4
}
pNumber;


char *
strleft (char *out_str, const char *in_str, int length)
{
  char *ptr = out_str;
  if (length <= 0)
    {
      *out_str = '\0';
      return out_str;
    }

  while ((*out_str++ = *in_str++) && --length);

  if (!length)
    {
      *out_str = '\0';
    }

  return ptr;
}


char *
strmid (char *out_str, const char *in_str, int pos, int length)
{
  if ((length < 0) || (pos <= 0))
    {
      *out_str = '\0';
      return (out_str);
    }

  for (; pos; pos--)
    {
      if (!*in_str++)
	{
	  *out_str = '\0';
	  return (out_str);
	}
    }

  in_str--;

  return (strleft (out_str, in_str, length));
}


char *
itostr (int number)
{
  static char tmp[5];

  sprintf (tmp, "%d", number);
  printf ("%d-->%s\n", number, tmp);
  return tmp;
}


unsigned int
checksum (char *data)
{
  unsigned int mod[3] = { 7, 3, 1 };
  unsigned int sum = 0;

  unsigned int i;
#error lamer control;-)
  for (i = 0; i < strlen (data); i++)
    { // every number
      char *number;
      strmid (number, data, i + 1, 1);
      sum += atoi (number) * mod[i % 3];
      printf ("%d=%d*%d\n", sum, atoi (number), mod[i % 3]);	// debug
    }

  printf ("%d=%d%%10\n", sum % 10, sum);	// debug
  return sum % 10;
}


int
main (int argc, char *argv[])
{
  char tmp[100];
  int calcedChecksum;

  if (argc != 5)
    { // 4 blocks not given
      printf ("%s wwwwNNNNNpD yyMMddX YYmmDDx n\n", argv[0]);
      return 0;
    }

  /* LOADING BLOCKS */

  /* 1 */
  strmid (pNumber.block1_data, argv[1], 1, 9);
  strmid (tmp, argv[1], 10, 1);
  pNumber.block1_checksum = atoi (tmp);
  printf ("1: %s|%d\n", pNumber.block1_data, pNumber.block1_checksum);

  /* 2 */
  strmid (pNumber.block2_data, argv[2], 1, 6);
  strmid (tmp, argv[2], 7, 1);
  pNumber.block2_checksum = atoi (tmp);
  printf ("2: %s|%d\n", pNumber.block2_data, pNumber.block2_checksum);

  /* 3 */
  strmid (pNumber.block3_data, argv[3], 1, 6);
  strmid (tmp, argv[3], 7, 1);
  pNumber.block3_checksum = atoi (tmp);
  printf ("3: %s|%d\n", pNumber.block3_data, pNumber.block3_checksum);

  /* 4 */
  strmid (tmp, argv[4], 1, 1);
  pNumber.checksum = atoi (tmp);
  printf ("4: %d\n", pNumber.checksum);

  /* VERIFY CHECKSUMS */

  /* 1 */
  printf (SEPARATOR);
  calcedChecksum = checksum (pNumber.block1_data);
  printf ("block 1: ");
  if (calcedChecksum != pNumber.block1_checksum)
    { // check calced and fixed checksum
      printf ("bad checksum. should be %d, not %d.\n", calcedChecksum,
	      pNumber.block1_checksum);
    }
  else
    {
      printf ("checksum ok.\n");
    }

  /* 2 */
  printf (SEPARATOR);
  calcedChecksum = checksum (pNumber.block2_data);
  printf ("block 2: ");
  if (calcedChecksum != pNumber.block2_checksum)
    { // check calced and fixed checksum
      printf ("bad checksum. should be %d, not %d.\n", calcedChecksum,
	      pNumber.block2_checksum);
    }
  else
    {
      printf ("checksum ok.\n");
    }

  /* 3 */
  printf (SEPARATOR);
  calcedChecksum = checksum (pNumber.block3_data);
  printf ("block 3: ");
  if (calcedChecksum != pNumber.block3_checksum)
    { // check calced and fixed checksum
      printf ("bad checksum. should be %d, not %d.\n", calcedChecksum,
	      pNumber.block3_checksum);
    }
  else
    {
      printf ("checksum ok.\n");
    }

  /* 4 */
  printf (SEPARATOR);
  strcpy (tmp, pNumber.block1_data);
  strcat (tmp, itostr (pNumber.block1_checksum));
  strcat (tmp, pNumber.block2_data);
  strcat (tmp, itostr (pNumber.block2_checksum));
  strcat (tmp, pNumber.block3_data);
  strcat (tmp, itostr (pNumber.block3_checksum));

  calcedChecksum = checksum (tmp);
  printf ("block 4: ");
  if (calcedChecksum != pNumber.checksum)
    { // check calced and fixed checksum
      printf ("bad checksum. should be %d, not %d.\n", calcedChecksum,
	      pNumber.checksum);
      return -1;
    }
  else
    {
      printf ("checksum ok.\n");
      return 0;
    }

}
