changecom(`/*',`*/')
/* change the comment character to C style */

/* do a really ugly hack so #include and include() both still work */
define(`m4_include', defn(`include'))
undefine(`include')
define(`include', `ifelse($#,0, ``include'', m4_include($*))')

/* same again but uglier for #define and define() */
define(`m4_define', defn(`define'))
undefine(`define')
m4_define(`define', `ifelse($#,0, ``define'', `m4_define($1,shift($@))')')
/****************************************************************************
 *      $Id: macros.m4,v 1.2 1998/01/22 05:49:38 kevine Exp $
 *      Copyright (C) 1997, 1998 Kevin Elphinstone, University of New South
 *      Wales
 *
 *      This file is part of the L4/MIPS micro-kernel distribution.
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version 2
 *      of the License, or (at your option) any later version.
 *      
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *      
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *      
 ****************************************************************************/


/****************************************************************************
 *
 * stack_c & unstack_c
 *
 * to preserve C calling conventions we need to preserve
 * and restore s0-7 registers and gp, fp, ra for system call 
 *
 ****************************************************************************/

define(`stack_c', `
	sd	ra, (sp)
	sd	fp, 8(sp)
	sd	gp, 16(sp)
	sd	s7, 24(sp)
	sd	s6, 32(sp)
	sd	s5, 40(sp)
	sd	s4, 48(sp)
	sd	s3, 56(sp)
	sd	s2, 64(sp)
	sd	s1, 72(sp)
	sd	s0, 80(sp)')
	

define(`unstack_c', `
	ld	ra, (sp)
	ld	fp, 8(sp)
	ld	gp, 16(sp)
	ld	s7, 24(sp)
	ld	s6, 32(sp)
	ld	s5, 40(sp)
	ld	s4, 48(sp)
	ld	s3, 56(sp)
	ld	s2, 64(sp)
	ld	s1, 72(sp)
	ld	s0, 80(sp)')
	
/****************************************************************************
 *
 * msg_to_reg(reg) and reg_to_msg
 *
 * copy registers to and from a C buffer
 *
 ****************************************************************************/

define(`msg_to_reg',`
	ld	s0, ($1)
	ld	s1, 8($1)
	ld	s2, 16($1)
	ld	s3, 24($1)
	ld	s4, 32($1)
	ld	s5, 40($1)
	ld	s6, 48($1)
	ld	s7, 56($1)')
	
define(`reg_to_msg',`
	sd	s0, ($1)
	sd	s1, 8($1)
	sd	s2, 16($1)
	sd	s3, 24($1)
	sd	s4, 32($1)
	sd	s5, 40($1)
	sd	s6, 48($1)
	sd	s7, 56($1)')
	
	