/* $Id: bcopy.c,v 1.1 1997/06/25 07:45:53 kevine Exp $ */
/** bcopy(src,dst,bytes) copy bytes from src to destination */
bcopy (src, dst, bytes)
     char           *src, *dst;
     unsigned int   bytes;
{

    if (dst >= src && dst < src + bytes) {
	/* do overlapping copy backwards, slowly! */
	src += bytes;
	dst += bytes;
	while (bytes--)
	  *--dst = *--src;
    } else {
	/* use the assembler code memcpy() */
	memcpy (dst, src, bytes);
    }
}
