/****************************************************************************
 * $Id: mem_test.c,v 1.2 1998/01/22 05:47:48 kevine Exp $
 * Copyright (C) 1997, 1998 Kevin Elphinstone, Univeristy of New South
 * Wales.
 *
 * This file is part of the L4/MIPS micro-kernel distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ****************************************************************************/
#include <libc.h>
#include <assert.h>
#include <l4/ipc.h>
#include <l4/syscalls.h>

static const l4_threadid_t SERIAL_TID = {0x60001};
static const l4_threadid_t SONIC_TID = {0x80001};

#define REFS 1000000
#define MEM_BASE  (8*1024*1024)

main()
{
  l4_msgdope_t result;
  int r;
  l4_ipc_reg_msg_t msg;
  char *c;
  l4_threadid_t tid, pager, preempter;
  unsigned long count, time0, dummy;
  dword_t old_eip, old_sp;
  l4_threadid_t t4 = {5 << 10};
  l4_threadid_t t2 = {2 << 10};
  


  count = 0;
  tid = l4_myself();

  c = (char *) &msg.reg[0];
  sprintf(c, "Mem tester... thread id 0x%x\r\n",tid);

  r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
		       L4_IPC_NEVER, &result);
  assert(r == 0);
  
  while (1)
  {

    /**************************************************************/
    c = (char *) &msg.reg[0];
    sprintf(c, "%d mem refs over 8K region\r\n", REFS );
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);
    r = l4_ipc_sleep(L4_IPC_TIMEOUT(0,0,3,5,0,0),&result);
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			  L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    time0 = msg.reg[0];
    for (count = 0; count < REFS*8; count += 8)
    {
      dummy = *(volatile long *)(MEM_BASE + (count << 51 >> 51));
    }
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    sprintf(c,"time = %lld\r\n", time0 - msg.reg[0]);
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);

    /**************************************************************/
    c = (char *) &msg.reg[0];
    sprintf(c, "%d mem refs over 8K region 32 bytes apart\r\n", REFS );
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);
    r = l4_ipc_sleep(L4_IPC_TIMEOUT(0,0,3,5,0,0),&result);
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    time0 = msg.reg[0];
    for (count = 0; count < REFS*32; count += 32)
    {
      dummy = *(volatile long *)(MEM_BASE + (count << 51 >> 51));
    }
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    sprintf(c,"time = %lld\r\n", time0 - msg.reg[0]);
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);
    
    /**************************************************************/
    
    c = (char *) &msg.reg[0];
    sprintf(c, "%d mem refs over 512K region\r\n", REFS );
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);
    r = l4_ipc_sleep(L4_IPC_TIMEOUT(0,0,3,5,0,0),&result);
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    time0 = msg.reg[0];
    for (count = 0; count < REFS*8; count+= 8)
    {
      dummy = *(volatile long *)(MEM_BASE + (count << 45 >> 45));
    }
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    sprintf(c,"time = %lld\r\n", time0 - msg.reg[0]);
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);
    
    /**************************************************************/

    c = (char *) &msg.reg[0];
    sprintf(c, "%d mem refs over 512K region 32 bytes apart\r\n", REFS );
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);
    r = l4_ipc_sleep(L4_IPC_TIMEOUT(0,0,3,5,0,0),&result);
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    time0 = msg.reg[0];
    for (count = 0; count < REFS*32; count += 32)
    {
      dummy = *(volatile long *)(MEM_BASE + (count  << 45 >> 45));
    }
    r = l4_mips_ipc_call(SONIC_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    sprintf(c,"time = %lld\r\n", time0 - msg.reg[0]);
    r = l4_mips_ipc_send(SERIAL_TID, L4_IPC_SHORT_MSG, &msg,
			 L4_IPC_NEVER, &result);
    assert(r == 0);
    
  }
}

