changecom(`/*',`*/')
/* change the comment character to C style */
/****************************************************************************
 *      $Id: macros.m4,v 1.28 1998/05/27 04:07:46 alanau Exp $
 *      Copyright (C) 1997, 1998 Kevin Elphinstone, Univeristy of New South
 *      Wales.
 *
 *      This file is part of the L4/MIPS micro-kernel distribution.
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version 2
 *      of the License, or (at your option) any later version.
 *      
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *      
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *      
 ****************************************************************************/

/* do a really ugly hack so #include and include() both still work */
define(`m4_include', defn(`include'))
undefine(`include')
define(`include', `ifelse($#,0, ``include'', m4_include($*))')

/* same again but uglier for #define and define() */
define(`m4_define', defn(`define'))
undefine(`define')
m4_define(`define', `ifelse($#,0, ``define'', `m4_define($1,shift($@))')')

/* same again but uglier for #ifdef and ifdef() */
define(`m4_ifdef', defn(`ifdef'))
undefine(`ifdef')
m4_define(`ifdef', `ifelse($#,0, ``ifdef'', m4_ifdef($*))')

/****************************************************************************
 * wakeup_remaining(tcb, time, temp)
 * 
 * calculate time remaining before wakeup
 * tcb: contains the wakeup time
 * time: wakeup time remaining in timeout format (m.s. 12 bits)
 * temp: temporary register
 ****************************************************************************/

define(`wakeup_remaining',`
	.set noat
	ld	$2, T_WAKEUP($1)
	bne	$2, zero, 1f
	move	$2, zero /* infinte wakeup left - i.e. no wakeup */
	b	2f
1:	lui 	AT, KERNEL_BASE
	ld	AT, K_CLOCK(AT)
	dsubu	$2, AT, $2
	.set	at
	dli	$3, 1000
	ddiv	$2, $3
	mflo	$2
	encode_time($2, AT, $3)
	.set noat
	dsll	AT, CT_TIME_MAN_SHIFT
	dsll	$3, CT_TIME_EXP_SHIFT
	or	$2, $2, AT
	or	$2, $2, $3
2:	.set at')

/****************************************************************************
 * decode_time(m, e, output)
 * 
 * decode a timeout/timeslice format specification into a *millisecond* value 
 * m: register containing the 'm' value of a timeout/timeslice 
 * e: register containing the 'e' value of a timeout/timeslice
 * ouput: millisecond value returned in this register 
 ****************************************************************************/

define(`decode_time', `
	/* check if m is zero */
	bne	zero, $1, 254f
	move	$3, zero /* zero time */
	b	255f
254:
	dli	$3, 15
	sub 	$2, $3, $2
	sll	$2, $2, 1 
	sllv	$3, $1, $2
	
	.set noreorder
	
	/* round to nearest millisecond */
	dli	$1, 1000
	ddiv	$3, $1
	dli	$2, 500
	nop
	mflo	$3
	mfhi	$1
	sub	$1, $1, $2
	blez	$1, 255f /* round down */
	nop
	addi	$3, $3, 1 /* round up */

255:
	.set reorder')

/****************************************************************************
 * encode_time(input, m, e)
 * 
 * encode a *millisecond* value into a timeout/timeslice format 
 * input: millisecond value to be decoded; returns microsecond value   
 * m: register containing the 'm' value of the decoded timeout/timeslice 
 * e: register containing the 'e' value of the decoded timeout/timeslice
 ****************************************************************************/

define(`encode_time', `
	.set noreorder
	.set noat

	/* convert into microseconds */
	dli	AT, 1000
	dmult	$1, AT
	dli	$2, 0
	dli	$3, 1 /* any non-zero value is ok */
	mflo	$1

	/* check if input is zero */
	bne	$1, zero, 252f
	nop
	b	255f

252:	dli	AT, 28 /* e < 15 for millisecond precision */

253:	dli	$3, 30
	dsubu	$3, $3, AT /* $3 = 30 - AT */
	dsrlv	$2, $1, $3 /* $2 = $1 DIV 2^(30 -AT) */
	dli	$3, 255
	dsubu	$3, $3, $2
	bgez	$3, 254f
	nop
	daddiu	AT, AT, -2
	b	253b
254:	move	$3, AT
	dsrl	$3, 1
	.set at
	.set reorder
255:')

/****************************************************************************
 *
 * ins_dl(input, list , offset)
 *
 * insert tcb into double linked list before head of list
 * input: register pointing to tcb to be linked in
 * list: register pointing to tcb already in list
 * offset: offset from tcb base containing next pointer (prev pointer must
 * 	follow next)
 *
 * No null pointers in next/prev allowed
 *
 ****************************************************************************/

define(`ins_dl', `
	.set	noat
	sd	$2, $3($1)
	ld	AT, $3+8($2)
	sd	AT, $3+8($1)
	sd	$1, $3(AT)
	sd	$1, $3+8($2)
	.set	at')

/****************************************************************************
 *
 * tcbtop(tcb)
 *
 * derive top of tcb from stack pointer
 *
 ****************************************************************************/

define(`tcbtop',`
	ori	$1, sp, TCBO')
	
/****************************************************************************
 *
 * tid2tcb(tid, tcb)
 *
 ****************************************************************************/

define(`tid2tcb',`
	.set	noat
	dsll	$2, $1, 36
	dsrl	$2, $2, 46
	dsll	$2, $2, TCB_SIZE_SHIFT
	dli	AT, TCB_VBASE
	daddu	$2, $2, AT
	.set	at')

/****************************************************************************
 *
 * tid2ttable(tid, address)
 *
 ****************************************************************************/

define(`tid2ttable',`
	.set	noat
	dsrl	$2, $1, 17
	dli	AT, 03777
	and	$2, $2, AT
	dsll	$2, $2, 2
	dli	AT, TID_TABLE_BASE
	daddu	$2, $2, AT
	.set	at')

/****************************************************************************
 *
 * thread_switch_fast(stcb, dtcb, kernel_base) 
 *
 * stcb: top of sender tcb
 * dtcb: bottom of destination tcb
 * kernel base
 *
 ****************************************************************************/
	
define(`thread_switch_fast',`
	.set	noat
	.set 	noreorder
	sd	sp, T_STACK_POINTER-TCBO($1)
	ld	sp, T_ASID($2)
	ld	AT, T_GPT_POINTER($2)
	bgez	sp, 255f
	dmtc0	sp, C0_ENTRYHI
	sd	AT, K_GPT_POINTER($3)
	ld	sp, T_STACK_POINTER($2)
	daddiu	AT, $2, TCB_SIZE
	jal	asid_get
	sd	AT, K_STACK_BOTTOM($3)
	b	254f	
	nop
255:	sd	AT, K_GPT_POINTER($3)
	ld	sp, T_STACK_POINTER($2)
	daddiu	AT, $2, TCB_SIZE
	sd	AT, K_STACK_BOTTOM($3)
254:
	.set	reorder
	.set	at')



/****************************************************************************
 *
 * ins_list(tcb, tcb link, kern base, list head)
 *
 * Note: list end must be -1, tcb link = 0 means not in list yet
 *
 ****************************************************************************/

define(`ins_list',`
	.set	noat
	ld	AT, $2($1)
	bne	AT, zero, 255f
	ld	AT, $4($3)
	sd	AT, $2($1)
	sd	$1, $4($3)
255:	
	.set	at')

/****************************************************************************
 *
 * syscall_ret()
 *
 ****************************************************************************/
		
define(`syscall_ret',`
	.set noreorder
	.set noat
#if 0	
	lw	k0, (sp)   /* status */
	li	k1, ~(ST_KSU| ST_IE) /* set EXL first */
	and	k1, k0, k1
	mtc0	k1, C0_STATUS
#endif
	mfc0	k0, C0_STATUS
	ori	k0, k0, ST_EXL
	mtc0	k0, C0_STATUS
	li	k1, 0x0fffff00
	and	k0, k0, k1
	lbu	k1, (sp)
	or	k0, k0, k1

	ld	k1, 8(sp)  /* EPC */
	dmtc0   k1, C0_EPC
	mtc0	k0, C0_STATUS /* now EXL is set, change KSU */
	ld	sp, 16(sp)
	eret
	.set at
	.set reorder')

/****************************************************************************
 *
 * ins_wakeup(timeout, tcb, kbase)
 *
 * insert tcb in appropriate wakeup list
 *
 ****************************************************************************/

define(`ins_wakeup',`
	.set noat
	ld	AT, K_CLOCK($3)
	daddu	AT, $1, AT
	sd	AT, T_WAKEUP($2)
	
	daddiu	AT, $1, -SOON_TIME
	blez	AT, 254f

	daddiu	AT, $1, -LATE_TIME
	blez	AT, 253f
	
	/* enter in late wakeup list */
	ins_list($2, T_LATE_WAKEUP_LINK, $3, K_LATE_WAKEUP_LIST)
	b	252f

254:	/* enter in soon wakeup list */
	ins_list($2, T_SOON_WAKEUP_LINK, $3, K_SOON_WAKEUP_LIST)	
	b	252f
	
253:   /* enter in wakeup list */
	ins_list($2, T_WAKEUP_LINK, $3, K_WAKEUP_LIST)	
	
252:	
	.set	at')

/****************************************************************************
 *
 * ins_int_list(tcb base, kernel base)
 *
 * insert tcb into interrupt list
 *
 ****************************************************************************/
	
define(`ins_int_list',`
	.set noat
	ld	AT, K_INT_LIST($2)
	sd	AT, T_INT_LINK($1)
	sd	$1, K_INT_LIST($2)	
	.set at')

/****************************************************************************
 *
 * ins_sendq_end(sending tcb, receiving tcb)
 *
 * NOTE: 	next = head->tail
 *		prev = tail->head
 *
 ****************************************************************************/

define(`ins_sendq_end',`
	.set noat
	ld	AT, T_SNDQ_END($2)
	bne	AT, zero, 255f
		sd	$1, T_SNDQ_START($2)
		sd	$1, T_SNDQ_END($2)
		sd	zero, T_SNDQ_NEXT($1)
		sd	zero, T_SNDQ_PREV($1)
		b	254f
255:	sd	zero, T_SNDQ_NEXT($1)
	sd	AT, T_SNDQ_PREV($1)
	sd	$1, T_SNDQ_NEXT(AT)
	sd	$1, T_SNDQ_END($2)
254:
	.set at')

/****************************************************************************
 *
 * rem_sendq(sending tcb, receiving tcb, temp reg)
 *
 ****************************************************************************/

define(`rem_sendq',`
	.set	noat
	ld	AT, T_SNDQ_NEXT($1)
	bne	AT, zero, 255f
		ld	AT, T_SNDQ_PREV($1)
		sd	AT,  T_SNDQ_END($2)
		b	254f
255:	ld	$3, T_SNDQ_PREV($1)
	sd	$3, T_SNDQ_PREV(AT)

254:	ld	AT, T_SNDQ_PREV($1)
	bne	AT, zero, 255f
		ld	AT, T_SNDQ_NEXT($1)
		sd	AT, T_SNDQ_START($2)
		b	254f
255:	ld	$3, T_SNDQ_NEXT($1)
	sd	$3, T_SNDQ_NEXT(AT)

254:	.set at')

/****************************************************************************
 *
 * ins_busy_list(tcb, kern base, temp reg)
 *
 * insert in busy list only if not already inside
 *
 ****************************************************************************/

define(`ins_busy_list',`
	.set	noat
	
	/* check if already in busy list */
	ld	AT, T_BUSY_LINK($1)
	bne	AT, zero, 254f /* already in a queue */

	/* check if timeslice is zero */
	lhu	AT, T_TIMESLICE($1)
	beq	AT, zero, 255f

	/* insert into appropriate queue */
	lbu	$3, T_TSP($1)
	sll	$3, 3
	daddu	$3, $3, $2

	ld	AT, K_PRIO_BUSY_LIST($3)
	sd	$1, K_PRIO_BUSY_LIST($3)
	bne	AT, zero, 253f
	
	/* insert tcb into empty queue */
	sd	$1, T_BUSY_LINK($1)
	b	254f
	nop

253:	/* insert tcb at tail of existing queue */
	ld	$3, T_BUSY_LINK(AT)
	sd	$3, T_BUSY_LINK($1)
	sd	$1, T_BUSY_LINK(AT)
254:
	/* reset remaining time slice & current priority values */
	lhu	$3, T_TIMESLICE($1)
	sh	$3, T_REM_TIMESLICE($1)
	lbu	$3, T_TSP($1)
	sb	$3, T_CTSP($1)
255:
	.set at
	')

/****************************************************************************
 *
 * init_tcb(tcb base)
 *
 * initialize variables in new tcb block
 *
 ****************************************************************************/

define(`init_tcb',`
	sd	zero, T_SNDQ_END($1)
	sd	zero, T_WAKEUP_LINK($1)
	sd	zero, T_BUSY_LINK($1)
	sd	zero, T_INT_LINK($1)
	sd	zero, T_WFOR($1)
	sd	zero, T_SNDQ_START($1)
	sd	zero, T_CPU_TIME($1)
	/* T_STACK_POINTER */
	sd	zero, T_ASID($1)
	/* gpt pointer */
	/* T_MYSELF */
	/* T_FINE_STATE */
	/* T_COARSE_STATE */
	sd	zero, T_RECV_DESC($1)
	/* T_PRESENT_NEXT */
	sd	zero, T_CHILD_TASK($1)
	sd	zero, T_REM_TIMESLICE($1)
	/* T_WAKEUP (dont care) */
	sd	zero, T_SOON_WAKEUP_LINK($1)
	sd	zero, T_LATE_WAKEUP_LINK($1)
	sd	zero, T_SNDQ_NEXT($1)
	sd	zero, T_SNDQ_PREV($1)
	/* pager */
	/* preempter */
	/* comm_parter */
	/* wdw_addr */
	sd	zero, T_INTERRUPT_MASK($1)
	sw	zero, T_STACKED_FINE_STATE($1)
	/* T_STACKED_COMM_PRTNR */
	sd	zero, T_SISTER_TASK($1)
	')
	


/****************************************************************************
 *
 * ins_pres_list(new tcb base, existing base)
 *
 * insert tcb in present double linked list
 *
 ****************************************************************************/

define(`ins_pres_list',`
	.set	noat
	ld	AT, T_PRESENT_NEXT($2)
	sd	AT, T_PRESENT_NEXT($1)
	sd	$1, T_PRESENT_NEXT($2)
	.set	at
	')
	
/****************************************************************************
 *
 * to_next_thread(kernel_base)
 *
 * switch from current thread to next runnable thread on busy list 
 *
 ****************************************************************************/

define(`to_next_thread',`
	move	s0, $1
	move	a0, $1
	jal	get_next_thread
	tcbtop(t0)
	thread_switch_fast(t0, v0, s0)
	ld	ra, (sp)
	jr	ra
	')

/****************************************************************************
 *
 * make_busy(tcb, return_code)
 *
 * mark the given thread busy with the given return code
 *
 ****************************************************************************/

define(`make_busy',`
	.set	noat
	daddiu	AT, $1, TCB_SIZE + ST_EX_V0
	sd	$2, (AT)
	daddiu	AT, $1, TCB_SIZE - ST_EX_SIZE -8
	sd	AT, T_STACK_POINTER($1)
	dla	$2, preempt_ret
	sd	$2, (AT)
	li	AT, FS_BUSY
	sw	AT, T_FINE_STATE($1)
	.set	at
	')

/****************************************************************************
 *
 * trace(string) macro to change led display for tracing
 *
 ****************************************************************************/
	
define(`trace',`

#ifdef KDEBUG
	.data
tmsg_$1:
	.ascii "$1"
	.text
#ifdef P4000
	lui	k0, KERNEL_BASE
	sd	t0, K_TRACE_REG_SAVE(k0)
	dla	k0, tmsg_$1
	dli	k1, PHYS_TO_CKSEG1(ALPHN_CHAR_BASE)
	lbu	t0, (k0)
	sll	t0, 24
	sw	t0, 12(k1)
	lbu	t0, 1(k0)
	sll	t0, 24
	sw	t0, 8(k1)
	lbu	t0, 2(k0)
	sll	t0, 24
	sw	t0, 4(k1)
	lbu	t0, 3(k0)
	sll	t0, 24
	sw	t0, (k1)
	lui	k0, KERNEL_BASE
	ld	t0, K_TRACE_REG_SAVE(k0)
#endif
#ifdef U4600
	lui	k0, KERNEL_BASE
	sd	t0, K_TRACE_REG_SAVE(k0)
	dla	k0, tmsg_$1
	dli	k1, PHYS_TO_CKSEG1(LED_BASE)
	lbu	t0, (k0)
	sb	t0, 3(k1)
	lbu	t0, 1(k0)
	sb	t0, 2(k1)
	lbu	t0, 2(k0)
	sb	t0, 1(k1)
	lbu	t0, 3(k0)
	sb	t0, (k1)
	lui	k0, KERNEL_BASE
	ld	t0, K_TRACE_REG_SAVE(k0)
#endif	
#endif
	')

/* define(`trace',`') */

/****************************************************************************
 *
 * break() call the debugger preserving everything except k0, k1
 *
 ****************************************************************************/

define(`break',`
	lui	k0, KERNEL_BASE
	sd	ra, K_TRACE_REG_SAVE(k0)
	jal	dbg
	lui	k0, KERNEL_BASE
	ld	ra,  K_TRACE_REG_SAVE(k0)
	')
/****************************************************************************
 *
 * cbreak() conditional call the debugger preserving everything except k0, k1
 *
 ****************************************************************************/

define(`cbreak',`
#ifdef KDEBUG
	lui	k0, KERNEL_BASE
	ld	k1, K_BREAK_ON(k0)
	beq	k1, zero, 255f
	sd	ra, K_TRACE_REG_SAVE(k0)
	jal	dbg
	lui	k0, KERNEL_BASE
	lui	k0, KERNEL_BASE
	ld	ra,  K_TRACE_REG_SAVE(k0)
255:
#endif
	')

/****************************************************************************
 *
 * receive_timeout(timeout, rcv_exp, rtime)
 *
 * decode the receive timeout value
 *
 ****************************************************************************/

define(`receive_timeout',`
	.set	noat
	dli	AT, L4_RCV_MAN_MASK
	and	AT, $1, AT
	dsrl	AT, AT, 4  /* return timeout in 1024 us units */
	dsrlv	AT, AT, $2
	dsrlv	$3, AT, $2
	.set	at
	')

/****************************************************************************
 *
 * send_timeout(timeout, snd_exp, stime)
 *
 * decode the send timeout value
 *
 ****************************************************************************/

define(`send_timeout',`
	.set	noat
	dli	AT, L4_SND_MAN_MASK
	and	AT, $1, AT
	dsll	AT, AT, 4  /* return timeout in 1024 us units */
	dsrlv	AT, AT, $2
	dsrlv	$3, AT, $2
	.set	at
	')

/****************************************************************************
 * int_preempt(src, inth, kern, tmp)
 *
 * stack an interrupted thread and reload the kernel scheduling vars
 *   	(only stack if current remaining timeslice is greater than zero)
 * src: tcb base of thread being interrupted
 * inth: tcb base of interrupt handler thread
 * kern: kernel base 
 * tmp: temprary reg
 ****************************************************************************/

define(`int_preempt',`
	.set	noat
	lw 	AT, K_TIMESLICE($3)
	beq	zero, AT, 254f
	nop
	sh	AT, T_REM_TIMESLICE($1)
	lw	AT, K_PRIORITY($3)
	sb	AT, T_CTSP($1)
	ins_int_list($1, $3)
	.set noat
	b	255f
	nop
254:
	ins_busy_list($1, $3, $4)
	.set noat
255:	
	/* reload kernel vars */
	lhu	AT, T_TIMESLICE($2)
	sw	AT, K_TIMESLICE($3)
	lbu	AT, T_CTSP($2)
	sw	AT, K_PRIORITY($3)
	.set at')

	





