.\"     $Id: l4_task_new.man,v 1.4 1998/01/22 05:45:26 kevine Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_TASK_NEW 2 "06.12.97" "CSE/UNSW" "System calls"
.SH NAME
l4_task_new \- create or delete a task
.SH "Synopsis"
.br
\fB#include <l4/syscalls.h>\fP
.PP
\fB l4_taskid_t l4_task_new(l4_taskid_t\fP \fIdest\fP \fB, dword_t\fP \fImcp_or_new_chief\fP \fB, dword_t\fP \fIesp\fP \fB, dword_t\fP
\fIeip\fP \fB, l4_threadid_t\fP \fIpager\fP \fB, l4_threadid_t\fP \fIexcpt\fP \fB);\fP
.SH "Description"
The \fBl4_task_new()\fP system call deletes and/or creates a task. Deletion
of a task means that the address space of the task and all threads of
the task disappear. The cpu time of all deleted threads is added to
the cputime of the deleting thread. If the deleted task was chief of a
clan, all tasks of the clan are deleted as well.
.PP
Tasks may be created as active or inactive. For an active task, a new
address space is created together with 128 threads. Lthread 0 is
started, the other ones wait for a "real" creation using
\fBl4_thread_ex_regs()\fP. An inactive task is empty. It occupies no
resources, has no address space and no threads. Communication with
inactive tasks is not possible.
.PP
A newly created task gets the creator as its chief, i.e. it is created
inside the creator's clan. Symmetrically, a task can only be deleted
either directly by its chief or indirectly by a higher\-level chief.
.SH "Arguments"
.IP "\fIdest\fP"
Task id of an existing task whose chief is the
current task. If this is not fulfilled, the system call has no effect. 
Simultaneously, a new task with the same task number is created. It
may be active or inactive.
.IP "\fImcp_or_new_chief\fP"
Depending on the state of the task (active or
inactive), two variants are possible here: 
.RS
.IP "<mcp>"
Maximum controlled priority defines the highest priority which can be
ruled by the new task acting as a scheduler. The new task's effective
mcp is the minimum of the creator's mcp and the specified mcp.
Use this parameter if the newly generated task is an active task.
.IP "<new_chief>"
Specifies the chief of the new inactive task. This
mechanism permits to transfer inactive tasks to other
tasks. Transferring an inactive task to the specified chief means to
transfer the related right to create a task.
Use this parameter if the newly generated task is an inactive task.
.RE
.IP "\fIesp\fP"
Initial stack pointer for lthread 0 if the new task is
created as an active one. Ignored otherwise.
.IP "\fIeip\fP"
Initial instruction pointer for lthread 0 if the new task is
created as an active one. Ignored otherwise.
.IP "\fIpager\fP"
If \fBL4_NIL_ID\fP is used, the new task is created as
inactive. Lthread 0 is not created. Otherwise the new task is created
as active and the specified pager is associated to Lthread 0.  
.IP "\fIexcpt\fP"
The thread identifier of the exception handling thread of the new task.
.SH "Return Values"
If task creation succeeded its id is delivered back. If the new task is
active, the new task id will have a new version number so that it
differs from all task ids used earlier. Chief and task number are the
same as in dest task. If the new task is created inactive, the chief is
taken from the chief parameter; the task number remains unchanged. The
version is undefined so that the new task id might be identical with a
formerly (but not currently and not in future) valid task id. This is
safe since communication with inactive tasks is impossible.
.PP
If task creation failed \fBL4_NIL_ID\fP is returned.
.SH "See Also"
\fIl4_thread_ex_regs\fP, 
\fIl4_fpage_unmap\fP, 
\fIl4_myself\fP, 
\fIl4_id_nearest\fP, 
\fIl4_ipc\fP,
\fIl4_thread_switch\fP, 
\fIl4_thread_schedule\fP
