.\"     $Id: l4_mips_ipc_wait.man,v 1.4 1998/01/22 05:45:24 kevine Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_MIPS_IPC_WAIT 2 "06.12.97" "CSE/UNSW" "System calls"
.SH NAME
l4_mips_ipc_wait \- wait for message from any source
.SH "Synopsis"
.br
\fB#include <ipc.h>\fP
.PP
\fBstatic inline int\fP 
.br
\fBl4_mips_ipc_wait(l4_threadid_t\fP \fI*src\fP \fB, void\fP
\fI*rcv_msg\fP \fB, l4_ipc_reg_msg_t\fP \fI*rcv_reg\fP \fB,
l4_timeout_t\fP \fItimeout\fP \fB, l4_msgdope_t\fP \fI*result\fP
\fB);\fP
.SH "Description"
This operation includes no send phase. The invoker waits for a message
from any source (including a hardware interrupt).
.SH "Arguments"
.IP "\fI*src\fP"
Thread id of the source (undefined if no message was received).
.IP "\fI*rcv_msg\fP" 
Pointer to Receive Descriptor. It can contain the
following values: 
.RS
.IP "\fB0\fP"
Only messages up to 8 dwords and are
accepted. The received message is stored in \fIrcv_msg\fP.
.IP "<mem>" 
If Bit 1 of \fI*rcv_msg\fP is 0 ipc includes receiving a
message (or waiting to receive a message). \fI*rcv_msg\fP must
point to a valid message. Note that the first 8 dwords of the 
received message are stored in \fIrcv_reg\fP.
.IP "<rmap>"
If Bit 1 of \fI*rcv_msg\fP is 1 only send\-fpage messages or up to 8
dwords (in \fIrcv_reg\fP) are accepted. If a map message is received,
the 62 most significant bits describe the receive fpage (instead of
\fIrcvfpage option\fP in a memory message buffer). Thus fpages can also
be received without a message buffer in memory.
.RE
.IP "\fI*rcv_reg\fP" 
A pointer to the place to store the first 8 dwords received in registers of received message,
undefined if no message was received. 
.IP "\fItimeout\fP"
This 32\-bit word specifies all 4 timeouts, the
quadruple (snd, rcv, snd pf, rcv pf). For a detailed description see
the L4 Reference Manual.
.IP "\fIresult\fP"
The message dope describing the result of the Ipc.
.SH "Return Values"
The following return values are possible:
.IP "\fB0\fP"
No error occured. The optional send operation was
successful, and if a receive operation was also specified, a message
was also received correctly. 
.IP "\fBL4_IPC_ENOT_EXISTENT\fP"
Non\-existing destination or source.
.IP "\fBL4_IPC_RETIMEOUT\fP"
Timeout during receive operation.
.IP "\fBL4_IPC_RECANCELED\fP"
Receive operation cancelled by another thread.
.IP "\fBL4_IPC_REMAPFAILED\fP"
Map failed due to a shortage of page
tables during receive operation.
.IP "\fBL4_IPC_RESNDPFTO\fP"
Send pagefault timeout.
.IP "\fBL4_IPC_RERCVPFTO\fP"
Receive pagefault timeout.
.IP "\fBL4_IPC_REABORTED\fP"
Receive operation aborted by another
thread.
.IP "\fBL4_IPC_REMSGCUT\fP"
Received message cut. Potential reasons
are:
.RS
.IP "(a)"
The recipient's mword buffer is too small.
.IP "(b)"
The recipient does not accept enough strings.
.IP "(c)"
At least one of the recipient's string buffers is too small.
.RE
.SH "See Also"
\fIl4_ipc\fP, 
\fIl4_mips_ipc_receive\fP, 
\fIl4_mips_ipc_reply_and_wait\fP, 
\fIl4_mips_ipc_reply_deceiving_and_wait\fP, 
\fIl4_mips_ipc_send\fP, 
\fIl4_mips_ipc_send_deceiving\fP,
\fIl4_mips_ipc_call\fP,
\fIl4_mips_ipc_sleep\fP 
