.\"     $Id: l4_mips_ipc_send_deceiving.man,v 1.3 1998/01/22 05:45:22 kevine Exp $
.\"     Copyright (C) 1997, 1998 Kevin Elphinstone, University of New
.\"     South Wales.
.\"
.\"     This file is part of the L4/MIPS micro-kernel distribution.
.\"
.\"     This program is free software; you can redistribute it and/or
.\"     modify it under the terms of the GNU General Public License
.\"     as published by the Free Software Foundation; either version 2
.\"     of the License, or (at your option) any later version.
.\"     
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"     
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH L4_MIPS_IPC_SEND_DECEIVING 2 "06.12.97" "CSE/UNSW" "System calls"
.SH NAME
l4_mips_ipc_send_deceiving \- deceive send operation
.SH "Synopsis"
.br
\fB#include <l4/ipc.h>\fP
.PP
\fBstatic inline int\fP 
.br
\fBl4_mips_ipc_send_deceiving(l4_threadid_t\fP \fIdest\fP \fB,
l4_threadid_t\fP \fIvsend\fP \fB, const void\fP \fI*snd_msg\fP \fB,
l4_ipc_reg_msg_t\fP \fI*snd_reg\fP \fB, l4_timeout_t\fP \fItimeout\fP
\fB, l4_msgdope_t\fP \fI*result\fP \fB);\fP
.SH "Description"
A chief can specify a virtual sender id in \fIids\fP which the
recipient should get instead of the chief's id. Recall that deceiving
is secure since only direction\-preserving deceit is possible. If the
specified virtual sender id does not fulfill this constraint, the call
works like \fBl4_mips_ipc_send()\fP.
.SH "Arguments"
.IP "\fIdest\fP"
Thread id of the destination.
.IP "\fIvsend\fP"
Virtual sender id for the destination.
.IP "\fI*snd_msg\fP"
Pointer to a Send Descriptor. It can contain the 
following values:
.RS
.IP "<mem>" 
Ipc includes sending a message to the destination 
specified by \fIdest\fP. \fI*snd_msg\fP must point to a valid
message. The first 8 dwords of the message have to be given 
separately by the pointer \fI*snd_reg\fP.
.IP "\fB0\fP" 
Ipc includes sending a message to the destination specified by
\fIdest\fP. The message consists solely of the 8 dwords pointed to by
\fI*snd_reg\fP.
.RE
.IP "\fI*snd_reg\fP"
A pointer to the first 8 dwords to be transmitted in registers.
.IP "\fItimeout\fP"
This 32\-bit word specifies all 4 timeouts, the
quadruple (snd, rcv, snd pf, rcv pf). For a detailed description see
the L4 Reference Manual.
.IP "\fIresult\fP"
The message dope describing the result of the Ipc.
.SH "Return Values"
The following return values are possible:
.IP "\fB0\fP"
No error occured. The optional send operation was
successful, and if a receive operation was also specified, a message
was also received correctly. 
.IP "\fBL4_IPC_ENOT_EXISTENT\fP"
Non\-existing destination or source.
.IP "\fBL4_IPC_SETIMEOUT\fP"
Timeout during send operation.
.IP "\fBL4_IPC_SECANCELED\fP"
Send operation cancelled by another thread.
.IP "\fBL4_IPC_SEMAPFAILED\fP"
Map failed due to a shortage of page
tables during send operation.
.IP "\fBL4_IPC_SESNDPFTO\fP"
Send pagefault timeout.
.IP "\fBL4_IPC_SERCVPFTO\fP"
Receive pagefault timeout.
.IP "\fBL4_IPC_SEABORTED\fP"
Send operation aborted by another thread.
.IP "\fBL4_IPC_SEMSGCUT\fP"
Received message cut. Potential reasons
are:
.RS
.IP "(a)"
The recipient's mword buffer is too small.
.IP "(b)"
The recipient does not accept enough strings.
.IP "(c)"
At least one of the recipient's string buffers is too small.
.RE
.SH "See Also"
\fIl4_ipc\fP, 
\fIl4_mips_ipc_receive\fP, 
\fIl4_mips_ipc_reply_and_wait\fP, 
\fIl4_mips_ipc_reply_deceiving_and_wait\fP, 
\fIl4_mips_ipc_send\fP, 
\fIl4_mips_ipc_call\fP,
\fIl4_mips_ipc_wait\fP,
\fIl4_mips_ipc_sleep\fP 
