/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <malloc.h>
#include <stdlib.h>
#include <string.h>

#include <flux/lmm.h>
#include <flux/x86/base_paging.h>

int ptab_alloc(vm_offset_t *out_ptab_pa)
{
	void *ptab_va = lmm_alloc_page(&malloc_lmm, 0);
	if (ptab_va == 0)
		return -1;

	/* Clear it out to make sure all entries are invalid.  */
	memset(ptab_va, 0, 4096);

	*out_ptab_pa = kvtophys(ptab_va);
	return 0;
}

