/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <flux/debug.h>
#include <flux/page.h>
#include <flux/x86/base_cpu.h>
#include <flux/x86/base_paging.h>

void pdir_unmap_range(vm_offset_t pdir_pa, vm_offset_t la, vm_size_t size)
{
	while (size > 0)
	{
		pd_entry_t *pde = pdir_find_pde(pdir_pa, la);

		assert(*pde & INTEL_PDE_VALID);

		if (*pde & INTEL_PDE_SUPERPAGE)
		{
			/*
			 * A superpage was used to map an entire 4MB region.
			 * Just zero out the superpage entry in the PDE.
			 */
			assert(superpage_aligned(la));
			assert(size >= SUPERPAGE_SIZE);
			*pde = 0;
			la += SUPERPAGE_SIZE;
			size -= SUPERPAGE_SIZE;
		}
		else
		{
			pt_entry_t *pte;

			/* Find the page table for this 4MB region.  */
			assert(*pde & INTEL_PDE_VALID);
			pte = ptab_find_pte(pde_to_pa(*pde), la);

			/* Clear out the affected 4KB page mappings.  */
			do
			{
				/* Remove the page mapping.  */
				assert(*pte & INTEL_PTE_VALID);
				*pte = 0;

				/* Advance to the next page.  */
				pte++;
				la += PAGE_SIZE;
				size -= PAGE_SIZE;
			}
			while ((size > 0) && !superpage_aligned(la));
		}
	}
}

