/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <flux/config.h>
#include <flux/x86/asm.h>
#include <flux/x86/base_stack.h>

/*
 * Although recent versions of the GNU assembler work fine
 * when .bss is used here instead of .data, older versions,
 * such as the one supplied in the FreeBSD-2.1 distribution,
 * silently do horribly bogus and obscure things...
 * On such broken assemblers, we just declare the stack in the data section
 * and waste a little space in the executable file.
 */
#ifdef HAVE_WORKING_BSS
	.bss
#else
	.data
#endif

	.globl	EXT(base_stack_start)
LEXT(base_stack_start)

	.space	BASE_STACK_SIZE

	.globl	EXT(base_stack_end)
LEXT(base_stack_end)

