/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

/*
 * This is provided to allow the use of FreeBSD-style slices, which allow
 * a disklable to be inside a DOS partition.

 * compatabiluty-slice support?
 */

#include <sys/types.h> 
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <flux/diskpart/diskpart.h>


/*
 * This code is based on the diskpart_lookup_bsd_compat rountine
 *
 * name is a NULL-terminated ASCII string indicating the partition.
 * It is essentially the device name without the drive name part.
 * The FreeBSD slice name `sd0s1e' would just be `s1e'
 *
 * If a slice name is given, it is used.
 * Otherwise, a partition is first assumed to be inside of the
 * (first) BSD slice, if one exists.
 */

struct diskpart *
diskpart_lookup_bsd_string(struct diskpart *array, char *name)
{

        struct diskpart *partptr;
	char *nname;
	int num;

	/* null pointer */
        if (name == NULL) {
		return(NULL);
	}

	nname=name;
	partptr=array;

	/*  If no partition then return the whole disk */
	if (nname[0] == 0)
		return(partptr);
	
	/* is it a slice specification? ('s' followed by int) */
	if ((tolower(nname[0]) == 's') && (isdigit(nname[1]))) {

		nname++; 			/* skip past the s */

		num = atoi(nname); 		/* get the slice number */

		if (num > partptr->nsubs) {
			return(NULL);
		} else {
			if (num>0) 
				partptr = &partptr->subs[num-1];
			else
				return(NULL);	/* Slice 0 is no good */
		}
		while (isdigit(nname[0]))
			nname++;

		/* If no partition then return the whole `slice' */
		if (nname[0] == 0)
			return(partptr);

	} else {  /* check first for BSD partition (if any) */

		int i;

		for (i = 0; i < array[0].nsubs; i++)
			if (partptr[0].subs[i].type == DISKPART_BSD) {
				partptr=&partptr->subs[i];
				break;
			}

		/* I could check for VTOC aliasing too ... */
	}


	/* find the partition (in slice, if specified, or aliased to BSD */

	if (isalpha(nname[0])) {
		num = tolower(nname[0]) - 'a';

		if (num > partptr->nsubs) {
			return(NULL);
		} else {
			partptr = &partptr->subs[num];
		}

	} else { 			/* bad name */
		return(NULL);
	}

	return(partptr);
}
