/*
 * Mach Operating System
 * Copyright (c) 1991,1990 Carnegie Mellon University
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON, THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF
 * THIS SOFTWARE IN ITS "AS IS" CONDITION, AND DISCLAIM ANY LIABILITY
 * OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF
 * THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/*
 * This is the layer of the partitioning code that searches for a
 * specific partitioning scheme (potentially nested inside annother
 * partitioning scheme).
 *
 * This file currently contains the routines for
 * a BSD-style disklabel.
 *
 */

#include <sys/types.h> 
#include <stdio.h>

#include <flux/diskpart/diskpart.h>
#include <flux/diskpart/disklabel.h>


/*
 * This is the routine to locate a BSD disklabel.
 * It should work on the bare drive, or in a dos partition.
 */

int
diskpart_get_disklabel(struct diskpart *array, char *buff, int start,
		void *driver_info, int (*bottom_read_fun)(),
		int max_part) 
{
	struct disklabel *dlp;
	int mybase = start + (512 * LBLLOC)/SECTOR_SIZE, i;
	int count;

        diskpart_check_read((*bottom_read_fun)(driver_info, mybase, buff)); 
                
        dlp = (struct disklabel *)buff;
        if (dlp->d_magic != DISKMAGIC || dlp->d_magic2 != DISKMAGIC) {
		return(0);  /* no partitions added */
        }

	/* note: BSD disklabel offsets are from start of DRIVE -- uuggh */

	count = min(8,max_part);  /* always 8 in a disklabel */

        /* COPY into the array */
	for (i = 0; i < count; i++)
		diskpart_fill_entry(&array[i], /* mybase + */ 
			dlp->d_partitions[i].p_offset,
			dlp->d_partitions[i].p_size,
			NULL, 0, DISKPART_NONE, dlp->d_partitions[i].p_fstype);

		/* note: p_fstype is not the same set as the DOS types */
                        
	return(count);  /* 'always' 8 partitions in disklabel -- if space */

}


