/*
 * Mach Operating System
 * Copyright (c) 1991,1990 Carnegie Mellon University
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON, THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF
 * THIS SOFTWARE IN ITS "AS IS" CONDITION, AND DISCLAIM ANY LIABILITY
 * OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF
 * THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/*
 * This is the layer of the partitioning code that searches for a
 * specific partitioning scheme (potentially nested inside annother
 * partitioning scheme).
 *
 * This file currently contains the routines for DEC
 * type labels.
 *
 * Note that this is UNTESTED, and no attempt has been made to ensure
 * correctness.
 */

#include <sys/types.h> 
#include <stdio.h>

#include <flux/diskpart/diskpart.h>
#include <flux/diskpart/dec.h>


/* 
 * NOT TESTED!
 */
#if 0 /* Not only is this code not tested, it is obviously broken. -BAD */
int diskpart_get_dec(struct diskpart *array, char *buff, int start,
		void *driver_info, int (*bottom_read_fun)(),
		int max_part) 
{
        struct disklabel        *label;

        /* here look for a DEC label */
        register dec_label_t    *part;
        int                             i;
  
#if (PARTITION_DEBUG) 
        printf("Checking for dec_label...\n");
#endif

        diskpart_check_read((*bottom_read_fun)(driver_info, start +
			DEC_LABEL_BYTE_OFFSET/SECTOR_SIZE, buff)); 
        
        if (part->magic == DEC_LABEL_MAGIC) {
#if (PARTITION_DEBUG) 
                printf("{Using DEC label}");
#endif
                for (i = 0; i < 8; i++) {
                        label->d_partitions[i].p_size = part->partitions[i].n_sectors;
                        label->d_partitions[i].p_offset = part->partitions[i].offset;
                }
  		return(8); 
        }
#if (PARTITION_DEBUG) 
        printf("No dec label found.\n");
#endif

        return(0);
}
#endif 0

