/*
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

/*
 * This routine prints the the partitioning information in a logical form.
 */

#include <sys/types.h> 
#include <stdio.h>
#include <ctype.h>
#include <flux/diskpart/diskpart.h>

void
diskpart_dump(struct diskpart *array, int level, char part)
{
	int i, j;
	struct diskpart *subs;

	subs = array[0].subs;

	for (j = 0; j < level; j++)
		printf("  ");

	printf("%c: %d, %d, %d, %d (%d subparts)\n", part,
		array->start, array->size, array->fsys, 
		array->type, array->nsubs);

        for (i = 0; i < array[0].nsubs; i++) {
		if (isalpha(part))
			diskpart_dump(&subs[i], level+1, '1'+i);
		else
			diskpart_dump(&subs[i], level+1, 'a'+i);

	}
}

