/* 
 * Copyright (c) 1996-1995 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <stdio.h>

/*
 * This function provides a dump of the function call stack on an x86.  It
 * starts with its caller's frame, and goes back until either the
 * maximum number of levels is exceeded, or its hits a null fp or eip.
 *
 * The prototype is in <flux/debug.h>
 */

#define MAX_ST_LEVELS 10

void dump_stack_trace(void)
{
	unsigned int *fp, i;
	
	asm volatile ("movl %%ebp,%0" : "=r" (fp));

	for (i = 0; i < MAX_ST_LEVELS; i++) {
		fp = (int *)(*fp);
		
		if (!(*(fp + 1) && *fp))
			break;

		printf("%d] eip=0x%x\n", i, *(fp + 1));
	}
}


