/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
#include <stdio.h>
#include <malloc.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <flux/fdev.h>
#include <flux/tty.h>
#include <flux/debug.h>
#include <flux/c/termios.h>
#include <flux/x86/base_vm.h>
#include <flux/x86/pc/com_cons.h>

/* This is the testing program for the partitioning code. */
#include <flux/diskpart/diskpart.h>


#define SIZE 1024

#define MAX_PARTS 30
#if 0
diskpart_t *part_array[MAX_PARTS];
#else
diskpart_t **part_array;
#endif

/* This is bad: how do I find this? */
#define DISK_SIZE 10000

char *NAME[]={"e","s1e","s2","",0};


int
putchar(int c)
{
#if 0
	direct_cons_putchar(c);
#else
	com_cons_putchar(c);
#endif
	return (c);
}

void
_exit(int rc)
{
	printf("exit(%d)\n", rc);
	pc_reset();
}

#define DISKNAME	"sd0"


int 
my_read_fun(char *driver_info, int start, char *buf)
{
	static fdev_t *dev;
	int err, amt;
	static char *newbuf;

	if (!newbuf) {
		printf("grabbing buffer!\n");
		newbuf = lmm_alloc_aligned(&malloc_lmm, 512, 0, 9, 0);
		if (!newbuf) {
			printf("couldn't allocate tmp buffer!\n");
			_exit(1);
		}
	}

	if (!dev) {
		printf("Opening disk %s...\n", DISKNAME);
		err = fdev_drv_open(driver_info, FDEV_OPEN_READ, &dev);
		if (err) {
			printf("  error %d opening disk\n", err);
			_exit(1);
		}
	}

	printf("reading block %d, buf = %x\n", start, buf);

	err = fdev_drv_read(dev, newbuf, 0, (512 * start), 512, &amt);
	if (err) {
		printf("  error %d reading at block %x\n", err, start);
		_exit(1);
	} 

	memcpy(buf, newbuf, 512);

	printf("done reading block %d\n", start);

        return(0);
}


int
main(int argc, char **argv)
{
	int i, numparts;

#if 0
	base_cooked_termios.c_ispeed = B115200;
	base_cooked_termios.c_ospeed = B115200;
#endif
	com_cons_init(1, &base_cooked_termios);

	printf("phys_mem_va 0x%x\n", phys_mem_va);

	printf("Initializing devices...\n");
	fdev_init();

	part_array = (diskpart_t *) lmm_alloc_aligned(&malloc_lmm, 
				       (sizeof(diskpart_t) * MAX_PARTS), 
				       0, 9, 0);
	if (!part_array) {
		printf("  can't allocate buf!\n");
		_exit(1);
	}

       /* call the partition code */
        numparts = diskpart_get_partition(DISKNAME, (*my_read_fun), part_array,
                MAX_PARTS, DISK_SIZE);

        printf("%d partitions found\n",numparts);

        diskpart_dump(part_array, 0, 'Disk');

#if 0
        for (i=0;i<4;i++) {
                printf("%s:\n",NAME[i]);
                diskpart_dump(diskpart_lookup_bsd_string(part_array,NAME[i]),
                        0,NAME[i][strlen(NAME[i])-1]);
        }
#endif 0

#if 0
        for (i=0;i<13;i++) {
                printf("%d: %p\n",i,&part_array[i]);
                diskpart_dump(&part_array[i], 0, 'a'+i);
        }
#endif 0

	printf("FOOBAR!\n");
	_exit(0);
}
