/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Startup code to create MultiBoot-compliant kernel images.
 * You must link this at the beginning of the kernel image.
 * Furthermore, you must link crtn.o at the end of the kernel image,
 * after all of your .o's _and_ after all libraries you link with.
 * (Actually, crtn.o is only strictly required under ELF,
 * but its use is recommended in any case for consistency.)
 *
 * The MultiBoot header defined here assumes none of the specific
 * feature flag bits need to be set
 * (other than the a.out-kludge bit, in the case of a.out format).
 * If you need to use additional features,
 * you will need to define your own MultiBoot header -
 * e.g., just copy this file and modify it as appropriate.
 */

#include <flux/x86/asm.h>

	.text

	/* We should never be entered this way.  */
ENTRY(_start)
	jmp	boot_entry

	/* MultiBoot header - see multiboot.h.  */
	P2ALIGN(2)
boot_hdr:
	.long	0x1BADB002		/* magic */
#ifdef __ELF__
	.long	0x00000000		/* feature flags */
	.long	0-0x1BADB002-0x00000000	/* checksum */
#else /* a.out kludge */
	.long	0x00010000		/* feature flags */
	.long	0-0x1BADB002-0x00010000	/* checksum */
	.long	boot_hdr		/* header_addr */
	.long	EXT(_start)		/* load_addr */
	.long	EXT(edata)		/* load_end_addr */
	.long	EXT(end)		/* bss_end_addr */
	.long	boot_entry		/* entry */
#endif

boot_entry:

	/* Switch to our own stack.  */
	movl	$EXT(base_stack_end),%esp

	/*
	 * Reset EFLAGS to a known state.
	 * This will also clear the DF flag for the string-clear below.
	 */
	pushl	$0
	popf

	/* Clear uninitialized data.  */
	/* XXX this shouldn't be necessary, as the multiboot spec now says
	   that the bootloader does this rather than the OS kernel.
	   Remove when we're sure all boot loaders have been updated. */
	lea	_edata,%edi
	lea	_end,%ecx
	subl	%edi,%ecx
	xorl	%eax,%eax
	rep
	stosb

	/* Push the boot_info parameter for multiboot_main()
	   before ebx gets trashed by the initialization code in crti.h.  */
	pushl	%ebx

#include "crti.h"

	/* Jump into C code.  */
	call	EXT(multiboot_main)

