/* 
 * Copyright (c) 1995-1994 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <mach/machine/seg.h>
#include <mach/machine/proc_reg.h>

#include "real.h"
#include "i16.h"
#include "debug.h"


void raw_real_int(int intnum, struct real_call_data *rcd)
{
	assert((get_cs() & 3) == 0);

	do_16bit(
		unsigned int eflags;

		i16_raw_switch_to_real_mode();
		i16_real_int(intnum, rcd);
		i16_raw_switch_to_pmode();
	);
}

void (*real_int)(int intnum, struct real_call_data *rcd) = raw_real_int;

