/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <flux/x86/base_paging.h>

int pdir_map_page(vm_offset_t pdir_pa, vm_offset_t la, pt_entry_t mapping)
{
	pd_entry_t *pde = pdir_find_pde(pdir_pa, la);
	pt_entry_t *pte;

	/* Find the page directory entry.  */
	pde = pdir_find_pde(pdir_pa, la);

	/* Find the page table entry,
	   creating the page table if necessary.  */
	if (!(*pde & INTEL_PTE_VALID))
	{
		vm_offset_t ptab_pa;
		int rc;

		/* Allocate a new page table.  */
		rc = ptab_alloc(&ptab_pa);
		if (rc)
			return rc;

		/* Set the page directory entry to point to it.  */
		*pde = pa_to_pte(ptab_pa)
			| INTEL_PTE_VALID | INTEL_PTE_USER | INTEL_PTE_WRITE;
	}
	pte = ptab_find_pte(pde_to_pa(*pde), la);

	/* Insert the mapping.
	   If there was already a valid mapping,
	   leave the accessed and dirty bits unmodified.  */
	if ((mapping & INTEL_PTE_VALID) && (*pte & INTEL_PTE_VALID))
		mapping |= *pte & (INTEL_PTE_MOD | INTEL_PTE_REF);
	*pte = mapping;

	return 0;
}

