/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Code to reset a PC.
 */

#include <flux/x86/seg.h>
#include <flux/x86/proc_reg.h>
#include <flux/x86/base_vm.h>
#include <flux/x86/pc/keyboard.h>
#include <flux/x86/pc/reset.h>

static struct pseudo_descriptor null_pdesc;

void pc_reset()
{
	int i;

	/* Inform BIOS that this is a warm boot.  */
	*(unsigned short *)phystokv(0x472) = 0x1234;

	/* Try to reset using the keyboard controller.  */
	for (i = 0; i < 100; i++)
	{
		kb_command(KC_CMD_PULSE & ~KO_SYSRESET);
	}

	/* If that fails, try the ultimate kludge:
	   clearing the IDT and causing a "triple fault"
	   so that the processor is forced to reset itself.  */
	set_idt(&null_pdesc);
	asm("int $3");
}

