/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Basic default termios settings for a typical raw-mode console.
 */

#include <termios.h>

struct termios base_raw_termios =
{
	0,				/* input flags */
	0,				/* output flags */
	CS8,				/* control flags */
	0,				/* local flags */
	{	'D'-64,			/* VEOF */
		_POSIX_VDISABLE,	/* VEOL */
		0,
		'H'-64,			/* VERASE */
		0,
		'U'-64,			/* VKILL */
		0,
		0,
		'C'-64,			/* VINTR */
		'\\'-64,		/* VQUIT */
		'Z'-64,			/* VSUSP */
		0,
		'Q'-64,			/* VSTART */
		'S'-64,			/* VSTOP */
	},
	B9600,				/* input speed */
	B9600,				/* output speed */
};

