/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Linux software interrupts.
 */

#ifndef OSKIT
#define OSKIT
#endif

#define OSKIT_INCLUDE

#include <flux/fdev.h>

#include <linux/sched.h>
#include <linux/interrupt.h>
#include <asm/system.h>
#include <asm/bitops.h>

/*
 * Mask of pending interrupts.
 */
unsigned long bh_active = 0;

/*
 * Mask of enabled interrupts.
 */
unsigned long bh_mask = 0;

/*
 * List of software interrupt handlers.
 */
struct bh_struct bh_base[32];

/*
 * Software interrupt handler.
 */
static void
soft_intr()
{
	unsigned long active;
	unsigned long mask, left;
	struct bh_struct *bh;

	bh = bh_base;
	active = bh_active & bh_mask;
	for (mask = 1, left = ~0;
	     left & active; bh++, mask += mask, left += left) {
		if (mask & active) {
			void (*fn)(void *);

			bh_active &= ~mask;
			fn = bh->routine;
			if (fn == 0)
				goto bad_bh;
			intr_count++;
			(*fn)(bh->data);
			intr_count--;
		}
	}
	return;
 bad_bh:
	printf("linux_soft_intr: bad interrupt handler entry 0x%08lx\n", mask);
}

/*
 * Post a software interrupt.
 */
void
mark_bh(int nr)
{
	set_bit(nr, &bh_active);
	fdev_register_soft_handler(soft_intr);
}
