/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
#include <stdio.h>
#include <malloc.h>
#include <flux/fdev.h>
#include <flux/tty.h>
#include <flux/debug.h>
#include <flux/c/termios.h>
#include <flux/x86/base_vm.h>
#include <flux/x86/pc/com_cons.h>


#define SIZE 1024

int
putchar(int c)
{
#if 0
	direct_cons_putchar(c);
#else
	com_cons_putchar(c);
#endif
	return (c);
}

void
_exit(int rc)
{
#if 0
	volatile int i = 0xdead;

	while (i == 0xdead)
		;
#else
	printf("exit(%d)\n", rc);
	pc_reset();
#endif
}

#define DISKNAME	"sd0"

int
main(int argc, char **argv)
{
	int err, amt;
	fdev_t *dev;
#if 0
	static char buf[SIZE];
#else
	char *buf;
#endif
	int i;

#if 0
	base_cooked_termios.c_ispeed = B115200;
	base_cooked_termios.c_ospeed = B115200;
#endif

	com_cons_init(1, &base_cooked_termios);

	printf("phys_mem_va 0x%x\n", phys_mem_va);

	printf("Initializing devices...\n");
	fdev_init();

	buf = lmm_alloc_aligned(&malloc_lmm, SIZE, 0, 9, 0);
	if (!buf) {
		printf("  can't allocate buf!\n");
		_exit(1);
	}
	bzero(buf, SIZE);

	printf("Opening disk %s...\n", DISKNAME);
	err = fdev_drv_open(DISKNAME, FDEV_OPEN_READ|FDEV_OPEN_WRITE, &dev);
	if (err) {
		printf("  error %d\n", err);
		_exit(1);
	}

#if 0
	printf("Reading first sector...\n");
	err = fdev_drv_read(dev, buf, 0, 0, SIZE, &amt);
	if (err) {
		printf("  ERROR %d\n", err);
		_exit(1);
	}
	printf("Done, amt = %d\n", amt);

#if 0
	for (i = 0; i < 10; ) {
		printf("%8x %8x %8x %8x\n", buf[i++], buf[i++], buf[i++], 
		       buf[i++]);
	}
#endif
#endif
	printf("NOW CALLING MEMSET!\n");

	memset(buf, 0xb, SIZE);
	err = fdev_drv_write(dev, buf, 0, 0, SIZE, &amt);
	if (err || amt != SIZE) {
		 printf("  error %d\n", err);
                _exit(1);
        }

	printf("wrote %d bytes just fine!\n", amt);

	bzero(buf, SIZE);

	err = fdev_drv_read(dev, buf, 0, 0, SIZE, &amt);
	if (err || amt != SIZE) {
		 printf("  error %d\n", err);
                _exit(1);
        }

	_exit(0);
}
