/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Define the boot adaptor's putchar routine.
 */

#include <flux/x86/pc/com_cons.h>
#include <flux/x86/pc/direct_cons.h>
#include <flux/c/sys/reboot.h>

#include "boottype.h"

/*
 * Define this if you want the boot adaptor to always use the serial
 * line for the console,
 * regardless of what the RB_SERIAL flag (if any) is set to.
 */
#undef BA_FORCE_SERIAL

static int serial = 0;			/* Use serial console or not. */

static void
putchar_init()
{
	/*
	 * Check the BSD-style RB_SERIAL flag if we're booting from
	 * BSD bootblocks.
	 */
#ifdef BA_FORCE_SERIAL
	serial = 1;
#else
	serial = (boottype == BOOTTYPE_OLDBSD || boottype == BOOTTYPE_NEWBSD)
		 && (boothowto & BSD_RB_SERIAL);
#endif

	if (serial)
		com_cons_init(1, 0);
}

int
putchar(int c)
{
	static int inited = 0;

	if (! inited) {
		putchar_init();
		inited = 1;
	}

	serial ? com_cons_putchar(c) : direct_cons_putchar(c);

	return c;
}
