#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <termios.h>
#include <unistd.h>
#include <linux/termios.h>

void 
main(void)
{
  int fil, rslt;
  char tty_name[]="/dev/ttyS1";
  struct values {
    unsigned long sti, irq_start, serial_irq_start, irq_stop, resumed;
  } val;

  fil = open(tty_name, O_RDWR) ;
  if (fil < 0)
    {
      perror(tty_name) ;
      return ;
    }

  rslt = ioctl(fil, TIOCIRQ, &val) ;
  if (rslt < 0)
    {
      perror("TIOCIRQ ioctl") ;
      return ;
    }
  printf("sti -> irq_start:     %lx (%ld)\n"
	 "irq_start -> irq_end: %lx (%ld)\n"
	 "irq_end -> resume:    %lx (%ld)\n"
	 "sti -> resume:        %lx (%ld)\n",
	 val.irq_start-val.sti, val.irq_start-val.sti, 
	 val.irq_stop-val.irq_start, val.irq_stop-val.irq_start,
 	 val.resumed-val.irq_stop, val.resumed-val.irq_stop, 
	 val.resumed-val.sti, val.resumed-val.sti);
}
