/* mmuio.h - MMU-supported high-speed I/O */

/* Written 1995,1996 by Werner Almesberger, EPFL LRC */


#ifndef _LINUX_MMUIO_H
#define _LINUX_MMUIO_H

#include <linux/config.h>

#ifdef CONFIG_MMU_HACKS

#include <linux/uio.h>
#include <linux/skbuff.h>

void free_range(unsigned long start,unsigned long size);
void mmucp_tofs(unsigned long user,unsigned long size,struct sk_buff *skb,
    unsigned long kernel);
int lock_user(unsigned long start,unsigned long size,int iov_max,
    struct iovec *iov);
void unlock_user(int iovcnt,struct iovec *iov);

#endif

#endif
