/*
 * 
 * ATM Lan Emulation Daemon vs. driver interface
 *
 * carnil@cs.tut.fi
 *
 */

#ifndef _ATMLEC_H_
#define _ATMLEC_H_

#include <linux/atmioc.h>
#include <linux/atm.h>
#include <linux/if_ether.h>
/* ATM lec daemon control socket */
#define ATMLEC_CTRL _IO('a',ATMIOC_LANE)
#define ATMLEC_DATA _IO('a',ATMIOC_LANE+1)
#define ATMLEC_MCAST _IO('a',ATMIOC_LANE+2)

/* Maximum number of LEC interfaces (tweakable) */
#define MAX_LEC_ITF 4

typedef enum { 
        l_set_mac_addr,   l_del_mac_addr, 
        l_svc_setup, 
        l_addr_delete,    l_topology_change, 
        l_flush_complete, l_arp_update,
        l_config,         l_flush_tran_id, 
        l_set_lecid,      l_arp_xmt 
} atmlec_msg_type;

#define ATMLEC_MSG_TYPE_MAX l_arp_xmt

struct atmlec_config_msg {
        unsigned int maximum_unknown_frame_count;
        unsigned long max_unknown_frame_time;
        unsigned short max_retry_count;
        unsigned long aging_time;
        unsigned long forward_delay_time;
        unsigned long arp_response_time;
        unsigned long flush_timeout;
        unsigned long path_switching_delay;
};
 
struct atmlec_msg {
        atmlec_msg_type type;
        union {
                struct {
                        unsigned char mac_addr[ETH_ALEN];
                        unsigned char atm_addr[ATM_ESA_LEN];
                        unsigned long flag;/* Topology_change flag, 
                                              remoteflag, permanent flag,
                                              lecid, transaction id */
                } normal;
                struct atmlec_config_msg config;
        } content;
};

struct atmlec_ioc {
        int dev_num;
        unsigned char atm_addr[ATM_ESA_LEN];
        unsigned char receive;    /* 1= receive vcc, 0 = send_vcc */
};
#endif /* _ATMLEC_H_ */
