/* $Id: unistd.h,v 1.9 1997/04/11 12:48:30 hohmuth Exp $ */

#ifndef __ASM_L4_I386_UNISTD_H
#define __ASM_L4_I386_UNISTD_H

/* Linux/l4-i386 has a Linux/i386 ABI: fetch system call numbers from
   <asm-i386/unistd.h> */

#ifdef __KERNEL_SYSCALLS__
# define __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# undef __KERNEL_SYSCALLS__
#endif

#include <asm-i386/unistd.h>

#ifdef __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# undef __ASM_L4_I386_UNISTD_H__KERNEL_SYSCALLS__
# define  __KERNEL_SYSCALLS__
#endif


#ifdef __KERNEL_SYSCALLS__

#include <linux/sched.h>
#include <linux/linkage.h>
#include <asm/ptrace.h>

#include <l4/kdebug.h>
#include "../../arch/l4-i386/include/config.h"

/* make sure these don't interfere */
#undef _syscall0
#undef _syscall1
#undef _syscall2
#undef _syscall3
#undef _syscall4
#undef _syscall5

#define __Ksyscall0(type,name) \
type name(void) \
{ \
asmlinkage long __SC__##name(void) asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(); \
if (__res >= 0) \
        return (type) __res; \
errno = -__res; \
return -1; \
}

#define __Ksyscall1(type,name,type1,arg1) \
type name(type1 arg1) \
{ \
asmlinkage long __SC__##name(type1 arg1) asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(arg1); \
if (__res >= 0) \
        return (type) __res; \
errno = -__res; \
return -1; \
}

#define __Ksyscall2(type,name,type1,arg1,type2,arg2) \
type name(type1 arg1,type2 arg2) \
{ \
asmlinkage long __SC__##name(type1 arg1, type2 arg2) \
    asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(arg1, arg2); \
if (__res >= 0) \
        return (type) __res; \
errno = -__res; \
return -1; \
}

#define __Ksyscall3(type,name,type1,arg1,type2,arg2,type3,arg3) \
type name(type1 arg1,type2 arg2,type3 arg3) \
{ \
asmlinkage long __SC__##name(type1 arg1, type2 arg2, type3 arg3) \
    asm(SYMBOL_NAME_STR(sys_) ## #name); \
long __res = __SC__##name(arg1, arg2, arg3); \
if (__res>=0) \
        return (type) __res; \
errno=-__res; \
return -1; \
}

/* WARNING: if any of the following ones want and/or modify struct
   pt_regs on its stack, we lose! */

static inline __Ksyscall0(int,idle)
/* static inline __Ksyscall0(int,fork) */
/* static inline __Ksyscall2(int,clone,unsigned long,flags,char *,esp) */
/* static inline __Ksyscall0(int,pause) */
static inline __Ksyscall0(int,setup)
static inline __Ksyscall0(int,sync)
static inline __Ksyscall0(pid_t,setsid)
static inline __Ksyscall3(int,write,int,fd,const char *,buf,off_t,count)
static inline __Ksyscall1(int,dup,int,fd)
static inline __Ksyscall3(int,open,const char *,file,int,flag,int,mode)
static inline __Ksyscall1(int,close,int,fd)
static inline __Ksyscall3(pid_t,waitpid,pid_t,pid,int *,wait_stat,int,options)

int execve(char * file, char ** argv, char ** envp);

static inline void _exit(int exitcode)
{
  asmlinkage void __SC__exit(int exitcode) asm(SYMBOL_NAME_STR(sys_) "exit");
  __SC__exit(exitcode);
}

static inline pid_t wait(int * wait_stat)
{
  return waitpid(-1,wait_stat,0);
}

/* start a new kernel internal thread */
static inline pid_t kernel_thread(int (*fn)(void *), void * arg, 
				  unsigned long flags)
{
  pid_t pid;

#if (48 != PTREGS_SIZE)
# error "adapt me"
#endif

  /* we don't care about errno, that's why we call the system calls
     directly (sys_*() routines). */

  __asm__ __volatile__
    (
     /* sys_clone() expects the caller's struct pt_regs on the stack
	which will become the new task's state.  we fake that struct
	here. */

     "pushl $0			\n\t" /* esp -- fake */
     "pushfl			\n\t" /* eflags */
     "pushl $0			\n\t" /* cs */
     "pushl $1f			\n\t" /* eip -- child return address */
     "pushl %%eax		\n\t" /* orig_eax */
     "pushl %%eax		\n\t" /* eax */
     "pushl %%ebp		\n\t" /* ebp */
     "pushl %%edi		\n\t" /* edi */
     "pushl %%esi		\n\t" /* esi */
     "pushl %%edx		\n\t" /* edx */
     "pushl $0			\n\t" /* ecx -- user stack arg */
     "pushl %%ebx		\n\t" /* ebx -- clone flags */
     "call " SYMBOL_NAME_STR(internal_sys_clone) "\n\t" /* call internal_sys_clone */
     "jmp   0f			\n"   /* parent */

     /* this is the point where the child returns, with a new stack
        (so don't junk the sys_clone() args in this case) */

   "1: pushl %3			\n\t" /* child: push arg */
     "call  *%2			\n\t" /* child: call fn */
     "movl  $0,(%%esp)		\n\t" /* child: push arg for sys_exit */
     "call " SYMBOL_NAME_STR(sys_exit) "\n" /* child: call sys_exit */

     /* parent */

   "0: leal 48(%%esp), %%esp	\n\t" /* parent: junk sys_clone args */

     : "=a" (pid)
     : "0" (__NR_clone), "r" (fn), "r" (arg),
       "b" (flags | CLONE_VM)
     : "ecx", "edx"
     );

  return pid;
}

#endif

#endif /* ! __ASM_L4_I386_UNISTD_H */
