/* $Id: elf.h,v 1.2 1997/12/10 17:15:08 jw5 Exp $ */

#ifndef __ASM_L4_I386_ELF_H
#define __ASM_L4_I386_ELF_H

/*
 * ELF register definitions..
 */

#include <asm/ptrace.h>

typedef unsigned long elf_greg_t;

/* Linux/l4-i386 has a Linux/i386 ABI, therefore we have to define
   elf_greg_t compliant to Linux/i386.  */

#define ELF_NGREG (sizeof (struct linux_i386_pt_regs) / sizeof(elf_greg_t))
typedef elf_greg_t elf_gregset_t[ELF_NGREG];

typedef struct user_i387_struct elf_fpregset_t;

/*
 * This is used to ensure we don't load something for the wrong architecture.
 */
#define elf_check_arch(x) ( ((x) == EM_386) || ((x) == EM_486) )

/*
 * These are used to set parameters in the core dumps.
 */
#define ELF_CLASS	ELFCLASS32
#define ELF_DATA	ELFDATA2LSB;
#define ELF_ARCH	EM_386

	/* SVR4/i386 ABI (pages 3-31, 3-32) says that when the program
	   starts %edx contains a pointer to a function which might be
	   registered using `atexit'.  This provides a mean for the
	   dynamic linker to call DT_FINI functions for shared libraries
	   that have been loaded before the code runs.

	   A value of 0 tells we have no such handler.  */
#define ELF_PLAT_INIT(_r)	_r->edx = 0

#define USE_ELF_CORE_DUMP
#define ELF_EXEC_PAGESIZE	4096

/* Linux/l4-i386 has a Linux/i386 ABI, therefore we have to move some
   data around to generate an Linux/i386 compliant core file */

#define ELF_CORE_COPY_REGS(dest, src) \
	memset((dest), sizeof((dest)), 0); \
	((struct linux_i386_pt_regs *)(dest))->ebx = (src)->ebx; \
	((struct linux_i386_pt_regs *)(dest))->ecx = (src)->ecx; \
	((struct linux_i386_pt_regs *)(dest))->edx = (src)->edx; \
	((struct linux_i386_pt_regs *)(dest))->esi = (src)->esi; \
	((struct linux_i386_pt_regs *)(dest))->edi = (src)->edi; \
	((struct linux_i386_pt_regs *)(dest))->ebp = (src)->ebp; \
	((struct linux_i386_pt_regs *)(dest))->eax = (src)->eax; \
	((struct linux_i386_pt_regs *)(dest))->orig_eax = (src)->orig_eax; \
	((struct linux_i386_pt_regs *)(dest))->eip = (src)->eip; \
	((struct linux_i386_pt_regs *)(dest))->eflags = (src)->eflags; \
	((struct linux_i386_pt_regs *)(dest))->esp = (src)->esp;

#endif /* ! __ASM_L4_I386_ELF_H */
