#include <linux/module.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/interrupt.h>
#include <linux/tty.h>
#include <linux/tty_flip.h>
#include <linux/serial.h>
#include <linux/serial_reg.h>
#include <linux/config.h>
#include <linux/major.h>
#include <linux/string.h>
#include <linux/fcntl.h>
#include <linux/ptrace.h>
#include <linux/ioport.h>
#include <linux/mm.h>

#include <asm/system.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/bitops.h>
#include <asm/system.h>

#include <l4/kdebug.h>

#include "../../arch/l4-i386/include/perform.h"
#include "../../../l4/lib/libl4dbg/include/l4/l4_com.h"
#if 0
#define KO(x) ko(x)
#else
#define KO(x) 
#endif

int check_irq_handling(struct async_struct *info, void *arg);
void check_irq_interrupt(int, void *, struct pt_regs *);

unsigned volatile int no_serial_int;
static unsigned long serial_irq_start;
extern unsigned long irq_start, irq_stop;
/*
 * Initializes the SIO for DIVISOR bps, 8N1, only receive interrupts
 */

void
set_8250_mode(void)
{
    asm(
        /* set speed in DLLO/DLHI */
        "             movw %0,%%dx               \n\t" /* adr of LCR */
        "             inb %%dx,%%al              \n\t"
        "             orb $0x80,%%al             \n\t" /* set DLAB in LCR */ 
        "             outb %%al,%%dx             \n\t"  

        "             movw %2,%%dx               \n\t" /* adr of DLLO */
        "             movb %3,%%al               \n\t" /* lo divisor value */
        "             outb %%al,%%dx             \n\t"

        /* DLHI can be omitted for speed > 460 bps */
        
        "             movw %0,%%dx               \n\t" /* adr of LCR */
        "             movb $0x03,%%al            \n\t" /* 8N1, clear DLAB */
        "             outb %%al,%%dx             \n\t"

        /* reset 8250 to cancel possible pending interrupts */
        "             movw %4,%%dx               \n\t" /* read IIR */
	"             inb %%dx,%%al              \n\t" 
        "             movw %5,%%dx               \n\t" /* read LSR */
	"             inb %%dx,%%al              \n\t" 
        "             movw %4,%%dx               \n\t" /* read IIR */
	"             inb %%dx,%%al              \n\t"
        "             movw %6,%%dx               \n\t" /* read RBR */
	"             inb %%dx,%%al              \n\t"
        "             movw %4,%%dx               \n\t" /* read IIR */
	"             inb %%dx,%%al              \n\t"
        "             movw %7,%%dx               \n\t" /* read MSR */
	"             inb %%dx,%%al              \n\t"
        "             movw %4,%%dx               \n\t" /* read IIR */
	"             inb %%dx,%%al              \n\t"

        /* enable RCV interrupts, clear rest */
        "             movw %1,%%dx               \n\t" /* adr of IER */
        "             movb $0x01,%%al            \n\t"
        "             outb %%al,%%dx             \n\t"

        /* set DTR and RTS in Modem Control Register */
	"             movw %8,%%dx               \n\t" /* adr of MCR */
        "             movb $0b11011,%%al         \n\t" /* set LOOP, DTR, RTS, MCRE */
        "             outb %%al,%%dx             \n\t"
        :
        /* no output */
        :
        "i" (COM_LCR),               /* 0 */
        "i" (COM_IER),               /* 1 */
        "i" (COM_DLLO),              /* 2 */
        "i" (DIVISOR),               /* 3 */
        "i" (COM_IIR),               /* 4 */
        "i" (COM_LSR),               /* 5 */
        "i" (COM_RBR),               /* 6 */
        "i" (COM_MSR),               /* 7 */
        "i" (COM_MCR)                /* 8 */
        :
        "eax", "edx"
    );
}

/*
 * Sends the character to SIO via polling
 */
void 
write_char(char value)
{
    asm
    (
        "             movw %1,%%dx               \n\t"   /* adr of LSR */
        "0:           inb %%dx,%%al              \n\t"    
        "             testb $0b01000000,%%al     \n\t"   /* polling */
        "             jz 0b                      \n\t"

        "             movb %0,%%al               \n\t"
        "             movw %2,%%dx               \n\t"   /* adr of THR */
        "             outb %%al,%%dx             \n\t"
        : 
        /* no output */
        :
        "r" (value),       /* 0 */
        "i" (COM_LSR),     /* 1 */
        "i" (COM_THR)      /* 2 */
        :
        "eax", "edx"
    );
}

void check_irq_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
  /*
   * Reads one character from SIO (after interrrupt occured)
   */
    int result;

    read_time(&serial_irq_start);
    asm
    (
     /* no test of line status necessary, received interrupt means char can be
        read from RBR */
     
        "             movw %2,%%dx               \n\t"  /* adr of RBR */
        "             inb %%dx,%%al              \n\t"
        "             movzbl %%al,%%eax          \n\t"  /* zero extend al */
        :
        "=a" (result)      /* 0 */
        :
        "i" (COM_LSR),     /* 1 */
        "i" (COM_RBR)      /* 2 */     
        :
        "eax", "edx"
    );
    if (result != 'a')
      printk("received interrupt, character different: %c\n", (char)result);
#if 0
    else
      printk("received interrupt, character ok\n");
#endif
    no_serial_int = 0;
}

int check_irq_handling(struct async_struct *info, void *arg)
{
  int retval, flags, error;
  unsigned long start, delay;
  struct values {
    unsigned long sti, irq_start, serial_irq_start, irq_stop, resumed;
  } val;

  free_irq(info->irq, NULL);
  retval = request_irq(info->irq,
		       check_irq_interrupt,
		        SA_INTERRUPT,
		       "check_irq", NULL);
  /* initialize uart, set loop mode */
  save_flags(flags);
  cli();
  KO('s');
  set_8250_mode();  
  /* get time */
  KO('g');
  /* send byte */
  KO('w');
  write_char('a');
  /* wait for interrupt */
  KO('W');
  no_serial_int = 1;

  read_time(&start);
  delay = start;
  while (delay - start < 1000)
    read_time(&delay);

  read_time(&val.sti);
  restore_flags(flags);
  while (no_serial_int) ;
  /* get time */
  KO('G');
  read_time(&val.resumed);
  /* return difference */
  KO('R');
  val.irq_start = irq_start;
  val.serial_irq_start = serial_irq_start;
  val.irq_stop = irq_stop;

  error = verify_area(VERIFY_WRITE, (void *) arg,
		      sizeof(struct values));
  if (error)
    return error;
  memcpy_tofs((struct values *) arg,
	      &val, sizeof(struct values));
  return 0;
}
