/* drivers/atm/fore200.c - This is just a test, not a real driver */
 
/* Written 1996 by Werner Almesberger, EPFL LRC */
 

#include <linux/string.h>
#include <linux/kernel.h>
#include <asm/sbus.h>


int fore200_detect(void)
{
	struct linux_sbus *bus;
	struct linux_sbus_device *sdev = 0;

	for_each_sbus(bus) {
		for_each_sbusdev(sdev, bus) {
			if (strcmp(sdev->prom_name,"FORE,sba-200") == 0) {
				printk(KERN_NOTICE "fore200: found an SBA-200 "
				    "in slot %x,offset=%08lx,irq=%d",
				    sdev->slot,sdev->offset,sdev->irqs->pri);
			}
		}
	}
	return 0;
}
