#include <linux/config.h>

#include <linux/mm.h>

#include <asm/system.h>
#include <asm/segment.h>
#include <asm/pgtable.h>

#include "../include/l4_memory.h"
#include "../include/task.h"
#include "../include/config.h"
/* #define DEBUG */
#include "../include/debug.h"

/* #define SANITY */
/* #define DEBUG */
/* #define PARANOIA */
extern inline int check_fpage(l4_fpage_t fpage)
{
  if ((fpage.fpage & PAGE_MASK) >= root_pager_memory_end)
    {
      printk("{flush,romap}_page: flushing non physical page (0x%x)\n", 
	     fpage.fpage);
      enter_kdebug("flush_page: non physical page");
    }
}

extern inline void 
flush_page(l4_fpage_t fpage)
{
  if ((fpage.fpage & PAGE_MASK) < 0x80000000UL)
    {
#ifdef DEBUG
      printk("root_flush_page: flushing fpage 0x%x\n", fpage.fpage);
      enter_kdebug("flush");
#endif
#ifdef SANITY
      check_fpage(fpage);
#endif
      l4_fpage_unmap(fpage, L4_FP_OTHER_SPACES|L4_FP_FLUSH_PAGE);
#ifdef DEBUG
      enter_kdebug("after flush");
#endif
    }
}

extern inline void
romap_page(l4_fpage_t fpage)
{
  if ((fpage.fpage & PAGE_MASK) < 0x80000000UL)
    {
#ifdef DEBUG
      printk("root_romap_page: remapping fpage 0x%x\n", fpage.fpage);
      enter_kdebug("remap");
#endif
#ifdef SANITY
      check_fpage(fpage);
#endif
      
      l4_fpage_unmap(fpage, L4_FP_OTHER_SPACES|L4_FP_REMAP_PAGE);
      
#ifdef DEBUG
      enter_kdebug("after remap");
#endif
    }
}

void set_pte(pte_t *pteptr, pte_t pteval)
{
  /*
   * Check if any invalidation is necessary
   *
   * Invalidation (flush) necessary if:
   *   old page was present
   *       new page has another physical address OR
   *       new page is not present OR
   *       new page has another protection OR
   *       new page has other access attributes
   */
#ifdef DEBUG
   printk("set_pte called from %lx, pte to be set: %x to entry: %lx\n", 
	  *(((unsigned long *)&pteptr)-1),
	  (unsigned)pteptr, pte_val(pteval));
#endif /* DEBUG */
  if (pte_present(*pteptr))
    {
      if (!pte_present(pteval) || (pte_page(*pteptr) != pte_page(pteval)))
	{
	  /* (old was present && new not) || physical page frame changed */
	  /* flush */
	  flush_page(l4_fpage(pte_page(*pteptr), PAGE_SHIFT, 0, 0));
	}
      else
	{
	  /* both old and new are present and in same physical frame, but
	     access mask or access attributes have changed */
	  if ( (pte_write(*pteptr) && !pte_write(pteval)) ||
	       (pte_dirty(*pteptr) && !pte_dirty(pteval)) )
	    {
	      /* Protection changed from r/w to ro or page now clean */
	      /* XXX do it locally if possible */
	      romap_page(l4_fpage(pte_page(*pteptr), PAGE_SHIFT, 0, 0));
	    }
	  else if (pte_young(*pteptr) && !pte_young(pteval))
	    {
	      /* flush page to be able to detect access to this page */
	      flush_page(l4_fpage(pte_page(*pteptr), PAGE_SHIFT, 0, 0));
	    }
	}
    }
  /*
   * Set new value
   */
  *pteptr = pteval;
}
void pte_clear(pte_t *ptep)
{ 
  /*
   * Check if any invalidation is necessary
   * If possible, invalidate locally.
   */
#ifdef DEBUG
  printk("pte_clear called, pte to be cleared: %x\n", (unsigned)ptep);
#endif
  if (pte_present(*ptep))
    {
      /* 
       * Invalidate page
       */
      flush_page(l4_fpage(pte_page(*ptep), PAGE_SHIFT, 0, 0));
    }
  pte_val(*ptep) = 0; 
}

void 
vm_set_pte(pte_t *pteptr, pte_t pteval, unsigned long vm_address)
{
#ifdef DEBUG
  printk("set_pte: pte to be set: %x for vm_addr: %lx to entry: %lx\n", 
	 (unsigned)pteptr, vm_address, pte_val(pteval));
#endif
  if (!pte_none(*pteptr))
    {
      enter_kdebug("vm_set_pte: page already present");
      l4_fpage_unmap(l4_fpage(vm_address, PAGE_SHIFT, 0, 0), 
		     L4_FP_ALL_SPACES | L4_FP_FLUSH_PAGE);
    }
  if (vm_address != VM_PTE_NO_MAP)
    {
      request_physical_page_from_sigma0(pte_page(pteval), L4_WRITE_ACCESS, 
					vm_address - TASK_SIZE);
    }
  /*
   * Set new value
   */
  *pteptr = pteval;
}
void 
vm_pte_clear(pte_t *ptep, unsigned long vm_address)
{
  l4_fpage_unmap(l4_fpage(vm_address, PAGE_SHIFT, 0, 0), 
		 L4_FP_ALL_SPACES | L4_FP_FLUSH_PAGE);
  pte_val(*ptep) = 0; 
}
